// media/mojo/mojom/speech_recognition_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognition_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
HypothesisParts::HypothesisParts()
    : text(),
      hypothesis_part_offset() {}

HypothesisParts::HypothesisParts(
    WTF::Vector<WTF::String> text_in,
    ::base::TimeDelta hypothesis_part_offset_in)
    : text(std::move(text_in)),
      hypothesis_part_offset(std::move(hypothesis_part_offset_in)) {}

HypothesisParts::~HypothesisParts() = default;

void HypothesisParts::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hypothesis_part_offset"), this->hypothesis_part_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HypothesisParts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TimingInformation::TimingInformation()
    : audio_start_time(),
      audio_end_time(),
      hypothesis_parts() {}

TimingInformation::TimingInformation(
    ::base::TimeDelta audio_start_time_in,
    ::base::TimeDelta audio_end_time_in,
    absl::optional<WTF::Vector<HypothesisPartsPtr>> hypothesis_parts_in)
    : audio_start_time(std::move(audio_start_time_in)),
      audio_end_time(std::move(audio_end_time_in)),
      hypothesis_parts(std::move(hypothesis_parts_in)) {}

TimingInformation::~TimingInformation() = default;

void TimingInformation::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_start_time"), this->audio_start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_end_time"), this->audio_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hypothesis_parts"), this->hypothesis_parts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<WTF::Vector<HypothesisPartsPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TimingInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechRecognitionResult::SpeechRecognitionResult()
    : transcription(),
      is_final(),
      timing_information() {}

SpeechRecognitionResult::SpeechRecognitionResult(
    const WTF::String& transcription_in,
    bool is_final_in,
    TimingInformationPtr timing_information_in)
    : transcription(std::move(transcription_in)),
      is_final(std::move(is_final_in)),
      timing_information(std::move(timing_information_in)) {}

SpeechRecognitionResult::~SpeechRecognitionResult() = default;

void SpeechRecognitionResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transcription"), this->transcription,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_final"), this->is_final,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_information"), this->timing_information,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingInformationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechRecognitionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LanguageIdentificationEvent::LanguageIdentificationEvent()
    : language(),
      confidence_level() {}

LanguageIdentificationEvent::LanguageIdentificationEvent(
    const WTF::String& language_in,
    ConfidenceLevel confidence_level_in)
    : language(std::move(language_in)),
      confidence_level(std::move(confidence_level_in)) {}

LanguageIdentificationEvent::~LanguageIdentificationEvent() = default;
size_t LanguageIdentificationEvent::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->language);
  seed = mojo::internal::WTFHash(seed, this->confidence_level);
  return seed;
}

void LanguageIdentificationEvent::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confidence_level"), this->confidence_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConfidenceLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LanguageIdentificationEvent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechRecognitionOptions::SpeechRecognitionOptions()
    : recognition_mode(),
      enable_formatting(),
      language() {}

SpeechRecognitionOptions::SpeechRecognitionOptions(
    SpeechRecognitionMode recognition_mode_in,
    bool enable_formatting_in,
    const WTF::String& language_in)
    : recognition_mode(std::move(recognition_mode_in)),
      enable_formatting(std::move(enable_formatting_in)),
      language(std::move(language_in)) {}

SpeechRecognitionOptions::~SpeechRecognitionOptions() = default;

void SpeechRecognitionOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_mode"), this->recognition_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SpeechRecognitionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_formatting"), this->enable_formatting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechRecognitionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeechRecognitionContext::Name_[] = "media.mojom.SpeechRecognitionContext";

class SpeechRecognitionContext_BindRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
      SpeechRecognitionContext::BindRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionContext::BindRecognizerCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindRecognizer_ForwardToCallback);
};

class SpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback(
      SpeechRecognitionContext::BindAudioSourceFetcherCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionContext::BindAudioSourceFetcherCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback);
};

SpeechRecognitionContextProxy::SpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionContextProxy::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> in_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> in_client, SpeechRecognitionOptionsPtr in_options, BindRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionContext::BindRecognizer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<SpeechRecognitionRecognizer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionRecognizerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SpeechRecognitionOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindRecognizer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionRecognizerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in SpeechRecognitionContext.BindRecognizer request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionRecognizerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechRecognitionContext.BindRecognizer request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SpeechRecognitionContext.BindRecognizer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SpeechRecognitionContextProxy::BindAudioSourceFetcher(
    ::mojo::PendingReceiver<AudioSourceFetcher> in_fetcher_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> in_client, SpeechRecognitionOptionsPtr in_options, BindAudioSourceFetcherCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionContext::BindAudioSourceFetcher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetcher_receiver"), in_fetcher_receiver,
                        "<value of type ::mojo::PendingReceiver<AudioSourceFetcher>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionRecognizerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type SpeechRecognitionOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindAudioSourceFetcher_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioSourceFetcherInterfaceBase>>(
      in_fetcher_receiver, &params->fetcher_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->fetcher_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid fetcher_receiver in SpeechRecognitionContext.BindAudioSourceFetcher request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionRecognizerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechRecognitionContext.BindAudioSourceFetcher request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SpeechRecognitionContext.BindAudioSourceFetcher request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindAudioSourceFetcher");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SpeechRecognitionContext_BindRecognizer_ProxyToResponder {
 public:
  static SpeechRecognitionContext::BindRecognizerCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SpeechRecognitionContext_BindRecognizer_ProxyToResponder> proxy(
        new SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionContext_BindRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpeechRecognitionContext::BindRecognizerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_multichannel_supported);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindRecognizer_ProxyToResponder);
};

bool SpeechRecognitionContext_BindRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::SpeechRecognitionContext::BindRecognizerCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_is_multichannel_supported{};
  SpeechRecognitionContext_BindRecognizer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_multichannel_supported = input_data_view.is_multichannel_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_multichannel_supported));
  return true;
}

void SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run(
    bool in_is_multichannel_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizerCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_multichannel_supported"), in_is_multichannel_supported,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindRecognizer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->is_multichannel_supported = in_is_multichannel_supported;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizerCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder {
 public:
  static SpeechRecognitionContext::BindAudioSourceFetcherCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder> proxy(
        new SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpeechRecognitionContext::BindAudioSourceFetcherCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_multichannel_supported);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder);
};

bool SpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::SpeechRecognitionContext::BindAudioSourceFetcherCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_is_multichannel_supported{};
  SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_multichannel_supported = input_data_view.is_multichannel_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionContext::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_multichannel_supported));
  return true;
}

void SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::Run(
    bool in_is_multichannel_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindAudioSourceFetcherCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_multichannel_supported"), in_is_multichannel_supported,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindAudioSourceFetcher_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->is_multichannel_supported = in_is_multichannel_supported;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindAudioSourceFetcherCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindAudioSourceFetcher");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionContextStubDispatch::Accept(
    SpeechRecognitionContext* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionContext_BindRecognizer_Name: {
      break;
    }
    case internal::kSpeechRecognitionContext_BindAudioSourceFetcher_Name: {
      break;
    }
  }
  return false;
}

// static
bool SpeechRecognitionContextStubDispatch::AcceptWithResponder(
    SpeechRecognitionContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionContext_BindRecognizer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SpeechRecognitionContext_BindRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionContext_BindRecognizer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<SpeechRecognitionRecognizer> p_receiver{};
      ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> p_client{};
      SpeechRecognitionOptionsPtr p_options{};
      SpeechRecognitionContext_BindRecognizer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionContext::Name_, 0, false);
        return false;
      }
      SpeechRecognitionContext::BindRecognizerCallback callback =
          SpeechRecognitionContext_BindRecognizer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindRecognizer(
std::move(p_receiver), 
std::move(p_client), 
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kSpeechRecognitionContext_BindAudioSourceFetcher_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionContext::BindAudioSourceFetcher",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionContext::BindAudioSourceFetcher");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<AudioSourceFetcher> p_fetcher_receiver{};
      ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> p_client{};
      SpeechRecognitionOptionsPtr p_options{};
      SpeechRecognitionContext_BindAudioSourceFetcher_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_fetcher_receiver =
            input_data_view.TakeFetcherReceiver<decltype(p_fetcher_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionContext::Name_, 1, false);
        return false;
      }
      SpeechRecognitionContext::BindAudioSourceFetcherCallback callback =
          SpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAudioSourceFetcher(
std::move(p_fetcher_receiver), 
std::move(p_client), 
std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionContextValidationInfo[] = {
    {internal::kSpeechRecognitionContext_BindRecognizer_Name,
     {&internal::SpeechRecognitionContext_BindRecognizer_Params_Data::Validate,
      &internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate}},
    {internal::kSpeechRecognitionContext_BindAudioSourceFetcher_Name,
     {&internal::SpeechRecognitionContext_BindAudioSourceFetcher_Params_Data::Validate,
      &internal::SpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data::Validate}},
};

bool SpeechRecognitionContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionContextValidationInfo);
}

bool SpeechRecognitionContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSpeechRecognitionContextValidationInfo);

}
const char SpeechRecognitionService::Name_[] = "media.mojom.SpeechRecognitionService";

SpeechRecognitionServiceProxy::SpeechRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionServiceProxy::BindContext(
    ::mojo::PendingReceiver<SpeechRecognitionContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::BindContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingReceiver<SpeechRecognitionContext>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_BindContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_BindContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionContextInterfaceBase>>(
      in_context, &params->context, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->context),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid context in SpeechRecognitionService.BindContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::SetUrlLoaderFactory(
    ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> in_url_loader_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::SetUrlLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in SpeechRecognitionService.SetUrlLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetUrlLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::SetSodaPath(
    const ::base::FilePath& in_binary_path, const ::base::FilePath& in_config_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::SetSodaPath", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binary_path"), in_binary_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_path"), in_config_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_SetSodaPath_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_SetSodaPath_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binary_path)::BaseType> binary_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_binary_path, binary_path_fragment);
  params->binary_path.Set(
      binary_path_fragment.is_null() ? nullptr : binary_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binary_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binary_path in SpeechRecognitionService.SetSodaPath request");
  mojo::internal::MessageFragment<
      typename decltype(params->config_path)::BaseType> config_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_config_path, config_path_fragment);
  params->config_path.Set(
      config_path_fragment.is_null() ? nullptr : config_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config_path in SpeechRecognitionService.SetSodaPath request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetSodaPath");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::BindSpeechRecognitionServiceClient(
    ::mojo::PendingRemote<SpeechRecognitionServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionServiceClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechRecognitionService.BindSpeechRecognitionServiceClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindSpeechRecognitionServiceClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionServiceStubDispatch::Accept(
    SpeechRecognitionService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionService_BindContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::BindContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::BindContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<SpeechRecognitionContext> p_context{};
      SpeechRecognitionService_BindContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindContext(
std::move(p_context));
      return true;
    }
    case internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::SetUrlLoaderFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::SetUrlLoaderFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> p_url_loader_factory{};
      SpeechRecognitionService_SetUrlLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUrlLoaderFactory(
std::move(p_url_loader_factory));
      return true;
    }
    case internal::kSpeechRecognitionService_SetSodaPath_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::SetSodaPath",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::SetSodaPath");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetSodaPath_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetSodaPath_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_binary_path{};
      ::base::FilePath p_config_path{};
      SpeechRecognitionService_SetSodaPath_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinaryPath(&p_binary_path))
        success = false;
      if (success && !input_data_view.ReadConfigPath(&p_config_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSodaPath(
std::move(p_binary_path), 
std::move(p_config_path));
      return true;
    }
    case internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SpeechRecognitionServiceClient> p_client{};
      SpeechRecognitionService_BindSpeechRecognitionServiceClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSpeechRecognitionServiceClient(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionServiceStubDispatch::AcceptWithResponder(
    SpeechRecognitionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionService_BindContext_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_SetSodaPath_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionServiceValidationInfo[] = {
    {internal::kSpeechRecognitionService_BindContext_Name,
     {&internal::SpeechRecognitionService_BindContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name,
     {&internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_SetSodaPath_Name,
     {&internal::SpeechRecognitionService_SetSodaPath_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name,
     {&internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionServiceValidationInfo);
}

const char AudioSourceFetcher::Name_[] = "media.mojom.AudioSourceFetcher";

AudioSourceFetcherProxy::AudioSourceFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioSourceFetcherProxy::Start(
    ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> in_factory, const WTF::String& in_device_id, const ::media::AudioParameters& in_audio_parameters) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioSourceFetcher::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_parameters"), in_audio_parameters,
                        "<value of type const ::media::AudioParameters&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioSourceFetcher_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceFetcher_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioStreamFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in AudioSourceFetcher.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in AudioSourceFetcher.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_parameters)::BaseType> audio_parameters_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_audio_parameters, audio_parameters_fragment);
  params->audio_parameters.Set(
      audio_parameters_fragment.is_null() ? nullptr : audio_parameters_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->audio_parameters.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null audio_parameters in AudioSourceFetcher.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceFetcher::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioSourceFetcherProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioSourceFetcher::Stop");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAudioSourceFetcher_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceFetcher_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceFetcher::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioSourceFetcherStubDispatch::Accept(
    AudioSourceFetcher* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioSourceFetcher_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioSourceFetcher::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioSourceFetcher::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioSourceFetcher_Start_Params_Data* params =
          reinterpret_cast<internal::AudioSourceFetcher_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> p_factory{};
      WTF::String p_device_id{};
      ::media::AudioParameters p_audio_parameters{};
      AudioSourceFetcher_Start_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadAudioParameters(&p_audio_parameters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioSourceFetcher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_factory), 
std::move(p_device_id), 
std::move(p_audio_parameters));
      return true;
    }
    case internal::kAudioSourceFetcher_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioSourceFetcher::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioSourceFetcher::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioSourceFetcher_Stop_Params_Data* params =
          reinterpret_cast<internal::AudioSourceFetcher_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioSourceFetcher_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioSourceFetcher::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop();
      return true;
    }
  }
  return false;
}

// static
bool AudioSourceFetcherStubDispatch::AcceptWithResponder(
    AudioSourceFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioSourceFetcher_Start_Name: {
      break;
    }
    case internal::kAudioSourceFetcher_Stop_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioSourceFetcherValidationInfo[] = {
    {internal::kAudioSourceFetcher_Start_Name,
     {&internal::AudioSourceFetcher_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioSourceFetcher_Stop_Name,
     {&internal::AudioSourceFetcher_Stop_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioSourceFetcherRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::AudioSourceFetcher::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioSourceFetcherValidationInfo);
}

const char SpeechRecognitionServiceClient::Name_[] = "media.mojom.SpeechRecognitionServiceClient";

SpeechRecognitionServiceClientProxy::SpeechRecognitionServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionServiceClientProxy::OnNetworkServiceDisconnect(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionServiceClient::Name_);
  message.set_method_name("OnNetworkServiceDisconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionServiceClientStubDispatch::Accept(
    SpeechRecognitionServiceClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkServiceDisconnect();
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionServiceClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionServiceClientValidationInfo[] = {
    {internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name,
     {&internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionServiceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionServiceClientValidationInfo);
}

const char SpeechRecognitionRecognizer::Name_[] = "media.mojom.SpeechRecognitionRecognizer";

SpeechRecognitionRecognizerProxy::SpeechRecognitionRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerProxy::SendAudioToSpeechRecognitionService(
    ::media::mojom::blink::AudioDataS16Ptr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::AudioDataS16Ptr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioDataS16DataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in SpeechRecognitionRecognizer.SendAudioToSpeechRecognitionService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("SendAudioToSpeechRecognitionService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionRecognizerProxy::OnLanguageChanged(
    const WTF::String& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizer_OnLanguageChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_language, language_fragment);
  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->language.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in SpeechRecognitionRecognizer.OnLanguageChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("OnLanguageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionRecognizerStubDispatch::Accept(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::AudioDataS16Ptr p_buffer{};
      SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendAudioToSpeechRecognitionService(
std::move(p_buffer));
      return true;
    }
    case internal::kSpeechRecognitionRecognizer_OnLanguageChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizer::OnLanguageChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_language{};
      SpeechRecognitionRecognizer_OnLanguageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLanguageChanged(
std::move(p_language));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name: {
      break;
    }
    case internal::kSpeechRecognitionRecognizer_OnLanguageChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionRecognizerValidationInfo[] = {
    {internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name,
     {&internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionRecognizer_OnLanguageChanged_Name,
     {&internal::SpeechRecognitionRecognizer_OnLanguageChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionRecognizerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionRecognizer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionRecognizerValidationInfo);
}

const char SpeechRecognitionRecognizerClient::Name_[] = "media.mojom.SpeechRecognitionRecognizerClient";

class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback(
      SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback);
};

SpeechRecognitionRecognizerClientProxy::SpeechRecognitionRecognizerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionRecognitionEvent(
    SpeechRecognitionResultPtr in_result, OnSpeechRecognitionRecognitionEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SpeechRecognitionResultPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in SpeechRecognitionRecognizerClient.OnSpeechRecognitionRecognitionEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionRecognitionEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionRecognizerClientProxy::OnLanguageIdentificationEvent(
    LanguageIdentificationEventPtr in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type LanguageIdentificationEventPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::LanguageIdentificationEventDataView>(
      in_event, event_fragment);
  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in SpeechRecognitionRecognizerClient.OnLanguageIdentificationEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnLanguageIdentificationEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder {
 public:
  static SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder> proxy(
        new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder);
};

bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionRecognizerClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionRecognitionEvent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::Accept(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name: {
      break;
    }
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionError();
      return true;
    }
    case internal::kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnLanguageIdentificationEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LanguageIdentificationEventPtr p_event{};
      SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLanguageIdentificationEvent(
std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionResultPtr p_result{};
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 0, false);
        return false;
      }
      SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEventCallback callback =
          SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionRecognitionEvent(
std::move(p_result), std::move(callback));
      return true;
    }
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name: {
      break;
    }
    case internal::kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionRecognizerClientValidationInfo[] = {
    {internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name,
     {&internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate,
      &internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams_Data::Validate}},
    {internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name,
     {&internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name,
     {&internal::SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionRecognizerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionRecognizerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionRecognizerClientValidationInfo);
}

bool SpeechRecognitionRecognizerClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionRecognizerClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSpeechRecognitionRecognizerClientValidationInfo);

}
const char SpeechRecognitionBrowserObserver::Name_[] = "media.mojom.SpeechRecognitionBrowserObserver";

SpeechRecognitionBrowserObserverProxy::SpeechRecognitionBrowserObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionBrowserObserverProxy::SpeechRecognitionAvailabilityChanged(
    bool in_is_speech_recognition_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speech_recognition_available"), in_is_speech_recognition_available,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data> params(
          message);
  params.Allocate();
  params->is_speech_recognition_available = in_is_speech_recognition_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionBrowserObserver::Name_);
  message.set_method_name("SpeechRecognitionAvailabilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionBrowserObserverProxy::SpeechRecognitionLanguageChanged(
    const WTF::String& in_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_language, language_fragment);
  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->language.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in SpeechRecognitionBrowserObserver.SpeechRecognitionLanguageChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionBrowserObserver::Name_);
  message.set_method_name("SpeechRecognitionLanguageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionBrowserObserverStubDispatch::Accept(
    SpeechRecognitionBrowserObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionAvailabilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_speech_recognition_available{};
      SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_speech_recognition_available = input_data_view.is_speech_recognition_available();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionBrowserObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SpeechRecognitionAvailabilityChanged(
std::move(p_is_speech_recognition_available));
      return true;
    }
    case internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionBrowserObserver::SpeechRecognitionLanguageChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_language{};
      SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionBrowserObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SpeechRecognitionLanguageChanged(
std::move(p_language));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionBrowserObserverStubDispatch::AcceptWithResponder(
    SpeechRecognitionBrowserObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name: {
      break;
    }
    case internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionBrowserObserverValidationInfo[] = {
    {internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name,
     {&internal::SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name,
     {&internal::SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionBrowserObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionBrowserObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionBrowserObserverValidationInfo);
}

const char SpeechRecognitionClientBrowserInterface::Name_[] = "media.mojom.SpeechRecognitionClientBrowserInterface";

SpeechRecognitionClientBrowserInterfaceProxy::SpeechRecognitionClientBrowserInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionClientBrowserInterfaceProxy::BindSpeechRecognitionBrowserObserver(
    ::mojo::PendingRemote<SpeechRecognitionBrowserObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<SpeechRecognitionBrowserObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionBrowserObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in SpeechRecognitionClientBrowserInterface.BindSpeechRecognitionBrowserObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionClientBrowserInterface::Name_);
  message.set_method_name("BindSpeechRecognitionBrowserObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionClientBrowserInterfaceStubDispatch::Accept(
    SpeechRecognitionClientBrowserInterface* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionClientBrowserInterface::BindSpeechRecognitionBrowserObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SpeechRecognitionBrowserObserver> p_observer{};
      SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionClientBrowserInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSpeechRecognitionBrowserObserver(
std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionClientBrowserInterfaceStubDispatch::AcceptWithResponder(
    SpeechRecognitionClientBrowserInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionClientBrowserInterfaceValidationInfo[] = {
    {internal::kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name,
     {&internal::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionClientBrowserInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionClientBrowserInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionClientBrowserInterfaceValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::HypothesisParts::DataView, ::media::mojom::blink::HypothesisPartsPtr>::Read(
    ::media::mojom::blink::HypothesisParts::DataView input,
    ::media::mojom::blink::HypothesisPartsPtr* output) {
  bool success = true;
  ::media::mojom::blink::HypothesisPartsPtr result(::media::mojom::blink::HypothesisParts::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadHypothesisPartOffset(&result->hypothesis_part_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::TimingInformation::DataView, ::media::mojom::blink::TimingInformationPtr>::Read(
    ::media::mojom::blink::TimingInformation::DataView input,
    ::media::mojom::blink::TimingInformationPtr* output) {
  bool success = true;
  ::media::mojom::blink::TimingInformationPtr result(::media::mojom::blink::TimingInformation::New());
  
      if (success && !input.ReadAudioStartTime(&result->audio_start_time))
        success = false;
      if (success && !input.ReadAudioEndTime(&result->audio_end_time))
        success = false;
      if (success && !input.ReadHypothesisParts(&result->hypothesis_parts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SpeechRecognitionResult::DataView, ::media::mojom::blink::SpeechRecognitionResultPtr>::Read(
    ::media::mojom::blink::SpeechRecognitionResult::DataView input,
    ::media::mojom::blink::SpeechRecognitionResultPtr* output) {
  bool success = true;
  ::media::mojom::blink::SpeechRecognitionResultPtr result(::media::mojom::blink::SpeechRecognitionResult::New());
  
      if (success && !input.ReadTranscription(&result->transcription))
        success = false;
      if (success)
        result->is_final = input.is_final();
      if (success && !input.ReadTimingInformation(&result->timing_information))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::LanguageIdentificationEvent::DataView, ::media::mojom::blink::LanguageIdentificationEventPtr>::Read(
    ::media::mojom::blink::LanguageIdentificationEvent::DataView input,
    ::media::mojom::blink::LanguageIdentificationEventPtr* output) {
  bool success = true;
  ::media::mojom::blink::LanguageIdentificationEventPtr result(::media::mojom::blink::LanguageIdentificationEvent::New());
  
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadConfidenceLevel(&result->confidence_level))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SpeechRecognitionOptions::DataView, ::media::mojom::blink::SpeechRecognitionOptionsPtr>::Read(
    ::media::mojom::blink::SpeechRecognitionOptions::DataView input,
    ::media::mojom::blink::SpeechRecognitionOptionsPtr* output) {
  bool success = true;
  ::media::mojom::blink::SpeechRecognitionOptionsPtr result(::media::mojom::blink::SpeechRecognitionOptions::New());
  
      if (success && !input.ReadRecognitionMode(&result->recognition_mode))
        success = false;
      if (success)
        result->enable_formatting = input.enable_formatting();
      if (success && !input.ReadLanguage(&result->language))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif