// media/mojo/mojom/video_decoder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_decoder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_decoder.mojom-params-data.h"
#include "media/mojo/mojom/video_decoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_decoder.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_JUMBO_H_
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"
#endif
namespace media {
namespace mojom {
SupportedVideoDecoderConfig::SupportedVideoDecoderConfig()
    : profile_min(),
      profile_max(),
      coded_size_min(),
      coded_size_max(),
      allow_encrypted(),
      require_encrypted() {}

SupportedVideoDecoderConfig::SupportedVideoDecoderConfig(
    ::media::VideoCodecProfile profile_min_in,
    ::media::VideoCodecProfile profile_max_in,
    const ::gfx::Size& coded_size_min_in,
    const ::gfx::Size& coded_size_max_in,
    bool allow_encrypted_in,
    bool require_encrypted_in)
    : profile_min(std::move(profile_min_in)),
      profile_max(std::move(profile_max_in)),
      coded_size_min(std::move(coded_size_min_in)),
      coded_size_max(std::move(coded_size_max_in)),
      allow_encrypted(std::move(allow_encrypted_in)),
      require_encrypted(std::move(require_encrypted_in)) {}

SupportedVideoDecoderConfig::~SupportedVideoDecoderConfig() = default;

void SupportedVideoDecoderConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_min"), this->profile_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_max"), this->profile_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_min"), this->coded_size_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_max"), this->coded_size_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_encrypted"), this->allow_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_encrypted"), this->require_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedVideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommandBufferId::CommandBufferId()
    : channel_token(),
      route_id() {}

CommandBufferId::CommandBufferId(
    const ::base::UnguessableToken& channel_token_in,
    int32_t route_id_in)
    : channel_token(std::move(channel_token_in)),
      route_id(std::move(route_id_in)) {}

CommandBufferId::~CommandBufferId() = default;

void CommandBufferId::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_token"), this->channel_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_id"), this->route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommandBufferId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VideoFrameHandleReleaser::Name_[] = "media.mojom.VideoFrameHandleReleaser";

VideoFrameHandleReleaserProxy::VideoFrameHandleReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoFrameHandleReleaserProxy::ReleaseVideoFrame(
    const ::base::UnguessableToken& in_release_token, const ::gpu::SyncToken& in_release_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_sync_token"), in_release_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoFrameHandleReleaser_ReleaseVideoFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_release_token, release_token_fragment);
  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->release_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null release_token in VideoFrameHandleReleaser.ReleaseVideoFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->release_sync_token)::BaseType> release_sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_release_sync_token, release_sync_token_fragment);
  params->release_sync_token.Set(
      release_sync_token_fragment.is_null() ? nullptr : release_sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->release_sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null release_sync_token in VideoFrameHandleReleaser.ReleaseVideoFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoFrameHandleReleaser::Name_);
  message.set_method_name("ReleaseVideoFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoFrameHandleReleaserStubDispatch::Accept(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoFrameHandleReleaser_ReleaseVideoFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoFrameHandleReleaser::ReleaseVideoFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* params =
          reinterpret_cast<internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_release_token{};
      ::gpu::SyncToken p_release_sync_token{};
      VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (success && !input_data_view.ReadReleaseSyncToken(&p_release_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoFrameHandleReleaser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseVideoFrame(
std::move(p_release_token), 
std::move(p_release_sync_token));
      return true;
    }
  }
  return false;
}

// static
bool VideoFrameHandleReleaserStubDispatch::AcceptWithResponder(
    VideoFrameHandleReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoFrameHandleReleaser_ReleaseVideoFrame_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoFrameHandleReleaserValidationInfo[] = {
    {internal::kVideoFrameHandleReleaser_ReleaseVideoFrame_Name,
     {&internal::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoFrameHandleReleaserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoFrameHandleReleaser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoFrameHandleReleaserValidationInfo);
}

const char VideoDecoder::Name_[] = "media.mojom.VideoDecoder";

class VideoDecoder_GetSupportedConfigs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_GetSupportedConfigs_ForwardToCallback(
      VideoDecoder::GetSupportedConfigsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::GetSupportedConfigsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_GetSupportedConfigs_ForwardToCallback);
};

class VideoDecoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Initialize_ForwardToCallback(
      VideoDecoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::InitializeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Initialize_ForwardToCallback);
};

class VideoDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Decode_ForwardToCallback(
      VideoDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::DecodeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Decode_ForwardToCallback);
};

class VideoDecoder_Reset_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoDecoder_Reset_ForwardToCallback(
      VideoDecoder::ResetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoDecoder::ResetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Reset_ForwardToCallback);
};

VideoDecoderProxy::VideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecoderProxy::GetSupportedConfigs(
    GetSupportedConfigsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::VideoDecoder::GetSupportedConfigs");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_GetSupportedConfigs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_GetSupportedConfigs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_GetSupportedConfigs_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoDecoderProxy::Construct(
    ::mojo::PendingAssociatedRemote<VideoDecoderClient> in_client, ::mojo::PendingAssociatedRemote<::media::mojom::MediaLog> in_media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> in_video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle in_decoder_buffer_pipe, CommandBufferIdPtr in_command_buffer_id, const ::gfx::ColorSpace& in_target_color_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoder::Construct", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<VideoDecoderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), in_media_log,
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::MediaLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_frame_handle_releaser"), in_video_frame_handle_releaser,
                        "<value of type ::mojo::PendingReceiver<VideoFrameHandleReleaser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_buffer_pipe"), in_decoder_buffer_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_buffer_id"), in_command_buffer_id,
                        "<value of type CommandBufferIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_color_space"), in_target_color_space,
                        "<value of type const ::gfx::ColorSpace&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Construct_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Construct_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoDecoderClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in VideoDecoder.Construct request");
  mojo::internal::Serialize<::media::mojom::MediaLogAssociatedPtrInfoDataView>(
      in_media_log, &params->media_log, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->media_log),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid media_log in VideoDecoder.Construct request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoFrameHandleReleaserInterfaceBase>>(
      in_video_frame_handle_releaser, &params->video_frame_handle_releaser, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->video_frame_handle_releaser),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid video_frame_handle_releaser in VideoDecoder.Construct request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_decoder_buffer_pipe, &params->decoder_buffer_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->decoder_buffer_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid decoder_buffer_pipe in VideoDecoder.Construct request");
  mojo::internal::MessageFragment<
      typename decltype(params->command_buffer_id)::BaseType> command_buffer_id_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::CommandBufferIdDataView>(
      in_command_buffer_id, command_buffer_id_fragment);
  params->command_buffer_id.Set(
      command_buffer_id_fragment.is_null() ? nullptr : command_buffer_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->target_color_space)::BaseType> target_color_space_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
      in_target_color_space, target_color_space_fragment);
  params->target_color_space.Set(
      target_color_space_fragment.is_null() ? nullptr : target_color_space_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_color_space.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_color_space in VideoDecoder.Construct request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Construct");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoDecoderProxy::Initialize(
    const ::media::VideoDecoderConfig& in_config, bool in_low_delay, const absl::optional<::base::UnguessableToken>& in_cdm_id, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::VideoDecoderConfig&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("low_delay"), in_low_delay,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_id"), in_cdm_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in VideoDecoder.Initialize request");
  params->low_delay = in_low_delay;
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_id)::BaseType> cdm_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id, cdm_id_fragment);
  params->cdm_id.Set(
      cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoDecoderProxy::Decode(
    ::media::mojom::DecoderBufferPtr in_buffer, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Decode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in VideoDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoDecoderProxy::Reset(
    ResetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::VideoDecoder::Reset");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Reset_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Reset");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoDecoder_Reset_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoDecoderProxy::OnOverlayInfoChanged(
    const ::media::OverlayInfo& in_overlay_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoder::OnOverlayInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overlay_info"), in_overlay_info,
                        "<value of type const ::media::OverlayInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_OnOverlayInfoChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_OnOverlayInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->overlay_info)::BaseType> overlay_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::OverlayInfoDataView>(
      in_overlay_info, overlay_info_fragment);
  params->overlay_info.Set(
      overlay_info_fragment.is_null() ? nullptr : overlay_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->overlay_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null overlay_info in VideoDecoder.OnOverlayInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("OnOverlayInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class VideoDecoder_GetSupportedConfigs_ProxyToResponder {
 public:
  static VideoDecoder::GetSupportedConfigsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoDecoder_GetSupportedConfigs_ProxyToResponder> proxy(
        new VideoDecoder_GetSupportedConfigs_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoDecoder_GetSupportedConfigs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_GetSupportedConfigs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoDecoder_GetSupportedConfigs_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoDecoder::GetSupportedConfigsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::SupportedVideoDecoderConfig>& in_supported_configs, ::media::VideoDecoderType in_decoder_type);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_GetSupportedConfigs_ProxyToResponder);
};

bool VideoDecoder_GetSupportedConfigs_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoDecoder::GetSupportedConfigsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::media::SupportedVideoDecoderConfig> p_supported_configs{};
  ::media::VideoDecoderType p_decoder_type{};
  VideoDecoder_GetSupportedConfigs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedConfigs(&p_supported_configs))
    success = false;
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_supported_configs), 
std::move(p_decoder_type));
  return true;
}

void VideoDecoder_GetSupportedConfigs_ProxyToResponder::Run(
    const std::vector<::media::SupportedVideoDecoderConfig>& in_supported_configs, ::media::VideoDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoDecoder::GetSupportedConfigsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_configs"), in_supported_configs,
                        "<value of type const std::vector<::media::SupportedVideoDecoderConfig>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_GetSupportedConfigs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->supported_configs)::BaseType>
      supported_configs_fragment(params.message());
  const mojo::internal::ContainerValidateParams supported_configs_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SupportedVideoDecoderConfigDataView>>(
      in_supported_configs, supported_configs_fragment, &supported_configs_validate_params);
  params->supported_configs.Set(
      supported_configs_fragment.is_null() ? nullptr : supported_configs_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->supported_configs.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_configs in ");
  mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
      in_decoder_type, &params->decoder_type);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoDecoder::GetSupportedConfigsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("GetSupportedConfigs");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoDecoder_Initialize_ProxyToResponder {
 public:
  static VideoDecoder::InitializeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoDecoder_Initialize_ProxyToResponder> proxy(
        new VideoDecoder_Initialize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoDecoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoDecoder_Initialize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoDecoder::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::Status& in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Initialize_ProxyToResponder);
};

bool VideoDecoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoDecoder::InitializeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoDecoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::Status p_status{};
  bool p_needs_bitstream_conversion{};
  int32_t p_max_decode_requests{};
  ::media::VideoDecoderType p_decoder_type{};
  VideoDecoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_needs_bitstream_conversion = input_data_view.needs_bitstream_conversion();
  if (success)
    p_max_decode_requests = input_data_view.max_decode_requests();
  if (success && !input_data_view.ReadDecoderType(&p_decoder_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_needs_bitstream_conversion), 
std::move(p_max_decode_requests), 
std::move(p_decoder_type));
  return true;
}

void VideoDecoder_Initialize_ProxyToResponder::Run(
    const ::media::Status& in_status, bool in_needs_bitstream_conversion, int32_t in_max_decode_requests, ::media::VideoDecoderType in_decoder_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoDecoder::InitializeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::Status&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_bitstream_conversion"), in_needs_bitstream_conversion,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_decode_requests"), in_max_decode_requests,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_type"), in_decoder_type,
                        "<value of type ::media::VideoDecoderType>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");
  params->needs_bitstream_conversion = in_needs_bitstream_conversion;
  params->max_decode_requests = in_max_decode_requests;
  mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
      in_decoder_type, &params->decoder_type);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoDecoder::InitializeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoDecoder_Decode_ProxyToResponder {
 public:
  static VideoDecoder::DecodeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoDecoder_Decode_ProxyToResponder> proxy(
        new VideoDecoder_Decode_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoDecoder_Decode_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoDecoder::DecodeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::Status& in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Decode_ProxyToResponder);
};

bool VideoDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoDecoder::DecodeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::Status p_status{};
  VideoDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void VideoDecoder_Decode_ProxyToResponder::Run(
    const ::media::Status& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoDecoder::DecodeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::Status&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Decode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoDecoder::DecodeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoDecoder_Reset_ProxyToResponder {
 public:
  static VideoDecoder::ResetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoDecoder_Reset_ProxyToResponder> proxy(
        new VideoDecoder_Reset_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoDecoder_Reset_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoDecoder_Reset_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoDecoder_Reset_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoDecoder::ResetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoDecoder_Reset_ProxyToResponder);
};

bool VideoDecoder_Reset_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoDecoder::ResetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoDecoder_Reset_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoDecoder_Reset_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VideoDecoder_Reset_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoDecoder::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VideoDecoder_Reset_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::VideoDecoder::ResetCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoder_Reset_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoder_Reset_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoDecoder::ResetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoder::Name_);
  message.set_method_name("Reset");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoDecoderStubDispatch::Accept(
    VideoDecoder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoDecoder_GetSupportedConfigs_Name: {
      break;
    }
    case internal::kVideoDecoder_Construct_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::Construct",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::Construct");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecoder_Construct_Params_Data* params =
          reinterpret_cast<internal::VideoDecoder_Construct_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<VideoDecoderClient> p_client{};
      ::mojo::PendingAssociatedRemote<::media::mojom::MediaLog> p_media_log{};
      ::mojo::PendingReceiver<VideoFrameHandleReleaser> p_video_frame_handle_releaser{};
      ::mojo::ScopedDataPipeConsumerHandle p_decoder_buffer_pipe{};
      CommandBufferIdPtr p_command_buffer_id{};
      ::gfx::ColorSpace p_target_color_space{};
      VideoDecoder_Construct_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_media_log =
            input_data_view.TakeMediaLog<decltype(p_media_log)>();
      }
      if (success) {
        p_video_frame_handle_releaser =
            input_data_view.TakeVideoFrameHandleReleaser<decltype(p_video_frame_handle_releaser)>();
      }
      if (success)
        p_decoder_buffer_pipe = input_data_view.TakeDecoderBufferPipe();
      if (success && !input_data_view.ReadCommandBufferId(&p_command_buffer_id))
        success = false;
      if (success && !input_data_view.ReadTargetColorSpace(&p_target_color_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Construct(
std::move(p_client), 
std::move(p_media_log), 
std::move(p_video_frame_handle_releaser), 
std::move(p_decoder_buffer_pipe), 
std::move(p_command_buffer_id), 
std::move(p_target_color_space));
      return true;
    }
    case internal::kVideoDecoder_Initialize_Name: {
      break;
    }
    case internal::kVideoDecoder_Decode_Name: {
      break;
    }
    case internal::kVideoDecoder_Reset_Name: {
      break;
    }
    case internal::kVideoDecoder_OnOverlayInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::OnOverlayInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::OnOverlayInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecoder_OnOverlayInfoChanged_Params_Data* params =
          reinterpret_cast<internal::VideoDecoder_OnOverlayInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::OverlayInfo p_overlay_info{};
      VideoDecoder_OnOverlayInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOverlayInfo(&p_overlay_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOverlayInfoChanged(
std::move(p_overlay_info));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecoderStubDispatch::AcceptWithResponder(
    VideoDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoDecoder_GetSupportedConfigs_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::GetSupportedConfigs",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::GetSupportedConfigs");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoDecoder_GetSupportedConfigs_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_GetSupportedConfigs_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoDecoder_GetSupportedConfigs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 0, false);
        return false;
      }
      VideoDecoder::GetSupportedConfigsCallback callback =
          VideoDecoder_GetSupportedConfigs_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSupportedConfigs(std::move(callback));
      return true;
    }
    case internal::kVideoDecoder_Construct_Name: {
      break;
    }
    case internal::kVideoDecoder_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoDecoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::VideoDecoderConfig p_config{};
      bool p_low_delay{};
      absl::optional<::base::UnguessableToken> p_cdm_id{};
      VideoDecoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success)
        p_low_delay = input_data_view.low_delay();
      if (success && !input_data_view.ReadCdmId(&p_cdm_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 2, false);
        return false;
      }
      VideoDecoder::InitializeCallback callback =
          VideoDecoder_Initialize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_config), 
std::move(p_low_delay), 
std::move(p_cdm_id), std::move(callback));
      return true;
    }
    case internal::kVideoDecoder_Decode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::Decode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::Decode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::mojom::DecoderBufferPtr p_buffer{};
      VideoDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 3, false);
        return false;
      }
      VideoDecoder::DecodeCallback callback =
          VideoDecoder_Decode_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(
std::move(p_buffer), std::move(callback));
      return true;
    }
    case internal::kVideoDecoder_Reset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoder::Reset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoder::Reset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoDecoder_Reset_Params_Data* params =
          reinterpret_cast<
              internal::VideoDecoder_Reset_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VideoDecoder_Reset_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoder::Name_, 4, false);
        return false;
      }
      VideoDecoder::ResetCallback callback =
          VideoDecoder_Reset_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(std::move(callback));
      return true;
    }
    case internal::kVideoDecoder_OnOverlayInfoChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoDecoderValidationInfo[] = {
    {internal::kVideoDecoder_GetSupportedConfigs_Name,
     {&internal::VideoDecoder_GetSupportedConfigs_Params_Data::Validate,
      &internal::VideoDecoder_GetSupportedConfigs_ResponseParams_Data::Validate}},
    {internal::kVideoDecoder_Construct_Name,
     {&internal::VideoDecoder_Construct_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoDecoder_Initialize_Name,
     {&internal::VideoDecoder_Initialize_Params_Data::Validate,
      &internal::VideoDecoder_Initialize_ResponseParams_Data::Validate}},
    {internal::kVideoDecoder_Decode_Name,
     {&internal::VideoDecoder_Decode_Params_Data::Validate,
      &internal::VideoDecoder_Decode_ResponseParams_Data::Validate}},
    {internal::kVideoDecoder_Reset_Name,
     {&internal::VideoDecoder_Reset_Params_Data::Validate,
      &internal::VideoDecoder_Reset_ResponseParams_Data::Validate}},
    {internal::kVideoDecoder_OnOverlayInfoChanged_Name,
     {&internal::VideoDecoder_OnOverlayInfoChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoDecoderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoDecoder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoDecoderValidationInfo);
}

bool VideoDecoderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoDecoder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoDecoderValidationInfo);

}
const char VideoDecoderClient::Name_[] = "media.mojom.VideoDecoderClient";

VideoDecoderClientProxy::VideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecoderClientProxy::OnVideoFrameDecoded(
    const ::scoped_refptr<::media::VideoFrame>& in_frame, bool in_can_read_without_stalling, const absl::optional<::base::UnguessableToken>& in_release_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoderClient::OnVideoFrameDecoded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type const ::scoped_refptr<::media::VideoFrame>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_read_without_stalling"), in_can_read_without_stalling,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("release_token"), in_release_token,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoderClient_OnVideoFrameDecoded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in VideoDecoderClient.OnVideoFrameDecoded request");
  params->can_read_without_stalling = in_can_read_without_stalling;
  mojo::internal::MessageFragment<
      typename decltype(params->release_token)::BaseType> release_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_release_token, release_token_fragment);
  params->release_token.Set(
      release_token_fragment.is_null() ? nullptr : release_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnVideoFrameDecoded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoDecoderClientProxy::OnWaiting(
    ::media::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoderClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::WaitingReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoderClient_OnWaiting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoDecoderClientProxy::RequestOverlayInfo(
    bool in_restart_for_transitions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoDecoderClient::RequestOverlayInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restart_for_transitions"), in_restart_for_transitions,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVideoDecoderClient_RequestOverlayInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecoderClient_RequestOverlayInfo_Params_Data> params(
          message);
  params.Allocate();
  params->restart_for_transitions = in_restart_for_transitions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecoderClient::Name_);
  message.set_method_name("RequestOverlayInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoDecoderClientStubDispatch::Accept(
    VideoDecoderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoDecoderClient_OnVideoFrameDecoded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoderClient::OnVideoFrameDecoded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoderClient::OnVideoFrameDecoded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::media::VideoFrame> p_frame{};
      bool p_can_read_without_stalling{};
      absl::optional<::base::UnguessableToken> p_release_token{};
      VideoDecoderClient_OnVideoFrameDecoded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success)
        p_can_read_without_stalling = input_data_view.can_read_without_stalling();
      if (success && !input_data_view.ReadReleaseToken(&p_release_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoFrameDecoded(
std::move(p_frame), 
std::move(p_can_read_without_stalling), 
std::move(p_release_token));
      return true;
    }
    case internal::kVideoDecoderClient_OnWaiting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoderClient::OnWaiting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoderClient::OnWaiting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::WaitingReason p_reason{};
      VideoDecoderClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(
std::move(p_reason));
      return true;
    }
    case internal::kVideoDecoderClient_RequestOverlayInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoDecoderClient::RequestOverlayInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoDecoderClient::RequestOverlayInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoDecoderClient_RequestOverlayInfo_Params_Data* params =
          reinterpret_cast<internal::VideoDecoderClient_RequestOverlayInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_restart_for_transitions{};
      VideoDecoderClient_RequestOverlayInfo_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_restart_for_transitions = input_data_view.restart_for_transitions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecoderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestOverlayInfo(
std::move(p_restart_for_transitions));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecoderClientStubDispatch::AcceptWithResponder(
    VideoDecoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoDecoderClient_OnVideoFrameDecoded_Name: {
      break;
    }
    case internal::kVideoDecoderClient_OnWaiting_Name: {
      break;
    }
    case internal::kVideoDecoderClient_RequestOverlayInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoDecoderClientValidationInfo[] = {
    {internal::kVideoDecoderClient_OnVideoFrameDecoded_Name,
     {&internal::VideoDecoderClient_OnVideoFrameDecoded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoDecoderClient_OnWaiting_Name,
     {&internal::VideoDecoderClient_OnWaiting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoDecoderClient_RequestOverlayInfo_Name,
     {&internal::VideoDecoderClient_RequestOverlayInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoDecoderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::VideoDecoderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoDecoderClientValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::SupportedVideoDecoderConfig::DataView, ::media::mojom::SupportedVideoDecoderConfigPtr>::Read(
    ::media::mojom::SupportedVideoDecoderConfig::DataView input,
    ::media::mojom::SupportedVideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::SupportedVideoDecoderConfigPtr result(::media::mojom::SupportedVideoDecoderConfig::New());
  
      if (success && !input.ReadProfileMin(&result->profile_min))
        success = false;
      if (success && !input.ReadProfileMax(&result->profile_max))
        success = false;
      if (success && !input.ReadCodedSizeMin(&result->coded_size_min))
        success = false;
      if (success && !input.ReadCodedSizeMax(&result->coded_size_max))
        success = false;
      if (success)
        result->allow_encrypted = input.allow_encrypted();
      if (success)
        result->require_encrypted = input.require_encrypted();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CommandBufferId::DataView, ::media::mojom::CommandBufferIdPtr>::Read(
    ::media::mojom::CommandBufferId::DataView input,
    ::media::mojom::CommandBufferIdPtr* output) {
  bool success = true;
  ::media::mojom::CommandBufferIdPtr result(::media::mojom::CommandBufferId::New());
  
      if (success && !input.ReadChannelToken(&result->channel_token))
        success = false;
      if (success)
        result->route_id = input.route_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif