// media/mojo/mojom/video_encoder_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encoder_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_info.mojom-params-data.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encoder_info.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
ResolutionBitrateLimit::ResolutionBitrateLimit()
    : frame_size(),
      min_start_bitrate_bps(),
      min_bitrate_bps(),
      max_bitrate_bps() {}

ResolutionBitrateLimit::ResolutionBitrateLimit(
    const ::gfx::Size& frame_size_in,
    int32_t min_start_bitrate_bps_in,
    int32_t min_bitrate_bps_in,
    int32_t max_bitrate_bps_in)
    : frame_size(std::move(frame_size_in)),
      min_start_bitrate_bps(std::move(min_start_bitrate_bps_in)),
      min_bitrate_bps(std::move(min_bitrate_bps_in)),
      max_bitrate_bps(std::move(max_bitrate_bps_in)) {}

ResolutionBitrateLimit::~ResolutionBitrateLimit() = default;

void ResolutionBitrateLimit::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_size"), this->frame_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_start_bitrate_bps"), this->min_start_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_bitrate_bps"), this->min_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_bitrate_bps"), this->max_bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolutionBitrateLimit::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncoderInfo::VideoEncoderInfo()
    : implementation_name(),
      supports_native_handle(),
      has_trusted_rate_controller(),
      is_hardware_accelerated(),
      supports_simulcast(),
      fps_allocation(),
      resolution_bitrate_limits() {}

VideoEncoderInfo::VideoEncoderInfo(
    const std::string& implementation_name_in,
    bool supports_native_handle_in,
    bool has_trusted_rate_controller_in,
    bool is_hardware_accelerated_in,
    bool supports_simulcast_in,
    std::vector<std::vector<uint8_t>> fps_allocation_in,
    std::vector<::media::ResolutionBitrateLimit> resolution_bitrate_limits_in)
    : implementation_name(std::move(implementation_name_in)),
      supports_native_handle(std::move(supports_native_handle_in)),
      has_trusted_rate_controller(std::move(has_trusted_rate_controller_in)),
      is_hardware_accelerated(std::move(is_hardware_accelerated_in)),
      supports_simulcast(std::move(supports_simulcast_in)),
      fps_allocation(std::move(fps_allocation_in)),
      resolution_bitrate_limits(std::move(resolution_bitrate_limits_in)) {}

VideoEncoderInfo::~VideoEncoderInfo() = default;

void VideoEncoderInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "implementation_name"), this->implementation_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_native_handle"), this->supports_native_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trusted_rate_controller"), this->has_trusted_rate_controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_hardware_accelerated"), this->is_hardware_accelerated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_simulcast"), this->supports_simulcast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fps_allocation"), this->fps_allocation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution_bitrate_limits"), this->resolution_bitrate_limits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::ResolutionBitrateLimit>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncoderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::ResolutionBitrateLimit::DataView, ::media::mojom::ResolutionBitrateLimitPtr>::Read(
    ::media::mojom::ResolutionBitrateLimit::DataView input,
    ::media::mojom::ResolutionBitrateLimitPtr* output) {
  bool success = true;
  ::media::mojom::ResolutionBitrateLimitPtr result(::media::mojom::ResolutionBitrateLimit::New());
  
      if (success && !input.ReadFrameSize(&result->frame_size))
        success = false;
      if (success)
        result->min_start_bitrate_bps = input.min_start_bitrate_bps();
      if (success)
        result->min_bitrate_bps = input.min_bitrate_bps();
      if (success)
        result->max_bitrate_bps = input.max_bitrate_bps();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEncoderInfo::DataView, ::media::mojom::VideoEncoderInfoPtr>::Read(
    ::media::mojom::VideoEncoderInfo::DataView input,
    ::media::mojom::VideoEncoderInfoPtr* output) {
  bool success = true;
  ::media::mojom::VideoEncoderInfoPtr result(::media::mojom::VideoEncoderInfo::New());
  
      if (success && !input.ReadImplementationName(&result->implementation_name))
        success = false;
      if (success)
        result->supports_native_handle = input.supports_native_handle();
      if (success)
        result->has_trusted_rate_controller = input.has_trusted_rate_controller();
      if (success)
        result->is_hardware_accelerated = input.is_hardware_accelerated();
      if (success)
        result->supports_simulcast = input.supports_simulcast();
      if (success && !input.ReadFpsAllocation(&result->fps_allocation))
        success = false;
      if (success && !input.ReadResolutionBitrateLimits(&result->resolution_bitrate_limits))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif