// mojo/public/mojom/base/application_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/application_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/application_state.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

static NOINLINE const char* ApplicationStateToStringHelper(ApplicationState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ApplicationState::UNKNOWN:
      return "UNKNOWN";
    case ApplicationState::HAS_RUNNING_ACTIVITIES:
      return "HAS_RUNNING_ACTIVITIES";
    case ApplicationState::HAS_PAUSED_ACTIVITIES:
      return "HAS_PAUSED_ACTIVITIES";
    case ApplicationState::HAS_STOPPED_ACTIVITIES:
      return "HAS_STOPPED_ACTIVITIES";
    case ApplicationState::HAS_DESTROYED_ACTIVITIES:
      return "HAS_DESTROYED_ACTIVITIES";
    default:
      return nullptr;
  }
}

std::string ApplicationStateToString(ApplicationState value) {
  const char *str = ApplicationStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ApplicationState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ApplicationState value) {
  return os << ApplicationStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base

namespace perfetto {

// static
void TraceFormatTraits<::mojo_base::mojom::ApplicationState>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojo_base::mojom::ApplicationState value) {
  return std::move(context).WriteString(::mojo_base::mojom::ApplicationStateToString(value));
}

} // namespace perfetto
