// printing/mojom/print.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "printing/mojom/print.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/mojom/print.mojom-params-data.h"
namespace printing {
namespace mojom {

static NOINLINE const char* ColorModelToStringHelper(ColorModel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorModel::kUnknownColorModel:
      return "kUnknownColorModel";
    case ColorModel::kGray:
      return "kGray";
    case ColorModel::kColor:
      return "kColor";
    case ColorModel::kCMYK:
      return "kCMYK";
    case ColorModel::kCMY:
      return "kCMY";
    case ColorModel::kKCMY:
      return "kKCMY";
    case ColorModel::kCMYPlusK:
      return "kCMYPlusK";
    case ColorModel::kBlack:
      return "kBlack";
    case ColorModel::kGrayscale:
      return "kGrayscale";
    case ColorModel::kRGB:
      return "kRGB";
    case ColorModel::kRGB16:
      return "kRGB16";
    case ColorModel::kRGBA:
      return "kRGBA";
    case ColorModel::kColorModeColor:
      return "kColorModeColor";
    case ColorModel::kColorModeMonochrome:
      return "kColorModeMonochrome";
    case ColorModel::kHPColorColor:
      return "kHPColorColor";
    case ColorModel::kHPColorBlack:
      return "kHPColorBlack";
    case ColorModel::kPrintoutModeNormal:
      return "kPrintoutModeNormal";
    case ColorModel::kPrintoutModeNormalGray:
      return "kPrintoutModeNormalGray";
    case ColorModel::kProcessColorModelCMYK:
      return "kProcessColorModelCMYK";
    case ColorModel::kProcessColorModelGreyscale:
      return "kProcessColorModelGreyscale";
    case ColorModel::kProcessColorModelRGB:
      return "kProcessColorModelRGB";
    case ColorModel::kBrotherCUPSColor:
      return "kBrotherCUPSColor";
    case ColorModel::kBrotherCUPSMono:
      return "kBrotherCUPSMono";
    case ColorModel::kBrotherBRScript3Color:
      return "kBrotherBRScript3Color";
    case ColorModel::kBrotherBRScript3Black:
      return "kBrotherBRScript3Black";
    case ColorModel::kEpsonInkColor:
      return "kEpsonInkColor";
    case ColorModel::kEpsonInkMono:
      return "kEpsonInkMono";
    case ColorModel::kSharpARCModeCMColor:
      return "kSharpARCModeCMColor";
    case ColorModel::kSharpARCModeCMBW:
      return "kSharpARCModeCMBW";
    case ColorModel::kXeroxXRXColorAutomatic:
      return "kXeroxXRXColorAutomatic";
    case ColorModel::kXeroxXRXColorBW:
      return "{kXeroxXRXColorBW, kColorModelLast}";
    default:
      return nullptr;
  }
}

std::string ColorModelToString(ColorModel value) {
  const char *str = ColorModelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorModel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorModel value) {
  return os << ColorModelToString(value);
}

static NOINLINE const char* DuplexModeToStringHelper(DuplexMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DuplexMode::kUnknownDuplexMode:
      return "kUnknownDuplexMode";
    case DuplexMode::kSimplex:
      return "kSimplex";
    case DuplexMode::kLongEdge:
      return "kLongEdge";
    case DuplexMode::kShortEdge:
      return "kShortEdge";
    default:
      return nullptr;
  }
}

std::string DuplexModeToString(DuplexMode value) {
  const char *str = DuplexModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DuplexMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DuplexMode value) {
  return os << DuplexModeToString(value);
}

static NOINLINE const char* PageOrientationToStringHelper(PageOrientation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PageOrientation::kUpright:
      return "kUpright";
    case PageOrientation::kRotateLeft:
      return "kRotateLeft";
    case PageOrientation::kRotateRight:
      return "kRotateRight";
    default:
      return nullptr;
  }
}

std::string PageOrientationToString(PageOrientation value) {
  const char *str = PageOrientationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PageOrientation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PageOrientation value) {
  return os << PageOrientationToString(value);
}

static NOINLINE const char* PrintScalingOptionToStringHelper(PrintScalingOption value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrintScalingOption::kNone:
      return "kNone";
    case PrintScalingOption::kFitToPrintableArea:
      return "kFitToPrintableArea";
    case PrintScalingOption::kSourceSize:
      return "kSourceSize";
    case PrintScalingOption::kFitToPaper:
      return "kFitToPaper";
    default:
      return nullptr;
  }
}

std::string PrintScalingOptionToString(PrintScalingOption value) {
  const char *str = PrintScalingOptionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrintScalingOption value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrintScalingOption value) {
  return os << PrintScalingOptionToString(value);
}

static NOINLINE const char* SkiaDocumentTypeToStringHelper(SkiaDocumentType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SkiaDocumentType::kPDF:
      return "kPDF";
    case SkiaDocumentType::kMSKP:
      return "kMSKP";
    default:
      return nullptr;
  }
}

std::string SkiaDocumentTypeToString(SkiaDocumentType value) {
  const char *str = SkiaDocumentTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SkiaDocumentType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SkiaDocumentType value) {
  return os << SkiaDocumentTypeToString(value);
}

static NOINLINE const char* MarginTypeToStringHelper(MarginType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MarginType::kDefaultMargins:
      return "kDefaultMargins";
    case MarginType::kNoMargins:
      return "kNoMargins";
    case MarginType::kPrintableAreaMargins:
      return "kPrintableAreaMargins";
    case MarginType::kCustomMargins:
      return "kCustomMargins";
    default:
      return nullptr;
  }
}

std::string MarginTypeToString(MarginType value) {
  const char *str = MarginTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MarginType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MarginType value) {
  return os << MarginTypeToString(value);
}

static NOINLINE const char* ResultCodeToStringHelper(ResultCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResultCode::kSuccess:
      return "kSuccess";
    case ResultCode::kFailed:
      return "kFailed";
    case ResultCode::kAccessDenied:
      return "kAccessDenied";
    default:
      return nullptr;
  }
}

std::string ResultCodeToString(ResultCode value) {
  const char *str = ResultCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResultCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResultCode value) {
  return os << ResultCodeToString(value);
}

static NOINLINE const char* PrinterTypeToStringHelper(PrinterType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrinterType::kPrivet:
      return "kPrivet";
    case PrinterType::kExtension:
      return "kExtension";
    case PrinterType::kPdf:
      return "kPdf";
    case PrinterType::kLocal:
      return "kLocal";
    case PrinterType::kCloud:
      return "kCloud";
    default:
      return nullptr;
  }
}

std::string PrinterTypeToString(PrinterType value) {
  const char *str = PrinterTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrinterType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrinterType value) {
  return os << PrinterTypeToString(value);
}

namespace internal {


// static
bool PageSizeMargins_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageSizeMargins_Data* object = static_cast<const PageSizeMargins_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageSizeMargins_Data::PageSizeMargins_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::ColorModel>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::ColorModel value) {
  return std::move(context).WriteString(::printing::mojom::ColorModelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::DuplexMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::DuplexMode value) {
  return std::move(context).WriteString(::printing::mojom::DuplexModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PageOrientation>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PageOrientation value) {
  return std::move(context).WriteString(::printing::mojom::PageOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrintScalingOption>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PrintScalingOption value) {
  return std::move(context).WriteString(::printing::mojom::PrintScalingOptionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::SkiaDocumentType>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::SkiaDocumentType value) {
  return std::move(context).WriteString(::printing::mojom::SkiaDocumentTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::MarginType>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::MarginType value) {
  return std::move(context).WriteString(::printing::mojom::MarginTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::ResultCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::ResultCode value) {
  return std::move(context).WriteString(::printing::mojom::ResultCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrinterType>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PrinterType value) {
  return std::move(context).WriteString(::printing::mojom::PrinterTypeToString(value));
}

} // namespace perfetto
