// qtwebengine/browser/plugin.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/browser/plugin.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/browser/plugin.mojom-params-data.h"
namespace chrome {
namespace mojom {

static NOINLINE const char* PluginStatusToStringHelper(PluginStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PluginStatus::kAllowed:
      return "kAllowed";
    case PluginStatus::kBlocked:
      return "kBlocked";
    case PluginStatus::kBlockedByPolicy:
      return "kBlockedByPolicy";
    case PluginStatus::kBlockedNoLoading:
      return "kBlockedNoLoading";
    case PluginStatus::kComponentUpdateRequired:
      return "kComponentUpdateRequired";
    case PluginStatus::kDisabled:
      return "kDisabled";
    case PluginStatus::kFlashHiddenPreferHtml:
      return "kFlashHiddenPreferHtml";
    case PluginStatus::kNotFound:
      return "kNotFound";
    case PluginStatus::kOutdatedBlocked:
      return "kOutdatedBlocked";
    case PluginStatus::kOutdatedDisallowed:
      return "kOutdatedDisallowed";
    case PluginStatus::kPlayImportantContent:
      return "kPlayImportantContent";
    case PluginStatus::kRestartRequired:
      return "kRestartRequired";
    case PluginStatus::kUnauthorized:
      return "kUnauthorized";
    default:
      return nullptr;
  }
}

std::string PluginStatusToString(PluginStatus value) {
  const char *str = PluginStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PluginStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PluginStatus value) {
  return os << PluginStatusToString(value);
}

namespace internal {


// static
bool PluginInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PluginInfo_Data* object = static_cast<const PluginInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::chrome::mojom::internal::PluginStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plugin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->plugin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_mime_type, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams actual_mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->actual_mime_type, validation_context,
                                         &actual_mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_identifier, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams group_identifier_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->group_identifier, validation_context,
                                         &group_identifier_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_name, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_name, validation_context))
    return false;

  return true;
}

PluginInfo_Data::PluginInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::PluginStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::PluginStatus value) {
  return std::move(context).WriteString(::chrome::mojom::PluginStatusToString(value));
}

} // namespace perfetto
