// qtwebengine/browser/plugin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/plugin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/browser/plugin.mojom-params-data.h"
#include "qtwebengine/browser/plugin.mojom-shared-message-ids.h"

#include "qtwebengine/browser/plugin.mojom-import-headers.h"


#ifndef QTWEBENGINE_BROWSER_PLUGIN_MOJOM_JUMBO_H_
#define QTWEBENGINE_BROWSER_PLUGIN_MOJOM_JUMBO_H_
#endif
namespace chrome {
namespace mojom {
PluginInfo::PluginInfo()
    : status(),
      plugin(),
      actual_mime_type(),
      group_identifier(),
      group_name() {}

PluginInfo::PluginInfo(
    PluginStatus status_in,
    WebPluginInfoPtr plugin_in,
    const std::string& actual_mime_type_in,
    const std::string& group_identifier_in,
    const ::std::u16string& group_name_in)
    : status(std::move(status_in)),
      plugin(std::move(plugin_in)),
      actual_mime_type(std::move(actual_mime_type_in)),
      group_identifier(std::move(group_identifier_in)),
      group_name(std::move(group_name_in)) {}

PluginInfo::~PluginInfo() = default;

void PluginInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PluginStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plugin"), this->plugin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPluginInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actual_mime_type"), this->actual_mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_identifier"), this->group_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_name"), this->group_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace chrome

namespace mojo {


// static
bool StructTraits<::chrome::mojom::PluginInfo::DataView, ::chrome::mojom::PluginInfoPtr>::Read(
    ::chrome::mojom::PluginInfo::DataView input,
    ::chrome::mojom::PluginInfoPtr* output) {
  bool success = true;
  ::chrome::mojom::PluginInfoPtr result(::chrome::mojom::PluginInfo::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadPlugin(&result->plugin))
        success = false;
      if (success && !input.ReadActualMimeType(&result->actual_mime_type))
        success = false;
      if (success && !input.ReadGroupIdentifier(&result->group_identifier))
        success = false;
      if (success && !input.ReadGroupName(&result->group_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif