// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/resources_private.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "qtwebengine/common/extensions/api/resources_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace resources_private {
//
// Types
//

const char* ToString(Component enum_param) {
  switch (enum_param) {
    case COMPONENT_IDENTITY:
      return "identity";
    case COMPONENT_PDF:
      return "pdf";
    case COMPONENT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

Component ParseComponent(const std::string& enum_string) {
  if (enum_string == "identity")
    return COMPONENT_IDENTITY;
  if (enum_string == "pdf")
    return COMPONENT_PDF;
  return COMPONENT_NONE;
}



//
// Functions
//

namespace GetStrings {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* component_value = nullptr;
  if (args.Get(0, &component_value) &&
      !component_value->is_none()) {
    {
      std::string component_as_string;
      if (!component_value->GetAsString(&component_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->component = ParseComponent(component_as_string);
      if (params->component == COMPONENT_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


Results::Result::Result()
 {}

Results::Result::~Result() = default;
Results::Result::Result(Result&& rhs) = default;
Results::Result& Results::Result::operator=(Result&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Result::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}


std::vector<base::Value> Results::Create(const Result& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetStrings

}  // namespace resources_private
}  // namespace api
}  // namespace extensions

