// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/webrtc_desktop_capture_private.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "qtwebengine/common/extensions/api/webrtc_desktop_capture_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace webrtc_desktop_capture_private {
//
// Types
//

RequestInfo::RequestInfo()
: guest_process_id(0),
guest_render_frame_id(0) {}

RequestInfo::~RequestInfo() = default;
RequestInfo::RequestInfo(RequestInfo&& rhs) = default;
RequestInfo& RequestInfo::operator=(RequestInfo&& rhs) = default;
// static
bool RequestInfo::Populate(
    const base::Value& value, RequestInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* guest_process_id_value = dict->FindKey("guestProcessId");
  if (!guest_process_id_value) {
    return false;
  }
  {
    auto temp = guest_process_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->guest_process_id = temp.value();
  }

  const base::Value* guest_render_frame_id_value = dict->FindKey("guestRenderFrameId");
  if (!guest_render_frame_id_value) {
    return false;
  }
  {
    auto temp = guest_render_frame_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->guest_render_frame_id = temp.value();
  }

  return true;
}

// static
std::unique_ptr<RequestInfo> RequestInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<RequestInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RequestInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("guestProcessId", std::make_unique<base::Value>(this->guest_process_id));

  to_value_result->SetWithoutPathExpansion("guestRenderFrameId", std::make_unique<base::Value>(this->guest_render_frame_id));


  return to_value_result;
}


Options::Options()
: can_request_audio_track(false) {}

Options::~Options() = default;
Options::Options(Options&& rhs) = default;
Options& Options::operator=(Options&& rhs) = default;
// static
bool Options::Populate(
    const base::Value& value, Options* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* can_request_audio_track_value = dict->FindKey("canRequestAudioTrack");
  if (!can_request_audio_track_value) {
    return false;
  }
  {
    auto temp = can_request_audio_track_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->can_request_audio_track = temp.value();
  }

  return true;
}

// static
std::unique_ptr<Options> Options::FromValue(const base::Value& value) {
  auto out = std::make_unique<Options>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Options::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("canRequestAudioTrack", std::make_unique<base::Value>(this->can_request_audio_track));


  return to_value_result;
}



//
// Functions
//

namespace ChooseDesktopMedia {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = nullptr;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& stream_id, const Options& options) {
  std::vector<base::Value> create_results;
  create_results.reserve(2);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(stream_id)));

  create_results.push_back(base::Value::FromUniquePtrValue((options).ToValue()));

  return create_results;
}
}  // namespace ChooseDesktopMedia

}  // namespace webrtc_desktop_capture_private
}  // namespace api
}  // namespace extensions

