// services/audio/public/mojom/system_info.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/audio/public/mojom/system_info.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "services/audio/public/mojom/audio_device_description.mojom.h"


#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_JUMBO_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_JUMBO_H_
#endif


namespace audio {
namespace mojom {


void SystemInfoInterceptorForTesting::GetInputStreamParameters(const std::string& device_id, GetInputStreamParametersCallback callback) {
  GetForwardingInterface()->GetInputStreamParameters(std::move(device_id), std::move(callback));
}
void SystemInfoInterceptorForTesting::GetOutputStreamParameters(const std::string& device_id, GetOutputStreamParametersCallback callback) {
  GetForwardingInterface()->GetOutputStreamParameters(std::move(device_id), std::move(callback));
}
void SystemInfoInterceptorForTesting::HasInputDevices(HasInputDevicesCallback callback) {
  GetForwardingInterface()->HasInputDevices(std::move(callback));
}
void SystemInfoInterceptorForTesting::HasOutputDevices(HasOutputDevicesCallback callback) {
  GetForwardingInterface()->HasOutputDevices(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetInputDeviceDescriptions(GetInputDeviceDescriptionsCallback callback) {
  GetForwardingInterface()->GetInputDeviceDescriptions(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetOutputDeviceDescriptions(GetOutputDeviceDescriptionsCallback callback) {
  GetForwardingInterface()->GetOutputDeviceDescriptions(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetAssociatedOutputDeviceID(const std::string& input_device_id, GetAssociatedOutputDeviceIDCallback callback) {
  GetForwardingInterface()->GetAssociatedOutputDeviceID(std::move(input_device_id), std::move(callback));
}
void SystemInfoInterceptorForTesting::GetInputDeviceInfo(const std::string& input_device_id, GetInputDeviceInfoCallback callback) {
  GetForwardingInterface()->GetInputDeviceInfo(std::move(input_device_id), std::move(callback));
}
SystemInfoAsyncWaiter::SystemInfoAsyncWaiter(
    SystemInfo* proxy) : proxy_(proxy) {}

SystemInfoAsyncWaiter::~SystemInfoAsyncWaiter() = default;

void SystemInfoAsyncWaiter::GetInputStreamParameters(
    const std::string& device_id, absl::optional<::media::AudioParameters>* out_params) {
  base::RunLoop loop;
  proxy_->GetInputStreamParameters(std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::media::AudioParameters>* out_params
,
             const absl::optional<::media::AudioParameters>& params) {*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_params));
  loop.Run();
}
void SystemInfoAsyncWaiter::GetOutputStreamParameters(
    const std::string& device_id, absl::optional<::media::AudioParameters>* out_params) {
  base::RunLoop loop;
  proxy_->GetOutputStreamParameters(std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::media::AudioParameters>* out_params
,
             const absl::optional<::media::AudioParameters>& params) {*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_params));
  loop.Run();
}
void SystemInfoAsyncWaiter::HasInputDevices(
    bool* out_has_input_devices) {
  base::RunLoop loop;
  proxy_->HasInputDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_input_devices
,
             bool has_input_devices) {*out_has_input_devices = std::move(has_input_devices);
            loop->Quit();
          },
          &loop,
          out_has_input_devices));
  loop.Run();
}
void SystemInfoAsyncWaiter::HasOutputDevices(
    bool* out_has_output_devices) {
  base::RunLoop loop;
  proxy_->HasOutputDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_output_devices
,
             bool has_output_devices) {*out_has_output_devices = std::move(has_output_devices);
            loop->Quit();
          },
          &loop,
          out_has_output_devices));
  loop.Run();
}
void SystemInfoAsyncWaiter::GetInputDeviceDescriptions(
    std::vector<::media::AudioDeviceDescription>* out_device_descriptions) {
  base::RunLoop loop;
  proxy_->GetInputDeviceDescriptions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::AudioDeviceDescription>* out_device_descriptions
,
             std::vector<::media::AudioDeviceDescription> device_descriptions) {*out_device_descriptions = std::move(device_descriptions);
            loop->Quit();
          },
          &loop,
          out_device_descriptions));
  loop.Run();
}
void SystemInfoAsyncWaiter::GetOutputDeviceDescriptions(
    std::vector<::media::AudioDeviceDescription>* out_device_descriptions) {
  base::RunLoop loop;
  proxy_->GetOutputDeviceDescriptions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::AudioDeviceDescription>* out_device_descriptions
,
             std::vector<::media::AudioDeviceDescription> device_descriptions) {*out_device_descriptions = std::move(device_descriptions);
            loop->Quit();
          },
          &loop,
          out_device_descriptions));
  loop.Run();
}
void SystemInfoAsyncWaiter::GetAssociatedOutputDeviceID(
    const std::string& input_device_id, absl::optional<std::string>* out_associated_output_device_id) {
  base::RunLoop loop;
  proxy_->GetAssociatedOutputDeviceID(std::move(input_device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<std::string>* out_associated_output_device_id
,
             const absl::optional<std::string>& associated_output_device_id) {*out_associated_output_device_id = std::move(associated_output_device_id);
            loop->Quit();
          },
          &loop,
          out_associated_output_device_id));
  loop.Run();
}
void SystemInfoAsyncWaiter::GetInputDeviceInfo(
    const std::string& input_device_id, absl::optional<::media::AudioParameters>* out_input_params, absl::optional<std::string>* out_associated_output_device_id) {
  base::RunLoop loop;
  proxy_->GetInputDeviceInfo(std::move(input_device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::media::AudioParameters>* out_input_params
,
             absl::optional<std::string>* out_associated_output_device_id
,
             const absl::optional<::media::AudioParameters>& input_params,
             const absl::optional<std::string>& associated_output_device_id) {*out_input_params = std::move(input_params);*out_associated_output_device_id = std::move(associated_output_device_id);
            loop->Quit();
          },
          &loop,
          out_input_params,
          out_associated_output_device_id));
  loop.Run();
}





}  // namespace mojom
}  // namespace audio

#if defined(__clang__)
#pragma clang diagnostic pop
#endif