// services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-params-data.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
SerializedResourceInfo::SerializedResourceInfo()
    : url(),
      mime_type(),
      size() {}

SerializedResourceInfo::SerializedResourceInfo(
    const ::GURL& url_in,
    const std::string& mime_type_in,
    uint64_t size_in)
    : url(std::move(url_in)),
      mime_type(std::move(mime_type_in)),
      size(std::move(size_in)) {}

SerializedResourceInfo::~SerializedResourceInfo() = default;

void SerializedResourceInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerializedResourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ResourceSnapshotForWebBundle::Name_[] = "data_decoder.mojom.ResourceSnapshotForWebBundle";

class ResourceSnapshotForWebBundle_GetResourceCount_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ResourceSnapshotForWebBundle_GetResourceCount_ForwardToCallback(
      ResourceSnapshotForWebBundle::GetResourceCountCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ResourceSnapshotForWebBundle::GetResourceCountCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceCount_ForwardToCallback);
};

class ResourceSnapshotForWebBundle_GetResourceInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ResourceSnapshotForWebBundle_GetResourceInfo_ForwardToCallback(
      ResourceSnapshotForWebBundle::GetResourceInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ResourceSnapshotForWebBundle::GetResourceInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceInfo_ForwardToCallback);
};

class ResourceSnapshotForWebBundle_GetResourceBody_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ResourceSnapshotForWebBundle_GetResourceBody_ForwardToCallback(
      ResourceSnapshotForWebBundle::GetResourceBodyCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ResourceSnapshotForWebBundle::GetResourceBodyCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceBody_ForwardToCallback);
};

ResourceSnapshotForWebBundleProxy::ResourceSnapshotForWebBundleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceSnapshotForWebBundleProxy::GetResourceCount(
    GetResourceCountCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCount");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceCount");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ResourceSnapshotForWebBundle_GetResourceCount_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ResourceSnapshotForWebBundleProxy::GetResourceInfo(
    uint64_t in_index, GetResourceInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceInfo_Params_Data> params(
          message);
  params.Allocate();
  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ResourceSnapshotForWebBundle_GetResourceInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ResourceSnapshotForWebBundleProxy::GetResourceBody(
    uint64_t in_index, GetResourceBodyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBody", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceBody_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceBody_Params_Data> params(
          message);
  params.Allocate();
  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceBody");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ResourceSnapshotForWebBundle_GetResourceBody_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder {
 public:
  static ResourceSnapshotForWebBundle::GetResourceCountCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder> proxy(
        new ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ResourceSnapshotForWebBundle::GetResourceCountCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder);
};

bool ResourceSnapshotForWebBundle_GetResourceCount_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCountCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ResourceSnapshotForWebBundle_GetResourceCount_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ResourceSnapshotForWebBundle_GetResourceCount_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_count{};
  ResourceSnapshotForWebBundle_GetResourceCount_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_count = input_data_view.count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ResourceSnapshotForWebBundle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_count));
  return true;
}

void ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder::Run(
    uint64_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCountCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceCount_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->count = in_count;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCountCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceCount");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder {
 public:
  static ResourceSnapshotForWebBundle::GetResourceInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder> proxy(
        new ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ResourceSnapshotForWebBundle::GetResourceInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerializedResourceInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder);
};

bool ResourceSnapshotForWebBundle_GetResourceInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ResourceSnapshotForWebBundle_GetResourceInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ResourceSnapshotForWebBundle_GetResourceInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerializedResourceInfoPtr p_info{};
  ResourceSnapshotForWebBundle_GetResourceInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ResourceSnapshotForWebBundle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder::Run(
    SerializedResourceInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type SerializedResourceInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::data_decoder::mojom::SerializedResourceInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder {
 public:
  static ResourceSnapshotForWebBundle::GetResourceBodyCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder> proxy(
        new ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ResourceSnapshotForWebBundle::GetResourceBodyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      absl::optional<::mojo_base::BigBuffer> in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder);
};

bool ResourceSnapshotForWebBundle_GetResourceBody_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBodyCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ResourceSnapshotForWebBundle_GetResourceBody_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ResourceSnapshotForWebBundle_GetResourceBody_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::mojo_base::BigBuffer> p_data{};
  ResourceSnapshotForWebBundle_GetResourceBody_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ResourceSnapshotForWebBundle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder::Run(
    absl::optional<::mojo_base::BigBuffer> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBodyCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type absl::optional<::mojo_base::BigBuffer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResourceSnapshotForWebBundle_GetResourceBody_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::ResourceSnapshotForWebBundle_GetResourceBody_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBodyCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceSnapshotForWebBundle::Name_);
  message.set_method_name("GetResourceBody");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ResourceSnapshotForWebBundleStubDispatch::Accept(
    ResourceSnapshotForWebBundle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kResourceSnapshotForWebBundle_GetResourceCount_Name: {
      break;
    }
    case internal::kResourceSnapshotForWebBundle_GetResourceInfo_Name: {
      break;
    }
    case internal::kResourceSnapshotForWebBundle_GetResourceBody_Name: {
      break;
    }
  }
  return false;
}

// static
bool ResourceSnapshotForWebBundleStubDispatch::AcceptWithResponder(
    ResourceSnapshotForWebBundle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResourceSnapshotForWebBundle_GetResourceCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ResourceSnapshotForWebBundle_GetResourceCount_Params_Data* params =
          reinterpret_cast<
              internal::ResourceSnapshotForWebBundle_GetResourceCount_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ResourceSnapshotForWebBundle_GetResourceCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceSnapshotForWebBundle::Name_, 0, false);
        return false;
      }
      ResourceSnapshotForWebBundle::GetResourceCountCallback callback =
          ResourceSnapshotForWebBundle_GetResourceCount_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetResourceCount(std::move(callback));
      return true;
    }
    case internal::kResourceSnapshotForWebBundle_GetResourceInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ResourceSnapshotForWebBundle_GetResourceInfo_Params_Data* params =
          reinterpret_cast<
              internal::ResourceSnapshotForWebBundle_GetResourceInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_index{};
      ResourceSnapshotForWebBundle_GetResourceInfo_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceSnapshotForWebBundle::Name_, 1, false);
        return false;
      }
      ResourceSnapshotForWebBundle::GetResourceInfoCallback callback =
          ResourceSnapshotForWebBundle_GetResourceInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetResourceInfo(
std::move(p_index), std::move(callback));
      return true;
    }
    case internal::kResourceSnapshotForWebBundle_GetResourceBody_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBody",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::ResourceSnapshotForWebBundle::GetResourceBody");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ResourceSnapshotForWebBundle_GetResourceBody_Params_Data* params =
          reinterpret_cast<
              internal::ResourceSnapshotForWebBundle_GetResourceBody_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_index{};
      ResourceSnapshotForWebBundle_GetResourceBody_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceSnapshotForWebBundle::Name_, 2, false);
        return false;
      }
      ResourceSnapshotForWebBundle::GetResourceBodyCallback callback =
          ResourceSnapshotForWebBundle_GetResourceBody_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetResourceBody(
std::move(p_index), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResourceSnapshotForWebBundleValidationInfo[] = {
    {internal::kResourceSnapshotForWebBundle_GetResourceCount_Name,
     {&internal::ResourceSnapshotForWebBundle_GetResourceCount_Params_Data::Validate,
      &internal::ResourceSnapshotForWebBundle_GetResourceCount_ResponseParams_Data::Validate}},
    {internal::kResourceSnapshotForWebBundle_GetResourceInfo_Name,
     {&internal::ResourceSnapshotForWebBundle_GetResourceInfo_Params_Data::Validate,
      &internal::ResourceSnapshotForWebBundle_GetResourceInfo_ResponseParams_Data::Validate}},
    {internal::kResourceSnapshotForWebBundle_GetResourceBody_Name,
     {&internal::ResourceSnapshotForWebBundle_GetResourceBody_Params_Data::Validate,
      &internal::ResourceSnapshotForWebBundle_GetResourceBody_ResponseParams_Data::Validate}},
};

bool ResourceSnapshotForWebBundleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::ResourceSnapshotForWebBundle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResourceSnapshotForWebBundleValidationInfo);
}

bool ResourceSnapshotForWebBundleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::ResourceSnapshotForWebBundle::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kResourceSnapshotForWebBundleValidationInfo);

}
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {


// static
bool StructTraits<::data_decoder::mojom::SerializedResourceInfo::DataView, ::data_decoder::mojom::SerializedResourceInfoPtr>::Read(
    ::data_decoder::mojom::SerializedResourceInfo::DataView input,
    ::data_decoder::mojom::SerializedResourceInfoPtr* output) {
  bool success = true;
  ::data_decoder::mojom::SerializedResourceInfoPtr result(::data_decoder::mojom::SerializedResourceInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->size = input.size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif