// services/data_decoder/public/mojom/web_bundler.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/data_decoder/public/mojom/web_bundler.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/web_bundler.mojom-params-data.h"
namespace data_decoder {
namespace mojom {

static NOINLINE const char* WebBundlerErrorToStringHelper(WebBundlerError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebBundlerError::kOK:
      return "kOK";
    case WebBundlerError::kConnectionError:
      return "kConnectionError";
    case WebBundlerError::kFileOpenFailed:
      return "kFileOpenFailed";
    case WebBundlerError::kWebBundlerConnectionError:
      return "kWebBundlerConnectionError";
    case WebBundlerError::kInvalidInput:
      return "kInvalidInput";
    default:
      return nullptr;
  }
}

std::string WebBundlerErrorToString(WebBundlerError value) {
  const char *str = WebBundlerErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebBundlerError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebBundlerError value) {
  return os << WebBundlerErrorToString(value);
}

namespace internal {


// static
bool WebBundler_Generate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundler_Generate_Params_Data* object = static_cast<const WebBundler_Generate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snapshots, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams snapshots_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->snapshots, validation_context,
                                         &snapshots_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

WebBundler_Generate_Params_Data::WebBundler_Generate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundler_Generate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundler_Generate_ResponseParams_Data* object = static_cast<const WebBundler_Generate_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::data_decoder::mojom::internal::WebBundlerError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

WebBundler_Generate_ResponseParams_Data::WebBundler_Generate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_decoder

namespace perfetto {

// static
void TraceFormatTraits<::data_decoder::mojom::WebBundlerError>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_decoder::mojom::WebBundlerError value) {
  return std::move(context).WriteString(::data_decoder::mojom::WebBundlerErrorToString(value));
}

} // namespace perfetto
