// services/device/public/mojom/bluetooth_system.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/bluetooth_system.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/bluetooth_system.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* BluetoothDeviceInfo_ConnectionStateToStringHelper(BluetoothDeviceInfo_ConnectionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothDeviceInfo_ConnectionState::kNotConnected:
      return "kNotConnected";
    case BluetoothDeviceInfo_ConnectionState::kConnecting:
      return "kConnecting";
    case BluetoothDeviceInfo_ConnectionState::kConnected:
      return "kConnected";
    default:
      return nullptr;
  }
}

std::string BluetoothDeviceInfo_ConnectionStateToString(BluetoothDeviceInfo_ConnectionState value) {
  const char *str = BluetoothDeviceInfo_ConnectionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothDeviceInfo_ConnectionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothDeviceInfo_ConnectionState value) {
  return os << BluetoothDeviceInfo_ConnectionStateToString(value);
}

static NOINLINE const char* BluetoothDeviceInfo_DeviceTypeToStringHelper(BluetoothDeviceInfo_DeviceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothDeviceInfo_DeviceType::kUnknown:
      return "kUnknown";
    case BluetoothDeviceInfo_DeviceType::kComputer:
      return "kComputer";
    case BluetoothDeviceInfo_DeviceType::kPhone:
      return "kPhone";
    case BluetoothDeviceInfo_DeviceType::kModem:
      return "kModem";
    case BluetoothDeviceInfo_DeviceType::kAudio:
      return "kAudio";
    case BluetoothDeviceInfo_DeviceType::kCarAudio:
      return "kCarAudio";
    case BluetoothDeviceInfo_DeviceType::kVideo:
      return "kVideo";
    case BluetoothDeviceInfo_DeviceType::kPeripheral:
      return "kPeripheral";
    case BluetoothDeviceInfo_DeviceType::kJoystick:
      return "kJoystick";
    case BluetoothDeviceInfo_DeviceType::kGamepad:
      return "kGamepad";
    case BluetoothDeviceInfo_DeviceType::kKeyboard:
      return "kKeyboard";
    case BluetoothDeviceInfo_DeviceType::kMouse:
      return "kMouse";
    case BluetoothDeviceInfo_DeviceType::kTablet:
      return "kTablet";
    case BluetoothDeviceInfo_DeviceType::kKeyboardMouseCombo:
      return "kKeyboardMouseCombo";
    default:
      return nullptr;
  }
}

std::string BluetoothDeviceInfo_DeviceTypeToString(BluetoothDeviceInfo_DeviceType value) {
  const char *str = BluetoothDeviceInfo_DeviceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothDeviceInfo_DeviceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothDeviceInfo_DeviceType value) {
  return os << BluetoothDeviceInfo_DeviceTypeToString(value);
}

static NOINLINE const char* BluetoothSystem_StateToStringHelper(BluetoothSystem_State value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothSystem_State::kUnsupported:
      return "kUnsupported";
    case BluetoothSystem_State::kUnavailable:
      return "kUnavailable";
    case BluetoothSystem_State::kPoweredOff:
      return "kPoweredOff";
    case BluetoothSystem_State::kTransitioning:
      return "kTransitioning";
    case BluetoothSystem_State::kPoweredOn:
      return "kPoweredOn";
    default:
      return nullptr;
  }
}

std::string BluetoothSystem_StateToString(BluetoothSystem_State value) {
  const char *str = BluetoothSystem_StateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothSystem_State value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothSystem_State value) {
  return os << BluetoothSystem_StateToString(value);
}

static NOINLINE const char* BluetoothSystem_SetPoweredResultToStringHelper(BluetoothSystem_SetPoweredResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothSystem_SetPoweredResult::kSuccess:
      return "kSuccess";
    case BluetoothSystem_SetPoweredResult::kFailedUnknownReason:
      return "kFailedUnknownReason";
    case BluetoothSystem_SetPoweredResult::kFailedBluetoothUnavailable:
      return "kFailedBluetoothUnavailable";
    case BluetoothSystem_SetPoweredResult::kFailedInProgress:
      return "kFailedInProgress";
    default:
      return nullptr;
  }
}

std::string BluetoothSystem_SetPoweredResultToString(BluetoothSystem_SetPoweredResult value) {
  const char *str = BluetoothSystem_SetPoweredResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothSystem_SetPoweredResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothSystem_SetPoweredResult value) {
  return os << BluetoothSystem_SetPoweredResultToString(value);
}

static NOINLINE const char* BluetoothSystem_ScanStateToStringHelper(BluetoothSystem_ScanState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothSystem_ScanState::kNotScanning:
      return "kNotScanning";
    case BluetoothSystem_ScanState::kTransitioning:
      return "kTransitioning";
    case BluetoothSystem_ScanState::kScanning:
      return "kScanning";
    default:
      return nullptr;
  }
}

std::string BluetoothSystem_ScanStateToString(BluetoothSystem_ScanState value) {
  const char *str = BluetoothSystem_ScanStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothSystem_ScanState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothSystem_ScanState value) {
  return os << BluetoothSystem_ScanStateToString(value);
}

static NOINLINE const char* BluetoothSystem_StartScanResultToStringHelper(BluetoothSystem_StartScanResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothSystem_StartScanResult::kSuccess:
      return "kSuccess";
    case BluetoothSystem_StartScanResult::kFailedUnknownReason:
      return "kFailedUnknownReason";
    case BluetoothSystem_StartScanResult::kFailedBluetoothUnavailable:
      return "kFailedBluetoothUnavailable";
    default:
      return nullptr;
  }
}

std::string BluetoothSystem_StartScanResultToString(BluetoothSystem_StartScanResult value) {
  const char *str = BluetoothSystem_StartScanResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothSystem_StartScanResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothSystem_StartScanResult value) {
  return os << BluetoothSystem_StartScanResultToString(value);
}

static NOINLINE const char* BluetoothSystem_StopScanResultToStringHelper(BluetoothSystem_StopScanResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BluetoothSystem_StopScanResult::kSuccess:
      return "kSuccess";
    case BluetoothSystem_StopScanResult::kFailedUnknownReason:
      return "kFailedUnknownReason";
    case BluetoothSystem_StopScanResult::kFailedBluetoothUnavailable:
      return "kFailedBluetoothUnavailable";
    default:
      return nullptr;
  }
}

std::string BluetoothSystem_StopScanResultToString(BluetoothSystem_StopScanResult value) {
  const char *str = BluetoothSystem_StopScanResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BluetoothSystem_StopScanResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BluetoothSystem_StopScanResult value) {
  return os << BluetoothSystem_StopScanResultToString(value);
}

namespace internal {


// static
bool BluetoothAddress_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothAddress_Data* object = static_cast<const BluetoothAddress_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams address_validate_params(
      6, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->address, validation_context,
                                         &address_validate_params)) {
    return false;
  }

  return true;
}

BluetoothAddress_Data::BluetoothAddress_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothDeviceBatteryInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothDeviceBatteryInfo_Data* object = static_cast<const BluetoothDeviceBatteryInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothDeviceBatteryInfo_Data::BluetoothDeviceBatteryInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothDeviceInfo_Data* object = static_cast<const BluetoothDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->address, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::BluetoothDeviceInfo_ConnectionState_Data
        ::Validate(object->connection_state, validation_context))
    return false;


  if (!::device::mojom::internal::BluetoothDeviceInfo_DeviceType_Data
        ::Validate(object->device_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->battery_info, validation_context))
    return false;

  return true;
}

BluetoothDeviceInfo_Data::BluetoothDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystemFactory_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystemFactory_Create_Params_Data* object = static_cast<const BluetoothSystemFactory_Create_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->system, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->system,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->system_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->system_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BluetoothSystemFactory_Create_Params_Data::BluetoothSystemFactory_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetState_Params_Data* object = static_cast<const BluetoothSystem_GetState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_GetState_Params_Data::BluetoothSystem_GetState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetState_ResponseParams_Data* object = static_cast<const BluetoothSystem_GetState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_State_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

BluetoothSystem_GetState_ResponseParams_Data::BluetoothSystem_GetState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_SetPowered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_SetPowered_Params_Data* object = static_cast<const BluetoothSystem_SetPowered_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_SetPowered_Params_Data::BluetoothSystem_SetPowered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_SetPowered_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_SetPowered_ResponseParams_Data* object = static_cast<const BluetoothSystem_SetPowered_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_SetPoweredResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

BluetoothSystem_SetPowered_ResponseParams_Data::BluetoothSystem_SetPowered_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetScanState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetScanState_Params_Data* object = static_cast<const BluetoothSystem_GetScanState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_GetScanState_Params_Data::BluetoothSystem_GetScanState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetScanState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetScanState_ResponseParams_Data* object = static_cast<const BluetoothSystem_GetScanState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_ScanState_Data
        ::Validate(object->scan_state, validation_context))
    return false;

  return true;
}

BluetoothSystem_GetScanState_ResponseParams_Data::BluetoothSystem_GetScanState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_StartScan_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_StartScan_Params_Data* object = static_cast<const BluetoothSystem_StartScan_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_StartScan_Params_Data::BluetoothSystem_StartScan_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_StartScan_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_StartScan_ResponseParams_Data* object = static_cast<const BluetoothSystem_StartScan_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_StartScanResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

BluetoothSystem_StartScan_ResponseParams_Data::BluetoothSystem_StartScan_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_StopScan_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_StopScan_Params_Data* object = static_cast<const BluetoothSystem_StopScan_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_StopScan_Params_Data::BluetoothSystem_StopScan_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_StopScan_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_StopScan_ResponseParams_Data* object = static_cast<const BluetoothSystem_StopScan_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_StopScanResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

BluetoothSystem_StopScan_ResponseParams_Data::BluetoothSystem_StopScan_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetAvailableDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetAvailableDevices_Params_Data* object = static_cast<const BluetoothSystem_GetAvailableDevices_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BluetoothSystem_GetAvailableDevices_Params_Data::BluetoothSystem_GetAvailableDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystem_GetAvailableDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystem_GetAvailableDevices_ResponseParams_Data* object = static_cast<const BluetoothSystem_GetAvailableDevices_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

BluetoothSystem_GetAvailableDevices_ResponseParams_Data::BluetoothSystem_GetAvailableDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystemClient_OnStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystemClient_OnStateChanged_Params_Data* object = static_cast<const BluetoothSystemClient_OnStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_State_Data
        ::Validate(object->new_state, validation_context))
    return false;

  return true;
}

BluetoothSystemClient_OnStateChanged_Params_Data::BluetoothSystemClient_OnStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BluetoothSystemClient_OnScanStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BluetoothSystemClient_OnScanStateChanged_Params_Data* object = static_cast<const BluetoothSystemClient_OnScanStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::BluetoothSystem_ScanState_Data
        ::Validate(object->new_state, validation_context))
    return false;

  return true;
}

BluetoothSystemClient_OnScanStateChanged_Params_Data::BluetoothSystemClient_OnScanStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothDeviceInfo_ConnectionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothDeviceInfo_ConnectionState value) {
  return std::move(context).WriteString(::device::mojom::BluetoothDeviceInfo_ConnectionStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothDeviceInfo_DeviceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothDeviceInfo_DeviceType value) {
  return std::move(context).WriteString(::device::mojom::BluetoothDeviceInfo_DeviceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothSystem_State>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothSystem_State value) {
  return std::move(context).WriteString(::device::mojom::BluetoothSystem_StateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothSystem_SetPoweredResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothSystem_SetPoweredResult value) {
  return std::move(context).WriteString(::device::mojom::BluetoothSystem_SetPoweredResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothSystem_ScanState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothSystem_ScanState value) {
  return std::move(context).WriteString(::device::mojom::BluetoothSystem_ScanStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothSystem_StartScanResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothSystem_StartScanResult value) {
  return std::move(context).WriteString(::device::mojom::BluetoothSystem_StartScanResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BluetoothSystem_StopScanResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BluetoothSystem_StopScanResult value) {
  return std::move(context).WriteString(::device::mojom::BluetoothSystem_StopScanResultToString(value));
}

} // namespace perfetto
