// services/device/public/mojom/device_posture_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/device_posture_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/device_posture_provider.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* DevicePostureTypeToStringHelper(DevicePostureType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DevicePostureType::kContinuous:
      return "kContinuous";
    case DevicePostureType::kFolded:
      return "kFolded";
    case DevicePostureType::kFoldedOver:
      return "kFoldedOver";
    default:
      return nullptr;
  }
}

std::string DevicePostureTypeToString(DevicePostureType value) {
  const char *str = DevicePostureTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DevicePostureType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DevicePostureType value) {
  return os << DevicePostureTypeToString(value);
}

namespace internal {


// static
bool DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data* object = static_cast<const DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data::DevicePostureProvider_AddListenerAndGetCurrentPosture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data* object = static_cast<const DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::DevicePostureType_Data
        ::Validate(object->posture, validation_context))
    return false;

  return true;
}

DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data::DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePostureProviderClient_OnPostureChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DevicePostureProviderClient_OnPostureChanged_Params_Data* object = static_cast<const DevicePostureProviderClient_OnPostureChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::DevicePostureType_Data
        ::Validate(object->posture, validation_context))
    return false;

  return true;
}

DevicePostureProviderClient_OnPostureChanged_Params_Data::DevicePostureProviderClient_OnPostureChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::DevicePostureType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::DevicePostureType value) {
  return std::move(context).WriteString(::device::mojom::DevicePostureTypeToString(value));
}

} // namespace perfetto
