// services/device/public/mojom/geoposition.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/geoposition.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geoposition.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* Geoposition_ErrorCodeToStringHelper(Geoposition_ErrorCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Geoposition_ErrorCode::NONE:
      return "NONE";
    case Geoposition_ErrorCode::PERMISSION_DENIED:
      return "PERMISSION_DENIED";
    case Geoposition_ErrorCode::POSITION_UNAVAILABLE:
      return "POSITION_UNAVAILABLE";
    case Geoposition_ErrorCode::TIMEOUT:
      return "{TIMEOUT, LAST}";
    default:
      return nullptr;
  }
}

std::string Geoposition_ErrorCodeToString(Geoposition_ErrorCode value) {
  const char *str = Geoposition_ErrorCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Geoposition_ErrorCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Geoposition_ErrorCode value) {
  return os << Geoposition_ErrorCodeToString(value);
}

namespace internal {


// static
bool Geoposition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Geoposition_Data* object = static_cast<const Geoposition_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;


  if (!::device::mojom::internal::Geoposition_ErrorCode_Data
        ::Validate(object->error_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

Geoposition_Data::Geoposition_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::Geoposition_ErrorCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::Geoposition_ErrorCode value) {
  return std::move(context).WriteString(::device::mojom::Geoposition_ErrorCodeToString(value));
}

} // namespace perfetto
