// services/device/public/mojom/nfc.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/nfc.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/nfc.mojom-params-data.h"
#include "services/device/public/mojom/nfc.mojom-shared-message-ids.h"

#include "services/device/public/mojom/nfc.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
NDEFError::NDEFError()
    : error_type(),
      error_message() {}

NDEFError::NDEFError(
    NDEFErrorType error_type_in,
    const std::string& error_message_in)
    : error_type(std::move(error_type_in)),
      error_message(std::move(error_message_in)) {}

NDEFError::~NDEFError() = default;
size_t NDEFError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->error_type);
  seed = mojo::internal::Hash(seed, this->error_message);
  return seed;
}

void NDEFError::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_type"), this->error_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFRecord::NDEFRecord()
    : category(),
      record_type(),
      media_type(),
      id(),
      encoding(),
      lang(),
      data(),
      payload_message() {}

NDEFRecord::NDEFRecord(
    NDEFRecordTypeCategory category_in,
    const std::string& record_type_in,
    const absl::optional<std::string>& media_type_in,
    const absl::optional<std::string>& id_in,
    const absl::optional<std::string>& encoding_in,
    const absl::optional<std::string>& lang_in,
    std::vector<uint8_t> data_in,
    NDEFMessagePtr payload_message_in)
    : category(std::move(category_in)),
      record_type(std::move(record_type_in)),
      media_type(std::move(media_type_in)),
      id(std::move(id_in)),
      encoding(std::move(encoding_in)),
      lang(std::move(lang_in)),
      data(std::move(data_in)),
      payload_message(std::move(payload_message_in)) {}

NDEFRecord::~NDEFRecord() = default;

void NDEFRecord::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category"), this->category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFRecordTypeCategory>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "record_type"), this->record_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_type"), this->media_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoding"), this->encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_message"), this->payload_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFMessagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFMessage::NDEFMessage()
    : data() {}

NDEFMessage::NDEFMessage(
    std::vector<NDEFRecordPtr> data_in)
    : data(std::move(data_in)) {}

NDEFMessage::~NDEFMessage() = default;

void NDEFMessage::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<NDEFRecordPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFWriteOptions::NDEFWriteOptions()
    : overwrite() {}

NDEFWriteOptions::NDEFWriteOptions(
    bool overwrite_in)
    : overwrite(std::move(overwrite_in)) {}

NDEFWriteOptions::~NDEFWriteOptions() = default;
size_t NDEFWriteOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->overwrite);
  return seed;
}

void NDEFWriteOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overwrite"), this->overwrite,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFWriteOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NFC::Name_[] = "device.mojom.NFC";

class NFC_Push_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NFC_Push_ForwardToCallback(
      NFC::PushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NFC::PushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NFC_Push_ForwardToCallback);
};

class NFC_Watch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NFC_Watch_ForwardToCallback(
      NFC::WatchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NFC::WatchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NFC_Watch_ForwardToCallback);
};

NFCProxy::NFCProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCProxy::SetClient(
    ::mojo::PendingRemote<NFCClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFC::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<NFCClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::NFCClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NFC.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NFCProxy::Push(
    NDEFMessagePtr in_message, NDEFWriteOptionsPtr in_options, PushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFC::Push", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type NDEFMessagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type NDEFWriteOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_Push_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Push_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in NFC.Push request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFWriteOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Push");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NFC_Push_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NFCProxy::CancelPush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::NFC::CancelPush");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_CancelPush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_CancelPush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("CancelPush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NFCProxy::Watch(
    uint32_t in_id, WatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFC::Watch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_Watch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Watch_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Watch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NFC_Watch_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NFCProxy::CancelWatch(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFC::CancelWatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_CancelWatch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_CancelWatch_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("CancelWatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NFC_Push_ProxyToResponder {
 public:
  static NFC::PushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NFC_Push_ProxyToResponder> proxy(
        new NFC_Push_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NFC_Push_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NFC_Push_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NFC_Push_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NFC::PushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      NDEFErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NFC_Push_ProxyToResponder);
};

bool NFC_Push_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::NFC::PushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NFC_Push_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NFC_Push_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NDEFErrorPtr p_error{};
  NFC_Push_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NFC::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void NFC_Push_ProxyToResponder::Run(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::NFC::PushCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_Push_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Push_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::NFC::PushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Push");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NFC_Watch_ProxyToResponder {
 public:
  static NFC::WatchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NFC_Watch_ProxyToResponder> proxy(
        new NFC_Watch_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NFC_Watch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NFC_Watch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NFC_Watch_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NFC::WatchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      NDEFErrorPtr in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NFC_Watch_ProxyToResponder);
};

bool NFC_Watch_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::NFC::WatchCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NFC_Watch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NFC_Watch_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NDEFErrorPtr p_error{};
  NFC_Watch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NFC::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void NFC_Watch_ProxyToResponder::Run(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::NFC::WatchCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFC_Watch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Watch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::NFC::WatchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Watch");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NFCStubDispatch::Accept(
    NFC* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNFC_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFC::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFC::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFC_SetClient_Params_Data* params =
          reinterpret_cast<internal::NFC_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NFCClient> p_client{};
      NFC_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kNFC_Push_Name: {
      break;
    }
    case internal::kNFC_CancelPush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFC::CancelPush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFC::CancelPush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFC_CancelPush_Params_Data* params =
          reinterpret_cast<internal::NFC_CancelPush_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NFC_CancelPush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelPush();
      return true;
    }
    case internal::kNFC_Watch_Name: {
      break;
    }
    case internal::kNFC_CancelWatch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFC::CancelWatch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFC::CancelWatch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFC_CancelWatch_Params_Data* params =
          reinterpret_cast<internal::NFC_CancelWatch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_id{};
      NFC_CancelWatch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelWatch(
std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool NFCStubDispatch::AcceptWithResponder(
    NFC* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNFC_SetClient_Name: {
      break;
    }
    case internal::kNFC_Push_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFC::Push",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFC::Push");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NFC_Push_Params_Data* params =
          reinterpret_cast<
              internal::NFC_Push_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NDEFMessagePtr p_message{};
      NDEFWriteOptionsPtr p_options{};
      NFC_Push_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 1, false);
        return false;
      }
      NFC::PushCallback callback =
          NFC_Push_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Push(
std::move(p_message), 
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kNFC_CancelPush_Name: {
      break;
    }
    case internal::kNFC_Watch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFC::Watch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFC::Watch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NFC_Watch_Params_Data* params =
          reinterpret_cast<
              internal::NFC_Watch_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_id{};
      NFC_Watch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 3, false);
        return false;
      }
      NFC::WatchCallback callback =
          NFC_Watch_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Watch(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kNFC_CancelWatch_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNFCValidationInfo[] = {
    {internal::kNFC_SetClient_Name,
     {&internal::NFC_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNFC_Push_Name,
     {&internal::NFC_Push_Params_Data::Validate,
      &internal::NFC_Push_ResponseParams_Data::Validate}},
    {internal::kNFC_CancelPush_Name,
     {&internal::NFC_CancelPush_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNFC_Watch_Name,
     {&internal::NFC_Watch_Params_Data::Validate,
      &internal::NFC_Watch_ResponseParams_Data::Validate}},
    {internal::kNFC_CancelWatch_Name,
     {&internal::NFC_CancelWatch_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NFCRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::NFC::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNFCValidationInfo);
}

bool NFCResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::NFC::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNFCValidationInfo);

}
const char NFCClient::Name_[] = "device.mojom.NFCClient";

NFCClientProxy::NFCClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCClientProxy::OnWatch(
    const std::vector<uint32_t>& in_watch_ids, const absl::optional<std::string>& in_serial_number, NDEFMessagePtr in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFCClient::OnWatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_ids"), in_watch_ids,
                        "<value of type const std::vector<uint32_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serial_number"), in_serial_number,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type NDEFMessagePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFCClient_OnWatch_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCClient_OnWatch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->watch_ids)::BaseType>
      watch_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams watch_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_watch_ids, watch_ids_fragment, &watch_ids_validate_params);
  params->watch_ids.Set(
      watch_ids_fragment.is_null() ? nullptr : watch_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->watch_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null watch_ids in NFCClient.OnWatch request");
  mojo::internal::MessageFragment<
      typename decltype(params->serial_number)::BaseType> serial_number_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_serial_number, serial_number_fragment);
  params->serial_number.Set(
      serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFMessageDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in NFCClient.OnWatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCClient::Name_);
  message.set_method_name("OnWatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NFCClientProxy::OnError(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::NFCClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNFCClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in NFCClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NFCClientStubDispatch::Accept(
    NFCClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNFCClient_OnWatch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFCClient::OnWatch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFCClient::OnWatch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFCClient_OnWatch_Params_Data* params =
          reinterpret_cast<internal::NFCClient_OnWatch_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint32_t> p_watch_ids{};
      absl::optional<std::string> p_serial_number{};
      NDEFMessagePtr p_message{};
      NFCClient_OnWatch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWatchIds(&p_watch_ids))
        success = false;
      if (success && !input_data_view.ReadSerialNumber(&p_serial_number))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWatch(
std::move(p_watch_ids), 
std::move(p_serial_number), 
std::move(p_message));
      return true;
    }
    case internal::kNFCClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::NFCClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::NFCClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NFCClient_OnError_Params_Data* params =
          reinterpret_cast<internal::NFCClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NDEFErrorPtr p_error{};
      NFCClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool NFCClientStubDispatch::AcceptWithResponder(
    NFCClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNFCClient_OnWatch_Name: {
      break;
    }
    case internal::kNFCClient_OnError_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNFCClientValidationInfo[] = {
    {internal::kNFCClient_OnWatch_Name,
     {&internal::NFCClient_OnWatch_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNFCClient_OnError_Name,
     {&internal::NFCClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NFCClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::NFCClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNFCClientValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::NDEFError::DataView, ::device::mojom::NDEFErrorPtr>::Read(
    ::device::mojom::NDEFError::DataView input,
    ::device::mojom::NDEFErrorPtr* output) {
  bool success = true;
  ::device::mojom::NDEFErrorPtr result(::device::mojom::NDEFError::New());
  
      if (success && !input.ReadErrorType(&result->error_type))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFRecord::DataView, ::device::mojom::NDEFRecordPtr>::Read(
    ::device::mojom::NDEFRecord::DataView input,
    ::device::mojom::NDEFRecordPtr* output) {
  bool success = true;
  ::device::mojom::NDEFRecordPtr result(::device::mojom::NDEFRecord::New());
  
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadRecordType(&result->record_type))
        success = false;
      if (success && !input.ReadMediaType(&result->media_type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadEncoding(&result->encoding))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadPayloadMessage(&result->payload_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFMessage::DataView, ::device::mojom::NDEFMessagePtr>::Read(
    ::device::mojom::NDEFMessage::DataView input,
    ::device::mojom::NDEFMessagePtr* output) {
  bool success = true;
  ::device::mojom::NDEFMessagePtr result(::device::mojom::NDEFMessage::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFWriteOptions::DataView, ::device::mojom::NDEFWriteOptionsPtr>::Read(
    ::device::mojom::NDEFWriteOptions::DataView input,
    ::device::mojom::NDEFWriteOptionsPtr* output) {
  bool success = true;
  ::device::mojom::NDEFWriteOptionsPtr result(::device::mojom::NDEFWriteOptions::New());
  
      if (success)
        result->overwrite = input.overwrite();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif