// services/device/public/mojom/sensor_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/sensor_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor_provider.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* SensorCreationResultToStringHelper(SensorCreationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SensorCreationResult::SUCCESS:
      return "SUCCESS";
    case SensorCreationResult::ERROR_NOT_AVAILABLE:
      return "ERROR_NOT_AVAILABLE";
    case SensorCreationResult::ERROR_NOT_ALLOWED:
      return "ERROR_NOT_ALLOWED";
    default:
      return nullptr;
  }
}

std::string SensorCreationResultToString(SensorCreationResult value) {
  const char *str = SensorCreationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SensorCreationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SensorCreationResult value) {
  return os << SensorCreationResultToString(value);
}

namespace internal {


// static
bool SensorInitParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorInitParams_Data* object = static_cast<const SensorInitParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->sensor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->sensor,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->memory, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->memory,
                                                 validation_context)) {
    return false;
  }


  if (!::device::mojom::internal::ReportingMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_configuration, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_configuration, validation_context))
    return false;

  return true;
}

SensorInitParams_Data::SensorInitParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetSensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorProvider_GetSensor_Params_Data* object = static_cast<const SensorProvider_GetSensor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SensorProvider_GetSensor_Params_Data::SensorProvider_GetSensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetSensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorProvider_GetSensor_ResponseParams_Data* object = static_cast<const SensorProvider_GetSensor_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::SensorCreationResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->init_params, validation_context))
    return false;

  return true;
}

SensorProvider_GetSensor_ResponseParams_Data::SensorProvider_GetSensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SensorCreationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SensorCreationResult value) {
  return std::move(context).WriteString(::device::mojom::SensorCreationResultToString(value));
}

} // namespace perfetto
