// services/device/public/mojom/serial.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/device/public/mojom/serial.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_JUMBO_H_
#endif


namespace device {
namespace mojom {


void SerialPortManagerInterceptorForTesting::SetClient(::mojo::PendingRemote<SerialPortManagerClient> client) {
  GetForwardingInterface()->SetClient(std::move(client));
}
void SerialPortManagerInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void SerialPortManagerInterceptorForTesting::OpenPort(const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, OpenPortCallback callback) {
  GetForwardingInterface()->OpenPort(std::move(token), std::move(use_alternate_path), std::move(options), std::move(client), std::move(watcher), std::move(callback));
}
SerialPortManagerAsyncWaiter::SerialPortManagerAsyncWaiter(
    SerialPortManager* proxy) : proxy_(proxy) {}

SerialPortManagerAsyncWaiter::~SerialPortManagerAsyncWaiter() = default;

void SerialPortManagerAsyncWaiter::GetDevices(
    std::vector<SerialPortInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SerialPortInfoPtr>* out_devices
,
             std::vector<SerialPortInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}
void SerialPortManagerAsyncWaiter::OpenPort(
    const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, ::mojo::PendingRemote<SerialPort>* out_port) {
  base::RunLoop loop;
  proxy_->OpenPort(std::move(token),std::move(use_alternate_path),std::move(options),std::move(client),std::move(watcher),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<SerialPort>* out_port
,
             ::mojo::PendingRemote<SerialPort> port) {*out_port = std::move(port);
            loop->Quit();
          },
          &loop,
          out_port));
  loop.Run();
}



void SerialPortManagerClientInterceptorForTesting::OnPortAdded(SerialPortInfoPtr port_info) {
  GetForwardingInterface()->OnPortAdded(std::move(port_info));
}
void SerialPortManagerClientInterceptorForTesting::OnPortRemoved(SerialPortInfoPtr port_info) {
  GetForwardingInterface()->OnPortRemoved(std::move(port_info));
}
SerialPortManagerClientAsyncWaiter::SerialPortManagerClientAsyncWaiter(
    SerialPortManagerClient* proxy) : proxy_(proxy) {}

SerialPortManagerClientAsyncWaiter::~SerialPortManagerClientAsyncWaiter() = default;




void SerialPortInterceptorForTesting::StartWriting(::mojo::ScopedDataPipeConsumerHandle consumer) {
  GetForwardingInterface()->StartWriting(std::move(consumer));
}
void SerialPortInterceptorForTesting::StartReading(::mojo::ScopedDataPipeProducerHandle producer) {
  GetForwardingInterface()->StartReading(std::move(producer));
}
void SerialPortInterceptorForTesting::Flush(SerialPortFlushMode mode, FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(mode), std::move(callback));
}
void SerialPortInterceptorForTesting::Drain(DrainCallback callback) {
  GetForwardingInterface()->Drain(std::move(callback));
}
void SerialPortInterceptorForTesting::GetControlSignals(GetControlSignalsCallback callback) {
  GetForwardingInterface()->GetControlSignals(std::move(callback));
}
void SerialPortInterceptorForTesting::SetControlSignals(SerialHostControlSignalsPtr signals, SetControlSignalsCallback callback) {
  GetForwardingInterface()->SetControlSignals(std::move(signals), std::move(callback));
}
void SerialPortInterceptorForTesting::ConfigurePort(SerialConnectionOptionsPtr options, ConfigurePortCallback callback) {
  GetForwardingInterface()->ConfigurePort(std::move(options), std::move(callback));
}
void SerialPortInterceptorForTesting::GetPortInfo(GetPortInfoCallback callback) {
  GetForwardingInterface()->GetPortInfo(std::move(callback));
}
void SerialPortInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
SerialPortAsyncWaiter::SerialPortAsyncWaiter(
    SerialPort* proxy) : proxy_(proxy) {}

SerialPortAsyncWaiter::~SerialPortAsyncWaiter() = default;

void SerialPortAsyncWaiter::Flush(
    SerialPortFlushMode mode) {
  base::RunLoop loop;
  proxy_->Flush(std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void SerialPortAsyncWaiter::Drain(
    ) {
  base::RunLoop loop;
  proxy_->Drain(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void SerialPortAsyncWaiter::GetControlSignals(
    SerialPortControlSignalsPtr* out_signals) {
  base::RunLoop loop;
  proxy_->GetControlSignals(
      base::BindOnce(
          [](base::RunLoop* loop,
             SerialPortControlSignalsPtr* out_signals
,
             SerialPortControlSignalsPtr signals) {*out_signals = std::move(signals);
            loop->Quit();
          },
          &loop,
          out_signals));
  loop.Run();
}
void SerialPortAsyncWaiter::SetControlSignals(
    SerialHostControlSignalsPtr signals, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetControlSignals(std::move(signals),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void SerialPortAsyncWaiter::ConfigurePort(
    SerialConnectionOptionsPtr options, bool* out_success) {
  base::RunLoop loop;
  proxy_->ConfigurePort(std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void SerialPortAsyncWaiter::GetPortInfo(
    SerialConnectionInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetPortInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             SerialConnectionInfoPtr* out_info
,
             SerialConnectionInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}
void SerialPortAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void SerialPortClientInterceptorForTesting::OnReadError(SerialReceiveError error) {
  GetForwardingInterface()->OnReadError(std::move(error));
}
void SerialPortClientInterceptorForTesting::OnSendError(SerialSendError error) {
  GetForwardingInterface()->OnSendError(std::move(error));
}
SerialPortClientAsyncWaiter::SerialPortClientAsyncWaiter(
    SerialPortClient* proxy) : proxy_(proxy) {}

SerialPortClientAsyncWaiter::~SerialPortClientAsyncWaiter() = default;




SerialPortConnectionWatcherAsyncWaiter::SerialPortConnectionWatcherAsyncWaiter(
    SerialPortConnectionWatcher* proxy) : proxy_(proxy) {}

SerialPortConnectionWatcherAsyncWaiter::~SerialPortConnectionWatcherAsyncWaiter() = default;






}  // namespace mojom
}  // namespace device

#if defined(__clang__)
#pragma clang diagnostic pop
#endif