// services/device/public/mojom/wake_lock.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/wake_lock.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/wake_lock.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* WakeLockTypeToStringHelper(WakeLockType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WakeLockType::kPreventAppSuspension:
      return "kPreventAppSuspension";
    case WakeLockType::kPreventDisplaySleep:
      return "kPreventDisplaySleep";
    case WakeLockType::kPreventDisplaySleepAllowDimming:
      return "kPreventDisplaySleepAllowDimming";
    default:
      return nullptr;
  }
}

std::string WakeLockTypeToString(WakeLockType value) {
  const char *str = WakeLockTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WakeLockType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WakeLockType value) {
  return os << WakeLockTypeToString(value);
}

static NOINLINE const char* WakeLockReasonToStringHelper(WakeLockReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WakeLockReason::kAudioPlayback:
      return "kAudioPlayback";
    case WakeLockReason::kVideoPlayback:
      return "kVideoPlayback";
    case WakeLockReason::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string WakeLockReasonToString(WakeLockReason value) {
  const char *str = WakeLockReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WakeLockReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WakeLockReason value) {
  return os << WakeLockReasonToString(value);
}

namespace internal {


// static
bool WakeLock_RequestWakeLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_RequestWakeLock_Params_Data* object = static_cast<const WakeLock_RequestWakeLock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WakeLock_RequestWakeLock_Params_Data::WakeLock_RequestWakeLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_CancelWakeLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_CancelWakeLock_Params_Data* object = static_cast<const WakeLock_CancelWakeLock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WakeLock_CancelWakeLock_Params_Data::WakeLock_CancelWakeLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_AddClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_AddClient_Params_Data* object = static_cast<const WakeLock_AddClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->wake_lock, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->wake_lock,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WakeLock_AddClient_Params_Data::WakeLock_AddClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_ChangeType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_ChangeType_Params_Data* object = static_cast<const WakeLock_ChangeType_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::WakeLockType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

WakeLock_ChangeType_Params_Data::WakeLock_ChangeType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_ChangeType_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_ChangeType_ResponseParams_Data* object = static_cast<const WakeLock_ChangeType_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WakeLock_ChangeType_ResponseParams_Data::WakeLock_ChangeType_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_HasWakeLockForTests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_HasWakeLockForTests_Params_Data* object = static_cast<const WakeLock_HasWakeLockForTests_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WakeLock_HasWakeLockForTests_Params_Data::WakeLock_HasWakeLockForTests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WakeLock_HasWakeLockForTests_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WakeLock_HasWakeLockForTests_ResponseParams_Data* object = static_cast<const WakeLock_HasWakeLockForTests_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WakeLock_HasWakeLockForTests_ResponseParams_Data::WakeLock_HasWakeLockForTests_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::WakeLockType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::WakeLockType value) {
  return std::move(context).WriteString(::device::mojom::WakeLockTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::WakeLockReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::WakeLockReason value) {
  return std::move(context).WriteString(::device::mojom::WakeLockReasonToString(value));
}

} // namespace perfetto
