// services/network/public/mojom/content_security_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/content_security_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/content_security_policy.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* ContentSecurityPolicyTypeToStringHelper(ContentSecurityPolicyType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSecurityPolicyType::kReport:
      return "kReport";
    case ContentSecurityPolicyType::kEnforce:
      return "kEnforce";
    default:
      return nullptr;
  }
}

std::string ContentSecurityPolicyTypeToString(ContentSecurityPolicyType value) {
  const char *str = ContentSecurityPolicyTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSecurityPolicyType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyType value) {
  return os << ContentSecurityPolicyTypeToString(value);
}

static NOINLINE const char* ContentSecurityPolicySourceToStringHelper(ContentSecurityPolicySource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSecurityPolicySource::kHTTP:
      return "kHTTP";
    case ContentSecurityPolicySource::kMeta:
      return "kMeta";
    case ContentSecurityPolicySource::kOriginPolicy:
      return "kOriginPolicy";
    default:
      return nullptr;
  }
}

std::string ContentSecurityPolicySourceToString(ContentSecurityPolicySource value) {
  const char *str = ContentSecurityPolicySourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSecurityPolicySource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicySource value) {
  return os << ContentSecurityPolicySourceToString(value);
}

static NOINLINE const char* CSPDispositionToStringHelper(CSPDisposition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSPDisposition::CHECK:
      return "CHECK";
    case CSPDisposition::DO_NOT_CHECK:
      return "DO_NOT_CHECK";
    default:
      return nullptr;
  }
}

std::string CSPDispositionToString(CSPDisposition value) {
  const char *str = CSPDispositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSPDisposition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSPDisposition value) {
  return os << CSPDispositionToString(value);
}

static NOINLINE const char* CSPHashAlgorithmToStringHelper(CSPHashAlgorithm value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSPHashAlgorithm::None:
      return "None";
    case CSPHashAlgorithm::SHA256:
      return "SHA256";
    case CSPHashAlgorithm::SHA384:
      return "SHA384";
    case CSPHashAlgorithm::SHA512:
      return "SHA512";
    default:
      return nullptr;
  }
}

std::string CSPHashAlgorithmToString(CSPHashAlgorithm value) {
  const char *str = CSPHashAlgorithmToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSPHashAlgorithm value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSPHashAlgorithm value) {
  return os << CSPHashAlgorithmToString(value);
}

static NOINLINE const char* CSPDirectiveNameToStringHelper(CSPDirectiveName value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSPDirectiveName::Unknown:
      return "Unknown";
    case CSPDirectiveName::BaseURI:
      return "BaseURI";
    case CSPDirectiveName::BlockAllMixedContent:
      return "BlockAllMixedContent";
    case CSPDirectiveName::ChildSrc:
      return "ChildSrc";
    case CSPDirectiveName::ConnectSrc:
      return "ConnectSrc";
    case CSPDirectiveName::DefaultSrc:
      return "DefaultSrc";
    case CSPDirectiveName::FontSrc:
      return "FontSrc";
    case CSPDirectiveName::FormAction:
      return "FormAction";
    case CSPDirectiveName::FrameAncestors:
      return "FrameAncestors";
    case CSPDirectiveName::FrameSrc:
      return "FrameSrc";
    case CSPDirectiveName::ImgSrc:
      return "ImgSrc";
    case CSPDirectiveName::ManifestSrc:
      return "ManifestSrc";
    case CSPDirectiveName::MediaSrc:
      return "MediaSrc";
    case CSPDirectiveName::NavigateTo:
      return "NavigateTo";
    case CSPDirectiveName::ObjectSrc:
      return "ObjectSrc";
    case CSPDirectiveName::PrefetchSrc:
      return "PrefetchSrc";
    case CSPDirectiveName::ReportTo:
      return "ReportTo";
    case CSPDirectiveName::ReportURI:
      return "ReportURI";
    case CSPDirectiveName::RequireTrustedTypesFor:
      return "RequireTrustedTypesFor";
    case CSPDirectiveName::Sandbox:
      return "Sandbox";
    case CSPDirectiveName::ScriptSrc:
      return "ScriptSrc";
    case CSPDirectiveName::ScriptSrcAttr:
      return "ScriptSrcAttr";
    case CSPDirectiveName::ScriptSrcElem:
      return "ScriptSrcElem";
    case CSPDirectiveName::StyleSrc:
      return "StyleSrc";
    case CSPDirectiveName::StyleSrcAttr:
      return "StyleSrcAttr";
    case CSPDirectiveName::StyleSrcElem:
      return "StyleSrcElem";
    case CSPDirectiveName::TreatAsPublicAddress:
      return "TreatAsPublicAddress";
    case CSPDirectiveName::TrustedTypes:
      return "TrustedTypes";
    case CSPDirectiveName::UpgradeInsecureRequests:
      return "UpgradeInsecureRequests";
    case CSPDirectiveName::WorkerSrc:
      return "WorkerSrc";
    default:
      return nullptr;
  }
}

std::string CSPDirectiveNameToString(CSPDirectiveName value) {
  const char *str = CSPDirectiveNameToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSPDirectiveName value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSPDirectiveName value) {
  return os << CSPDirectiveNameToString(value);
}

static NOINLINE const char* CSPRequireTrustedTypesForToStringHelper(CSPRequireTrustedTypesFor value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CSPRequireTrustedTypesFor::None:
      return "None";
    case CSPRequireTrustedTypesFor::Script:
      return "Script";
    default:
      return nullptr;
  }
}

std::string CSPRequireTrustedTypesForToString(CSPRequireTrustedTypesFor value) {
  const char *str = CSPRequireTrustedTypesForToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CSPRequireTrustedTypesFor value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CSPRequireTrustedTypesFor value) {
  return os << CSPRequireTrustedTypesForToString(value);
}

namespace internal {
// static
bool AllowCSPFromHeaderValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AllowCSPFromHeaderValue_Data* object = static_cast<const AllowCSPFromHeaderValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AllowCSPFromHeaderValue_Tag::ALLOW_STAR: {

      return true;
    }
    case AllowCSPFromHeaderValue_Tag::ORIGIN: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_origin, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_origin, validation_context))
        return false;
      return true;
    }
    case AllowCSPFromHeaderValue_Tag::ERROR_MESSAGE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_message, 3, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams error_message_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_error_message, validation_context,
                                             &error_message_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AllowCSPFromHeaderValue");
      return false;
    }
  }
}


// static
bool ContentSecurityPolicyHeader_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicyHeader_Data* object = static_cast<const ContentSecurityPolicyHeader_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams header_value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->header_value, validation_context,
                                         &header_value_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ContentSecurityPolicyType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::network::mojom::internal::ContentSecurityPolicySource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

ContentSecurityPolicyHeader_Data::ContentSecurityPolicyHeader_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPSource_Data* object = static_cast<const CSPSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams scheme_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  return true;
}

CSPSource_Data::CSPSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPHashSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPHashSource_Data* object = static_cast<const CSPHashSource_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CSPHashAlgorithm_Data
        ::Validate(object->algorithm, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

CSPHashSource_Data::CSPHashSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPSourceList_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPSourceList_Data* object = static_cast<const CSPSourceList_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sources_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonces, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams nonces_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->nonces, validation_context,
                                         &nonces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hashes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hashes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hashes, validation_context,
                                         &hashes_validate_params)) {
    return false;
  }

  return true;
}

CSPSourceList_Data::CSPSourceList_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPTrustedTypes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPTrustedTypes_Data* object = static_cast<const CSPTrustedTypes_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->list, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->list, validation_context,
                                         &list_validate_params)) {
    return false;
  }

  return true;
}

CSPTrustedTypes_Data::CSPTrustedTypes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSecurityPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ContentSecurityPolicy_Data* object = static_cast<const ContentSecurityPolicy_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->self_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->self_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_directives, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams raw_directives_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::network::mojom::internal::CSPDirectiveName_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->raw_directives, validation_context,
                                         &raw_directives_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->directives, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams directives_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::network::mojom::internal::CSPDirectiveName_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->directives, validation_context,
                                         &directives_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->header, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_endpoints, 10, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->report_endpoints, validation_context,
                                         &report_endpoints_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CSPRequireTrustedTypesFor_Data
        ::Validate(object->require_trusted_types_for, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_types, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsing_errors, 13, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams parsing_errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->parsing_errors, validation_context,
                                         &parsing_errors_validate_params)) {
    return false;
  }

  return true;
}

ContentSecurityPolicy_Data::ContentSecurityPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CSPViolation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CSPViolation_Data* object = static_cast<const CSPViolation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->directive, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->directive, validation_context,
                                         &directive_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effective_directive, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams effective_directive_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->effective_directive, validation_context,
                                         &effective_directive_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->console_message, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams console_message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->console_message, validation_context,
                                         &console_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_endpoints, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->report_endpoints, validation_context,
                                         &report_endpoints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams header_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->header, validation_context,
                                         &header_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ContentSecurityPolicyType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  return true;
}

CSPViolation_Data::CSPViolation_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ContentSecurityPolicyType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ContentSecurityPolicyType value) {
  return std::move(context).WriteString(::network::mojom::ContentSecurityPolicyTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ContentSecurityPolicySource>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ContentSecurityPolicySource value) {
  return std::move(context).WriteString(::network::mojom::ContentSecurityPolicySourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CSPDisposition>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CSPDisposition value) {
  return std::move(context).WriteString(::network::mojom::CSPDispositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CSPHashAlgorithm>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CSPHashAlgorithm value) {
  return std::move(context).WriteString(::network::mojom::CSPHashAlgorithmToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CSPDirectiveName>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CSPDirectiveName value) {
  return std::move(context).WriteString(::network::mojom::CSPDirectiveNameToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CSPRequireTrustedTypesFor>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CSPRequireTrustedTypesFor value) {
  return std::move(context).WriteString(::network::mojom::CSPRequireTrustedTypesForToString(value));
}

} // namespace perfetto
