// services/network/public/mojom/cookie_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cookie_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_manager.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* CookieAccessDelegateTypeToStringHelper(CookieAccessDelegateType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieAccessDelegateType::USE_CONTENT_SETTINGS:
      return "USE_CONTENT_SETTINGS";
    case CookieAccessDelegateType::ALWAYS_LEGACY:
      return "ALWAYS_LEGACY";
    case CookieAccessDelegateType::ALWAYS_NONLEGACY:
      return "ALWAYS_NONLEGACY";
    default:
      return nullptr;
  }
}

std::string CookieAccessDelegateTypeToString(CookieAccessDelegateType value) {
  const char *str = CookieAccessDelegateTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieAccessDelegateType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieAccessDelegateType value) {
  return os << CookieAccessDelegateTypeToString(value);
}

static NOINLINE const char* CookiePriorityToStringHelper(CookiePriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookiePriority::LOW:
      return "LOW";
    case CookiePriority::MEDIUM:
      return "MEDIUM";
    case CookiePriority::HIGH:
      return "HIGH";
    default:
      return nullptr;
  }
}

std::string CookiePriorityToString(CookiePriority value) {
  const char *str = CookiePriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookiePriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookiePriority value) {
  return os << CookiePriorityToString(value);
}

static NOINLINE const char* CookieSourceSchemeToStringHelper(CookieSourceScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSourceScheme::kUnset:
      return "kUnset";
    case CookieSourceScheme::kNonSecure:
      return "kNonSecure";
    case CookieSourceScheme::kSecure:
      return "kSecure";
    default:
      return nullptr;
  }
}

std::string CookieSourceSchemeToString(CookieSourceScheme value) {
  const char *str = CookieSourceSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSourceScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSourceScheme value) {
  return os << CookieSourceSchemeToString(value);
}

static NOINLINE const char* CookieSameSiteToStringHelper(CookieSameSite value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSameSite::UNSPECIFIED:
      return "UNSPECIFIED";
    case CookieSameSite::NO_RESTRICTION:
      return "NO_RESTRICTION";
    case CookieSameSite::LAX_MODE:
      return "LAX_MODE";
    case CookieSameSite::STRICT_MODE:
      return "STRICT_MODE";
    default:
      return nullptr;
  }
}

std::string CookieSameSiteToString(CookieSameSite value) {
  const char *str = CookieSameSiteToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSameSite value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSameSite value) {
  return os << CookieSameSiteToString(value);
}

static NOINLINE const char* CookieEffectiveSameSiteToStringHelper(CookieEffectiveSameSite value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieEffectiveSameSite::kNoRestriction:
      return "kNoRestriction";
    case CookieEffectiveSameSite::kLaxMode:
      return "kLaxMode";
    case CookieEffectiveSameSite::kStrictMode:
      return "kStrictMode";
    case CookieEffectiveSameSite::kLaxModeAllowUnsafe:
      return "kLaxModeAllowUnsafe";
    case CookieEffectiveSameSite::kUndefined:
      return "kUndefined";
    default:
      return nullptr;
  }
}

std::string CookieEffectiveSameSiteToString(CookieEffectiveSameSite value) {
  const char *str = CookieEffectiveSameSiteToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieEffectiveSameSite value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieEffectiveSameSite value) {
  return os << CookieEffectiveSameSiteToString(value);
}

static NOINLINE const char* ContextTypeToStringHelper(ContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContextType::CROSS_SITE:
      return "CROSS_SITE";
    case ContextType::SAME_SITE_LAX_METHOD_UNSAFE:
      return "SAME_SITE_LAX_METHOD_UNSAFE";
    case ContextType::SAME_SITE_LAX:
      return "SAME_SITE_LAX";
    case ContextType::SAME_SITE_STRICT:
      return "SAME_SITE_STRICT";
    default:
      return nullptr;
  }
}

std::string ContextTypeToString(ContextType value) {
  const char *str = ContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContextType value) {
  return os << ContextTypeToString(value);
}

static NOINLINE const char* CookieSameSiteContextMetadataDowngradeTypeToStringHelper(CookieSameSiteContextMetadataDowngradeType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieSameSiteContextMetadataDowngradeType::kNoDowngrade:
      return "kNoDowngrade";
    case CookieSameSiteContextMetadataDowngradeType::kStrictToLax:
      return "kStrictToLax";
    case CookieSameSiteContextMetadataDowngradeType::kStrictToCross:
      return "kStrictToCross";
    case CookieSameSiteContextMetadataDowngradeType::kLaxToCross:
      return "kLaxToCross";
    default:
      return nullptr;
  }
}

std::string CookieSameSiteContextMetadataDowngradeTypeToString(CookieSameSiteContextMetadataDowngradeType value) {
  const char *str = CookieSameSiteContextMetadataDowngradeTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieSameSiteContextMetadataDowngradeType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieSameSiteContextMetadataDowngradeType value) {
  return os << CookieSameSiteContextMetadataDowngradeTypeToString(value);
}

static NOINLINE const char* SamePartyCookieContextTypeToStringHelper(SamePartyCookieContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SamePartyCookieContextType::kCrossParty:
      return "kCrossParty";
    case SamePartyCookieContextType::kSameParty:
      return "kSameParty";
    default:
      return nullptr;
  }
}

std::string SamePartyCookieContextTypeToString(SamePartyCookieContextType value) {
  const char *str = SamePartyCookieContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SamePartyCookieContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SamePartyCookieContextType value) {
  return os << SamePartyCookieContextTypeToString(value);
}

static NOINLINE const char* CookieAccessSemanticsToStringHelper(CookieAccessSemantics value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieAccessSemantics::UNKNOWN:
      return "UNKNOWN";
    case CookieAccessSemantics::NONLEGACY:
      return "NONLEGACY";
    case CookieAccessSemantics::LEGACY:
      return "LEGACY";
    default:
      return nullptr;
  }
}

std::string CookieAccessSemanticsToString(CookieAccessSemantics value) {
  const char *str = CookieAccessSemanticsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieAccessSemantics value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieAccessSemantics value) {
  return os << CookieAccessSemanticsToString(value);
}

static NOINLINE const char* CookieChangeCauseToStringHelper(CookieChangeCause value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieChangeCause::INSERTED:
      return "INSERTED";
    case CookieChangeCause::EXPLICIT:
      return "EXPLICIT";
    case CookieChangeCause::UNKNOWN_DELETION:
      return "UNKNOWN_DELETION";
    case CookieChangeCause::OVERWRITE:
      return "OVERWRITE";
    case CookieChangeCause::EXPIRED:
      return "EXPIRED";
    case CookieChangeCause::EVICTED:
      return "EVICTED";
    case CookieChangeCause::EXPIRED_OVERWRITE:
      return "EXPIRED_OVERWRITE";
    default:
      return nullptr;
  }
}

std::string CookieChangeCauseToString(CookieChangeCause value) {
  const char *str = CookieChangeCauseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieChangeCause value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieChangeCause value) {
  return os << CookieChangeCauseToString(value);
}

static NOINLINE const char* CookieDeletionSessionControlToStringHelper(CookieDeletionSessionControl value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieDeletionSessionControl::IGNORE_CONTROL:
      return "IGNORE_CONTROL";
    case CookieDeletionSessionControl::SESSION_COOKIES:
      return "SESSION_COOKIES";
    case CookieDeletionSessionControl::PERSISTENT_COOKIES:
      return "PERSISTENT_COOKIES";
    default:
      return nullptr;
  }
}

std::string CookieDeletionSessionControlToString(CookieDeletionSessionControl value) {
  const char *str = CookieDeletionSessionControlToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieDeletionSessionControl value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieDeletionSessionControl value) {
  return os << CookieDeletionSessionControlToString(value);
}

namespace internal {
// static
bool CookieOrLine_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CookieOrLine_Data* object = static_cast<const CookieOrLine_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CookieOrLine_Tag::COOKIE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cookie, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cookie, validation_context))
        return false;
      return true;
    }
    case CookieOrLine_Tag::COOKIE_STRING: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cookie_string, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams cookie_string_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_cookie_string, validation_context,
                                             &cookie_string_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CookieOrLine");
      return false;
    }
  }
}


// static
bool CookieManagerParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManagerParams_Data* object = static_cast<const CookieManagerParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings, validation_context,
                                         &settings_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secure_origin_cookies_allowed_schemes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams secure_origin_cookies_allowed_schemes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->secure_origin_cookies_allowed_schemes, validation_context,
                                         &secure_origin_cookies_allowed_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matching_scheme_cookies_allowed_schemes, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams matching_scheme_cookies_allowed_schemes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->matching_scheme_cookies_allowed_schemes, validation_context,
                                         &matching_scheme_cookies_allowed_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->third_party_cookies_allowed_schemes, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams third_party_cookies_allowed_schemes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->third_party_cookies_allowed_schemes, validation_context,
                                         &third_party_cookies_allowed_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings_for_legacy_cookie_access, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_for_legacy_cookie_access_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings_for_legacy_cookie_access, validation_context,
                                         &settings_for_legacy_cookie_access_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings_for_storage_access, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_for_storage_access_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings_for_storage_access, validation_context,
                                         &settings_for_storage_access_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CookieAccessDelegateType_Data
        ::Validate(object->cookie_access_delegate_type, validation_context))
    return false;

  return true;
}

CookieManagerParams_Data::CookieManagerParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieSameSiteContextMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieSameSiteContextMetadata_Data* object = static_cast<const CookieSameSiteContextMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CookieSameSiteContextMetadataDowngradeType_Data
        ::Validate(object->cross_site_redirect_downgrade, validation_context))
    return false;

  return true;
}

CookieSameSiteContextMetadata_Data::CookieSameSiteContextMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieSameSiteContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieSameSiteContext_Data* object = static_cast<const CookieSameSiteContext_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ContextType_Data
        ::Validate(object->context, validation_context))
    return false;


  if (!::network::mojom::internal::ContextType_Data
        ::Validate(object->schemeful_context, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->schemeful_metadata, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->schemeful_metadata, validation_context))
    return false;

  return true;
}

CookieSameSiteContext_Data::CookieSameSiteContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieOptions_Data* object = static_cast<const CookieOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->same_site_cookie_context, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->same_site_cookie_context, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->same_party_context, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->same_party_context, validation_context))
    return false;

  return true;
}

CookieOptions_Data::CookieOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookiePartitionKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookiePartitionKey_Data* object = static_cast<const CookiePartitionKey_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site, validation_context))
    return false;

  return true;
}

CookiePartitionKey_Data::CookiePartitionKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CanonicalCookie_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CanonicalCookie_Data* object = static_cast<const CanonicalCookie_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams domain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_access, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_access, validation_context))
    return false;


  if (!::network::mojom::internal::CookieSameSite_Data
        ::Validate(object->site_restrictions, validation_context))
    return false;


  if (!::network::mojom::internal::CookiePriority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::network::mojom::internal::CookieSourceScheme_Data
        ::Validate(object->source_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->partition_key, validation_context))
    return false;

  return true;
}

CanonicalCookie_Data::CanonicalCookie_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieInclusionStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieInclusionStatus_Data* object = static_cast<const CookieInclusionStatus_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieInclusionStatus_Data::CookieInclusionStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieAndLineWithAccessResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieAndLineWithAccessResult_Data* object = static_cast<const CookieAndLineWithAccessResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_string, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookie_string_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookie_string, validation_context,
                                         &cookie_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_result, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access_result, validation_context))
    return false;

  return true;
}

CookieAndLineWithAccessResult_Data::CookieAndLineWithAccessResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieOrLineWithAccessResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieOrLineWithAccessResult_Data* object = static_cast<const CookieOrLineWithAccessResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->cookie_or_line, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->cookie_or_line, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access_result, validation_context))
    return false;

  return true;
}

CookieOrLineWithAccessResult_Data::CookieOrLineWithAccessResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieAccessResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieAccessResult_Data* object = static_cast<const CookieAccessResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CookieEffectiveSameSite_Data
        ::Validate(object->effective_same_site, validation_context))
    return false;


  if (!::network::mojom::internal::CookieAccessSemantics_Data
        ::Validate(object->access_semantics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

CookieAccessResult_Data::CookieAccessResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieWithAccessResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieWithAccessResult_Data* object = static_cast<const CookieWithAccessResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access_result, validation_context))
    return false;

  return true;
}

CookieWithAccessResult_Data::CookieWithAccessResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SamePartyContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SamePartyContext_Data* object = static_cast<const SamePartyContext_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::SamePartyCookieContextType_Data
        ::Validate(object->context_type, validation_context))
    return false;


  if (!::network::mojom::internal::SamePartyCookieContextType_Data
        ::Validate(object->ancestors_for_metrics_only, validation_context))
    return false;


  if (!::network::mojom::internal::SamePartyCookieContextType_Data
        ::Validate(object->top_resource_for_metrics_only, validation_context))
    return false;

  return true;
}

SamePartyContext_Data::SamePartyContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieChangeInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieChangeInfo_Data* object = static_cast<const CookieChangeInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access_result, validation_context))
    return false;


  if (!::network::mojom::internal::CookieChangeCause_Data
        ::Validate(object->cause, validation_context))
    return false;

  return true;
}

CookieChangeInfo_Data::CookieChangeInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieDeletionFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieDeletionFilter_Data* object = static_cast<const CookieDeletionFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->created_after_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->created_before_time, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams excluding_domains_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->excluding_domains, validation_context,
                                         &excluding_domains_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams including_domains_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->including_domains, validation_context,
                                         &including_domains_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams cookie_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookie_name, validation_context,
                                         &cookie_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams host_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host_name, validation_context,
                                         &host_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::CookieDeletionSessionControl_Data
        ::Validate(object->session_control, validation_context))
    return false;

  return true;
}

CookieDeletionFilter_Data::CookieDeletionFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieChangeListener_OnCookieChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieChangeListener_OnCookieChange_Params_Data* object = static_cast<const CookieChangeListener_OnCookieChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->change, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->change, validation_context))
    return false;

  return true;
}

CookieChangeListener_OnCookieChange_Params_Data::CookieChangeListener_OnCookieChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieRemoteAccessFilter_AllowedAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieRemoteAccessFilter_AllowedAccess_Params_Data* object = static_cast<const CookieRemoteAccessFilter_AllowedAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  return true;
}

CookieRemoteAccessFilter_AllowedAccess_Params_Data::CookieRemoteAccessFilter_AllowedAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data* object = static_cast<const CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetAllCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetAllCookies_Params_Data* object = static_cast<const CookieManager_GetAllCookies_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_GetAllCookies_Params_Data::CookieManager_GetAllCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetAllCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetAllCookies_ResponseParams_Data* object = static_cast<const CookieManager_GetAllCookies_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_GetAllCookies_ResponseParams_Data::CookieManager_GetAllCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* object = static_cast<const CookieManager_GetAllCookiesWithAccessSemantics_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* object = static_cast<const CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_semantics_list, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams access_semantics_list_validate_params(
      0, ::network::mojom::internal::CookieAccessSemantics_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->access_semantics_list, validation_context,
                                         &access_semantics_list_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetCookieList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetCookieList_Params_Data* object = static_cast<const CookieManager_GetCookieList_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_options, validation_context))
    return false;

  return true;
}

CookieManager_GetCookieList_Params_Data::CookieManager_GetCookieList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_GetCookieList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_GetCookieList_ResponseParams_Data* object = static_cast<const CookieManager_GetCookieList_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->excluded_cookies, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams excluded_cookies_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->excluded_cookies, validation_context,
                                         &excluded_cookies_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_GetCookieList_ResponseParams_Data::CookieManager_GetCookieList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetCanonicalCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetCanonicalCookie_Params_Data* object = static_cast<const CookieManager_SetCanonicalCookie_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_options, validation_context))
    return false;

  return true;
}

CookieManager_SetCanonicalCookie_Params_Data::CookieManager_SetCanonicalCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetCanonicalCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetCanonicalCookie_ResponseParams_Data* object = static_cast<const CookieManager_SetCanonicalCookie_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access_result, validation_context))
    return false;

  return true;
}

CookieManager_SetCanonicalCookie_ResponseParams_Data::CookieManager_SetCanonicalCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteCanonicalCookie_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteCanonicalCookie_Params_Data* object = static_cast<const CookieManager_DeleteCanonicalCookie_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  return true;
}

CookieManager_DeleteCanonicalCookie_Params_Data::CookieManager_DeleteCanonicalCookie_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteCanonicalCookie_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteCanonicalCookie_ResponseParams_Data* object = static_cast<const CookieManager_DeleteCanonicalCookie_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_DeleteCanonicalCookie_ResponseParams_Data::CookieManager_DeleteCanonicalCookie_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteCookies_Params_Data* object = static_cast<const CookieManager_DeleteCookies_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

CookieManager_DeleteCookies_Params_Data::CookieManager_DeleteCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteCookies_ResponseParams_Data* object = static_cast<const CookieManager_DeleteCookies_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_DeleteCookies_ResponseParams_Data::CookieManager_DeleteCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteSessionOnlyCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteSessionOnlyCookies_Params_Data* object = static_cast<const CookieManager_DeleteSessionOnlyCookies_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_DeleteSessionOnlyCookies_Params_Data::CookieManager_DeleteSessionOnlyCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data* object = static_cast<const CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_AddCookieChangeListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_AddCookieChangeListener_Params_Data* object = static_cast<const CookieManager_AddCookieChangeListener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieManager_AddCookieChangeListener_Params_Data::CookieManager_AddCookieChangeListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_AddGlobalChangeListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_AddGlobalChangeListener_Params_Data* object = static_cast<const CookieManager_AddGlobalChangeListener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->notification_pointer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->notification_pointer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieManager_AddGlobalChangeListener_Params_Data::CookieManager_AddGlobalChangeListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_CloneInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_CloneInterface_Params_Data* object = static_cast<const CookieManager_CloneInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->new_interface, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->new_interface,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieManager_CloneInterface_Params_Data::CookieManager_CloneInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_FlushCookieStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_FlushCookieStore_Params_Data* object = static_cast<const CookieManager_FlushCookieStore_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_FlushCookieStore_Params_Data::CookieManager_FlushCookieStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_FlushCookieStore_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_FlushCookieStore_ResponseParams_Data* object = static_cast<const CookieManager_FlushCookieStore_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_FlushCookieStore_ResponseParams_Data::CookieManager_FlushCookieStore_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_AllowFileSchemeCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_AllowFileSchemeCookies_Params_Data* object = static_cast<const CookieManager_AllowFileSchemeCookies_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_AllowFileSchemeCookies_Params_Data::CookieManager_AllowFileSchemeCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_AllowFileSchemeCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_AllowFileSchemeCookies_ResponseParams_Data* object = static_cast<const CookieManager_AllowFileSchemeCookies_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_AllowFileSchemeCookies_ResponseParams_Data::CookieManager_AllowFileSchemeCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetContentSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetContentSettings_Params_Data* object = static_cast<const CookieManager_SetContentSettings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings, validation_context,
                                         &settings_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_SetContentSettings_Params_Data::CookieManager_SetContentSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetRemoteFilter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetRemoteFilter_Params_Data* object = static_cast<const CookieManager_SetRemoteFilter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remote_access_filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remote_access_filter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieManager_SetRemoteFilter_Params_Data::CookieManager_SetRemoteFilter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetForceKeepSessionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetForceKeepSessionState_Params_Data* object = static_cast<const CookieManager_SetForceKeepSessionState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_SetForceKeepSessionState_Params_Data::CookieManager_SetForceKeepSessionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_BlockThirdPartyCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_BlockThirdPartyCookies_Params_Data* object = static_cast<const CookieManager_BlockThirdPartyCookies_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_BlockThirdPartyCookies_Params_Data::CookieManager_BlockThirdPartyCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data* object = static_cast<const CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings, validation_context,
                                         &settings_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetStorageAccessGrantSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetStorageAccessGrantSettings_Params_Data* object = static_cast<const CookieManager_SetStorageAccessGrantSettings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->settings, validation_context,
                                         &settings_validate_params)) {
    return false;
  }

  return true;
}

CookieManager_SetStorageAccessGrantSettings_Params_Data::CookieManager_SetStorageAccessGrantSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data* object = static_cast<const CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieAccessDelegateType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieAccessDelegateType value) {
  return std::move(context).WriteString(::network::mojom::CookieAccessDelegateTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookiePriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookiePriority value) {
  return std::move(context).WriteString(::network::mojom::CookiePriorityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieSourceScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieSourceScheme value) {
  return std::move(context).WriteString(::network::mojom::CookieSourceSchemeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieSameSite>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieSameSite value) {
  return std::move(context).WriteString(::network::mojom::CookieSameSiteToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieEffectiveSameSite>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieEffectiveSameSite value) {
  return std::move(context).WriteString(::network::mojom::CookieEffectiveSameSiteToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ContextType value) {
  return std::move(context).WriteString(::network::mojom::ContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieSameSiteContextMetadataDowngradeType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieSameSiteContextMetadataDowngradeType value) {
  return std::move(context).WriteString(::network::mojom::CookieSameSiteContextMetadataDowngradeTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SamePartyCookieContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SamePartyCookieContextType value) {
  return std::move(context).WriteString(::network::mojom::SamePartyCookieContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieAccessSemantics>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieAccessSemantics value) {
  return std::move(context).WriteString(::network::mojom::CookieAccessSemanticsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieChangeCause>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieChangeCause value) {
  return std::move(context).WriteString(::network::mojom::CookieChangeCauseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieDeletionSessionControl>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieDeletionSessionControl value) {
  return std::move(context).WriteString(::network::mojom::CookieDeletionSessionControlToString(value));
}

} // namespace perfetto
