// services/network/public/mojom/cors.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cors.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* CorsPreflightPolicyToStringHelper(CorsPreflightPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsPreflightPolicy::kConsiderPreflight:
      return "kConsiderPreflight";
    case CorsPreflightPolicy::kPreventPreflight:
      return "kPreventPreflight";
    default:
      return nullptr;
  }
}

std::string CorsPreflightPolicyToString(CorsPreflightPolicy value) {
  const char *str = CorsPreflightPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsPreflightPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsPreflightPolicy value) {
  return os << CorsPreflightPolicyToString(value);
}

static NOINLINE const char* CorsErrorToStringHelper(CorsError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CorsError::kDisallowedByMode:
      return "kDisallowedByMode";
    case CorsError::kInvalidResponse:
      return "kInvalidResponse";
    case CorsError::kWildcardOriginNotAllowed:
      return "kWildcardOriginNotAllowed";
    case CorsError::kMissingAllowOriginHeader:
      return "kMissingAllowOriginHeader";
    case CorsError::kMultipleAllowOriginValues:
      return "kMultipleAllowOriginValues";
    case CorsError::kInvalidAllowOriginValue:
      return "kInvalidAllowOriginValue";
    case CorsError::kAllowOriginMismatch:
      return "kAllowOriginMismatch";
    case CorsError::kInvalidAllowCredentials:
      return "kInvalidAllowCredentials";
    case CorsError::kCorsDisabledScheme:
      return "kCorsDisabledScheme";
    case CorsError::kPreflightInvalidStatus:
      return "kPreflightInvalidStatus";
    case CorsError::kPreflightDisallowedRedirect:
      return "kPreflightDisallowedRedirect";
    case CorsError::kPreflightWildcardOriginNotAllowed:
      return "kPreflightWildcardOriginNotAllowed";
    case CorsError::kPreflightMissingAllowOriginHeader:
      return "kPreflightMissingAllowOriginHeader";
    case CorsError::kPreflightMultipleAllowOriginValues:
      return "kPreflightMultipleAllowOriginValues";
    case CorsError::kPreflightInvalidAllowOriginValue:
      return "kPreflightInvalidAllowOriginValue";
    case CorsError::kPreflightAllowOriginMismatch:
      return "kPreflightAllowOriginMismatch";
    case CorsError::kPreflightInvalidAllowCredentials:
      return "kPreflightInvalidAllowCredentials";
    case CorsError::kPreflightMissingAllowExternal:
      return "kPreflightMissingAllowExternal";
    case CorsError::kPreflightInvalidAllowExternal:
      return "kPreflightInvalidAllowExternal";
    case CorsError::kInvalidAllowMethodsPreflightResponse:
      return "kInvalidAllowMethodsPreflightResponse";
    case CorsError::kInvalidAllowHeadersPreflightResponse:
      return "kInvalidAllowHeadersPreflightResponse";
    case CorsError::kMethodDisallowedByPreflightResponse:
      return "kMethodDisallowedByPreflightResponse";
    case CorsError::kHeaderDisallowedByPreflightResponse:
      return "kHeaderDisallowedByPreflightResponse";
    case CorsError::kRedirectContainsCredentials:
      return "kRedirectContainsCredentials";
    case CorsError::kInsecurePrivateNetwork:
      return "kInsecurePrivateNetwork";
    default:
      return nullptr;
  }
}

std::string CorsErrorToString(CorsError value) {
  const char *str = CorsErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CorsError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CorsError value) {
  return os << CorsErrorToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsPreflightPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsPreflightPolicy value) {
  return std::move(context).WriteString(::network::mojom::CorsPreflightPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsError>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CorsError value) {
  return std::move(context).WriteString(::network::mojom::CorsErrorToString(value));
}

} // namespace perfetto
