// services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* CrossOriginEmbedderPolicyValueToStringHelper(CrossOriginEmbedderPolicyValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CrossOriginEmbedderPolicyValue::kNone:
      return "kNone";
    case CrossOriginEmbedderPolicyValue::kCredentialless:
      return "kCredentialless";
    case CrossOriginEmbedderPolicyValue::kRequireCorp:
      return "kRequireCorp";
    default:
      return nullptr;
  }
}

std::string CrossOriginEmbedderPolicyValueToString(CrossOriginEmbedderPolicyValue value) {
  const char *str = CrossOriginEmbedderPolicyValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CrossOriginEmbedderPolicyValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CrossOriginEmbedderPolicyValue value) {
  return os << CrossOriginEmbedderPolicyValueToString(value);
}

namespace internal {


// static
bool CrossOriginEmbedderPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicy_Data* object = static_cast<const CrossOriginEmbedderPolicy_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CrossOriginEmbedderPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CrossOriginEmbedderPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams report_only_reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginEmbedderPolicy_Data::CrossOriginEmbedderPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* object = static_cast<const CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;

  return true;
}

CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginEmbedderPolicyReporter_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicyReporter_Clone_Params_Data* object = static_cast<const CrossOriginEmbedderPolicyReporter_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CrossOriginEmbedderPolicyReporter_Clone_Params_Data::CrossOriginEmbedderPolicyReporter_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CrossOriginEmbedderPolicyValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CrossOriginEmbedderPolicyValue value) {
  return std::move(context).WriteString(::network::mojom::CrossOriginEmbedderPolicyValueToString(value));
}

} // namespace perfetto
