// services/network/public/mojom/cross_origin_embedder_policy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy()
    : value(CrossOriginEmbedderPolicyValue::kNone),
      reporting_endpoint(),
      report_only_value(CrossOriginEmbedderPolicyValue::kNone),
      report_only_reporting_endpoint() {}

CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy(
    CrossOriginEmbedderPolicyValue value_in,
    const absl::optional<std::string>& reporting_endpoint_in,
    CrossOriginEmbedderPolicyValue report_only_value_in,
    const absl::optional<std::string>& report_only_reporting_endpoint_in)
    : value(std::move(value_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      report_only_value(std::move(report_only_value_in)),
      report_only_reporting_endpoint(std::move(report_only_reporting_endpoint_in)) {}

CrossOriginEmbedderPolicy::~CrossOriginEmbedderPolicy() = default;

void CrossOriginEmbedderPolicy::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginEmbedderPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_value"), this->report_only_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginEmbedderPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_reporting_endpoint"), this->report_only_reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CrossOriginEmbedderPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CrossOriginEmbedderPolicyReporter::Name_[] = "network.mojom.CrossOriginEmbedderPolicyReporter";

CrossOriginEmbedderPolicyReporterProxy::CrossOriginEmbedderPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrossOriginEmbedderPolicyReporterProxy::QueueCorpViolationReport(
    const ::GURL& in_blocked_url, ::network::mojom::RequestDestination in_destination, bool in_report_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type ::network::mojom::RequestDestination>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_only"), in_report_only,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url, blocked_url_fragment);
  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blocked_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_url in CrossOriginEmbedderPolicyReporter.QueueCorpViolationReport request");
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
      in_destination, &params->destination);
  params->report_only = in_report_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("QueueCorpViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CrossOriginEmbedderPolicyReporterProxy::Clone(
    ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CrossOriginEmbedderPolicyReporter::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCrossOriginEmbedderPolicyReporter_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CrossOriginEmbedderPolicyReporter.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::Accept(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_blocked_url{};
      ::network::mojom::RequestDestination p_destination{};
      bool p_report_only{};
      CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success)
        p_report_only = input_data_view.report_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCorpViolationReport(
std::move(p_blocked_url), 
std::move(p_destination), 
std::move(p_report_only));
      return true;
    }
    case internal::kCrossOriginEmbedderPolicyReporter_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> p_receiver{};
      CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::AcceptWithResponder(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name: {
      break;
    }
    case internal::kCrossOriginEmbedderPolicyReporter_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCrossOriginEmbedderPolicyReporterValidationInfo[] = {
    {internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name,
     {&internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCrossOriginEmbedderPolicyReporter_Clone_Name,
     {&internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CrossOriginEmbedderPolicyReporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::CrossOriginEmbedderPolicyReporter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCrossOriginEmbedderPolicyReporterValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CrossOriginEmbedderPolicy::DataView, ::network::mojom::CrossOriginEmbedderPolicyPtr>::Read(
    ::network::mojom::CrossOriginEmbedderPolicy::DataView input,
    ::network::mojom::CrossOriginEmbedderPolicyPtr* output) {
  bool success = true;
  ::network::mojom::CrossOriginEmbedderPolicyPtr result(::network::mojom::CrossOriginEmbedderPolicy::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadReportOnlyValue(&result->report_only_value))
        success = false;
      if (success && !input.ReadReportOnlyReportingEndpoint(&result->report_only_reporting_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif