// services/network/public/mojom/early_hints.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/early_hints.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/early_hints.mojom-params-data.h"
#include "services/network/public/mojom/early_hints.mojom-shared-message-ids.h"

#include "services/network/public/mojom/early_hints.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_EARLY_HINTS_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_EARLY_HINTS_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
EarlyHints::EarlyHints()
    : headers(),
      ip_address_space(),
      origin_trial_tokens() {}

EarlyHints::EarlyHints(
    ::network::mojom::ParsedHeadersPtr headers_in,
    ::network::mojom::IPAddressSpace ip_address_space_in,
    std::vector<std::string> origin_trial_tokens_in)
    : headers(std::move(headers_in)),
      ip_address_space(std::move(ip_address_space_in)),
      origin_trial_tokens(std::move(origin_trial_tokens_in)) {}

EarlyHints::~EarlyHints() = default;

void EarlyHints::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ParsedHeadersPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address_space"), this->ip_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_trial_tokens"), this->origin_trial_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EarlyHints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::EarlyHints::DataView, ::network::mojom::EarlyHintsPtr>::Read(
    ::network::mojom::EarlyHints::DataView input,
    ::network::mojom::EarlyHintsPtr* output) {
  bool success = true;
  ::network::mojom::EarlyHintsPtr result(::network::mojom::EarlyHints::New());
  
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
      if (success && !input.ReadOriginTrialTokens(&result->origin_trial_tokens))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif