// services/network/public/mojom/host_resolver.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/host_resolver.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/host_resolver.mojom-params-data.h"
#include "services/network/public/mojom/host_resolver.mojom-shared-message-ids.h"

#include "services/network/public/mojom/host_resolver.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
DnsOverHttpsServer::DnsOverHttpsServer()
    : server_template(),
      use_post(false) {}

DnsOverHttpsServer::DnsOverHttpsServer(
    const std::string& server_template_in,
    bool use_post_in)
    : server_template(std::move(server_template_in)),
      use_post(std::move(use_post_in)) {}

DnsOverHttpsServer::~DnsOverHttpsServer() = default;
size_t DnsOverHttpsServer::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->server_template);
  seed = mojo::internal::Hash(seed, this->use_post);
  return seed;
}

void DnsOverHttpsServer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_template"), this->server_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_post"), this->use_post,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsOverHttpsServer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DnsConfigOverrides::DnsConfigOverrides()
    : nameservers(),
      search(),
      append_to_multi_label_name(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      ndots(-1),
      fallback_period(),
      attempts(-1),
      rotate(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      use_local_ipv6(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      dns_over_https_servers(),
      secure_dns_mode(OptionalSecureDnsMode::NO_OVERRIDE),
      allow_dns_over_https_upgrade(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      disabled_upgrade_providers(),
      clear_hosts(false) {}

DnsConfigOverrides::DnsConfigOverrides(
    absl::optional<std::vector<::net::IPEndPoint>> nameservers_in,
    absl::optional<std::vector<std::string>> search_in,
    DnsConfigOverrides::Tristate append_to_multi_label_name_in,
    int8_t ndots_in,
    absl::optional<::base::TimeDelta> fallback_period_in,
    int32_t attempts_in,
    DnsConfigOverrides::Tristate rotate_in,
    DnsConfigOverrides::Tristate use_local_ipv6_in,
    absl::optional<std::vector<DnsOverHttpsServerPtr>> dns_over_https_servers_in,
    OptionalSecureDnsMode secure_dns_mode_in,
    DnsConfigOverrides::Tristate allow_dns_over_https_upgrade_in,
    absl::optional<std::vector<std::string>> disabled_upgrade_providers_in,
    bool clear_hosts_in)
    : nameservers(std::move(nameservers_in)),
      search(std::move(search_in)),
      append_to_multi_label_name(std::move(append_to_multi_label_name_in)),
      ndots(std::move(ndots_in)),
      fallback_period(std::move(fallback_period_in)),
      attempts(std::move(attempts_in)),
      rotate(std::move(rotate_in)),
      use_local_ipv6(std::move(use_local_ipv6_in)),
      dns_over_https_servers(std::move(dns_over_https_servers_in)),
      secure_dns_mode(std::move(secure_dns_mode_in)),
      allow_dns_over_https_upgrade(std::move(allow_dns_over_https_upgrade_in)),
      disabled_upgrade_providers(std::move(disabled_upgrade_providers_in)),
      clear_hosts(std::move(clear_hosts_in)) {}

DnsConfigOverrides::~DnsConfigOverrides() = default;

void DnsConfigOverrides::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nameservers"), this->nameservers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<::net::IPEndPoint>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search"), this->search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "append_to_multi_label_name"), this->append_to_multi_label_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ndots"), this->ndots,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_period"), this->fallback_period,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attempts"), this->attempts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotate"), this->rotate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_local_ipv6"), this->use_local_ipv6,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_over_https_servers"), this->dns_over_https_servers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<DnsOverHttpsServerPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_dns_mode"), this->secure_dns_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalSecureDnsMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_dns_over_https_upgrade"), this->allow_dns_over_https_upgrade,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_upgrade_providers"), this->disabled_upgrade_providers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clear_hosts"), this->clear_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsConfigOverrides::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveErrorInfo::ResolveErrorInfo()
    : error(),
      is_secure_network_error(false) {}

ResolveErrorInfo::ResolveErrorInfo(
    int32_t error_in,
    bool is_secure_network_error_in)
    : error(std::move(error_in)),
      is_secure_network_error(std::move(is_secure_network_error_in)) {}

ResolveErrorInfo::~ResolveErrorInfo() = default;

void ResolveErrorInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_secure_network_error"), this->is_secure_network_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolveErrorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveHostParameters::ResolveHostParameters()
    : dns_query_type(mojo::internal::ConvertEnumValue<DnsQueryType, ::net::DnsQueryType>(DnsQueryType::UNSPECIFIED)),
      initial_priority(mojo::internal::ConvertEnumValue<::network::mojom::RequestPriority, ::net::RequestPriority>(::network::mojom::RequestPriority::kLowest)),
      source(mojo::internal::ConvertEnumValue<ResolveHostParameters::Source, ::net::HostResolverSource>(ResolveHostParameters_Source::ANY)),
      cache_usage(ResolveHostParameters_CacheUsage::ALLOWED),
      control_handle(),
      include_canonical_name(false),
      loopback_only(false),
      is_speculative(false),
      secure_dns_policy(SecureDnsPolicy::ALLOW),
      purpose(ResolveHostParameters_Purpose::kUnspecified) {}

ResolveHostParameters::ResolveHostParameters(
    ::net::DnsQueryType dns_query_type_in,
    ::net::RequestPriority initial_priority_in,
    ::net::HostResolverSource source_in,
    ResolveHostParameters::CacheUsage cache_usage_in,
    ::mojo::PendingReceiver<ResolveHostHandle> control_handle_in,
    bool include_canonical_name_in,
    bool loopback_only_in,
    bool is_speculative_in,
    SecureDnsPolicy secure_dns_policy_in,
    ResolveHostParameters::Purpose purpose_in)
    : dns_query_type(std::move(dns_query_type_in)),
      initial_priority(std::move(initial_priority_in)),
      source(std::move(source_in)),
      cache_usage(std::move(cache_usage_in)),
      control_handle(std::move(control_handle_in)),
      include_canonical_name(std::move(include_canonical_name_in)),
      loopback_only(std::move(loopback_only_in)),
      is_speculative(std::move(is_speculative_in)),
      secure_dns_policy(std::move(secure_dns_policy_in)),
      purpose(std::move(purpose_in)) {}

ResolveHostParameters::~ResolveHostParameters() = default;

void ResolveHostParameters::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_query_type"), this->dns_query_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::DnsQueryType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_priority"), this->initial_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::HostResolverSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_usage"), this->cache_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolveHostParameters::CacheUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_handle"), this->control_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<ResolveHostHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_canonical_name"), this->include_canonical_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loopback_only"), this->loopback_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_speculative"), this->is_speculative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_dns_policy"), this->secure_dns_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SecureDnsPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purpose"), this->purpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolveHostParameters::Purpose>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolveHostParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ResolveHostHandle::Name_[] = "network.mojom.ResolveHostHandle";

ResolveHostHandleProxy::ResolveHostHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostHandleProxy::Cancel(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostHandle::Cancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResolveHostHandle_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostHandle_Cancel_Params_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostHandle::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResolveHostHandleStubDispatch::Accept(
    ResolveHostHandle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kResolveHostHandle_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostHandle::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostHandle::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostHandle_Cancel_Params_Data* params =
          reinterpret_cast<internal::ResolveHostHandle_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_result{};
      ResolveHostHandle_Cancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostHandleStubDispatch::AcceptWithResponder(
    ResolveHostHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResolveHostHandle_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResolveHostHandleValidationInfo[] = {
    {internal::kResolveHostHandle_Cancel_Name,
     {&internal::ResolveHostHandle_Cancel_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ResolveHostHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ResolveHostHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResolveHostHandleValidationInfo);
}

const char ResolveHostClient::Name_[] = "network.mojom.ResolveHostClient";

ResolveHostClientProxy::ResolveHostClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostClientProxy::OnComplete(
    int32_t in_result, const ::net::ResolveErrorInfo& in_resolve_error_info, const absl::optional<::net::AddressList>& in_resolved_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolve_error_info"), in_resolve_error_info,
                        "<value of type const ::net::ResolveErrorInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolved_addresses"), in_resolved_addresses,
                        "<value of type const absl::optional<::net::AddressList>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResolveHostClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->resolve_error_info)::BaseType> resolve_error_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
      in_resolve_error_info, resolve_error_info_fragment);
  params->resolve_error_info.Set(
      resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resolve_error_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resolve_error_info in ResolveHostClient.OnComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->resolved_addresses)::BaseType> resolved_addresses_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
      in_resolved_addresses, resolved_addresses_fragment);
  params->resolved_addresses.Set(
      resolved_addresses_fragment.is_null() ? nullptr : resolved_addresses_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResolveHostClientProxy::OnTextResults(
    const std::vector<std::string>& in_text_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnTextResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_results"), in_text_results,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResolveHostClient_OnTextResults_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnTextResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text_results)::BaseType>
      text_results_fragment(params.message());
  const mojo::internal::ContainerValidateParams text_results_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_text_results, text_results_fragment, &text_results_validate_params);
  params->text_results.Set(
      text_results_fragment.is_null() ? nullptr : text_results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text_results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_results in ResolveHostClient.OnTextResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnTextResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResolveHostClientProxy::OnHostnameResults(
    const std::vector<::net::HostPortPair>& in_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnHostnameResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hosts"), in_hosts,
                        "<value of type const std::vector<::net::HostPortPair>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kResolveHostClient_OnHostnameResults_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnHostnameResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hosts)::BaseType>
      hosts_fragment(params.message());
  const mojo::internal::ContainerValidateParams hosts_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HostPortPairDataView>>(
      in_hosts, hosts_fragment, &hosts_validate_params);
  params->hosts.Set(
      hosts_fragment.is_null() ? nullptr : hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hosts in ResolveHostClient.OnHostnameResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnHostnameResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResolveHostClientStubDispatch::Accept(
    ResolveHostClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kResolveHostClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_result{};
      ::net::ResolveErrorInfo p_resolve_error_info{};
      absl::optional<::net::AddressList> p_resolved_addresses{};
      ResolveHostClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_result = input_data_view.result();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadResolvedAddresses(&p_resolved_addresses))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_result), 
std::move(p_resolve_error_info), 
std::move(p_resolved_addresses));
      return true;
    }
    case internal::kResolveHostClient_OnTextResults_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnTextResults",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnTextResults");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnTextResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnTextResults_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_text_results{};
      ResolveHostClient_OnTextResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTextResults(&p_text_results))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResults(
std::move(p_text_results));
      return true;
    }
    case internal::kResolveHostClient_OnHostnameResults_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnHostnameResults",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnHostnameResults");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnHostnameResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnHostnameResults_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::net::HostPortPair> p_hosts{};
      ResolveHostClient_OnHostnameResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHosts(&p_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResults(
std::move(p_hosts));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostClientStubDispatch::AcceptWithResponder(
    ResolveHostClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResolveHostClient_OnComplete_Name: {
      break;
    }
    case internal::kResolveHostClient_OnTextResults_Name: {
      break;
    }
    case internal::kResolveHostClient_OnHostnameResults_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResolveHostClientValidationInfo[] = {
    {internal::kResolveHostClient_OnComplete_Name,
     {&internal::ResolveHostClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kResolveHostClient_OnTextResults_Name,
     {&internal::ResolveHostClient_OnTextResults_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kResolveHostClient_OnHostnameResults_Name,
     {&internal::ResolveHostClient_OnHostnameResults_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ResolveHostClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ResolveHostClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResolveHostClientValidationInfo);
}

const char MdnsListenClient::Name_[] = "network.mojom.MdnsListenClient";

MdnsListenClientProxy::MdnsListenClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MdnsListenClientProxy::OnAddressResult(
    ::net::MdnsListenerUpdateType in_update_type, ::net::DnsQueryType in_query_type, const ::net::IPEndPoint& in_endpoint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnAddressResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::net::MdnsListenerUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnAddressResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnAddressResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_endpoint, endpoint_fragment);
  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->endpoint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoint in MdnsListenClient.OnAddressResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnAddressResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnTextResult(
    ::net::MdnsListenerUpdateType in_update_type, ::net::DnsQueryType in_query_type, const std::vector<std::string>& in_text_records) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnTextResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::net::MdnsListenerUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_records"), in_text_records,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnTextResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnTextResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->text_records)::BaseType>
      text_records_fragment(params.message());
  const mojo::internal::ContainerValidateParams text_records_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_text_records, text_records_fragment, &text_records_validate_params);
  params->text_records.Set(
      text_records_fragment.is_null() ? nullptr : text_records_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text_records.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_records in MdnsListenClient.OnTextResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnTextResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnHostnameResult(
    ::net::MdnsListenerUpdateType in_update_type, ::net::DnsQueryType in_query_type, const ::net::HostPortPair& in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnHostnameResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::net::MdnsListenerUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnHostnameResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnHostnameResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in MdnsListenClient.OnHostnameResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnHostnameResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnUnhandledResult(
    ::net::MdnsListenerUpdateType in_update_type, ::net::DnsQueryType in_query_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnUnhandledResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type ::net::MdnsListenerUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnUnhandledResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnUnhandledResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnUnhandledResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MdnsListenClientStubDispatch::Accept(
    MdnsListenClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMdnsListenClient_OnAddressResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnAddressResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnAddressResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnAddressResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnAddressResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::MdnsListenerUpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      ::net::IPEndPoint p_endpoint{};
      MdnsListenClient_OnAddressResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAddressResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_endpoint));
      return true;
    }
    case internal::kMdnsListenClient_OnTextResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnTextResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnTextResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnTextResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnTextResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::MdnsListenerUpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      std::vector<std::string> p_text_records{};
      MdnsListenClient_OnTextResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadTextRecords(&p_text_records))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_text_records));
      return true;
    }
    case internal::kMdnsListenClient_OnHostnameResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnHostnameResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnHostnameResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnHostnameResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnHostnameResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::MdnsListenerUpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      ::net::HostPortPair p_host{};
      MdnsListenClient_OnHostnameResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_host));
      return true;
    }
    case internal::kMdnsListenClient_OnUnhandledResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnUnhandledResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnUnhandledResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnUnhandledResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnUnhandledResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::MdnsListenerUpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      MdnsListenClient_OnUnhandledResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUnhandledResult(
std::move(p_update_type), 
std::move(p_query_type));
      return true;
    }
  }
  return false;
}

// static
bool MdnsListenClientStubDispatch::AcceptWithResponder(
    MdnsListenClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMdnsListenClient_OnAddressResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnTextResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnHostnameResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnUnhandledResult_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMdnsListenClientValidationInfo[] = {
    {internal::kMdnsListenClient_OnAddressResult_Name,
     {&internal::MdnsListenClient_OnAddressResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnTextResult_Name,
     {&internal::MdnsListenClient_OnTextResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnHostnameResult_Name,
     {&internal::MdnsListenClient_OnHostnameResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnUnhandledResult_Name,
     {&internal::MdnsListenClient_OnUnhandledResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MdnsListenClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::MdnsListenClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMdnsListenClientValidationInfo);
}

const char HostResolver::Name_[] = "network.mojom.HostResolver";

class HostResolver_MdnsListen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HostResolver_MdnsListen_ForwardToCallback(
      HostResolver::MdnsListenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HostResolver::MdnsListenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HostResolver_MdnsListen_ForwardToCallback);
};

HostResolverProxy::HostResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HostResolverProxy::ResolveHost(
    const ::net::HostPortPair& in_host, const ::net::NetworkIsolationKey& in_network_isolation_key, ResolveHostParametersPtr in_optional_parameters, ::mojo::PendingRemote<ResolveHostClient> in_response_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HostResolver::ResolveHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_isolation_key"), in_network_isolation_key,
                        "<value of type const ::net::NetworkIsolationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("optional_parameters"), in_optional_parameters,
                        "<value of type ResolveHostParametersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_client"), in_response_client,
                        "<value of type ::mojo::PendingRemote<ResolveHostClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHostResolver_ResolveHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_ResolveHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in HostResolver.ResolveHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->network_isolation_key)::BaseType> network_isolation_key_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, network_isolation_key_fragment);
  params->network_isolation_key.Set(
      network_isolation_key_fragment.is_null() ? nullptr : network_isolation_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in HostResolver.ResolveHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->optional_parameters)::BaseType> optional_parameters_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ResolveHostParametersDataView>(
      in_optional_parameters, optional_parameters_fragment);
  params->optional_parameters.Set(
      optional_parameters_fragment.is_null() ? nullptr : optional_parameters_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
      in_response_client, &params->response_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_client in HostResolver.ResolveHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("ResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void HostResolverProxy::MdnsListen(
    const ::net::HostPortPair& in_host, ::net::DnsQueryType in_query_type, ::mojo::PendingRemote<MdnsListenClient> in_response_client, MdnsListenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HostResolver::MdnsListen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_client"), in_response_client,
                        "<value of type ::mojo::PendingRemote<MdnsListenClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHostResolver_MdnsListen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_MdnsListen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in HostResolver.MdnsListen request");
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::MdnsListenClientInterfaceBase>>(
      in_response_client, &params->response_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_client in HostResolver.MdnsListen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HostResolver_MdnsListen_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HostResolver_MdnsListen_ProxyToResponder {
 public:
  static HostResolver::MdnsListenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HostResolver_MdnsListen_ProxyToResponder> proxy(
        new HostResolver_MdnsListen_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HostResolver_MdnsListen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HostResolver_MdnsListen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HostResolver_MdnsListen_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HostResolver::MdnsListenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HostResolver_MdnsListen_ProxyToResponder);
};

bool HostResolver_MdnsListen_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::HostResolver::MdnsListenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HostResolver_MdnsListen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HostResolver_MdnsListen_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_result{};
  HostResolver_MdnsListen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HostResolver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void HostResolver_MdnsListen_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::HostResolver::MdnsListenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHostResolver_MdnsListen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_MdnsListen_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::HostResolver::MdnsListenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HostResolverStubDispatch::Accept(
    HostResolver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHostResolver_ResolveHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HostResolver::ResolveHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HostResolver::ResolveHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::HostResolver_ResolveHost_Params_Data* params =
          reinterpret_cast<internal::HostResolver_ResolveHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::HostPortPair p_host{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ResolveHostParametersPtr p_optional_parameters{};
      ::mojo::PendingRemote<ResolveHostClient> p_response_client{};
      HostResolver_ResolveHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success && !input_data_view.ReadOptionalParameters(&p_optional_parameters))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveHost(
std::move(p_host), 
std::move(p_network_isolation_key), 
std::move(p_optional_parameters), 
std::move(p_response_client));
      return true;
    }
    case internal::kHostResolver_MdnsListen_Name: {
      break;
    }
  }
  return false;
}

// static
bool HostResolverStubDispatch::AcceptWithResponder(
    HostResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHostResolver_ResolveHost_Name: {
      break;
    }
    case internal::kHostResolver_MdnsListen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HostResolver::MdnsListen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HostResolver::MdnsListen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HostResolver_MdnsListen_Params_Data* params =
          reinterpret_cast<
              internal::HostResolver_MdnsListen_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::HostPortPair p_host{};
      ::net::DnsQueryType p_query_type{};
      ::mojo::PendingRemote<MdnsListenClient> p_response_client{};
      HostResolver_MdnsListen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 1, false);
        return false;
      }
      HostResolver::MdnsListenCallback callback =
          HostResolver_MdnsListen_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MdnsListen(
std::move(p_host), 
std::move(p_query_type), 
std::move(p_response_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHostResolverValidationInfo[] = {
    {internal::kHostResolver_ResolveHost_Name,
     {&internal::HostResolver_ResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kHostResolver_MdnsListen_Name,
     {&internal::HostResolver_MdnsListen_Params_Data::Validate,
      &internal::HostResolver_MdnsListen_ResponseParams_Data::Validate}},
};

bool HostResolverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HostResolver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHostResolverValidationInfo);
}

bool HostResolverResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HostResolver::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHostResolverValidationInfo);

}
const char DnsConfigChangeManagerClient::Name_[] = "network.mojom.DnsConfigChangeManagerClient";

DnsConfigChangeManagerClientProxy::DnsConfigChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerClientProxy::OnDnsConfigChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManagerClient::Name_);
  message.set_method_name("OnDnsConfigChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DnsConfigChangeManagerClientStubDispatch::Accept(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDnsConfigChanged();
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerClientStubDispatch::AcceptWithResponder(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDnsConfigChangeManagerClientValidationInfo[] = {
    {internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name,
     {&internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DnsConfigChangeManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::DnsConfigChangeManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDnsConfigChangeManagerClientValidationInfo);
}

const char DnsConfigChangeManager::Name_[] = "network.mojom.DnsConfigChangeManager";

DnsConfigChangeManagerProxy::DnsConfigChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<DnsConfigChangeManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DnsConfigChangeManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DnsConfigChangeManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDnsConfigChangeManager_RequestNotifications_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DnsConfigChangeManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DnsConfigChangeManagerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in DnsConfigChangeManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DnsConfigChangeManagerStubDispatch::Accept(
    DnsConfigChangeManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManager_RequestNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DnsConfigChangeManager::RequestNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DnsConfigChangeManager::RequestNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<DnsConfigChangeManagerClient> p_client{};
      DnsConfigChangeManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerStubDispatch::AcceptWithResponder(
    DnsConfigChangeManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManager_RequestNotifications_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDnsConfigChangeManagerValidationInfo[] = {
    {internal::kDnsConfigChangeManager_RequestNotifications_Name,
     {&internal::DnsConfigChangeManager_RequestNotifications_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DnsConfigChangeManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::DnsConfigChangeManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDnsConfigChangeManagerValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::DnsOverHttpsServer::DataView, ::network::mojom::DnsOverHttpsServerPtr>::Read(
    ::network::mojom::DnsOverHttpsServer::DataView input,
    ::network::mojom::DnsOverHttpsServerPtr* output) {
  bool success = true;
  ::network::mojom::DnsOverHttpsServerPtr result(::network::mojom::DnsOverHttpsServer::New());
  
      if (success && !input.ReadServerTemplate(&result->server_template))
        success = false;
      if (success)
        result->use_post = input.use_post();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::DnsConfigOverrides::DataView, ::network::mojom::DnsConfigOverridesPtr>::Read(
    ::network::mojom::DnsConfigOverrides::DataView input,
    ::network::mojom::DnsConfigOverridesPtr* output) {
  bool success = true;
  ::network::mojom::DnsConfigOverridesPtr result(::network::mojom::DnsConfigOverrides::New());
  
      if (success && !input.ReadNameservers(&result->nameservers))
        success = false;
      if (success && !input.ReadSearch(&result->search))
        success = false;
      if (success && !input.ReadAppendToMultiLabelName(&result->append_to_multi_label_name))
        success = false;
      if (success)
        result->ndots = input.ndots();
      if (success && !input.ReadFallbackPeriod(&result->fallback_period))
        success = false;
      if (success)
        result->attempts = input.attempts();
      if (success && !input.ReadRotate(&result->rotate))
        success = false;
      if (success && !input.ReadUseLocalIpv6(&result->use_local_ipv6))
        success = false;
      if (success && !input.ReadDnsOverHttpsServers(&result->dns_over_https_servers))
        success = false;
      if (success && !input.ReadSecureDnsMode(&result->secure_dns_mode))
        success = false;
      if (success && !input.ReadAllowDnsOverHttpsUpgrade(&result->allow_dns_over_https_upgrade))
        success = false;
      if (success && !input.ReadDisabledUpgradeProviders(&result->disabled_upgrade_providers))
        success = false;
      if (success)
        result->clear_hosts = input.clear_hosts();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ResolveErrorInfo::DataView, ::network::mojom::ResolveErrorInfoPtr>::Read(
    ::network::mojom::ResolveErrorInfo::DataView input,
    ::network::mojom::ResolveErrorInfoPtr* output) {
  bool success = true;
  ::network::mojom::ResolveErrorInfoPtr result(::network::mojom::ResolveErrorInfo::New());
  
      if (success)
        result->error = input.error();
      if (success)
        result->is_secure_network_error = input.is_secure_network_error();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ResolveHostParameters::DataView, ::network::mojom::ResolveHostParametersPtr>::Read(
    ::network::mojom::ResolveHostParameters::DataView input,
    ::network::mojom::ResolveHostParametersPtr* output) {
  bool success = true;
  ::network::mojom::ResolveHostParametersPtr result(::network::mojom::ResolveHostParameters::New());
  
      if (success && !input.ReadDnsQueryType(&result->dns_query_type))
        success = false;
      if (success && !input.ReadInitialPriority(&result->initial_priority))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadCacheUsage(&result->cache_usage))
        success = false;
      if (success) {
        result->control_handle =
            input.TakeControlHandle<decltype(result->control_handle)>();
      }
      if (success)
        result->include_canonical_name = input.include_canonical_name();
      if (success)
        result->loopback_only = input.loopback_only();
      if (success)
        result->is_speculative = input.is_speculative();
      if (success && !input.ReadSecureDnsPolicy(&result->secure_dns_policy))
        success = false;
      if (success && !input.ReadPurpose(&result->purpose))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif