// services/network/public/mojom/net_log.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/net_log.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/net_log.mojom-params-data.h"
#include "services/network/public/mojom/net_log.mojom-shared-message-ids.h"

#include "services/network/public/mojom/net_log.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char NetLogExporter::Name_[] = "network.mojom.NetLogExporter";
constexpr uint64_t NetLogExporter::kUnlimitedFileSize;

class NetLogExporter_Start_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetLogExporter_Start_ForwardToCallback(
      NetLogExporter::StartCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetLogExporter::StartCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetLogExporter_Start_ForwardToCallback);
};

class NetLogExporter_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetLogExporter_Stop_ForwardToCallback(
      NetLogExporter::StopCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetLogExporter::StopCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetLogExporter_Stop_ForwardToCallback);
};

NetLogExporterProxy::NetLogExporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogExporterProxy::Start(
    ::base::File in_destination, ::base::Value in_extra_constants, ::net::NetLogCaptureMode in_capture_mode, uint64_t in_max_file_size, StartCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetLogExporter::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra_constants"), in_extra_constants,
                        "<value of type ::base::Value>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_mode"), in_capture_mode,
                        "<value of type ::net::NetLogCaptureMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_file_size"), in_max_file_size,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogExporter_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->destination)::BaseType> destination_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_destination, destination_fragment);
  params->destination.Set(
      destination_fragment.is_null() ? nullptr : destination_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->destination.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null destination in NetLogExporter.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->extra_constants)::BaseType> extra_constants_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_extra_constants, extra_constants_fragment);
  params->extra_constants.Set(
      extra_constants_fragment.is_null() ? nullptr : extra_constants_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extra_constants.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_constants in NetLogExporter.Start request");
  mojo::internal::Serialize<::network::mojom::NetLogCaptureMode>(
      in_capture_mode, &params->capture_mode);
  params->max_file_size = in_max_file_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Start");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetLogExporter_Start_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetLogExporterProxy::Stop(
    ::base::Value in_polled_values, StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetLogExporter::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("polled_values"), in_polled_values,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogExporter_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->polled_values)::BaseType> polled_values_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_polled_values, polled_values_fragment);
  params->polled_values.Set(
      polled_values_fragment.is_null() ? nullptr : polled_values_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->polled_values.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null polled_values in NetLogExporter.Stop request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetLogExporter_Stop_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NetLogExporter_Start_ProxyToResponder {
 public:
  static NetLogExporter::StartCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetLogExporter_Start_ProxyToResponder> proxy(
        new NetLogExporter_Start_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetLogExporter_Start_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetLogExporter_Start_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetLogExporter_Start_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetLogExporter::StartCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetLogExporter_Start_ProxyToResponder);
};

bool NetLogExporter_Start_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetLogExporter::StartCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetLogExporter_Start_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetLogExporter_Start_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  NetLogExporter_Start_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetLogExporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void NetLogExporter_Start_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetLogExporter::StartCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogExporter_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Start_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetLogExporter::StartCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Start");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetLogExporter_Stop_ProxyToResponder {
 public:
  static NetLogExporter::StopCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetLogExporter_Stop_ProxyToResponder> proxy(
        new NetLogExporter_Stop_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetLogExporter_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetLogExporter_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetLogExporter_Stop_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetLogExporter::StopCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetLogExporter_Stop_ProxyToResponder);
};

bool NetLogExporter_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetLogExporter::StopCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetLogExporter_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetLogExporter_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  NetLogExporter_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetLogExporter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void NetLogExporter_Stop_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetLogExporter::StopCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogExporter_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Stop_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetLogExporter::StopCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetLogExporterStubDispatch::Accept(
    NetLogExporter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetLogExporter_Start_Name: {
      break;
    }
    case internal::kNetLogExporter_Stop_Name: {
      break;
    }
  }
  return false;
}

// static
bool NetLogExporterStubDispatch::AcceptWithResponder(
    NetLogExporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetLogExporter_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetLogExporter::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetLogExporter::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetLogExporter_Start_Params_Data* params =
          reinterpret_cast<
              internal::NetLogExporter_Start_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::File p_destination{};
      ::base::Value p_extra_constants{};
      ::net::NetLogCaptureMode p_capture_mode{};
      uint64_t p_max_file_size{};
      NetLogExporter_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success && !input_data_view.ReadExtraConstants(&p_extra_constants))
        success = false;
      if (success && !input_data_view.ReadCaptureMode(&p_capture_mode))
        success = false;
      if (success)
        p_max_file_size = input_data_view.max_file_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogExporter::Name_, 0, false);
        return false;
      }
      NetLogExporter::StartCallback callback =
          NetLogExporter_Start_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_destination), 
std::move(p_extra_constants), 
std::move(p_capture_mode), 
std::move(p_max_file_size), std::move(callback));
      return true;
    }
    case internal::kNetLogExporter_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetLogExporter::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetLogExporter::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetLogExporter_Stop_Params_Data* params =
          reinterpret_cast<
              internal::NetLogExporter_Stop_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Value p_polled_values{};
      NetLogExporter_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolledValues(&p_polled_values))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogExporter::Name_, 1, false);
        return false;
      }
      NetLogExporter::StopCallback callback =
          NetLogExporter_Stop_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(
std::move(p_polled_values), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetLogExporterValidationInfo[] = {
    {internal::kNetLogExporter_Start_Name,
     {&internal::NetLogExporter_Start_Params_Data::Validate,
      &internal::NetLogExporter_Start_ResponseParams_Data::Validate}},
    {internal::kNetLogExporter_Stop_Name,
     {&internal::NetLogExporter_Stop_Params_Data::Validate,
      &internal::NetLogExporter_Stop_ResponseParams_Data::Validate}},
};

bool NetLogExporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetLogExporter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetLogExporterValidationInfo);
}

bool NetLogExporterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetLogExporter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetLogExporterValidationInfo);

}
const char NetLogProxySource::Name_[] = "network.mojom.NetLogProxySource";

NetLogProxySourceProxy::NetLogProxySourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogProxySourceProxy::UpdateCaptureModes(
    uint32_t in_modes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetLogProxySource::UpdateCaptureModes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modes"), in_modes,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogProxySource_UpdateCaptureModes_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogProxySource_UpdateCaptureModes_Params_Data> params(
          message);
  params.Allocate();
  params->modes = in_modes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogProxySource::Name_);
  message.set_method_name("UpdateCaptureModes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetLogProxySourceStubDispatch::Accept(
    NetLogProxySource* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetLogProxySource_UpdateCaptureModes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetLogProxySource::UpdateCaptureModes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetLogProxySource::UpdateCaptureModes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetLogProxySource_UpdateCaptureModes_Params_Data* params =
          reinterpret_cast<internal::NetLogProxySource_UpdateCaptureModes_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_modes{};
      NetLogProxySource_UpdateCaptureModes_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_modes = input_data_view.modes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogProxySource::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCaptureModes(
std::move(p_modes));
      return true;
    }
  }
  return false;
}

// static
bool NetLogProxySourceStubDispatch::AcceptWithResponder(
    NetLogProxySource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetLogProxySource_UpdateCaptureModes_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetLogProxySourceValidationInfo[] = {
    {internal::kNetLogProxySource_UpdateCaptureModes_Name,
     {&internal::NetLogProxySource_UpdateCaptureModes_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetLogProxySourceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetLogProxySource::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetLogProxySourceValidationInfo);
}

const char NetLogProxySink::Name_[] = "network.mojom.NetLogProxySink";

NetLogProxySinkProxy::NetLogProxySinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogProxySinkProxy::AddEntry(
    uint32_t in_type, uint32_t in_source_type, uint32_t in_source_id, ::base::TimeTicks in_source_start_time, ::net::NetLogEventPhase in_phase, ::base::TimeTicks in_time, ::base::Value in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetLogProxySink::AddEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_type"), in_source_type,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_start_time"), in_source_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("phase"), in_phase,
                        "<value of type ::net::NetLogEventPhase>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNetLogProxySink_AddEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogProxySink_AddEntry_Params_Data> params(
          message);
  params.Allocate();
  params->type = in_type;
  params->source_type = in_source_type;
  params->source_id = in_source_id;
  mojo::internal::MessageFragment<
      typename decltype(params->source_start_time)::BaseType> source_start_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_source_start_time, source_start_time_fragment);
  params->source_start_time.Set(
      source_start_time_fragment.is_null() ? nullptr : source_start_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_start_time in NetLogProxySink.AddEntry request");
  mojo::internal::Serialize<::network::mojom::NetLogEventPhase>(
      in_phase, &params->phase);
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_time, time_fragment);
  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in NetLogProxySink.AddEntry request");
  mojo::internal::MessageFragment<decltype(params->params)>
      params_fragment(params.message());
  params_fragment.Claim(&params->params);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_params, params_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetLogProxySink.AddEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogProxySink::Name_);
  message.set_method_name("AddEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetLogProxySinkStubDispatch::Accept(
    NetLogProxySink* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetLogProxySink_AddEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetLogProxySink::AddEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetLogProxySink::AddEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetLogProxySink_AddEntry_Params_Data* params =
          reinterpret_cast<internal::NetLogProxySink_AddEntry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_type{};
      uint32_t p_source_type{};
      uint32_t p_source_id{};
      ::base::TimeTicks p_source_start_time{};
      ::net::NetLogEventPhase p_phase{};
      ::base::TimeTicks p_time{};
      ::base::Value p_params{};
      NetLogProxySink_AddEntry_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_type = input_data_view.type();
      if (success)
        p_source_type = input_data_view.source_type();
      if (success)
        p_source_id = input_data_view.source_id();
      if (success && !input_data_view.ReadSourceStartTime(&p_source_start_time))
        success = false;
      if (success && !input_data_view.ReadPhase(&p_phase))
        success = false;
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogProxySink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntry(
std::move(p_type), 
std::move(p_source_type), 
std::move(p_source_id), 
std::move(p_source_start_time), 
std::move(p_phase), 
std::move(p_time), 
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool NetLogProxySinkStubDispatch::AcceptWithResponder(
    NetLogProxySink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetLogProxySink_AddEntry_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetLogProxySinkValidationInfo[] = {
    {internal::kNetLogProxySink_AddEntry_Name,
     {&internal::NetLogProxySink_AddEntry_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetLogProxySinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetLogProxySink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetLogProxySinkValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif