// services/network/public/mojom/network_service.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/network_service.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"
#include "mojo/public/mojom/base/file.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-blink.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink.h"
#include "services/network/public/mojom/host_resolver.mojom-blink.h"
#include "services/network/public/mojom/http_raw_headers.mojom-blink.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"
#include "services/network/public/mojom/net_log.mojom-blink.h"
#include "services/network/public/mojom/network_change_manager.mojom-blink.h"
#include "services/network/public/mojom/network_context.mojom-blink.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink.h"
#include "services/network/public/mojom/network_interface.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-blink.h"
#include "services/network/public/mojom/network_service_test.mojom-blink.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink.h"
#include "services/network/public/mojom/parsed_headers.mojom-blink.h"
#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-blink.h"
#include "services/network/public/mojom/url_request.mojom-blink.h"
#include "services/network/public/mojom/url_response_head.mojom-blink.h"
#include "services/network/public/mojom/client_security_state.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "services/network/public/mojom/ct_log_info.mojom-blink.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif


namespace network {
namespace mojom {
namespace blink {


void NetworkServiceInterceptorForTesting::SetParams(NetworkServiceParamsPtr params) {
  GetForwardingInterface()->SetParams(std::move(params));
}
void NetworkServiceInterceptorForTesting::StartNetLog(::base::File file, ::network::mojom::blink::NetLogCaptureMode capture_mode, ::base::Value constants) {
  GetForwardingInterface()->StartNetLog(std::move(file), std::move(capture_mode), std::move(constants));
}
void NetworkServiceInterceptorForTesting::AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::blink::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::blink::NetLogProxySink> proxy_sink) {
  GetForwardingInterface()->AttachNetLogProxy(std::move(proxy_source), std::move(proxy_sink));
}
void NetworkServiceInterceptorForTesting::SetSSLKeyLogFile(::base::File file) {
  GetForwardingInterface()->SetSSLKeyLogFile(std::move(file));
}
void NetworkServiceInterceptorForTesting::CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::blink::NetworkContext> context, ::network::mojom::blink::NetworkContextParamsPtr params) {
  GetForwardingInterface()->CreateNetworkContext(std::move(context), std::move(params));
}
void NetworkServiceInterceptorForTesting::ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::network::mojom::blink::SecureDnsMode secure_dns_mode, absl::optional<WTF::Vector<::network::mojom::blink::DnsOverHttpsServerPtr>> dns_over_https_servers, bool additional_dns_types_enabled) {
  GetForwardingInterface()->ConfigureStubHostResolver(std::move(insecure_dns_client_enabled), std::move(secure_dns_mode), std::move(dns_over_https_servers), std::move(additional_dns_types_enabled));
}
void NetworkServiceInterceptorForTesting::DisableQuic() {
  GetForwardingInterface()->DisableQuic();
}
void NetworkServiceInterceptorForTesting::SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) {
  GetForwardingInterface()->SetUpHttpAuth(std::move(http_auth_static_params));
}
void NetworkServiceInterceptorForTesting::ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) {
  GetForwardingInterface()->ConfigureHttpAuthPrefs(std::move(http_auth_dynamic_params));
}
void NetworkServiceInterceptorForTesting::SetRawHeadersAccess(int32_t process_id, const WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins) {
  GetForwardingInterface()->SetRawHeadersAccess(std::move(process_id), std::move(origins));
}
void NetworkServiceInterceptorForTesting::SetMaxConnectionsPerProxy(int32_t max_connections) {
  GetForwardingInterface()->SetMaxConnectionsPerProxy(std::move(max_connections));
}
void NetworkServiceInterceptorForTesting::GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::blink::NetworkChangeManager> network_change_manager) {
  GetForwardingInterface()->GetNetworkChangeManager(std::move(network_change_manager));
}
void NetworkServiceInterceptorForTesting::GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::blink::NetworkQualityEstimatorManager> receiver) {
  GetForwardingInterface()->GetNetworkQualityEstimatorManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::blink::DnsConfigChangeManager> receiver) {
  GetForwardingInterface()->GetDnsConfigChangeManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetNetworkList(uint32_t policy, GetNetworkListCallback callback) {
  GetForwardingInterface()->GetNetworkList(std::move(policy), std::move(callback));
}
void NetworkServiceInterceptorForTesting::UpdateCRLSet(::base::span<const ::uint8_t> crl_set, UpdateCRLSetCallback callback) {
  GetForwardingInterface()->UpdateCRLSet(std::move(crl_set), std::move(callback));
}
void NetworkServiceInterceptorForTesting::OnCertDBChanged() {
  GetForwardingInterface()->OnCertDBChanged();
}
void NetworkServiceInterceptorForTesting::SetCryptConfig(CryptConfigPtr crypt_config) {
  GetForwardingInterface()->SetCryptConfig(std::move(crypt_config));
}
void NetworkServiceInterceptorForTesting::AddAllowedRequestInitiatorForPlugin(int32_t process_id, const ::scoped_refptr<const ::blink::SecurityOrigin>& allowed_request_initiator) {
  GetForwardingInterface()->AddAllowedRequestInitiatorForPlugin(std::move(process_id), std::move(allowed_request_initiator));
}
void NetworkServiceInterceptorForTesting::RemoveSecurityExceptionsForPlugin(int32_t process_id) {
  GetForwardingInterface()->RemoveSecurityExceptionsForPlugin(std::move(process_id));
}
void NetworkServiceInterceptorForTesting::OnMemoryPressure(::mojo_base::mojom::blink::MemoryPressureLevel memory_pressure_level) {
  GetForwardingInterface()->OnMemoryPressure(std::move(memory_pressure_level));
}
void NetworkServiceInterceptorForTesting::OnPeerToPeerConnectionsCountChange(uint32_t count) {
  GetForwardingInterface()->OnPeerToPeerConnectionsCountChange(std::move(count));
}
void NetworkServiceInterceptorForTesting::SetEnvironment(WTF::Vector<EnvironmentVariablePtr> environment) {
  GetForwardingInterface()->SetEnvironment(std::move(environment));
}
void NetworkServiceInterceptorForTesting::SetTrustTokenKeyCommitments(const WTF::String& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
  GetForwardingInterface()->SetTrustTokenKeyCommitments(std::move(raw_commitments), std::move(callback));
}
void NetworkServiceInterceptorForTesting::ClearSCTAuditingCache() {
  GetForwardingInterface()->ClearSCTAuditingCache();
}
void NetworkServiceInterceptorForTesting::ConfigureSCTAuditing(bool enabled, double sampling_rate, const ::blink::KURL& report_uri, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> factory) {
  GetForwardingInterface()->ConfigureSCTAuditing(std::move(enabled), std::move(sampling_rate), std::move(report_uri), std::move(traffic_annotation), std::move(factory));
}
void NetworkServiceInterceptorForTesting::UpdateCtLogList(WTF::Vector<::network::mojom::blink::CTLogInfoPtr> log_list, ::base::Time update_time) {
  GetForwardingInterface()->UpdateCtLogList(std::move(log_list), std::move(update_time));
}
void NetworkServiceInterceptorForTesting::SetCtEnforcementEnabled(bool enabled) {
  GetForwardingInterface()->SetCtEnforcementEnabled(std::move(enabled));
}
void NetworkServiceInterceptorForTesting::BindTestInterface(::mojo::PendingReceiver<::network::mojom::blink::NetworkServiceTest> receiver) {
  GetForwardingInterface()->BindTestInterface(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::SetFirstPartySets(const WTF::String& raw_sets) {
  GetForwardingInterface()->SetFirstPartySets(std::move(raw_sets));
}
void NetworkServiceInterceptorForTesting::SetExplicitlyAllowedPorts(const WTF::Vector<uint16_t>& ports) {
  GetForwardingInterface()->SetExplicitlyAllowedPorts(std::move(ports));
}
void NetworkServiceInterceptorForTesting::ParseHeaders(const ::blink::KURL& url, ::network::mojom::blink::HttpResponseHeadersPtr headers, ParseHeadersCallback callback) {
  GetForwardingInterface()->ParseHeaders(std::move(url), std::move(headers), std::move(callback));
}
NetworkServiceAsyncWaiter::NetworkServiceAsyncWaiter(
    NetworkService* proxy) : proxy_(proxy) {}

NetworkServiceAsyncWaiter::~NetworkServiceAsyncWaiter() = default;

void NetworkServiceAsyncWaiter::GetNetworkList(
    uint32_t policy, absl::optional<WTF::Vector<::net::NetworkInterface>>* out_networks) {
  base::RunLoop loop;
  proxy_->GetNetworkList(std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<WTF::Vector<::net::NetworkInterface>>* out_networks
,
             const absl::optional<WTF::Vector<::net::NetworkInterface>>& networks) {*out_networks = std::move(networks);
            loop->Quit();
          },
          &loop,
          out_networks));
  loop.Run();
}
void NetworkServiceAsyncWaiter::UpdateCRLSet(
    ::base::span<const ::uint8_t> crl_set) {
  base::RunLoop loop;
  proxy_->UpdateCRLSet(std::move(crl_set),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkServiceAsyncWaiter::SetTrustTokenKeyCommitments(
    const WTF::String& raw_commitments) {
  base::RunLoop loop;
  proxy_->SetTrustTokenKeyCommitments(std::move(raw_commitments),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkServiceAsyncWaiter::ParseHeaders(
    const ::blink::KURL& url, ::network::mojom::blink::HttpResponseHeadersPtr headers, ::network::mojom::blink::ParsedHeadersPtr* out_parsed_headers) {
  base::RunLoop loop;
  proxy_->ParseHeaders(std::move(url),std::move(headers),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::blink::ParsedHeadersPtr* out_parsed_headers
,
             ::network::mojom::blink::ParsedHeadersPtr parsed_headers) {*out_parsed_headers = std::move(parsed_headers);
            loop->Quit();
          },
          &loop,
          out_parsed_headers));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif