// services/network/public/mojom/network_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/network_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_raw_headers.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_change_manager.mojom.h"
#include "services/network/public/mojom/network_context.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom.h"
#include "services/network/public/mojom/network_interface.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom.h"
#include "services/network/public/mojom/network_service_test.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/ct_log_info.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_JUMBO_H_
#include "components/content_settings/core/common/content_settings_param_traits.h"
#endif


namespace network {
namespace mojom {


void NetworkServiceInterceptorForTesting::SetParams(NetworkServiceParamsPtr params) {
  GetForwardingInterface()->SetParams(std::move(params));
}
void NetworkServiceInterceptorForTesting::StartNetLog(::base::File file, ::net::NetLogCaptureMode capture_mode, ::base::Value constants) {
  GetForwardingInterface()->StartNetLog(std::move(file), std::move(capture_mode), std::move(constants));
}
void NetworkServiceInterceptorForTesting::AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) {
  GetForwardingInterface()->AttachNetLogProxy(std::move(proxy_source), std::move(proxy_sink));
}
void NetworkServiceInterceptorForTesting::SetSSLKeyLogFile(::base::File file) {
  GetForwardingInterface()->SetSSLKeyLogFile(std::move(file));
}
void NetworkServiceInterceptorForTesting::CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) {
  GetForwardingInterface()->CreateNetworkContext(std::move(context), std::move(params));
}
void NetworkServiceInterceptorForTesting::ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::net::SecureDnsMode secure_dns_mode, absl::optional<std::vector<::network::mojom::DnsOverHttpsServerPtr>> dns_over_https_servers, bool additional_dns_types_enabled) {
  GetForwardingInterface()->ConfigureStubHostResolver(std::move(insecure_dns_client_enabled), std::move(secure_dns_mode), std::move(dns_over_https_servers), std::move(additional_dns_types_enabled));
}
void NetworkServiceInterceptorForTesting::DisableQuic() {
  GetForwardingInterface()->DisableQuic();
}
void NetworkServiceInterceptorForTesting::SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) {
  GetForwardingInterface()->SetUpHttpAuth(std::move(http_auth_static_params));
}
void NetworkServiceInterceptorForTesting::ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) {
  GetForwardingInterface()->ConfigureHttpAuthPrefs(std::move(http_auth_dynamic_params));
}
void NetworkServiceInterceptorForTesting::SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) {
  GetForwardingInterface()->SetRawHeadersAccess(std::move(process_id), std::move(origins));
}
void NetworkServiceInterceptorForTesting::SetMaxConnectionsPerProxy(int32_t max_connections) {
  GetForwardingInterface()->SetMaxConnectionsPerProxy(std::move(max_connections));
}
void NetworkServiceInterceptorForTesting::GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) {
  GetForwardingInterface()->GetNetworkChangeManager(std::move(network_change_manager));
}
void NetworkServiceInterceptorForTesting::GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) {
  GetForwardingInterface()->GetNetworkQualityEstimatorManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) {
  GetForwardingInterface()->GetDnsConfigChangeManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetNetworkList(uint32_t policy, GetNetworkListCallback callback) {
  GetForwardingInterface()->GetNetworkList(std::move(policy), std::move(callback));
}
void NetworkServiceInterceptorForTesting::UpdateCRLSet(::base::span<const ::uint8_t> crl_set, UpdateCRLSetCallback callback) {
  GetForwardingInterface()->UpdateCRLSet(std::move(crl_set), std::move(callback));
}
void NetworkServiceInterceptorForTesting::OnCertDBChanged() {
  GetForwardingInterface()->OnCertDBChanged();
}
void NetworkServiceInterceptorForTesting::SetCryptConfig(CryptConfigPtr crypt_config) {
  GetForwardingInterface()->SetCryptConfig(std::move(crypt_config));
}
void NetworkServiceInterceptorForTesting::AddAllowedRequestInitiatorForPlugin(int32_t process_id, const ::url::Origin& allowed_request_initiator) {
  GetForwardingInterface()->AddAllowedRequestInitiatorForPlugin(std::move(process_id), std::move(allowed_request_initiator));
}
void NetworkServiceInterceptorForTesting::RemoveSecurityExceptionsForPlugin(int32_t process_id) {
  GetForwardingInterface()->RemoveSecurityExceptionsForPlugin(std::move(process_id));
}
void NetworkServiceInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) {
  GetForwardingInterface()->OnMemoryPressure(std::move(memory_pressure_level));
}
void NetworkServiceInterceptorForTesting::OnPeerToPeerConnectionsCountChange(uint32_t count) {
  GetForwardingInterface()->OnPeerToPeerConnectionsCountChange(std::move(count));
}
void NetworkServiceInterceptorForTesting::SetEnvironment(std::vector<EnvironmentVariablePtr> environment) {
  GetForwardingInterface()->SetEnvironment(std::move(environment));
}
void NetworkServiceInterceptorForTesting::SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
  GetForwardingInterface()->SetTrustTokenKeyCommitments(std::move(raw_commitments), std::move(callback));
}
void NetworkServiceInterceptorForTesting::ClearSCTAuditingCache() {
  GetForwardingInterface()->ClearSCTAuditingCache();
}
void NetworkServiceInterceptorForTesting::ConfigureSCTAuditing(bool enabled, double sampling_rate, const ::GURL& report_uri, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> factory) {
  GetForwardingInterface()->ConfigureSCTAuditing(std::move(enabled), std::move(sampling_rate), std::move(report_uri), std::move(traffic_annotation), std::move(factory));
}
void NetworkServiceInterceptorForTesting::UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, ::base::Time update_time) {
  GetForwardingInterface()->UpdateCtLogList(std::move(log_list), std::move(update_time));
}
void NetworkServiceInterceptorForTesting::SetCtEnforcementEnabled(bool enabled) {
  GetForwardingInterface()->SetCtEnforcementEnabled(std::move(enabled));
}
void NetworkServiceInterceptorForTesting::BindTestInterface(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) {
  GetForwardingInterface()->BindTestInterface(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::SetFirstPartySets(const std::string& raw_sets) {
  GetForwardingInterface()->SetFirstPartySets(std::move(raw_sets));
}
void NetworkServiceInterceptorForTesting::SetExplicitlyAllowedPorts(const std::vector<uint16_t>& ports) {
  GetForwardingInterface()->SetExplicitlyAllowedPorts(std::move(ports));
}
void NetworkServiceInterceptorForTesting::ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) {
  GetForwardingInterface()->ParseHeaders(std::move(url), std::move(headers), std::move(callback));
}
NetworkServiceAsyncWaiter::NetworkServiceAsyncWaiter(
    NetworkService* proxy) : proxy_(proxy) {}

NetworkServiceAsyncWaiter::~NetworkServiceAsyncWaiter() = default;

void NetworkServiceAsyncWaiter::GetNetworkList(
    uint32_t policy, absl::optional<std::vector<::net::NetworkInterface>>* out_networks) {
  base::RunLoop loop;
  proxy_->GetNetworkList(std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<std::vector<::net::NetworkInterface>>* out_networks
,
             const absl::optional<std::vector<::net::NetworkInterface>>& networks) {*out_networks = std::move(networks);
            loop->Quit();
          },
          &loop,
          out_networks));
  loop.Run();
}
void NetworkServiceAsyncWaiter::UpdateCRLSet(
    ::base::span<const ::uint8_t> crl_set) {
  base::RunLoop loop;
  proxy_->UpdateCRLSet(std::move(crl_set),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkServiceAsyncWaiter::SetTrustTokenKeyCommitments(
    const std::string& raw_commitments) {
  base::RunLoop loop;
  proxy_->SetTrustTokenKeyCommitments(std::move(raw_commitments),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkServiceAsyncWaiter::ParseHeaders(
    const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ::network::mojom::ParsedHeadersPtr* out_parsed_headers) {
  base::RunLoop loop;
  proxy_->ParseHeaders(std::move(url),std::move(headers),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::ParsedHeadersPtr* out_parsed_headers
,
             ::network::mojom::ParsedHeadersPtr parsed_headers) {*out_parsed_headers = std::move(parsed_headers);
            loop->Quit();
          },
          &loop,
          out_parsed_headers));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif