// services/network/public/mojom/url_loader_network_service_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-params-data.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
LoadInfo::LoadInfo()
    : timestamp(),
      host(),
      load_state(),
      state_param(),
      upload_position(),
      upload_size() {}

LoadInfo::LoadInfo(
    ::base::TimeTicks timestamp_in,
    const WTF::String& host_in,
    uint32_t load_state_in,
    const ::WTF::String& state_param_in,
    uint64_t upload_position_in,
    uint64_t upload_size_in)
    : timestamp(std::move(timestamp_in)),
      host(std::move(host_in)),
      load_state(std::move(load_state_in)),
      state_param(std::move(state_param_in)),
      upload_position(std::move(upload_position_in)),
      upload_size(std::move(upload_size_in)) {}

LoadInfo::~LoadInfo() = default;

void LoadInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_state"), this->load_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_param"), this->state_param,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_position"), this->upload_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_size"), this->upload_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoadInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ClientCertificateResponder::Name_[] = "network.mojom.ClientCertificateResponder";

ClientCertificateResponderProxy::ClientCertificateResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClientCertificateResponderProxy::ContinueWithCertificate(
    ::network::mojom::blink::X509CertificatePtr in_x509_certificate, const WTF::String& in_provider_name, const WTF::Vector<uint16_t>& in_algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> in_ssl_private_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ClientCertificateResponder::ContinueWithCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("x509_certificate"), in_x509_certificate,
                        "<value of type ::network::mojom::blink::X509CertificatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider_name"), in_provider_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("algorithm_preferences"), in_algorithm_preferences,
                        "<value of type const WTF::Vector<uint16_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_private_key"), in_ssl_private_key,
                        "<value of type ::mojo::PendingRemote<SSLPrivateKey>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kClientCertificateResponder_ContinueWithCertificate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->x509_certificate)::BaseType> x509_certificate_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_x509_certificate, x509_certificate_fragment);
  params->x509_certificate.Set(
      x509_certificate_fragment.is_null() ? nullptr : x509_certificate_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->x509_certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null x509_certificate in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::MessageFragment<
      typename decltype(params->provider_name)::BaseType> provider_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_name, provider_name_fragment);
  params->provider_name.Set(
      provider_name_fragment.is_null() ? nullptr : provider_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->provider_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider_name in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::MessageFragment<
      typename decltype(params->algorithm_preferences)::BaseType>
      algorithm_preferences_fragment(params.message());
  const mojo::internal::ContainerValidateParams algorithm_preferences_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_algorithm_preferences, algorithm_preferences_fragment, &algorithm_preferences_validate_params);
  params->algorithm_preferences.Set(
      algorithm_preferences_fragment.is_null() ? nullptr : algorithm_preferences_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->algorithm_preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null algorithm_preferences in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SSLPrivateKeyInterfaceBase>>(
      in_ssl_private_key, &params->ssl_private_key, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->ssl_private_key),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid ssl_private_key in ClientCertificateResponder.ContinueWithCertificate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClientCertificateResponderProxy::ContinueWithoutCertificate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ClientCertificateResponder::ContinueWithoutCertificate");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kClientCertificateResponder_ContinueWithoutCertificate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithoutCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClientCertificateResponderProxy::CancelRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ClientCertificateResponder::CancelRequest");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kClientCertificateResponder_CancelRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ClientCertificateResponder_CancelRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("CancelRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ClientCertificateResponderStubDispatch::Accept(
    ClientCertificateResponder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kClientCertificateResponder_ContinueWithCertificate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::ContinueWithCertificate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::ContinueWithCertificate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::X509CertificatePtr p_x509_certificate{};
      WTF::String p_provider_name{};
      WTF::Vector<uint16_t> p_algorithm_preferences{};
      ::mojo::PendingRemote<SSLPrivateKey> p_ssl_private_key{};
      ClientCertificateResponder_ContinueWithCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadX509Certificate(&p_x509_certificate))
        success = false;
      if (success && !input_data_view.ReadProviderName(&p_provider_name))
        success = false;
      if (success && !input_data_view.ReadAlgorithmPreferences(&p_algorithm_preferences))
        success = false;
      if (success) {
        p_ssl_private_key =
            input_data_view.TakeSslPrivateKey<decltype(p_ssl_private_key)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithCertificate(
std::move(p_x509_certificate), 
std::move(p_provider_name), 
std::move(p_algorithm_preferences), 
std::move(p_ssl_private_key));
      return true;
    }
    case internal::kClientCertificateResponder_ContinueWithoutCertificate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::ContinueWithoutCertificate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::ContinueWithoutCertificate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithoutCertificate();
      return true;
    }
    case internal::kClientCertificateResponder_CancelRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::CancelRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::CancelRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_CancelRequest_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_CancelRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClientCertificateResponder_CancelRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelRequest();
      return true;
    }
  }
  return false;
}

// static
bool ClientCertificateResponderStubDispatch::AcceptWithResponder(
    ClientCertificateResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kClientCertificateResponder_ContinueWithCertificate_Name: {
      break;
    }
    case internal::kClientCertificateResponder_ContinueWithoutCertificate_Name: {
      break;
    }
    case internal::kClientCertificateResponder_CancelRequest_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kClientCertificateResponderValidationInfo[] = {
    {internal::kClientCertificateResponder_ContinueWithCertificate_Name,
     {&internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kClientCertificateResponder_ContinueWithoutCertificate_Name,
     {&internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kClientCertificateResponder_CancelRequest_Name,
     {&internal::ClientCertificateResponder_CancelRequest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ClientCertificateResponderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ClientCertificateResponder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kClientCertificateResponderValidationInfo);
}

const char SSLPrivateKey::Name_[] = "network.mojom.SSLPrivateKey";

class SSLPrivateKey_Sign_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SSLPrivateKey_Sign_ForwardToCallback(
      SSLPrivateKey::SignCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SSLPrivateKey::SignCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SSLPrivateKey_Sign_ForwardToCallback);
};

SSLPrivateKeyProxy::SSLPrivateKeyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLPrivateKeyProxy::Sign(
    uint16_t in_algorithm, const WTF::Vector<uint8_t>& in_input, SignCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SSLPrivateKey::Sign", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("algorithm"), in_algorithm,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSSLPrivateKey_Sign_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLPrivateKey_Sign_Params_Data> params(
          message);
  params.Allocate();
  params->algorithm = in_algorithm;
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType>
      input_fragment(params.message());
  const mojo::internal::ContainerValidateParams input_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_input, input_fragment, &input_validate_params);
  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in SSLPrivateKey.Sign request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SSLPrivateKey_Sign_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SSLPrivateKey_Sign_ProxyToResponder {
 public:
  static SSLPrivateKey::SignCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SSLPrivateKey_Sign_ProxyToResponder> proxy(
        new SSLPrivateKey_Sign_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SSLPrivateKey_Sign_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SSLPrivateKey_Sign_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SSLPrivateKey_Sign_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SSLPrivateKey::SignCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const WTF::Vector<uint8_t>& in_signature);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SSLPrivateKey_Sign_ProxyToResponder);
};

bool SSLPrivateKey_Sign_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::SSLPrivateKey::SignCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SSLPrivateKey_Sign_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SSLPrivateKey_Sign_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  WTF::Vector<uint8_t> p_signature{};
  SSLPrivateKey_Sign_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadSignature(&p_signature))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SSLPrivateKey::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_signature));
  return true;
}

void SSLPrivateKey_Sign_ProxyToResponder::Run(
    int32_t in_net_error, const WTF::Vector<uint8_t>& in_signature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::SSLPrivateKey::SignCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signature"), in_signature,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSSLPrivateKey_Sign_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLPrivateKey_Sign_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->signature)::BaseType>
      signature_fragment(params.message());
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature, signature_fragment, &signature_validate_params);
  params->signature.Set(
      signature_fragment.is_null() ? nullptr : signature_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signature.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::SSLPrivateKey::SignCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SSLPrivateKeyStubDispatch::Accept(
    SSLPrivateKey* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSSLPrivateKey_Sign_Name: {
      break;
    }
  }
  return false;
}

// static
bool SSLPrivateKeyStubDispatch::AcceptWithResponder(
    SSLPrivateKey* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSSLPrivateKey_Sign_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SSLPrivateKey::Sign",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SSLPrivateKey::Sign");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SSLPrivateKey_Sign_Params_Data* params =
          reinterpret_cast<
              internal::SSLPrivateKey_Sign_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint16_t p_algorithm{};
      WTF::Vector<uint8_t> p_input{};
      SSLPrivateKey_Sign_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_algorithm = input_data_view.algorithm();
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLPrivateKey::Name_, 0, false);
        return false;
      }
      SSLPrivateKey::SignCallback callback =
          SSLPrivateKey_Sign_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Sign(
std::move(p_algorithm), 
std::move(p_input), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLPrivateKeyValidationInfo[] = {
    {internal::kSSLPrivateKey_Sign_Name,
     {&internal::SSLPrivateKey_Sign_Params_Data::Validate,
      &internal::SSLPrivateKey_Sign_ResponseParams_Data::Validate}},
};

bool SSLPrivateKeyRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::SSLPrivateKey::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSSLPrivateKeyValidationInfo);
}

bool SSLPrivateKeyResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::SSLPrivateKey::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSSLPrivateKeyValidationInfo);

}
const char AuthChallengeResponder::Name_[] = "network.mojom.AuthChallengeResponder";

AuthChallengeResponderProxy::AuthChallengeResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthChallengeResponderProxy::OnAuthCredentials(
    ::network::mojom::blink::AuthCredentialsPtr in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::AuthChallengeResponder::OnAuthCredentials", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type ::network::mojom::blink::AuthCredentialsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuthChallengeResponder_OnAuthCredentials_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AuthChallengeResponder_OnAuthCredentials_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, credentials_fragment);
  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuthChallengeResponder::Name_);
  message.set_method_name("OnAuthCredentials");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AuthChallengeResponderStubDispatch::Accept(
    AuthChallengeResponder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAuthChallengeResponder_OnAuthCredentials_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::AuthChallengeResponder::OnAuthCredentials",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::AuthChallengeResponder::OnAuthCredentials");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AuthChallengeResponder_OnAuthCredentials_Params_Data* params =
          reinterpret_cast<internal::AuthChallengeResponder_OnAuthCredentials_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::AuthCredentialsPtr p_credentials{};
      AuthChallengeResponder_OnAuthCredentials_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCredentials(&p_credentials))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuthChallengeResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthCredentials(
std::move(p_credentials));
      return true;
    }
  }
  return false;
}

// static
bool AuthChallengeResponderStubDispatch::AcceptWithResponder(
    AuthChallengeResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuthChallengeResponder_OnAuthCredentials_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuthChallengeResponderValidationInfo[] = {
    {internal::kAuthChallengeResponder_OnAuthCredentials_Name,
     {&internal::AuthChallengeResponder_OnAuthCredentials_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AuthChallengeResponderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::AuthChallengeResponder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuthChallengeResponderValidationInfo);
}

const char URLLoaderNetworkServiceObserver::Name_[] = "network.mojom.URLLoaderNetworkServiceObserver";

class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback);
};

class URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnClearSiteDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnClearSiteDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback);
};

class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback(
      URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback);
};

URLLoaderNetworkServiceObserverProxy::URLLoaderNetworkServiceObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderNetworkServiceObserverProxy::OnSSLCertificateError(
    const ::blink::KURL& in_url, int32_t in_net_error, ::network::mojom::blink::SSLInfoPtr in_ssl_info, bool in_fatal, OnSSLCertificateErrorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_info"), in_ssl_info,
                        "<value of type ::network::mojom::blink::SSLInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fatal"), in_fatal,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in URLLoaderNetworkServiceObserver.OnSSLCertificateError request");
  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_info)::BaseType> ssl_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info, ssl_info_fragment);
  params->ssl_info.Set(
      ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ssl_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ssl_info in URLLoaderNetworkServiceObserver.OnSSLCertificateError request");
  params->fatal = in_fatal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderNetworkServiceObserverProxy::OnCertificateRequested(
    const absl::optional<::base::UnguessableToken>& in_window_id, ::network::mojom::blink::SSLCertRequestInfoPtr in_cert_info, ::mojo::PendingRemote<ClientCertificateResponder> in_cert_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_info"), in_cert_info,
                        "<value of type ::network::mojom::blink::SSLCertRequestInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_responder"), in_cert_responder,
                        "<value of type ::mojo::PendingRemote<ClientCertificateResponder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_id)::BaseType> window_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_window_id, window_id_fragment);
  params->window_id.Set(
      window_id_fragment.is_null() ? nullptr : window_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->cert_info)::BaseType> cert_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SSLCertRequestInfoDataView>(
      in_cert_info, cert_info_fragment);
  params->cert_info.Set(
      cert_info_fragment.is_null() ? nullptr : cert_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cert_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cert_info in URLLoaderNetworkServiceObserver.OnCertificateRequested request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ClientCertificateResponderInterfaceBase>>(
      in_cert_responder, &params->cert_responder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cert_responder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cert_responder in URLLoaderNetworkServiceObserver.OnCertificateRequested request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnCertificateRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderNetworkServiceObserverProxy::OnAuthRequired(
    const absl::optional<::base::UnguessableToken>& in_window_id, uint32_t in_request_id, const ::blink::KURL& in_url, bool in_first_auth_attempt, const ::net::AuthChallengeInfo& in_auth_info, ::network::mojom::blink::HttpResponseHeadersPtr in_head_headers, ::mojo::PendingRemote<AuthChallengeResponder> in_auth_challenge_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("first_auth_attempt"), in_first_auth_attempt,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auth_info"), in_auth_info,
                        "<value of type const ::net::AuthChallengeInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head_headers"), in_head_headers,
                        "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auth_challenge_responder"), in_auth_challenge_responder,
                        "<value of type ::mojo::PendingRemote<AuthChallengeResponder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_id)::BaseType> window_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_window_id, window_id_fragment);
  params->window_id.Set(
      window_id_fragment.is_null() ? nullptr : window_id_fragment.data());
  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in URLLoaderNetworkServiceObserver.OnAuthRequired request");
  params->first_auth_attempt = in_first_auth_attempt;
  mojo::internal::MessageFragment<
      typename decltype(params->auth_info)::BaseType> auth_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_auth_info, auth_info_fragment);
  params->auth_info.Set(
      auth_info_fragment.is_null() ? nullptr : auth_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->auth_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auth_info in URLLoaderNetworkServiceObserver.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->head_headers)::BaseType> head_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_head_headers, head_headers_fragment);
  params->head_headers.Set(
      head_headers_fragment.is_null() ? nullptr : head_headers_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AuthChallengeResponderInterfaceBase>>(
      in_auth_challenge_responder, &params->auth_challenge_responder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->auth_challenge_responder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid auth_challenge_responder in URLLoaderNetworkServiceObserver.OnAuthRequired request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderNetworkServiceObserverProxy::OnClearSiteData(
    const ::blink::KURL& in_url, const WTF::String& in_header_value, int32_t in_load_flags, OnClearSiteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_value"), in_header_value,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_flags"), in_load_flags,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnClearSiteData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in URLLoaderNetworkServiceObserver.OnClearSiteData request");
  mojo::internal::MessageFragment<
      typename decltype(params->header_value)::BaseType> header_value_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_header_value, header_value_fragment);
  params->header_value.Set(
      header_value_fragment.is_null() ? nullptr : header_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->header_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_value in URLLoaderNetworkServiceObserver.OnClearSiteData request");
  params->load_flags = in_load_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnClearSiteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderNetworkServiceObserverProxy::OnLoadingStateUpdate(
    LoadInfoPtr in_info, OnLoadingStateUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type LoadInfoPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::LoadInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in URLLoaderNetworkServiceObserver.OnLoadingStateUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderNetworkServiceObserverProxy::OnDataUseUpdate(
    int32_t in_network_traffic_annotation_id_hash, int64_t in_recv_bytes, int64_t in_sent_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_traffic_annotation_id_hash"), in_network_traffic_annotation_id_hash,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recv_bytes"), in_recv_bytes,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sent_bytes"), in_sent_bytes,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data> params(
          message);
  params.Allocate();
  params->network_traffic_annotation_id_hash = in_network_traffic_annotation_id_hash;
  params->recv_bytes = in_recv_bytes;
  params->sent_bytes = in_sent_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnDataUseUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderNetworkServiceObserverProxy::Clone(
    ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderNetworkServiceObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in URLLoaderNetworkServiceObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder);
};

bool URLLoaderNetworkServiceObserver_OnSSLCertificateError_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_net_error{};
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnClearSiteDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnClearSiteDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder);
};

bool URLLoaderNetworkServiceObserver_OnClearSiteData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteDataCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnClearSiteData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnClearSiteData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder {
 public:
  static URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder> proxy(
        new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder);
};

bool URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderNetworkServiceObserver::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderNetworkServiceObserver::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderNetworkServiceObserverStubDispatch::Accept(
    URLLoaderNetworkServiceObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnCertificateRequested");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::base::UnguessableToken> p_window_id{};
      ::network::mojom::blink::SSLCertRequestInfoPtr p_cert_info{};
      ::mojo::PendingRemote<ClientCertificateResponder> p_cert_responder{};
      URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success && !input_data_view.ReadCertInfo(&p_cert_info))
        success = false;
      if (success) {
        p_cert_responder =
            input_data_view.TakeCertResponder<decltype(p_cert_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCertificateRequested(
std::move(p_window_id), 
std::move(p_cert_info), 
std::move(p_cert_responder));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnAuthRequired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnAuthRequired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::base::UnguessableToken> p_window_id{};
      uint32_t p_request_id{};
      ::blink::KURL p_url{};
      bool p_first_auth_attempt{};
      ::net::AuthChallengeInfo p_auth_info{};
      ::network::mojom::blink::HttpResponseHeadersPtr p_head_headers{};
      ::mojo::PendingRemote<AuthChallengeResponder> p_auth_challenge_responder{};
      URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_first_auth_attempt = input_data_view.first_auth_attempt();
      if (success && !input_data_view.ReadAuthInfo(&p_auth_info))
        success = false;
      if (success && !input_data_view.ReadHeadHeaders(&p_head_headers))
        success = false;
      if (success) {
        p_auth_challenge_responder =
            input_data_view.TakeAuthChallengeResponder<decltype(p_auth_challenge_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(
std::move(p_window_id), 
std::move(p_request_id), 
std::move(p_url), 
std::move(p_first_auth_attempt), 
std::move(p_auth_info), 
std::move(p_head_headers), 
std::move(p_auth_challenge_responder));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnClearSiteData_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnDataUseUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_network_traffic_annotation_id_hash{};
      int64_t p_recv_bytes{};
      int64_t p_sent_bytes{};
      URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_network_traffic_annotation_id_hash = input_data_view.network_traffic_annotation_id_hash();
      if (success)
        p_recv_bytes = input_data_view.recv_bytes();
      if (success)
        p_sent_bytes = input_data_view.sent_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataUseUpdate(
std::move(p_network_traffic_annotation_id_hash), 
std::move(p_recv_bytes), 
std::move(p_sent_bytes));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderNetworkServiceObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::URLLoaderNetworkServiceObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> p_listener{};
      URLLoaderNetworkServiceObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderNetworkServiceObserverStubDispatch::AcceptWithResponder(
    URLLoaderNetworkServiceObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnSSLCertificateError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      int32_t p_net_error{};
      ::network::mojom::blink::SSLInfoPtr p_ssl_info{};
      bool p_fatal{};
      URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (success && !input_data_view.ReadSslInfo(&p_ssl_info))
        success = false;
      if (success)
        p_fatal = input_data_view.fatal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 0, false);
        return false;
      }
      URLLoaderNetworkServiceObserver::OnSSLCertificateErrorCallback callback =
          URLLoaderNetworkServiceObserver_OnSSLCertificateError_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLCertificateError(
std::move(p_url), 
std::move(p_net_error), 
std::move(p_ssl_info), 
std::move(p_fatal), std::move(callback));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnAuthRequired_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnClearSiteData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnClearSiteData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_header_value{};
      int32_t p_load_flags{};
      URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHeaderValue(&p_header_value))
        success = false;
      if (success)
        p_load_flags = input_data_view.load_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 3, false);
        return false;
      }
      URLLoaderNetworkServiceObserver::OnClearSiteDataCallback callback =
          URLLoaderNetworkServiceObserver_OnClearSiteData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClearSiteData(
std::move(p_url), 
std::move(p_header_value), 
std::move(p_load_flags), std::move(callback));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderNetworkServiceObserver::OnLoadingStateUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LoadInfoPtr p_info{};
      URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderNetworkServiceObserver::Name_, 4, false);
        return false;
      }
      URLLoaderNetworkServiceObserver::OnLoadingStateUpdateCallback callback =
          URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoadingStateUpdate(
std::move(p_info), std::move(callback));
      return true;
    }
    case internal::kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name: {
      break;
    }
    case internal::kURLLoaderNetworkServiceObserver_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderNetworkServiceObserverValidationInfo[] = {
    {internal::kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data::Validate}},
    {internal::kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderNetworkServiceObserver_OnAuthRequired_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderNetworkServiceObserver_OnClearSiteData_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data::Validate}},
    {internal::kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data::Validate,
      &internal::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data::Validate}},
    {internal::kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name,
     {&internal::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderNetworkServiceObserver_Clone_Name,
     {&internal::URLLoaderNetworkServiceObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderNetworkServiceObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderNetworkServiceObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderNetworkServiceObserverValidationInfo);
}

bool URLLoaderNetworkServiceObserverResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderNetworkServiceObserver::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kURLLoaderNetworkServiceObserverValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::LoadInfo::DataView, ::network::mojom::blink::LoadInfoPtr>::Read(
    ::network::mojom::blink::LoadInfo::DataView input,
    ::network::mojom::blink::LoadInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::LoadInfoPtr result(::network::mojom::blink::LoadInfo::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->load_state = input.load_state();
      if (success && !input.ReadStateParam(&result->state_param))
        success = false;
      if (success)
        result->upload_position = input.upload_position();
      if (success)
        result->upload_size = input.upload_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif