// services/network/public/mojom/url_loader_network_service_observer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/url_loader_network_service_observer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void ClientCertificateResponderInterceptorForTesting::ContinueWithCertificate(const ::scoped_refptr<::net::X509Certificate>& x509_certificate, const std::string& provider_name, const std::vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) {
  GetForwardingInterface()->ContinueWithCertificate(std::move(x509_certificate), std::move(provider_name), std::move(algorithm_preferences), std::move(ssl_private_key));
}
void ClientCertificateResponderInterceptorForTesting::ContinueWithoutCertificate() {
  GetForwardingInterface()->ContinueWithoutCertificate();
}
void ClientCertificateResponderInterceptorForTesting::CancelRequest() {
  GetForwardingInterface()->CancelRequest();
}
ClientCertificateResponderAsyncWaiter::ClientCertificateResponderAsyncWaiter(
    ClientCertificateResponder* proxy) : proxy_(proxy) {}

ClientCertificateResponderAsyncWaiter::~ClientCertificateResponderAsyncWaiter() = default;




void SSLPrivateKeyInterceptorForTesting::Sign(uint16_t algorithm, const std::vector<uint8_t>& input, SignCallback callback) {
  GetForwardingInterface()->Sign(std::move(algorithm), std::move(input), std::move(callback));
}
SSLPrivateKeyAsyncWaiter::SSLPrivateKeyAsyncWaiter(
    SSLPrivateKey* proxy) : proxy_(proxy) {}

SSLPrivateKeyAsyncWaiter::~SSLPrivateKeyAsyncWaiter() = default;

void SSLPrivateKeyAsyncWaiter::Sign(
    uint16_t algorithm, const std::vector<uint8_t>& input, int32_t* out_net_error, std::vector<uint8_t>* out_signature) {
  base::RunLoop loop;
  proxy_->Sign(std::move(algorithm),std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             std::vector<uint8_t>* out_signature
,
             int32_t net_error,
             const std::vector<uint8_t>& signature) {*out_net_error = std::move(net_error);*out_signature = std::move(signature);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_signature));
  loop.Run();
}



void AuthChallengeResponderInterceptorForTesting::OnAuthCredentials(const absl::optional<::net::AuthCredentials>& credentials) {
  GetForwardingInterface()->OnAuthCredentials(std::move(credentials));
}
AuthChallengeResponderAsyncWaiter::AuthChallengeResponderAsyncWaiter(
    AuthChallengeResponder* proxy) : proxy_(proxy) {}

AuthChallengeResponderAsyncWaiter::~AuthChallengeResponderAsyncWaiter() = default;




void URLLoaderNetworkServiceObserverInterceptorForTesting::OnSSLCertificateError(const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) {
  GetForwardingInterface()->OnSSLCertificateError(std::move(url), std::move(net_error), std::move(ssl_info), std::move(fatal), std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnCertificateRequested(const absl::optional<::base::UnguessableToken>& window_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) {
  GetForwardingInterface()->OnCertificateRequested(std::move(window_id), std::move(cert_info), std::move(cert_responder));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnAuthRequired(const absl::optional<::base::UnguessableToken>& window_id, uint32_t request_id, const ::GURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, const ::scoped_refptr<::net::HttpResponseHeaders>& head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) {
  GetForwardingInterface()->OnAuthRequired(std::move(window_id), std::move(request_id), std::move(url), std::move(first_auth_attempt), std::move(auth_info), std::move(head_headers), std::move(auth_challenge_responder));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnClearSiteData(const ::GURL& url, const std::string& header_value, int32_t load_flags, OnClearSiteDataCallback callback) {
  GetForwardingInterface()->OnClearSiteData(std::move(url), std::move(header_value), std::move(load_flags), std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnLoadingStateUpdate(LoadInfoPtr info, OnLoadingStateUpdateCallback callback) {
  GetForwardingInterface()->OnLoadingStateUpdate(std::move(info), std::move(callback));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) {
  GetForwardingInterface()->OnDataUseUpdate(std::move(network_traffic_annotation_id_hash), std::move(recv_bytes), std::move(sent_bytes));
}
void URLLoaderNetworkServiceObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> listener) {
  GetForwardingInterface()->Clone(std::move(listener));
}
URLLoaderNetworkServiceObserverAsyncWaiter::URLLoaderNetworkServiceObserverAsyncWaiter(
    URLLoaderNetworkServiceObserver* proxy) : proxy_(proxy) {}

URLLoaderNetworkServiceObserverAsyncWaiter::~URLLoaderNetworkServiceObserverAsyncWaiter() = default;

void URLLoaderNetworkServiceObserverAsyncWaiter::OnSSLCertificateError(
    const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->OnSSLCertificateError(std::move(url),std::move(net_error),std::move(ssl_info),std::move(fatal),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}
void URLLoaderNetworkServiceObserverAsyncWaiter::OnClearSiteData(
    const ::GURL& url, const std::string& header_value, int32_t load_flags) {
  base::RunLoop loop;
  proxy_->OnClearSiteData(std::move(url),std::move(header_value),std::move(load_flags),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void URLLoaderNetworkServiceObserverAsyncWaiter::OnLoadingStateUpdate(
    LoadInfoPtr info) {
  base::RunLoop loop;
  proxy_->OnLoadingStateUpdate(std::move(info),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif