// services/network/public/mojom/websocket.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/websocket.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/websocket.mojom-params-data.h"
#include "services/network/public/mojom/websocket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/websocket.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
HttpHeader::HttpHeader()
    : name(),
      value() {}

HttpHeader::HttpHeader(
    const WTF::String& name_in,
    const WTF::String& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

HttpHeader::~HttpHeader() = default;
size_t HttpHeader::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void HttpHeader::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeRequest::WebSocketHandshakeRequest()
    : url(),
      headers(),
      headers_text() {}

WebSocketHandshakeRequest::WebSocketHandshakeRequest(
    const ::blink::KURL& url_in,
    WTF::Vector<HttpHeaderPtr> headers_in,
    const WTF::String& headers_text_in)
    : url(std::move(url_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)) {}

WebSocketHandshakeRequest::~WebSocketHandshakeRequest() = default;

void WebSocketHandshakeRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<HttpHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers_text"), this->headers_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebSocketHandshakeRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebSocketHandshakeResponse::WebSocketHandshakeResponse()
    : url(),
      http_version(),
      status_code(),
      status_text(),
      remote_endpoint(),
      headers(),
      headers_text(),
      selected_protocol(),
      extensions() {}

WebSocketHandshakeResponse::WebSocketHandshakeResponse(
    const ::blink::KURL& url_in,
    ::network::mojom::blink::HttpVersionPtr http_version_in,
    int32_t status_code_in,
    const WTF::String& status_text_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    WTF::Vector<HttpHeaderPtr> headers_in,
    const WTF::String& headers_text_in,
    const WTF::String& selected_protocol_in,
    const WTF::String& extensions_in)
    : url(std::move(url_in)),
      http_version(std::move(http_version_in)),
      status_code(std::move(status_code_in)),
      status_text(std::move(status_text_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      headers(std::move(headers_in)),
      headers_text(std::move(headers_text_in)),
      selected_protocol(std::move(selected_protocol_in)),
      extensions(std::move(extensions_in)) {}

WebSocketHandshakeResponse::~WebSocketHandshakeResponse() = default;

void WebSocketHandshakeResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_version"), this->http_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::HttpVersionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_text"), this->status_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_endpoint"), this->remote_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPEndPoint&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<HttpHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers_text"), this->headers_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_protocol"), this->selected_protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebSocketHandshakeResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WebSocketAuthenticationHandler::Name_[] = "network.mojom.WebSocketAuthenticationHandler";

class WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback(
      WebSocketAuthenticationHandler::OnAuthRequiredCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebSocketAuthenticationHandler::OnAuthRequiredCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback);
};

WebSocketAuthenticationHandlerProxy::WebSocketAuthenticationHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketAuthenticationHandlerProxy::OnAuthRequired(
    const ::net::AuthChallengeInfo& in_info, ::network::mojom::blink::HttpResponseHeadersPtr in_headers, const ::net::IPEndPoint& in_remote_endpoint, OnAuthRequiredCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketAuthenticationHandler::OnAuthRequired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::net::AuthChallengeInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type ::network::mojom::blink::HttpResponseHeadersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_endpoint"), in_remote_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketAuthenticationHandler_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in WebSocketAuthenticationHandler.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers, headers_fragment);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in WebSocketAuthenticationHandler.OnAuthRequired request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_endpoint)::BaseType> remote_endpoint_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint, remote_endpoint_fragment);
  params->remote_endpoint.Set(
      remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_endpoint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_endpoint in WebSocketAuthenticationHandler.OnAuthRequired request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketAuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder {
 public:
  static WebSocketAuthenticationHandler::OnAuthRequiredCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder> proxy(
        new WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebSocketAuthenticationHandler::OnAuthRequiredCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::blink::AuthCredentialsPtr in_credentials);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder);
};

bool WebSocketAuthenticationHandler_OnAuthRequired_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::WebSocketAuthenticationHandler::OnAuthRequiredCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::network::mojom::blink::AuthCredentialsPtr p_credentials{};
  WebSocketAuthenticationHandler_OnAuthRequired_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCredentials(&p_credentials))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebSocketAuthenticationHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_credentials));
  return true;
}

void WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::Run(
    ::network::mojom::blink::AuthCredentialsPtr in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::WebSocketAuthenticationHandler::OnAuthRequiredCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type ::network::mojom::blink::AuthCredentialsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketAuthenticationHandler_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, credentials_fragment);
  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::WebSocketAuthenticationHandler::OnAuthRequiredCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketAuthenticationHandler::Name_);
  message.set_method_name("OnAuthRequired");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebSocketAuthenticationHandlerStubDispatch::Accept(
    WebSocketAuthenticationHandler* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebSocketAuthenticationHandler_OnAuthRequired_Name: {
      break;
    }
  }
  return false;
}

// static
bool WebSocketAuthenticationHandlerStubDispatch::AcceptWithResponder(
    WebSocketAuthenticationHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketAuthenticationHandler_OnAuthRequired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketAuthenticationHandler::OnAuthRequired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketAuthenticationHandler::OnAuthRequired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data* params =
          reinterpret_cast<
              internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::AuthChallengeInfo p_info{};
      ::network::mojom::blink::HttpResponseHeadersPtr p_headers{};
      ::net::IPEndPoint p_remote_endpoint{};
      WebSocketAuthenticationHandler_OnAuthRequired_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRemoteEndpoint(&p_remote_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketAuthenticationHandler::Name_, 0, false);
        return false;
      }
      WebSocketAuthenticationHandler::OnAuthRequiredCallback callback =
          WebSocketAuthenticationHandler_OnAuthRequired_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(
std::move(p_info), 
std::move(p_headers), 
std::move(p_remote_endpoint), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketAuthenticationHandlerValidationInfo[] = {
    {internal::kWebSocketAuthenticationHandler_OnAuthRequired_Name,
     {&internal::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data::Validate,
      &internal::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data::Validate}},
};

bool WebSocketAuthenticationHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketAuthenticationHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketAuthenticationHandlerValidationInfo);
}

bool WebSocketAuthenticationHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketAuthenticationHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWebSocketAuthenticationHandlerValidationInfo);

}
const char WebSocketHandshakeClient::Name_[] = "network.mojom.WebSocketHandshakeClient";

WebSocketHandshakeClientProxy::WebSocketHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketHandshakeClientProxy::OnOpeningHandshakeStarted(
    WebSocketHandshakeRequestPtr in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type WebSocketHandshakeRequestPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in WebSocketHandshakeClient.OnOpeningHandshakeStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnOpeningHandshakeStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketHandshakeClientProxy::OnFailure(
    const WTF::String& in_message, int32_t in_net_error, int32_t in_response_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketHandshakeClient::OnFailure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_code"), in_response_code,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketHandshakeClient_OnFailure_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnFailure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in WebSocketHandshakeClient.OnFailure request");
  params->net_error = in_net_error;
  params->response_code = in_response_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnFailure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<WebSocket> in_socket, ::mojo::PendingReceiver<WebSocketClient> in_client_receiver, WebSocketHandshakeResponsePtr in_response, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingRemote<WebSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_receiver"), in_client_receiver,
                        "<value of type ::mojo::PendingReceiver<WebSocketClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type WebSocketHandshakeResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketInterfaceBase>>(
      in_socket, &params->socket, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebSocketClientInterfaceBase>>(
      in_client_receiver, &params->client_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client_receiver in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::WebSocketHandshakeResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in WebSocketHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writable in WebSocketHandshakeClient.OnConnectionEstablished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketHandshakeClientStubDispatch::Accept(
    WebSocketHandshakeClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketHandshakeClient::OnOpeningHandshakeStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketHandshakeRequestPtr p_request{};
      WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOpeningHandshakeStarted(
std::move(p_request));
      return true;
    }
    case internal::kWebSocketHandshakeClient_OnFailure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketHandshakeClient::OnFailure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketHandshakeClient::OnFailure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnFailure_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnFailure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_message{};
      int32_t p_net_error{};
      int32_t p_response_code{};
      WebSocketHandshakeClient_OnFailure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (success)
        p_response_code = input_data_view.response_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFailure(
std::move(p_message), 
std::move(p_net_error), 
std::move(p_response_code));
      return true;
    }
    case internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketHandshakeClient::OnConnectionEstablished",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketHandshakeClient::OnConnectionEstablished");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<WebSocket> p_socket{};
      ::mojo::PendingReceiver<WebSocketClient> p_client_receiver{};
      WebSocketHandshakeResponsePtr p_response{};
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_client_receiver =
            input_data_view.TakeClientReceiver<decltype(p_client_receiver)>();
      }
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketHandshakeClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(
std::move(p_socket), 
std::move(p_client_receiver), 
std::move(p_response), 
std::move(p_readable), 
std::move(p_writable));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketHandshakeClientStubDispatch::AcceptWithResponder(
    WebSocketHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name: {
      break;
    }
    case internal::kWebSocketHandshakeClient_OnFailure_Name: {
      break;
    }
    case internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketHandshakeClientValidationInfo[] = {
    {internal::kWebSocketHandshakeClient_OnOpeningHandshakeStarted_Name,
     {&internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketHandshakeClient_OnFailure_Name,
     {&internal::WebSocketHandshakeClient_OnFailure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketHandshakeClient_OnConnectionEstablished_Name,
     {&internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketHandshakeClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketHandshakeClientValidationInfo);
}

const char WebSocketClient::Name_[] = "network.mojom.WebSocketClient";

WebSocketClientProxy::WebSocketClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketClientProxy::OnDataFrame(
    bool in_fin, WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketClient::OnDataFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fin"), in_fin,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebSocketMessageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketClient_OnDataFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnDataFrame_Params_Data> params(
          message);
  params.Allocate();
  params->fin = in_fin;
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
      in_type, &params->type);
  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDataFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketClientProxy::OnDropChannel(
    bool in_was_clean, uint16_t in_code, const WTF::String& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocketClient::OnDropChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_clean"), in_was_clean,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketClient_OnDropChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnDropChannel_Params_Data> params(
          message);
  params.Allocate();
  params->was_clean = in_was_clean;
  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reason, reason_fragment);
  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reason.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in WebSocketClient.OnDropChannel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnDropChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketClientProxy::OnClosingHandshake(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebSocketClient::OnClosingHandshake");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocketClient_OnClosingHandshake_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocketClient_OnClosingHandshake_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketClient::Name_);
  message.set_method_name("OnClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketClientStubDispatch::Accept(
    WebSocketClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebSocketClient_OnDataFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnDataFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnDataFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDataFrame_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDataFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_fin{};
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocketClient_OnDataFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_fin = input_data_view.fin();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataFrame(
std::move(p_fin), 
std::move(p_type), 
std::move(p_data_length));
      return true;
    }
    case internal::kWebSocketClient_OnDropChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnDropChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnDropChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnDropChannel_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnDropChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_was_clean{};
      uint16_t p_code{};
      WTF::String p_reason{};
      WebSocketClient_OnDropChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_was_clean = input_data_view.was_clean();
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDropChannel(
std::move(p_was_clean), 
std::move(p_code), 
std::move(p_reason));
      return true;
    }
    case internal::kWebSocketClient_OnClosingHandshake_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocketClient::OnClosingHandshake",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocketClient::OnClosingHandshake");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketClient_OnClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocketClient_OnClosingHandshake_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketClient_OnClosingHandshake_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClosingHandshake();
      return true;
    }
  }
  return false;
}

// static
bool WebSocketClientStubDispatch::AcceptWithResponder(
    WebSocketClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketClient_OnDataFrame_Name: {
      break;
    }
    case internal::kWebSocketClient_OnDropChannel_Name: {
      break;
    }
    case internal::kWebSocketClient_OnClosingHandshake_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketClientValidationInfo[] = {
    {internal::kWebSocketClient_OnDataFrame_Name,
     {&internal::WebSocketClient_OnDataFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketClient_OnDropChannel_Name,
     {&internal::WebSocketClient_OnDropChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocketClient_OnClosingHandshake_Name,
     {&internal::WebSocketClient_OnClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocketClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketClientValidationInfo);
}

const char WebSocket::Name_[] = "network.mojom.WebSocket";

WebSocketProxy::WebSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketProxy::SendMessage(
    WebSocketMessageType in_type, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocket::SendMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebSocketMessageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocket_SendMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_SendMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::WebSocketMessageType>(
      in_type, &params->type);
  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("SendMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketProxy::StartReceiving(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebSocket::StartReceiving");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocket_StartReceiving_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_StartReceiving_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartReceiving");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebSocketProxy::StartClosingHandshake(
    uint16_t in_code, const WTF::String& in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebSocket::StartClosingHandshake", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebSocket_StartClosingHandshake_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebSocket_StartClosingHandshake_Params_Data> params(
          message);
  params.Allocate();
  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->reason)::BaseType> reason_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reason, reason_fragment);
  params->reason.Set(
      reason_fragment.is_null() ? nullptr : reason_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reason.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reason in WebSocket.StartClosingHandshake request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocket::Name_);
  message.set_method_name("StartClosingHandshake");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketStubDispatch::Accept(
    WebSocket* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebSocket_SendMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::SendMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::SendMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_SendMessage_Params_Data* params =
          reinterpret_cast<internal::WebSocket_SendMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocketMessageType p_type{};
      uint64_t p_data_length{};
      WebSocket_SendMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessage(
std::move(p_type), 
std::move(p_data_length));
      return true;
    }
    case internal::kWebSocket_StartReceiving_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::StartReceiving",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::StartReceiving");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_StartReceiving_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartReceiving_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebSocket_StartReceiving_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartReceiving();
      return true;
    }
    case internal::kWebSocket_StartClosingHandshake_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebSocket::StartClosingHandshake",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebSocket::StartClosingHandshake");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocket_StartClosingHandshake_Params_Data* params =
          reinterpret_cast<internal::WebSocket_StartClosingHandshake_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint16_t p_code{};
      WTF::String p_reason{};
      WebSocket_StartClosingHandshake_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocket::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartClosingHandshake(
std::move(p_code), 
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketStubDispatch::AcceptWithResponder(
    WebSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocket_SendMessage_Name: {
      break;
    }
    case internal::kWebSocket_StartReceiving_Name: {
      break;
    }
    case internal::kWebSocket_StartClosingHandshake_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebSocketValidationInfo[] = {
    {internal::kWebSocket_SendMessage_Name,
     {&internal::WebSocket_SendMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocket_StartReceiving_Name,
     {&internal::WebSocket_StartReceiving_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebSocket_StartClosingHandshake_Name,
     {&internal::WebSocket_StartClosingHandshake_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebSocketValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::HttpHeader::DataView, ::network::mojom::blink::HttpHeaderPtr>::Read(
    ::network::mojom::blink::HttpHeader::DataView input,
    ::network::mojom::blink::HttpHeaderPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpHeaderPtr result(::network::mojom::blink::HttpHeader::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebSocketHandshakeRequest::DataView, ::network::mojom::blink::WebSocketHandshakeRequestPtr>::Read(
    ::network::mojom::blink::WebSocketHandshakeRequest::DataView input,
    ::network::mojom::blink::WebSocketHandshakeRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebSocketHandshakeRequestPtr result(::network::mojom::blink::WebSocketHandshakeRequest::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebSocketHandshakeResponse::DataView, ::network::mojom::blink::WebSocketHandshakeResponsePtr>::Read(
    ::network::mojom::blink::WebSocketHandshakeResponse::DataView input,
    ::network::mojom::blink::WebSocketHandshakeResponsePtr* output) {
  bool success = true;
  ::network::mojom::blink::WebSocketHandshakeResponsePtr result(::network::mojom::blink::WebSocketHandshakeResponse::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadHttpVersion(&result->http_version))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadStatusText(&result->status_text))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadHeadersText(&result->headers_text))
        success = false;
      if (success && !input.ReadSelectedProtocol(&result->selected_protocol))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif