// services/network/public/mojom/websocket.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/websocket.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void WebSocketAuthenticationHandlerInterceptorForTesting::OnAuthRequired(const ::net::AuthChallengeInfo& info, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, const ::net::IPEndPoint& remote_endpoint, OnAuthRequiredCallback callback) {
  GetForwardingInterface()->OnAuthRequired(std::move(info), std::move(headers), std::move(remote_endpoint), std::move(callback));
}
WebSocketAuthenticationHandlerAsyncWaiter::WebSocketAuthenticationHandlerAsyncWaiter(
    WebSocketAuthenticationHandler* proxy) : proxy_(proxy) {}

WebSocketAuthenticationHandlerAsyncWaiter::~WebSocketAuthenticationHandlerAsyncWaiter() = default;

void WebSocketAuthenticationHandlerAsyncWaiter::OnAuthRequired(
    const ::net::AuthChallengeInfo& info, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, const ::net::IPEndPoint& remote_endpoint, absl::optional<::net::AuthCredentials>* out_credentials) {
  base::RunLoop loop;
  proxy_->OnAuthRequired(std::move(info),std::move(headers),std::move(remote_endpoint),
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::net::AuthCredentials>* out_credentials
,
             const absl::optional<::net::AuthCredentials>& credentials) {*out_credentials = std::move(credentials);
            loop->Quit();
          },
          &loop,
          out_credentials));
  loop.Run();
}



void WebSocketHandshakeClientInterceptorForTesting::OnOpeningHandshakeStarted(WebSocketHandshakeRequestPtr request) {
  GetForwardingInterface()->OnOpeningHandshakeStarted(std::move(request));
}
void WebSocketHandshakeClientInterceptorForTesting::OnFailure(const std::string& message, int32_t net_error, int32_t response_code) {
  GetForwardingInterface()->OnFailure(std::move(message), std::move(net_error), std::move(response_code));
}
void WebSocketHandshakeClientInterceptorForTesting::OnConnectionEstablished(::mojo::PendingRemote<WebSocket> socket, ::mojo::PendingReceiver<WebSocketClient> client_receiver, WebSocketHandshakeResponsePtr response, ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable) {
  GetForwardingInterface()->OnConnectionEstablished(std::move(socket), std::move(client_receiver), std::move(response), std::move(readable), std::move(writable));
}
WebSocketHandshakeClientAsyncWaiter::WebSocketHandshakeClientAsyncWaiter(
    WebSocketHandshakeClient* proxy) : proxy_(proxy) {}

WebSocketHandshakeClientAsyncWaiter::~WebSocketHandshakeClientAsyncWaiter() = default;




void WebSocketClientInterceptorForTesting::OnDataFrame(bool fin, WebSocketMessageType type, uint64_t data_length) {
  GetForwardingInterface()->OnDataFrame(std::move(fin), std::move(type), std::move(data_length));
}
void WebSocketClientInterceptorForTesting::OnDropChannel(bool was_clean, uint16_t code, const std::string& reason) {
  GetForwardingInterface()->OnDropChannel(std::move(was_clean), std::move(code), std::move(reason));
}
void WebSocketClientInterceptorForTesting::OnClosingHandshake() {
  GetForwardingInterface()->OnClosingHandshake();
}
WebSocketClientAsyncWaiter::WebSocketClientAsyncWaiter(
    WebSocketClient* proxy) : proxy_(proxy) {}

WebSocketClientAsyncWaiter::~WebSocketClientAsyncWaiter() = default;




void WebSocketInterceptorForTesting::SendMessage(WebSocketMessageType type, uint64_t data_length) {
  GetForwardingInterface()->SendMessage(std::move(type), std::move(data_length));
}
void WebSocketInterceptorForTesting::StartReceiving() {
  GetForwardingInterface()->StartReceiving();
}
void WebSocketInterceptorForTesting::StartClosingHandshake(uint16_t code, const std::string& reason) {
  GetForwardingInterface()->StartClosingHandshake(std::move(code), std::move(reason));
}
WebSocketAsyncWaiter::WebSocketAsyncWaiter(
    WebSocket* proxy) : proxy_(proxy) {}

WebSocketAsyncWaiter::~WebSocketAsyncWaiter() = default;






}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif