// services/tracing/public/mojom/perfetto_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/perfetto_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-params-data.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-import-headers.h"


#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_JUMBO_H_
#include "services/tracing/public/mojom/chrome_config_mojom_traits.h"
#include "services/tracing/public/mojom/commit_data_request_mojom_traits.h"
#include "services/tracing/public/mojom/data_source_config_mojom_traits.h"
#include "services/tracing/public/mojom/data_source_descriptor_mojom_traits.h"
#include "services/tracing/public/mojom/trace_config_mojom_traits.h"
#endif
namespace tracing {
namespace mojom {
const char kPerfettoProducerNamePrefix[] = "org.chromium-";
const char kTraceEventDataSourceName[] = "org.chromium.trace_event";
const char kMemoryInstrumentationDataSourceName[] = "org.chromium.memory_instrumentation";
const char kMetaDataSourceName[] = "org.chromium.trace_metadata";
const char kSystemTraceDataSourceName[] = "org.chromium.trace_system";
const char kArcTraceDataSourceName[] = "org.chromium.trace_arc";
const char kSamplerProfilerSourceName[] = "org.chromium.sampler_profiler";
const char kJavaHeapProfilerSourceName[] = "org.chromium.java_heap_profiler";
const char kReachedCodeProfilerSourceName[] = "org.chromium.reached_code_profiler";
const char kNativeHeapProfilerSourceName[] = "org.chromium.native_heap_profiler";
ChunksToMove::ChunksToMove()
    : page(),
      chunk(),
      target_buffer() {}

ChunksToMove::ChunksToMove(
    uint32_t page_in,
    uint32_t chunk_in,
    uint32_t target_buffer_in)
    : page(std::move(page_in)),
      chunk(std::move(chunk_in)),
      target_buffer(std::move(target_buffer_in)) {}

ChunksToMove::~ChunksToMove() = default;

void ChunksToMove::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page"), this->page,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chunk"), this->chunk,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_buffer"), this->target_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChunksToMove::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChunkPatch::ChunkPatch()
    : offset(),
      data() {}

ChunkPatch::ChunkPatch(
    uint32_t offset_in,
    const std::string& data_in)
    : offset(std::move(offset_in)),
      data(std::move(data_in)) {}

ChunkPatch::~ChunkPatch() = default;

void ChunkPatch::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChunkPatch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChunksToPatch::ChunksToPatch()
    : target_buffer(),
      writer_id(),
      chunk_id(),
      patches(),
      has_more_patches() {}

ChunksToPatch::ChunksToPatch(
    uint32_t target_buffer_in,
    uint32_t writer_id_in,
    uint32_t chunk_id_in,
    std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch> patches_in,
    bool has_more_patches_in)
    : target_buffer(std::move(target_buffer_in)),
      writer_id(std::move(writer_id_in)),
      chunk_id(std::move(chunk_id_in)),
      patches(std::move(patches_in)),
      has_more_patches(std::move(has_more_patches_in)) {}

ChunksToPatch::~ChunksToPatch() = default;

void ChunksToPatch::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_buffer"), this->target_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writer_id"), this->writer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chunk_id"), this->chunk_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "patches"), this->patches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::perfetto::CommitDataRequest::ChunkToPatch::Patch>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_more_patches"), this->has_more_patches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChunksToPatch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommitDataRequest::CommitDataRequest()
    : chunks_to_move(),
      chunks_to_patch(),
      flush_request_id() {}

CommitDataRequest::CommitDataRequest(
    std::vector<::perfetto::CommitDataRequest::ChunksToMove> chunks_to_move_in,
    std::vector<ChunksToPatchPtr> chunks_to_patch_in,
    uint64_t flush_request_id_in)
    : chunks_to_move(std::move(chunks_to_move_in)),
      chunks_to_patch(std::move(chunks_to_patch_in)),
      flush_request_id(std::move(flush_request_id_in)) {}

CommitDataRequest::~CommitDataRequest() = default;

void CommitDataRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chunks_to_move"), this->chunks_to_move,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::perfetto::CommitDataRequest::ChunksToMove>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chunks_to_patch"), this->chunks_to_patch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ChunksToPatchPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flush_request_id"), this->flush_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommitDataRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChromeConfig::ChromeConfig()
    : trace_config(),
      privacy_filtering_enabled(),
      convert_to_legacy_json(),
      client_priority() {}

ChromeConfig::ChromeConfig(
    const std::string& trace_config_in,
    bool privacy_filtering_enabled_in,
    bool convert_to_legacy_json_in,
    TracingClientPriority client_priority_in)
    : trace_config(std::move(trace_config_in)),
      privacy_filtering_enabled(std::move(privacy_filtering_enabled_in)),
      convert_to_legacy_json(std::move(convert_to_legacy_json_in)),
      client_priority(std::move(client_priority_in)) {}

ChromeConfig::~ChromeConfig() = default;

void ChromeConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_config"), this->trace_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "privacy_filtering_enabled"), this->privacy_filtering_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "convert_to_legacy_json"), this->convert_to_legacy_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_priority"), this->client_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TracingClientPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChromeConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataSourceConfig::DataSourceConfig()
    : name(),
      target_buffer(),
      trace_duration_ms(),
      tracing_session_id(),
      chrome_config(),
      legacy_config() {}

DataSourceConfig::DataSourceConfig(
    const std::string& name_in,
    uint32_t target_buffer_in,
    uint32_t trace_duration_ms_in,
    uint64_t tracing_session_id_in,
    const ::perfetto::ChromeConfig& chrome_config_in,
    const std::string& legacy_config_in)
    : name(std::move(name_in)),
      target_buffer(std::move(target_buffer_in)),
      trace_duration_ms(std::move(trace_duration_ms_in)),
      tracing_session_id(std::move(tracing_session_id_in)),
      chrome_config(std::move(chrome_config_in)),
      legacy_config(std::move(legacy_config_in)) {}

DataSourceConfig::~DataSourceConfig() = default;

void DataSourceConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_buffer"), this->target_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_duration_ms"), this->trace_duration_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracing_session_id"), this->tracing_session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chrome_config"), this->chrome_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::perfetto::ChromeConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "legacy_config"), this->legacy_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataSourceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataSourceRegistration::DataSourceRegistration()
    : name(),
      will_notify_on_start(),
      will_notify_on_stop(),
      handles_incremental_state_clear() {}

DataSourceRegistration::DataSourceRegistration(
    const std::string& name_in,
    bool will_notify_on_start_in,
    bool will_notify_on_stop_in,
    bool handles_incremental_state_clear_in)
    : name(std::move(name_in)),
      will_notify_on_start(std::move(will_notify_on_start_in)),
      will_notify_on_stop(std::move(will_notify_on_stop_in)),
      handles_incremental_state_clear(std::move(handles_incremental_state_clear_in)) {}

DataSourceRegistration::~DataSourceRegistration() = default;

void DataSourceRegistration::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_notify_on_start"), this->will_notify_on_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_notify_on_stop"), this->will_notify_on_stop,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handles_incremental_state_clear"), this->handles_incremental_state_clear,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataSourceRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BufferConfig::BufferConfig()
    : size_kb(),
      fill_policy() {}

BufferConfig::BufferConfig(
    uint32_t size_kb_in,
    ::perfetto::TraceConfig::BufferConfig::FillPolicy fill_policy_in)
    : size_kb(std::move(size_kb_in)),
      fill_policy(std::move(fill_policy_in)) {}

BufferConfig::~BufferConfig() = default;

void BufferConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_kb"), this->size_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_policy"), this->fill_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::perfetto::TraceConfig::BufferConfig::FillPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BufferConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataSource::DataSource()
    : config(),
      producer_name_filter() {}

DataSource::DataSource(
    const ::perfetto::DataSourceConfig& config_in,
    std::vector<std::string> producer_name_filter_in)
    : config(std::move(config_in)),
      producer_name_filter(std::move(producer_name_filter_in)) {}

DataSource::~DataSource() = default;

void DataSource::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config"), this->config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::perfetto::DataSourceConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "producer_name_filter"), this->producer_name_filter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PerfettoBuiltinDataSource::PerfettoBuiltinDataSource()
    : disable_clock_snapshotting(),
      disable_trace_config(),
      disable_system_info(),
      disable_service_events(),
      primary_trace_clock_id() {}

PerfettoBuiltinDataSource::PerfettoBuiltinDataSource(
    bool disable_clock_snapshotting_in,
    bool disable_trace_config_in,
    bool disable_system_info_in,
    bool disable_service_events_in,
    int32_t primary_trace_clock_id_in)
    : disable_clock_snapshotting(std::move(disable_clock_snapshotting_in)),
      disable_trace_config(std::move(disable_trace_config_in)),
      disable_system_info(std::move(disable_system_info_in)),
      disable_service_events(std::move(disable_service_events_in)),
      primary_trace_clock_id(std::move(primary_trace_clock_id_in)) {}

PerfettoBuiltinDataSource::~PerfettoBuiltinDataSource() = default;

void PerfettoBuiltinDataSource::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_clock_snapshotting"), this->disable_clock_snapshotting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_trace_config"), this->disable_trace_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_system_info"), this->disable_system_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_service_events"), this->disable_service_events,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_trace_clock_id"), this->primary_trace_clock_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PerfettoBuiltinDataSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IncrementalStateConfig::IncrementalStateConfig()
    : clear_period_ms() {}

IncrementalStateConfig::IncrementalStateConfig(
    uint32_t clear_period_ms_in)
    : clear_period_ms(std::move(clear_period_ms_in)) {}

IncrementalStateConfig::~IncrementalStateConfig() = default;

void IncrementalStateConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clear_period_ms"), this->clear_period_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IncrementalStateConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TraceConfig::TraceConfig()
    : data_sources(),
      perfetto_builtin_data_source(),
      buffers(),
      incremental_state_config(),
      duration_ms(),
      write_into_file() {}

TraceConfig::TraceConfig(
    std::vector<DataSourcePtr> data_sources_in,
    const ::perfetto::TraceConfig::BuiltinDataSource& perfetto_builtin_data_source_in,
    std::vector<BufferConfigPtr> buffers_in,
    const ::perfetto::TraceConfig::IncrementalStateConfig& incremental_state_config_in,
    uint32_t duration_ms_in,
    bool write_into_file_in)
    : data_sources(std::move(data_sources_in)),
      perfetto_builtin_data_source(std::move(perfetto_builtin_data_source_in)),
      buffers(std::move(buffers_in)),
      incremental_state_config(std::move(incremental_state_config_in)),
      duration_ms(std::move(duration_ms_in)),
      write_into_file(std::move(write_into_file_in)) {}

TraceConfig::~TraceConfig() = default;

void TraceConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_sources"), this->data_sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<DataSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "perfetto_builtin_data_source"), this->perfetto_builtin_data_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::perfetto::TraceConfig::BuiltinDataSource&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffers"), this->buffers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<BufferConfigPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "incremental_state_config"), this->incremental_state_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::perfetto::TraceConfig::IncrementalStateConfig&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration_ms"), this->duration_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "write_into_file"), this->write_into_file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TraceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ProducerHost::Name_[] = "tracing.mojom.ProducerHost";

class ProducerHost_CommitData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProducerHost_CommitData_ForwardToCallback(
      ProducerHost::CommitDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProducerHost::CommitDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProducerHost_CommitData_ForwardToCallback);
};

ProducerHostProxy::ProducerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProducerHostProxy::CommitData(
    const ::perfetto::CommitDataRequest& in_data_request, CommitDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerHost::CommitData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_request"), in_data_request,
                        "<value of type const ::perfetto::CommitDataRequest&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerHost_CommitData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerHost_CommitData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_request)::BaseType> data_request_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::CommitDataRequestDataView>(
      in_data_request, data_request_fragment);
  params->data_request.Set(
      data_request_fragment.is_null() ? nullptr : data_request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_request in ProducerHost.CommitData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerHost::Name_);
  message.set_method_name("CommitData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProducerHost_CommitData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProducerHostProxy::RegisterDataSource(
    const ::perfetto::DataSourceDescriptor& in_registration_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerHost::RegisterDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_info"), in_registration_info,
                        "<value of type const ::perfetto::DataSourceDescriptor&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerHost_RegisterDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerHost_RegisterDataSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration_info)::BaseType> registration_info_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::DataSourceRegistrationDataView>(
      in_registration_info, registration_info_fragment);
  params->registration_info.Set(
      registration_info_fragment.is_null() ? nullptr : registration_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->registration_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration_info in ProducerHost.RegisterDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerHost::Name_);
  message.set_method_name("RegisterDataSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProducerHostProxy::RegisterTraceWriter(
    uint32_t in_writer_id, uint32_t in_target_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerHost::RegisterTraceWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer_id"), in_writer_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_buffer"), in_target_buffer,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerHost_RegisterTraceWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerHost_RegisterTraceWriter_Params_Data> params(
          message);
  params.Allocate();
  params->writer_id = in_writer_id;
  params->target_buffer = in_target_buffer;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerHost::Name_);
  message.set_method_name("RegisterTraceWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProducerHostProxy::UnregisterTraceWriter(
    uint32_t in_writer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerHost::UnregisterTraceWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer_id"), in_writer_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerHost_UnregisterTraceWriter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerHost_UnregisterTraceWriter_Params_Data> params(
          message);
  params.Allocate();
  params->writer_id = in_writer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerHost::Name_);
  message.set_method_name("UnregisterTraceWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ProducerHost_CommitData_ProxyToResponder {
 public:
  static ProducerHost::CommitDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProducerHost_CommitData_ProxyToResponder> proxy(
        new ProducerHost_CommitData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProducerHost_CommitData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProducerHost_CommitData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProducerHost_CommitData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProducerHost::CommitDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProducerHost_CommitData_ProxyToResponder);
};

bool ProducerHost_CommitData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::ProducerHost::CommitDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProducerHost_CommitData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProducerHost_CommitData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ProducerHost_CommitData_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProducerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ProducerHost_CommitData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::ProducerHost::CommitDataCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerHost_CommitData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerHost_CommitData_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::ProducerHost::CommitDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerHost::Name_);
  message.set_method_name("CommitData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProducerHostStubDispatch::Accept(
    ProducerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProducerHost_CommitData_Name: {
      break;
    }
    case internal::kProducerHost_RegisterDataSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerHost::RegisterDataSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerHost::RegisterDataSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerHost_RegisterDataSource_Params_Data* params =
          reinterpret_cast<internal::ProducerHost_RegisterDataSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::perfetto::DataSourceDescriptor p_registration_info{};
      ProducerHost_RegisterDataSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistrationInfo(&p_registration_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterDataSource(
std::move(p_registration_info));
      return true;
    }
    case internal::kProducerHost_RegisterTraceWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerHost::RegisterTraceWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerHost::RegisterTraceWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerHost_RegisterTraceWriter_Params_Data* params =
          reinterpret_cast<internal::ProducerHost_RegisterTraceWriter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_writer_id{};
      uint32_t p_target_buffer{};
      ProducerHost_RegisterTraceWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writer_id = input_data_view.writer_id();
      if (success)
        p_target_buffer = input_data_view.target_buffer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterTraceWriter(
std::move(p_writer_id), 
std::move(p_target_buffer));
      return true;
    }
    case internal::kProducerHost_UnregisterTraceWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerHost::UnregisterTraceWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerHost::UnregisterTraceWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerHost_UnregisterTraceWriter_Params_Data* params =
          reinterpret_cast<internal::ProducerHost_UnregisterTraceWriter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_writer_id{};
      ProducerHost_UnregisterTraceWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_writer_id = input_data_view.writer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterTraceWriter(
std::move(p_writer_id));
      return true;
    }
  }
  return false;
}

// static
bool ProducerHostStubDispatch::AcceptWithResponder(
    ProducerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProducerHost_CommitData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerHost::CommitData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerHost::CommitData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProducerHost_CommitData_Params_Data* params =
          reinterpret_cast<
              internal::ProducerHost_CommitData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::perfetto::CommitDataRequest p_data_request{};
      ProducerHost_CommitData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDataRequest(&p_data_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerHost::Name_, 0, false);
        return false;
      }
      ProducerHost::CommitDataCallback callback =
          ProducerHost_CommitData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitData(
std::move(p_data_request), std::move(callback));
      return true;
    }
    case internal::kProducerHost_RegisterDataSource_Name: {
      break;
    }
    case internal::kProducerHost_RegisterTraceWriter_Name: {
      break;
    }
    case internal::kProducerHost_UnregisterTraceWriter_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProducerHostValidationInfo[] = {
    {internal::kProducerHost_CommitData_Name,
     {&internal::ProducerHost_CommitData_Params_Data::Validate,
      &internal::ProducerHost_CommitData_ResponseParams_Data::Validate}},
    {internal::kProducerHost_RegisterDataSource_Name,
     {&internal::ProducerHost_RegisterDataSource_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProducerHost_RegisterTraceWriter_Name,
     {&internal::ProducerHost_RegisterTraceWriter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProducerHost_UnregisterTraceWriter_Name,
     {&internal::ProducerHost_UnregisterTraceWriter_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProducerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::ProducerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProducerHostValidationInfo);
}

bool ProducerHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::ProducerHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProducerHostValidationInfo);

}
const char ProducerClient::Name_[] = "tracing.mojom.ProducerClient";

class ProducerClient_StartDataSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProducerClient_StartDataSource_ForwardToCallback(
      ProducerClient::StartDataSourceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProducerClient::StartDataSourceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProducerClient_StartDataSource_ForwardToCallback);
};

class ProducerClient_StopDataSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProducerClient_StopDataSource_ForwardToCallback(
      ProducerClient::StopDataSourceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProducerClient::StopDataSourceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProducerClient_StopDataSource_ForwardToCallback);
};

ProducerClientProxy::ProducerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProducerClientProxy::OnTracingStart(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::ProducerClient::OnTracingStart");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_OnTracingStart_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_OnTracingStart_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("OnTracingStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProducerClientProxy::StartDataSource(
    uint64_t in_id, const ::perfetto::DataSourceConfig& in_data_source_config, StartDataSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerClient::StartDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_source_config"), in_data_source_config,
                        "<value of type const ::perfetto::DataSourceConfig&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_StartDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_StartDataSource_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;
  mojo::internal::MessageFragment<
      typename decltype(params->data_source_config)::BaseType> data_source_config_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::DataSourceConfigDataView>(
      in_data_source_config, data_source_config_fragment);
  params->data_source_config.Set(
      data_source_config_fragment.is_null() ? nullptr : data_source_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_source_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_source_config in ProducerClient.StartDataSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("StartDataSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProducerClient_StartDataSource_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProducerClientProxy::StopDataSource(
    uint64_t in_id, StopDataSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerClient::StopDataSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_StopDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_StopDataSource_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("StopDataSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProducerClient_StopDataSource_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ProducerClientProxy::Flush(
    uint64_t in_flush_request_id, const std::vector<uint64_t>& in_data_source_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ProducerClient::Flush", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flush_request_id"), in_flush_request_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_source_ids"), in_data_source_ids,
                        "<value of type const std::vector<uint64_t>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_Flush_Params_Data> params(
          message);
  params.Allocate();
  params->flush_request_id = in_flush_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->data_source_ids)::BaseType>
      data_source_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_source_ids_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
      in_data_source_ids, data_source_ids_fragment, &data_source_ids_validate_params);
  params->data_source_ids.Set(
      data_source_ids_fragment.is_null() ? nullptr : data_source_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_source_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_source_ids in ProducerClient.Flush request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("Flush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProducerClientProxy::ClearIncrementalState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::ProducerClient::ClearIncrementalState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_ClearIncrementalState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_ClearIncrementalState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("ClearIncrementalState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ProducerClient_StartDataSource_ProxyToResponder {
 public:
  static ProducerClient::StartDataSourceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProducerClient_StartDataSource_ProxyToResponder> proxy(
        new ProducerClient_StartDataSource_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProducerClient_StartDataSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProducerClient_StartDataSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProducerClient_StartDataSource_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProducerClient::StartDataSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProducerClient_StartDataSource_ProxyToResponder);
};

bool ProducerClient_StartDataSource_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::ProducerClient::StartDataSourceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProducerClient_StartDataSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProducerClient_StartDataSource_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ProducerClient_StartDataSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProducerClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ProducerClient_StartDataSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::ProducerClient::StartDataSourceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_StartDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_StartDataSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::ProducerClient::StartDataSourceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("StartDataSource");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProducerClient_StopDataSource_ProxyToResponder {
 public:
  static ProducerClient::StopDataSourceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProducerClient_StopDataSource_ProxyToResponder> proxy(
        new ProducerClient_StopDataSource_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProducerClient_StopDataSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProducerClient_StopDataSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProducerClient_StopDataSource_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProducerClient::StopDataSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProducerClient_StopDataSource_ProxyToResponder);
};

bool ProducerClient_StopDataSource_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::ProducerClient::StopDataSourceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProducerClient_StopDataSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProducerClient_StopDataSource_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ProducerClient_StopDataSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProducerClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ProducerClient_StopDataSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::ProducerClient::StopDataSourceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProducerClient_StopDataSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ProducerClient_StopDataSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::ProducerClient::StopDataSourceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProducerClient::Name_);
  message.set_method_name("StopDataSource");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProducerClientStubDispatch::Accept(
    ProducerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProducerClient_OnTracingStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerClient::OnTracingStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerClient::OnTracingStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerClient_OnTracingStart_Params_Data* params =
          reinterpret_cast<internal::ProducerClient_OnTracingStart_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ProducerClient_OnTracingStart_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTracingStart();
      return true;
    }
    case internal::kProducerClient_StartDataSource_Name: {
      break;
    }
    case internal::kProducerClient_StopDataSource_Name: {
      break;
    }
    case internal::kProducerClient_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerClient::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerClient::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerClient_Flush_Params_Data* params =
          reinterpret_cast<internal::ProducerClient_Flush_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_flush_request_id{};
      std::vector<uint64_t> p_data_source_ids{};
      ProducerClient_Flush_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_flush_request_id = input_data_view.flush_request_id();
      if (success && !input_data_view.ReadDataSourceIds(&p_data_source_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(
std::move(p_flush_request_id), 
std::move(p_data_source_ids));
      return true;
    }
    case internal::kProducerClient_ClearIncrementalState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerClient::ClearIncrementalState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerClient::ClearIncrementalState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProducerClient_ClearIncrementalState_Params_Data* params =
          reinterpret_cast<internal::ProducerClient_ClearIncrementalState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ProducerClient_ClearIncrementalState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearIncrementalState();
      return true;
    }
  }
  return false;
}

// static
bool ProducerClientStubDispatch::AcceptWithResponder(
    ProducerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProducerClient_OnTracingStart_Name: {
      break;
    }
    case internal::kProducerClient_StartDataSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerClient::StartDataSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerClient::StartDataSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProducerClient_StartDataSource_Params_Data* params =
          reinterpret_cast<
              internal::ProducerClient_StartDataSource_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_id{};
      ::perfetto::DataSourceConfig p_data_source_config{};
      ProducerClient_StartDataSource_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success && !input_data_view.ReadDataSourceConfig(&p_data_source_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerClient::Name_, 1, false);
        return false;
      }
      ProducerClient::StartDataSourceCallback callback =
          ProducerClient_StartDataSource_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataSource(
std::move(p_id), 
std::move(p_data_source_config), std::move(callback));
      return true;
    }
    case internal::kProducerClient_StopDataSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ProducerClient::StopDataSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ProducerClient::StopDataSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProducerClient_StopDataSource_Params_Data* params =
          reinterpret_cast<
              internal::ProducerClient_StopDataSource_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_id{};
      ProducerClient_StopDataSource_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProducerClient::Name_, 2, false);
        return false;
      }
      ProducerClient::StopDataSourceCallback callback =
          ProducerClient_StopDataSource_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopDataSource(
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kProducerClient_Flush_Name: {
      break;
    }
    case internal::kProducerClient_ClearIncrementalState_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProducerClientValidationInfo[] = {
    {internal::kProducerClient_OnTracingStart_Name,
     {&internal::ProducerClient_OnTracingStart_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProducerClient_StartDataSource_Name,
     {&internal::ProducerClient_StartDataSource_Params_Data::Validate,
      &internal::ProducerClient_StartDataSource_ResponseParams_Data::Validate}},
    {internal::kProducerClient_StopDataSource_Name,
     {&internal::ProducerClient_StopDataSource_Params_Data::Validate,
      &internal::ProducerClient_StopDataSource_ResponseParams_Data::Validate}},
    {internal::kProducerClient_Flush_Name,
     {&internal::ProducerClient_Flush_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProducerClient_ClearIncrementalState_Name,
     {&internal::ProducerClient_ClearIncrementalState_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProducerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::ProducerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProducerClientValidationInfo);
}

bool ProducerClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::ProducerClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProducerClientValidationInfo);

}
const char PerfettoService::Name_[] = "tracing.mojom.PerfettoService";

PerfettoServiceProxy::PerfettoServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PerfettoServiceProxy::ConnectToProducerHost(
    ::mojo::PendingRemote<ProducerClient> in_producer_client, ::mojo::PendingReceiver<ProducerHost> in_producer_host_receiver, ::mojo::ScopedSharedBufferHandle in_shared_memory, uint64_t in_shared_memory_buffer_page_size_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::PerfettoService::ConnectToProducerHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("producer_client"), in_producer_client,
                        "<value of type ::mojo::PendingRemote<ProducerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("producer_host_receiver"), in_producer_host_receiver,
                        "<value of type ::mojo::PendingReceiver<ProducerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory,
                        "<value of type ::mojo::ScopedSharedBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_buffer_page_size_bytes"), in_shared_memory_buffer_page_size_bytes,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPerfettoService_ConnectToProducerHost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::PerfettoService_ConnectToProducerHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::ProducerClientInterfaceBase>>(
      in_producer_client, &params->producer_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->producer_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid producer_client in PerfettoService.ConnectToProducerHost request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::ProducerHostInterfaceBase>>(
      in_producer_host_receiver, &params->producer_host_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->producer_host_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid producer_host_receiver in PerfettoService.ConnectToProducerHost request");
  mojo::internal::Serialize<mojo::ScopedSharedBufferHandle>(
      in_shared_memory, &params->shared_memory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->shared_memory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid shared_memory in PerfettoService.ConnectToProducerHost request");
  params->shared_memory_buffer_page_size_bytes = in_shared_memory_buffer_page_size_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PerfettoService::Name_);
  message.set_method_name("ConnectToProducerHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PerfettoServiceStubDispatch::Accept(
    PerfettoService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPerfettoService_ConnectToProducerHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::PerfettoService::ConnectToProducerHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::PerfettoService::ConnectToProducerHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PerfettoService_ConnectToProducerHost_Params_Data* params =
          reinterpret_cast<internal::PerfettoService_ConnectToProducerHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<ProducerClient> p_producer_client{};
      ::mojo::PendingReceiver<ProducerHost> p_producer_host_receiver{};
      ::mojo::ScopedSharedBufferHandle p_shared_memory{};
      uint64_t p_shared_memory_buffer_page_size_bytes{};
      PerfettoService_ConnectToProducerHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_producer_client =
            input_data_view.TakeProducerClient<decltype(p_producer_client)>();
      }
      if (success) {
        p_producer_host_receiver =
            input_data_view.TakeProducerHostReceiver<decltype(p_producer_host_receiver)>();
      }
      if (success)
        p_shared_memory = input_data_view.TakeSharedMemory();
      if (success)
        p_shared_memory_buffer_page_size_bytes = input_data_view.shared_memory_buffer_page_size_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PerfettoService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToProducerHost(
std::move(p_producer_client), 
std::move(p_producer_host_receiver), 
std::move(p_shared_memory), 
std::move(p_shared_memory_buffer_page_size_bytes));
      return true;
    }
  }
  return false;
}

// static
bool PerfettoServiceStubDispatch::AcceptWithResponder(
    PerfettoService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPerfettoService_ConnectToProducerHost_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPerfettoServiceValidationInfo[] = {
    {internal::kPerfettoService_ConnectToProducerHost_Name,
     {&internal::PerfettoService_ConnectToProducerHost_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PerfettoServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::PerfettoService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPerfettoServiceValidationInfo);
}

const char ConsumerHost::Name_[] = "tracing.mojom.ConsumerHost";

ConsumerHostProxy::ConsumerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConsumerHostProxy::EnableTracing(
    ::mojo::PendingReceiver<TracingSessionHost> in_tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> in_tracing_session_client, const ::perfetto::TraceConfig& in_config, ::base::File in_output_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::ConsumerHost::EnableTracing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracing_session_host"), in_tracing_session_host,
                        "<value of type ::mojo::PendingReceiver<TracingSessionHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracing_session_client"), in_tracing_session_client,
                        "<value of type ::mojo::PendingRemote<TracingSessionClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::perfetto::TraceConfig&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_file"), in_output_file,
                        "<value of type ::base::File>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConsumerHost_EnableTracing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::ConsumerHost_EnableTracing_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::TracingSessionHostInterfaceBase>>(
      in_tracing_session_host, &params->tracing_session_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->tracing_session_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid tracing_session_host in ConsumerHost.EnableTracing request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::TracingSessionClientInterfaceBase>>(
      in_tracing_session_client, &params->tracing_session_client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->tracing_session_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid tracing_session_client in ConsumerHost.EnableTracing request");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::TraceConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in ConsumerHost.EnableTracing request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_file)::BaseType> output_file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_output_file, output_file_fragment);
  params->output_file.Set(
      output_file_fragment.is_null() ? nullptr : output_file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConsumerHost::Name_);
  message.set_method_name("EnableTracing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ConsumerHostStubDispatch::Accept(
    ConsumerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kConsumerHost_EnableTracing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::ConsumerHost::EnableTracing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::ConsumerHost::EnableTracing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ConsumerHost_EnableTracing_Params_Data* params =
          reinterpret_cast<internal::ConsumerHost_EnableTracing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<TracingSessionHost> p_tracing_session_host{};
      ::mojo::PendingRemote<TracingSessionClient> p_tracing_session_client{};
      ::perfetto::TraceConfig p_config{};
      ::base::File p_output_file{};
      ConsumerHost_EnableTracing_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_tracing_session_host =
            input_data_view.TakeTracingSessionHost<decltype(p_tracing_session_host)>();
      }
      if (success) {
        p_tracing_session_client =
            input_data_view.TakeTracingSessionClient<decltype(p_tracing_session_client)>();
      }
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success && !input_data_view.ReadOutputFile(&p_output_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConsumerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableTracing(
std::move(p_tracing_session_host), 
std::move(p_tracing_session_client), 
std::move(p_config), 
std::move(p_output_file));
      return true;
    }
  }
  return false;
}

// static
bool ConsumerHostStubDispatch::AcceptWithResponder(
    ConsumerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kConsumerHost_EnableTracing_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kConsumerHostValidationInfo[] = {
    {internal::kConsumerHost_EnableTracing_Name,
     {&internal::ConsumerHost_EnableTracing_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ConsumerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::ConsumerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kConsumerHostValidationInfo);
}

const char TracingSessionHost::Name_[] = "tracing.mojom.TracingSessionHost";

class TracingSessionHost_ReadBuffers_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TracingSessionHost_ReadBuffers_ForwardToCallback(
      TracingSessionHost::ReadBuffersCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TracingSessionHost::ReadBuffersCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_ReadBuffers_ForwardToCallback);
};

class TracingSessionHost_RequestBufferUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TracingSessionHost_RequestBufferUsage_ForwardToCallback(
      TracingSessionHost::RequestBufferUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TracingSessionHost::RequestBufferUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_RequestBufferUsage_ForwardToCallback);
};

class TracingSessionHost_DisableTracingAndEmitJson_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TracingSessionHost_DisableTracingAndEmitJson_ForwardToCallback(
      TracingSessionHost::DisableTracingAndEmitJsonCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TracingSessionHost::DisableTracingAndEmitJsonCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_DisableTracingAndEmitJson_ForwardToCallback);
};

TracingSessionHostProxy::TracingSessionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracingSessionHostProxy::ChangeTraceConfig(
    const ::perfetto::TraceConfig& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingSessionHost::ChangeTraceConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::perfetto::TraceConfig&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_ChangeTraceConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_ChangeTraceConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::TraceConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in TracingSessionHost.ChangeTraceConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("ChangeTraceConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TracingSessionHostProxy::DisableTracing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::TracingSessionHost::DisableTracing");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_DisableTracing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_DisableTracing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("DisableTracing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TracingSessionHostProxy::ReadBuffers(
    ::mojo::ScopedDataPipeProducerHandle in_stream, ReadBuffersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingSessionHost::ReadBuffers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_ReadBuffers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_ReadBuffers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in TracingSessionHost.ReadBuffers request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("ReadBuffers");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TracingSessionHost_ReadBuffers_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TracingSessionHostProxy::RequestBufferUsage(
    RequestBufferUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::TracingSessionHost::RequestBufferUsage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_RequestBufferUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_RequestBufferUsage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("RequestBufferUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TracingSessionHost_RequestBufferUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TracingSessionHostProxy::DisableTracingAndEmitJson(
    const std::string& in_agent_label_filter, ::mojo::ScopedDataPipeProducerHandle in_stream, bool in_privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingSessionHost::DisableTracingAndEmitJson", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_label_filter"), in_agent_label_filter,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("privacy_filtering_enabled"), in_privacy_filtering_enabled,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_DisableTracingAndEmitJson_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_DisableTracingAndEmitJson_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->agent_label_filter)::BaseType> agent_label_filter_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_agent_label_filter, agent_label_filter_fragment);
  params->agent_label_filter.Set(
      agent_label_filter_fragment.is_null() ? nullptr : agent_label_filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->agent_label_filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null agent_label_filter in TracingSessionHost.DisableTracingAndEmitJson request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in TracingSessionHost.DisableTracingAndEmitJson request");
  params->privacy_filtering_enabled = in_privacy_filtering_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("DisableTracingAndEmitJson");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TracingSessionHost_DisableTracingAndEmitJson_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TracingSessionHost_ReadBuffers_ProxyToResponder {
 public:
  static TracingSessionHost::ReadBuffersCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TracingSessionHost_ReadBuffers_ProxyToResponder> proxy(
        new TracingSessionHost_ReadBuffers_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TracingSessionHost_ReadBuffers_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TracingSessionHost_ReadBuffers_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TracingSessionHost_ReadBuffers_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TracingSessionHost::ReadBuffersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_ReadBuffers_ProxyToResponder);
};

bool TracingSessionHost_ReadBuffers_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::TracingSessionHost::ReadBuffersCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TracingSessionHost_ReadBuffers_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TracingSessionHost_ReadBuffers_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  TracingSessionHost_ReadBuffers_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TracingSessionHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void TracingSessionHost_ReadBuffers_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::TracingSessionHost::ReadBuffersCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_ReadBuffers_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_ReadBuffers_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::TracingSessionHost::ReadBuffersCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("ReadBuffers");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TracingSessionHost_RequestBufferUsage_ProxyToResponder {
 public:
  static TracingSessionHost::RequestBufferUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TracingSessionHost_RequestBufferUsage_ProxyToResponder> proxy(
        new TracingSessionHost_RequestBufferUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TracingSessionHost_RequestBufferUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TracingSessionHost_RequestBufferUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TracingSessionHost_RequestBufferUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TracingSessionHost::RequestBufferUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, float in_percent_full, bool in_data_loss);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_RequestBufferUsage_ProxyToResponder);
};

bool TracingSessionHost_RequestBufferUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::TracingSessionHost::RequestBufferUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TracingSessionHost_RequestBufferUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TracingSessionHost_RequestBufferUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  float p_percent_full{};
  bool p_data_loss{};
  TracingSessionHost_RequestBufferUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_percent_full = input_data_view.percent_full();
  if (success)
    p_data_loss = input_data_view.data_loss();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TracingSessionHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_percent_full), 
std::move(p_data_loss));
  return true;
}

void TracingSessionHost_RequestBufferUsage_ProxyToResponder::Run(
    bool in_success, float in_percent_full, bool in_data_loss) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)tracing::mojom::TracingSessionHost::RequestBufferUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("percent_full"), in_percent_full,
                        "<value of type float>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_loss"), in_data_loss,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_RequestBufferUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_RequestBufferUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  params->percent_full = in_percent_full;
  params->data_loss = in_data_loss;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::TracingSessionHost::RequestBufferUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("RequestBufferUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder {
 public:
  static TracingSessionHost::DisableTracingAndEmitJsonCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder> proxy(
        new TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TracingSessionHost::DisableTracingAndEmitJsonCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder);
};

bool TracingSessionHost_DisableTracingAndEmitJson_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::TracingSessionHost::DisableTracingAndEmitJsonCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  TracingSessionHost_DisableTracingAndEmitJson_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TracingSessionHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::TracingSessionHost::DisableTracingAndEmitJsonCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionHost_DisableTracingAndEmitJson_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::TracingSessionHost::DisableTracingAndEmitJsonCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionHost::Name_);
  message.set_method_name("DisableTracingAndEmitJson");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TracingSessionHostStubDispatch::Accept(
    TracingSessionHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTracingSessionHost_ChangeTraceConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionHost::ChangeTraceConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionHost::ChangeTraceConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingSessionHost_ChangeTraceConfig_Params_Data* params =
          reinterpret_cast<internal::TracingSessionHost_ChangeTraceConfig_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::perfetto::TraceConfig p_config{};
      TracingSessionHost_ChangeTraceConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeTraceConfig(
std::move(p_config));
      return true;
    }
    case internal::kTracingSessionHost_DisableTracing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionHost::DisableTracing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionHost::DisableTracing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingSessionHost_DisableTracing_Params_Data* params =
          reinterpret_cast<internal::TracingSessionHost_DisableTracing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TracingSessionHost_DisableTracing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableTracing();
      return true;
    }
    case internal::kTracingSessionHost_ReadBuffers_Name: {
      break;
    }
    case internal::kTracingSessionHost_RequestBufferUsage_Name: {
      break;
    }
    case internal::kTracingSessionHost_DisableTracingAndEmitJson_Name: {
      break;
    }
  }
  return false;
}

// static
bool TracingSessionHostStubDispatch::AcceptWithResponder(
    TracingSessionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTracingSessionHost_ChangeTraceConfig_Name: {
      break;
    }
    case internal::kTracingSessionHost_DisableTracing_Name: {
      break;
    }
    case internal::kTracingSessionHost_ReadBuffers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionHost::ReadBuffers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionHost::ReadBuffers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TracingSessionHost_ReadBuffers_Params_Data* params =
          reinterpret_cast<
              internal::TracingSessionHost_ReadBuffers_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_stream{};
      TracingSessionHost_ReadBuffers_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream = input_data_view.TakeStream();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionHost::Name_, 2, false);
        return false;
      }
      TracingSessionHost::ReadBuffersCallback callback =
          TracingSessionHost_ReadBuffers_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadBuffers(
std::move(p_stream), std::move(callback));
      return true;
    }
    case internal::kTracingSessionHost_RequestBufferUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionHost::RequestBufferUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionHost::RequestBufferUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TracingSessionHost_RequestBufferUsage_Params_Data* params =
          reinterpret_cast<
              internal::TracingSessionHost_RequestBufferUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      TracingSessionHost_RequestBufferUsage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionHost::Name_, 3, false);
        return false;
      }
      TracingSessionHost::RequestBufferUsageCallback callback =
          TracingSessionHost_RequestBufferUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestBufferUsage(std::move(callback));
      return true;
    }
    case internal::kTracingSessionHost_DisableTracingAndEmitJson_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionHost::DisableTracingAndEmitJson",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionHost::DisableTracingAndEmitJson");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TracingSessionHost_DisableTracingAndEmitJson_Params_Data* params =
          reinterpret_cast<
              internal::TracingSessionHost_DisableTracingAndEmitJson_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_agent_label_filter{};
      ::mojo::ScopedDataPipeProducerHandle p_stream{};
      bool p_privacy_filtering_enabled{};
      TracingSessionHost_DisableTracingAndEmitJson_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAgentLabelFilter(&p_agent_label_filter))
        success = false;
      if (success)
        p_stream = input_data_view.TakeStream();
      if (success)
        p_privacy_filtering_enabled = input_data_view.privacy_filtering_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionHost::Name_, 4, false);
        return false;
      }
      TracingSessionHost::DisableTracingAndEmitJsonCallback callback =
          TracingSessionHost_DisableTracingAndEmitJson_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableTracingAndEmitJson(
std::move(p_agent_label_filter), 
std::move(p_stream), 
std::move(p_privacy_filtering_enabled), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTracingSessionHostValidationInfo[] = {
    {internal::kTracingSessionHost_ChangeTraceConfig_Name,
     {&internal::TracingSessionHost_ChangeTraceConfig_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTracingSessionHost_DisableTracing_Name,
     {&internal::TracingSessionHost_DisableTracing_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTracingSessionHost_ReadBuffers_Name,
     {&internal::TracingSessionHost_ReadBuffers_Params_Data::Validate,
      &internal::TracingSessionHost_ReadBuffers_ResponseParams_Data::Validate}},
    {internal::kTracingSessionHost_RequestBufferUsage_Name,
     {&internal::TracingSessionHost_RequestBufferUsage_Params_Data::Validate,
      &internal::TracingSessionHost_RequestBufferUsage_ResponseParams_Data::Validate}},
    {internal::kTracingSessionHost_DisableTracingAndEmitJson_Name,
     {&internal::TracingSessionHost_DisableTracingAndEmitJson_Params_Data::Validate,
      &internal::TracingSessionHost_DisableTracingAndEmitJson_ResponseParams_Data::Validate}},
};

bool TracingSessionHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracingSessionHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTracingSessionHostValidationInfo);
}

bool TracingSessionHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracingSessionHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTracingSessionHostValidationInfo);

}
const char TracingSessionClient::Name_[] = "tracing.mojom.TracingSessionClient";

TracingSessionClientProxy::TracingSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracingSessionClientProxy::OnTracingEnabled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::TracingSessionClient::OnTracingEnabled");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionClient_OnTracingEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionClient_OnTracingEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionClient::Name_);
  message.set_method_name("OnTracingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TracingSessionClientProxy::OnTracingDisabled(
    bool in_tracing_succeeded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracingSessionClient::OnTracingDisabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracing_succeeded"), in_tracing_succeeded,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracingSessionClient_OnTracingDisabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracingSessionClient_OnTracingDisabled_Params_Data> params(
          message);
  params.Allocate();
  params->tracing_succeeded = in_tracing_succeeded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracingSessionClient::Name_);
  message.set_method_name("OnTracingDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TracingSessionClientStubDispatch::Accept(
    TracingSessionClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTracingSessionClient_OnTracingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionClient::OnTracingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionClient::OnTracingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingSessionClient_OnTracingEnabled_Params_Data* params =
          reinterpret_cast<internal::TracingSessionClient_OnTracingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TracingSessionClient_OnTracingEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTracingEnabled();
      return true;
    }
    case internal::kTracingSessionClient_OnTracingDisabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracingSessionClient::OnTracingDisabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracingSessionClient::OnTracingDisabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TracingSessionClient_OnTracingDisabled_Params_Data* params =
          reinterpret_cast<internal::TracingSessionClient_OnTracingDisabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_tracing_succeeded{};
      TracingSessionClient_OnTracingDisabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tracing_succeeded = input_data_view.tracing_succeeded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracingSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTracingDisabled(
std::move(p_tracing_succeeded));
      return true;
    }
  }
  return false;
}

// static
bool TracingSessionClientStubDispatch::AcceptWithResponder(
    TracingSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTracingSessionClient_OnTracingEnabled_Name: {
      break;
    }
    case internal::kTracingSessionClient_OnTracingDisabled_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTracingSessionClientValidationInfo[] = {
    {internal::kTracingSessionClient_OnTracingEnabled_Name,
     {&internal::TracingSessionClient_OnTracingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTracingSessionClient_OnTracingDisabled_Name,
     {&internal::TracingSessionClient_OnTracingDisabled_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TracingSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracingSessionClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTracingSessionClientValidationInfo);
}

}  // namespace mojom
}  // namespace tracing

namespace mojo {


// static
bool StructTraits<::tracing::mojom::ChunksToMove::DataView, ::tracing::mojom::ChunksToMovePtr>::Read(
    ::tracing::mojom::ChunksToMove::DataView input,
    ::tracing::mojom::ChunksToMovePtr* output) {
  bool success = true;
  ::tracing::mojom::ChunksToMovePtr result(::tracing::mojom::ChunksToMove::New());
  
      if (success)
        result->page = input.page();
      if (success)
        result->chunk = input.chunk();
      if (success)
        result->target_buffer = input.target_buffer();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::ChunkPatch::DataView, ::tracing::mojom::ChunkPatchPtr>::Read(
    ::tracing::mojom::ChunkPatch::DataView input,
    ::tracing::mojom::ChunkPatchPtr* output) {
  bool success = true;
  ::tracing::mojom::ChunkPatchPtr result(::tracing::mojom::ChunkPatch::New());
  
      if (success)
        result->offset = input.offset();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::ChunksToPatch::DataView, ::tracing::mojom::ChunksToPatchPtr>::Read(
    ::tracing::mojom::ChunksToPatch::DataView input,
    ::tracing::mojom::ChunksToPatchPtr* output) {
  bool success = true;
  ::tracing::mojom::ChunksToPatchPtr result(::tracing::mojom::ChunksToPatch::New());
  
      if (success)
        result->target_buffer = input.target_buffer();
      if (success)
        result->writer_id = input.writer_id();
      if (success)
        result->chunk_id = input.chunk_id();
      if (success && !input.ReadPatches(&result->patches))
        success = false;
      if (success)
        result->has_more_patches = input.has_more_patches();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::CommitDataRequest::DataView, ::tracing::mojom::CommitDataRequestPtr>::Read(
    ::tracing::mojom::CommitDataRequest::DataView input,
    ::tracing::mojom::CommitDataRequestPtr* output) {
  bool success = true;
  ::tracing::mojom::CommitDataRequestPtr result(::tracing::mojom::CommitDataRequest::New());
  
      if (success && !input.ReadChunksToMove(&result->chunks_to_move))
        success = false;
      if (success && !input.ReadChunksToPatch(&result->chunks_to_patch))
        success = false;
      if (success)
        result->flush_request_id = input.flush_request_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::ChromeConfig::DataView, ::tracing::mojom::ChromeConfigPtr>::Read(
    ::tracing::mojom::ChromeConfig::DataView input,
    ::tracing::mojom::ChromeConfigPtr* output) {
  bool success = true;
  ::tracing::mojom::ChromeConfigPtr result(::tracing::mojom::ChromeConfig::New());
  
      if (success && !input.ReadTraceConfig(&result->trace_config))
        success = false;
      if (success)
        result->privacy_filtering_enabled = input.privacy_filtering_enabled();
      if (success)
        result->convert_to_legacy_json = input.convert_to_legacy_json();
      if (success && !input.ReadClientPriority(&result->client_priority))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::DataSourceConfig::DataView, ::tracing::mojom::DataSourceConfigPtr>::Read(
    ::tracing::mojom::DataSourceConfig::DataView input,
    ::tracing::mojom::DataSourceConfigPtr* output) {
  bool success = true;
  ::tracing::mojom::DataSourceConfigPtr result(::tracing::mojom::DataSourceConfig::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->target_buffer = input.target_buffer();
      if (success)
        result->trace_duration_ms = input.trace_duration_ms();
      if (success)
        result->tracing_session_id = input.tracing_session_id();
      if (success && !input.ReadChromeConfig(&result->chrome_config))
        success = false;
      if (success && !input.ReadLegacyConfig(&result->legacy_config))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::DataSourceRegistration::DataView, ::tracing::mojom::DataSourceRegistrationPtr>::Read(
    ::tracing::mojom::DataSourceRegistration::DataView input,
    ::tracing::mojom::DataSourceRegistrationPtr* output) {
  bool success = true;
  ::tracing::mojom::DataSourceRegistrationPtr result(::tracing::mojom::DataSourceRegistration::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->will_notify_on_start = input.will_notify_on_start();
      if (success)
        result->will_notify_on_stop = input.will_notify_on_stop();
      if (success)
        result->handles_incremental_state_clear = input.handles_incremental_state_clear();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::BufferConfig::DataView, ::tracing::mojom::BufferConfigPtr>::Read(
    ::tracing::mojom::BufferConfig::DataView input,
    ::tracing::mojom::BufferConfigPtr* output) {
  bool success = true;
  ::tracing::mojom::BufferConfigPtr result(::tracing::mojom::BufferConfig::New());
  
      if (success)
        result->size_kb = input.size_kb();
      if (success && !input.ReadFillPolicy(&result->fill_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::DataSource::DataView, ::tracing::mojom::DataSourcePtr>::Read(
    ::tracing::mojom::DataSource::DataView input,
    ::tracing::mojom::DataSourcePtr* output) {
  bool success = true;
  ::tracing::mojom::DataSourcePtr result(::tracing::mojom::DataSource::New());
  
      if (success && !input.ReadConfig(&result->config))
        success = false;
      if (success && !input.ReadProducerNameFilter(&result->producer_name_filter))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::PerfettoBuiltinDataSource::DataView, ::tracing::mojom::PerfettoBuiltinDataSourcePtr>::Read(
    ::tracing::mojom::PerfettoBuiltinDataSource::DataView input,
    ::tracing::mojom::PerfettoBuiltinDataSourcePtr* output) {
  bool success = true;
  ::tracing::mojom::PerfettoBuiltinDataSourcePtr result(::tracing::mojom::PerfettoBuiltinDataSource::New());
  
      if (success)
        result->disable_clock_snapshotting = input.disable_clock_snapshotting();
      if (success)
        result->disable_trace_config = input.disable_trace_config();
      if (success)
        result->disable_system_info = input.disable_system_info();
      if (success)
        result->disable_service_events = input.disable_service_events();
      if (success)
        result->primary_trace_clock_id = input.primary_trace_clock_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::IncrementalStateConfig::DataView, ::tracing::mojom::IncrementalStateConfigPtr>::Read(
    ::tracing::mojom::IncrementalStateConfig::DataView input,
    ::tracing::mojom::IncrementalStateConfigPtr* output) {
  bool success = true;
  ::tracing::mojom::IncrementalStateConfigPtr result(::tracing::mojom::IncrementalStateConfig::New());
  
      if (success)
        result->clear_period_ms = input.clear_period_ms();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tracing::mojom::TraceConfig::DataView, ::tracing::mojom::TraceConfigPtr>::Read(
    ::tracing::mojom::TraceConfig::DataView input,
    ::tracing::mojom::TraceConfigPtr* output) {
  bool success = true;
  ::tracing::mojom::TraceConfigPtr result(::tracing::mojom::TraceConfig::New());
  
      if (success && !input.ReadDataSources(&result->data_sources))
        success = false;
      if (success && !input.ReadPerfettoBuiltinDataSource(&result->perfetto_builtin_data_source))
        success = false;
      if (success && !input.ReadBuffers(&result->buffers))
        success = false;
      if (success && !input.ReadIncrementalStateConfig(&result->incremental_state_config))
        success = false;
      if (success)
        result->duration_ms = input.duration_ms();
      if (success)
        result->write_into_file = input.write_into_file();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif