// services/tracing/public/mojom/system_tracing_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/system_tracing_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/system_tracing_service.mojom-params-data.h"
#include "services/tracing/public/mojom/system_tracing_service.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/system_tracing_service.mojom-import-headers.h"


#ifndef SERVICES_TRACING_PUBLIC_MOJOM_SYSTEM_TRACING_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_SYSTEM_TRACING_SERVICE_MOJOM_JUMBO_H_
#endif
namespace tracing {
namespace mojom {
const char SystemTracingService::Name_[] = "tracing.mojom.SystemTracingService";

class SystemTracingService_OpenProducerSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemTracingService_OpenProducerSocket_ForwardToCallback(
      SystemTracingService::OpenProducerSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SystemTracingService::OpenProducerSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SystemTracingService_OpenProducerSocket_ForwardToCallback);
};

SystemTracingServiceProxy::SystemTracingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemTracingServiceProxy::OpenProducerSocket(
    OpenProducerSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::SystemTracingService::OpenProducerSocket");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSystemTracingService_OpenProducerSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::SystemTracingService_OpenProducerSocket_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemTracingService::Name_);
  message.set_method_name("OpenProducerSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemTracingService_OpenProducerSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SystemTracingService_OpenProducerSocket_ProxyToResponder {
 public:
  static SystemTracingService::OpenProducerSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SystemTracingService_OpenProducerSocket_ProxyToResponder> proxy(
        new SystemTracingService_OpenProducerSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SystemTracingService_OpenProducerSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemTracingService_OpenProducerSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SystemTracingService_OpenProducerSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SystemTracingService::OpenProducerSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_traced_socket);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SystemTracingService_OpenProducerSocket_ProxyToResponder);
};

bool SystemTracingService_OpenProducerSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::SystemTracingService::OpenProducerSocketCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File p_traced_socket{};
  SystemTracingService_OpenProducerSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTracedSocket(&p_traced_socket))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemTracingService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_traced_socket));
  return true;
}

void SystemTracingService_OpenProducerSocket_ProxyToResponder::Run(
    ::base::File in_traced_socket) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)tracing::mojom::SystemTracingService::OpenProducerSocketCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traced_socket"), in_traced_socket,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSystemTracingService_OpenProducerSocket_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->traced_socket)::BaseType> traced_socket_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_traced_socket, traced_socket_fragment);
  params->traced_socket.Set(
      traced_socket_fragment.is_null() ? nullptr : traced_socket_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::SystemTracingService::OpenProducerSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemTracingService::Name_);
  message.set_method_name("OpenProducerSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SystemTracingServiceStubDispatch::Accept(
    SystemTracingService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSystemTracingService_OpenProducerSocket_Name: {
      break;
    }
  }
  return false;
}

// static
bool SystemTracingServiceStubDispatch::AcceptWithResponder(
    SystemTracingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSystemTracingService_OpenProducerSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::SystemTracingService::OpenProducerSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::SystemTracingService::OpenProducerSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SystemTracingService_OpenProducerSocket_Params_Data* params =
          reinterpret_cast<
              internal::SystemTracingService_OpenProducerSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SystemTracingService_OpenProducerSocket_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemTracingService::Name_, 0, false);
        return false;
      }
      SystemTracingService::OpenProducerSocketCallback callback =
          SystemTracingService_OpenProducerSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenProducerSocket(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSystemTracingServiceValidationInfo[] = {
    {internal::kSystemTracingService_OpenProducerSocket_Name,
     {&internal::SystemTracingService_OpenProducerSocket_Params_Data::Validate,
      &internal::SystemTracingService_OpenProducerSocket_ResponseParams_Data::Validate}},
};

bool SystemTracingServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::SystemTracingService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSystemTracingServiceValidationInfo);
}

bool SystemTracingServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::SystemTracingService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSystemTracingServiceValidationInfo);

}
}  // namespace mojom
}  // namespace tracing

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif