// services/video_capture/public/mojom/virtual_device.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/virtual_device.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/video_capture_buffer.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/producer.mojom.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void SharedMemoryVirtualDeviceInterceptorForTesting::RequestFrameBuffer(const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, RequestFrameBufferCallback callback) {
  GetForwardingInterface()->RequestFrameBuffer(std::move(dimension), std::move(pixel_format), std::move(strides), std::move(callback));
}
void SharedMemoryVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(std::move(buffer_id), std::move(frame_info));
}
SharedMemoryVirtualDeviceAsyncWaiter::SharedMemoryVirtualDeviceAsyncWaiter(
    SharedMemoryVirtualDevice* proxy) : proxy_(proxy) {}

SharedMemoryVirtualDeviceAsyncWaiter::~SharedMemoryVirtualDeviceAsyncWaiter() = default;

void SharedMemoryVirtualDeviceAsyncWaiter::RequestFrameBuffer(
    const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, int32_t* out_buffer_id) {
  base::RunLoop loop;
  proxy_->RequestFrameBuffer(std::move(dimension),std::move(pixel_format),std::move(strides),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_buffer_id
,
             int32_t buffer_id) {*out_buffer_id = std::move(buffer_id);
            loop->Quit();
          },
          &loop,
          out_buffer_id));
  loop.Run();
}



void TextureVirtualDeviceInterceptorForTesting::OnNewMailboxHolderBufferHandle(int32_t buffer_id, ::media::mojom::MailboxBufferHandleSetPtr mailbox_handles) {
  GetForwardingInterface()->OnNewMailboxHolderBufferHandle(std::move(buffer_id), std::move(mailbox_handles));
}
void TextureVirtualDeviceInterceptorForTesting::OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) {
  GetForwardingInterface()->OnFrameAccessHandlerReady(std::move(frame_access_handler));
}
void TextureVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(std::move(buffer_id), std::move(frame_info));
}
void TextureVirtualDeviceInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(std::move(buffer_id));
}
TextureVirtualDeviceAsyncWaiter::TextureVirtualDeviceAsyncWaiter(
    TextureVirtualDevice* proxy) : proxy_(proxy) {}

TextureVirtualDeviceAsyncWaiter::~TextureVirtualDeviceAsyncWaiter() = default;




void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnNewGpuMemoryBufferHandle(int32_t buffer_id, ::gfx::GpuMemoryBufferHandle gmb_handle) {
  GetForwardingInterface()->OnNewGpuMemoryBufferHandle(std::move(buffer_id), std::move(gmb_handle));
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) {
  GetForwardingInterface()->OnFrameAccessHandlerReady(std::move(frame_access_handler));
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) {
  GetForwardingInterface()->OnFrameReadyInBuffer(std::move(buffer_id), std::move(frame_info));
}
void GpuMemoryBufferVirtualDeviceInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(std::move(buffer_id));
}
GpuMemoryBufferVirtualDeviceAsyncWaiter::GpuMemoryBufferVirtualDeviceAsyncWaiter(
    GpuMemoryBufferVirtualDevice* proxy) : proxy_(proxy) {}

GpuMemoryBufferVirtualDeviceAsyncWaiter::~GpuMemoryBufferVirtualDeviceAsyncWaiter() = default;






}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif