// services/video_capture/public/mojom/virtual_device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/virtual_device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-params-data.h"
#include "services/video_capture/public/mojom/virtual_device.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char SharedMemoryVirtualDevice::Name_[] = "video_capture.mojom.SharedMemoryVirtualDevice";

class SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
      SharedMemoryVirtualDevice::RequestFrameBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SharedMemoryVirtualDevice::RequestFrameBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback);
};

SharedMemoryVirtualDeviceProxy::SharedMemoryVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedMemoryVirtualDeviceProxy::RequestFrameBuffer(
    const ::gfx::Size& in_dimension, ::media::VideoPixelFormat in_pixel_format, ::media::mojom::PlaneStridesPtr in_strides, RequestFrameBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dimension"), in_dimension,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pixel_format"), in_pixel_format,
                        "<value of type ::media::VideoPixelFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strides"), in_strides,
                        "<value of type ::media::mojom::PlaneStridesPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dimension)::BaseType> dimension_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_dimension, dimension_fragment);
  params->dimension.Set(
      dimension_fragment.is_null() ? nullptr : dimension_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dimension.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dimension in SharedMemoryVirtualDevice.RequestFrameBuffer request");
  mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
      in_pixel_format, &params->pixel_format);
  mojo::internal::MessageFragment<
      typename decltype(params->strides)::BaseType> strides_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PlaneStridesDataView>(
      in_strides, strides_fragment);
  params->strides.Set(
      strides_fragment.is_null() ? nullptr : strides_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SharedMemoryVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, frame_info_fragment);
  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in SharedMemoryVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder {
 public:
  static SharedMemoryVirtualDevice::RequestFrameBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder> proxy(
        new SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedMemoryVirtualDevice::RequestFrameBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_buffer_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder);
};

bool SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_buffer_id{};
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_buffer_id = input_data_view.buffer_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedMemoryVirtualDevice::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_id));
  return true;
}

void SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::Accept(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name: {
      break;
    }
    case internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_frame_info));
      return true;
    }
  }
  return false;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::AcceptWithResponder(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* params =
          reinterpret_cast<
              internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_dimension{};
      ::media::VideoPixelFormat p_pixel_format{};
      ::media::mojom::PlaneStridesPtr p_strides{};
      SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDimension(&p_dimension))
        success = false;
      if (success && !input_data_view.ReadPixelFormat(&p_pixel_format))
        success = false;
      if (success && !input_data_view.ReadStrides(&p_strides))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 0, false);
        return false;
      }
      SharedMemoryVirtualDevice::RequestFrameBufferCallback callback =
          SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestFrameBuffer(
std::move(p_dimension), 
std::move(p_pixel_format), 
std::move(p_strides), std::move(callback));
      return true;
    }
    case internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedMemoryVirtualDeviceValidationInfo[] = {
    {internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name,
     {&internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::Validate,
      &internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::Validate}},
    {internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedMemoryVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::SharedMemoryVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedMemoryVirtualDeviceValidationInfo);
}

bool SharedMemoryVirtualDeviceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::SharedMemoryVirtualDevice::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSharedMemoryVirtualDeviceValidationInfo);

}
const char TextureVirtualDevice::Name_[] = "video_capture.mojom.TextureVirtualDevice";

TextureVirtualDeviceProxy::TextureVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextureVirtualDeviceProxy::OnNewMailboxHolderBufferHandle(
    int32_t in_buffer_id, ::media::mojom::MailboxBufferHandleSetPtr in_mailbox_handles) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mailbox_handles"), in_mailbox_handles,
                        "<value of type ::media::mojom::MailboxBufferHandleSetPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->mailbox_handles)::BaseType> mailbox_handles_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::MailboxBufferHandleSetDataView>(
      in_mailbox_handles, mailbox_handles_fragment);
  params->mailbox_handles.Set(
      mailbox_handles_fragment.is_null() ? nullptr : mailbox_handles_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mailbox_handles.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mailbox_handles in TextureVirtualDevice.OnNewMailboxHolderBufferHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnNewMailboxHolderBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextureVirtualDeviceProxy::OnFrameAccessHandlerReady(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> in_frame_access_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_access_handler"), in_frame_access_handler,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnFrameAccessHandlerReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
      in_frame_access_handler, &params->frame_access_handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame_access_handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_access_handler in TextureVirtualDevice.OnFrameAccessHandlerReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnFrameAccessHandlerReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextureVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, frame_info_fragment);
  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in TextureVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextureVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnBufferRetired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::TextureVirtualDevice_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TextureVirtualDeviceStubDispatch::Accept(
    TextureVirtualDevice* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::MailboxBufferHandleSetPtr p_mailbox_handles{};
      TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadMailboxHandles(&p_mailbox_handles))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewMailboxHolderBufferHandle(
std::move(p_buffer_id), 
std::move(p_mailbox_handles));
      return true;
    }
    case internal::kTextureVirtualDevice_OnFrameAccessHandlerReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameAccessHandlerReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> p_frame_access_handler{};
      TextureVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frame_access_handler =
            input_data_view.TakeFrameAccessHandler<decltype(p_frame_access_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameAccessHandlerReady(
std::move(p_frame_access_handler));
      return true;
    }
    case internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_frame_info));
      return true;
    }
    case internal::kTextureVirtualDevice_OnBufferRetired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnBufferRetired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnBufferRetired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      TextureVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(
std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool TextureVirtualDeviceStubDispatch::AcceptWithResponder(
    TextureVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name: {
      break;
    }
    case internal::kTextureVirtualDevice_OnFrameAccessHandlerReady_Name: {
      break;
    }
    case internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
    case internal::kTextureVirtualDevice_OnBufferRetired_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTextureVirtualDeviceValidationInfo[] = {
    {internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name,
     {&internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTextureVirtualDevice_OnFrameAccessHandlerReady_Name,
     {&internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTextureVirtualDevice_OnBufferRetired_Name,
     {&internal::TextureVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TextureVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::TextureVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTextureVirtualDeviceValidationInfo);
}

const char GpuMemoryBufferVirtualDevice::Name_[] = "video_capture.mojom.GpuMemoryBufferVirtualDevice";

GpuMemoryBufferVirtualDeviceProxy::GpuMemoryBufferVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuMemoryBufferVirtualDeviceProxy::OnNewGpuMemoryBufferHandle(
    int32_t in_buffer_id, ::gfx::GpuMemoryBufferHandle in_gmb_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gmb_handle"), in_gmb_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->gmb_handle)::BaseType> gmb_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_gmb_handle, gmb_handle_fragment);
  params->gmb_handle.Set(
      gmb_handle_fragment.is_null() ? nullptr : gmb_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gmb_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gmb_handle in GpuMemoryBufferVirtualDevice.OnNewGpuMemoryBufferHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnNewGpuMemoryBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferVirtualDeviceProxy::OnFrameAccessHandlerReady(
    ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> in_frame_access_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_access_handler"), in_frame_access_handler,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
      in_frame_access_handler, &params->frame_access_handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame_access_handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_access_handler in GpuMemoryBufferVirtualDevice.OnFrameAccessHandlerReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnFrameAccessHandlerReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_info"), in_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->frame_info)::BaseType> frame_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, frame_info_fragment);
  params->frame_info.Set(
      frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in GpuMemoryBufferVirtualDevice.OnFrameReadyInBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::Accept(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::gfx::GpuMemoryBufferHandle p_gmb_handle{};
      GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadGmbHandle(&p_gmb_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewGpuMemoryBufferHandle(
std::move(p_buffer_id), 
std::move(p_gmb_handle));
      return true;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameAccessHandlerReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> p_frame_access_handler{};
      GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frame_access_handler =
            input_data_view.TakeFrameAccessHandler<decltype(p_frame_access_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameAccessHandlerReady(
std::move(p_frame_access_handler));
      return true;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_frame_info));
      return true;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(
std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::AcceptWithResponder(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name: {
      break;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Name: {
      break;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuMemoryBufferVirtualDeviceValidationInfo[] = {
    {internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuMemoryBufferVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::GpuMemoryBufferVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuMemoryBufferVirtualDeviceValidationInfo);
}

}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif