// services/viz/privileged/mojom/gl/context_lost_reason.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/gl/context_lost_reason.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/context_lost_reason.mojom-params-data.h"
namespace viz {
namespace mojom {

static NOINLINE const char* ContextLostReasonToStringHelper(ContextLostReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContextLostReason::GUILTY:
      return "GUILTY";
    case ContextLostReason::INNOCENT:
      return "INNOCENT";
    case ContextLostReason::UNKNOWN:
      return "UNKNOWN";
    case ContextLostReason::OUT_OF_MEMORY:
      return "OUT_OF_MEMORY";
    case ContextLostReason::MAKE_CURRENT_FAILED:
      return "MAKE_CURRENT_FAILED";
    case ContextLostReason::GPU_CHANNEL_LOST:
      return "GPU_CHANNEL_LOST";
    case ContextLostReason::INVALID_GPU_MESSAGE:
      return "INVALID_GPU_MESSAGE";
    default:
      return nullptr;
  }
}

std::string ContextLostReasonToString(ContextLostReason value) {
  const char *str = ContextLostReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContextLostReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContextLostReason value) {
  return os << ContextLostReasonToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ContextLostReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ContextLostReason value) {
  return std::move(context).WriteString(::viz::mojom::ContextLostReasonToString(value));
}

} // namespace perfetto
