// services/viz/privileged/mojom/gl/gpu_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char GpuService::Name_[] = "viz.mojom.GpuService";
bool GpuService::EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool cache_shaders_on_disk, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info) {
  NOTREACHED();
  return false;
}
bool GpuService::CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, int32_t client_id, ::gpu::SurfaceHandle surface_handle, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  NOTREACHED();
  return false;
}
class GpuService_EstablishGpuChannel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuService_EstablishGpuChannel_HandleSyncResponse(
      bool* result, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info)
      : result_(result), out_channel_handle_(out_channel_handle), out_gpu_info_(out_gpu_info), out_gpu_feature_info_(out_gpu_feature_info) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::ScopedMessagePipeHandle* out_channel_handle_;
  ::gpu::GPUInfo* out_gpu_info_;
  ::gpu::GpuFeatureInfo* out_gpu_feature_info_;DISALLOW_COPY_AND_ASSIGN(GpuService_EstablishGpuChannel_HandleSyncResponse);
};

class GpuService_EstablishGpuChannel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_EstablishGpuChannel_ForwardToCallback(
      GpuService::EstablishGpuChannelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::EstablishGpuChannelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_EstablishGpuChannel_ForwardToCallback);
};
class GpuService_CreateGpuMemoryBuffer_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuService_CreateGpuMemoryBuffer_HandleSyncResponse(
      bool* result, ::gfx::GpuMemoryBufferHandle* out_buffer_handle)
      : result_(result), out_buffer_handle_(out_buffer_handle) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::gfx::GpuMemoryBufferHandle* out_buffer_handle_;DISALLOW_COPY_AND_ASSIGN(GpuService_CreateGpuMemoryBuffer_HandleSyncResponse);
};

class GpuService_CreateGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_CreateGpuMemoryBuffer_ForwardToCallback(
      GpuService::CreateGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::CreateGpuMemoryBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_CreateGpuMemoryBuffer_ForwardToCallback);
};

class GpuService_CopyGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_CopyGpuMemoryBuffer_ForwardToCallback(
      GpuService::CopyGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::CopyGpuMemoryBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_CopyGpuMemoryBuffer_ForwardToCallback);
};

class GpuService_GetVideoMemoryUsageStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
      GpuService::GetVideoMemoryUsageStatsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetVideoMemoryUsageStatsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_GetVideoMemoryUsageStats_ForwardToCallback);
};

class GpuService_GetPeakMemoryUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetPeakMemoryUsage_ForwardToCallback(
      GpuService::GetPeakMemoryUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetPeakMemoryUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_GetPeakMemoryUsage_ForwardToCallback);
};

class GpuService_RequestHDRStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_RequestHDRStatus_ForwardToCallback(
      GpuService::RequestHDRStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::RequestHDRStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_RequestHDRStatus_ForwardToCallback);
};

class GpuService_GetDawnInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetDawnInfo_ForwardToCallback(
      GpuService::GetDawnInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetDawnInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_GetDawnInfo_ForwardToCallback);
};

GpuServiceProxy::GpuServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GpuServiceProxy::EstablishGpuChannel(
    int32_t param_client_id, uint64_t param_client_tracing_id, bool param_is_gpu_host, bool param_cache_shaders_on_disk, ::mojo::ScopedMessagePipeHandle* out_param_channel_handle, ::gpu::GPUInfo* out_param_gpu_info, ::gpu::GpuFeatureInfo* out_param_gpu_feature_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::GpuService::EstablishGpuChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), param_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_tracing_id"), param_client_tracing_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_gpu_host"), param_is_gpu_host,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_shaders_on_disk"), param_cache_shaders_on_disk,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = param_client_id;
  params->client_tracing_id = param_client_tracing_id;
  params->is_gpu_host = param_is_gpu_host;
  params->cache_shaders_on_disk = param_cache_shaders_on_disk;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_EstablishGpuChannel_HandleSyncResponse(
          &result, out_param_channel_handle, out_param_gpu_info, out_param_gpu_feature_info));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "viz::mojom::GpuService::EstablishGpuChannel", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), out_param_channel_handle,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), out_param_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), out_param_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
   });
#endif
  return result;
}

void GpuServiceProxy::EstablishGpuChannel(
    int32_t in_client_id, uint64_t in_client_tracing_id, bool in_is_gpu_host, bool in_cache_shaders_on_disk, EstablishGpuChannelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::EstablishGpuChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_tracing_id"), in_client_tracing_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_gpu_host"), in_is_gpu_host,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_shaders_on_disk"), in_cache_shaders_on_disk,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  params->client_tracing_id = in_client_tracing_id;
  params->is_gpu_host = in_is_gpu_host;
  params->cache_shaders_on_disk = in_cache_shaders_on_disk;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_EstablishGpuChannel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::SetChannelClientPid(
    int32_t in_client_id, ::base::ProcessId in_client_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::SetChannelClientPid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_pid"), in_client_pid,
                        "<value of type ::base::ProcessId>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_SetChannelClientPid_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_SetChannelClientPid_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->client_pid)::BaseType> client_pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_client_pid, client_pid_fragment);
  params->client_pid.Set(
      client_pid_fragment.is_null() ? nullptr : client_pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_pid in GpuService.SetChannelClientPid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("SetChannelClientPid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::CloseChannel(
    int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CloseChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CloseChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CloseChannel_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CloseChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::CreateVideoEncodeAcceleratorProvider(
    ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> in_vea_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vea_provider"), in_vea_provider,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
      in_vea_provider, &params->vea_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->vea_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid vea_provider in GpuService.CreateVideoEncodeAcceleratorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateVideoEncodeAcceleratorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool GpuServiceProxy::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId param_id, const ::gfx::Size& param_size, ::gfx::BufferFormat param_format, ::gfx::BufferUsage param_usage, int32_t param_client_id, ::gpu::SurfaceHandle param_surface_handle, ::gfx::GpuMemoryBufferHandle* out_param_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::GpuService::CreateGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), param_id,
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), param_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), param_format,
                        "<value of type ::gfx::BufferFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), param_usage,
                        "<value of type ::gfx::BufferUsage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), param_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_handle"), param_surface_handle,
                        "<value of type ::gpu::SurfaceHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      param_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuService.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      param_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in GpuService.CreateGpuMemoryBuffer request");
  mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      param_format, &params->format);
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      param_usage, &params->usage);
  params->client_id = param_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->surface_handle)::BaseType> surface_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView>(
      param_surface_handle, surface_handle_fragment);
  params->surface_handle.Set(
      surface_handle_fragment.is_null() ? nullptr : surface_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_handle in GpuService.CreateGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_CreateGpuMemoryBuffer_HandleSyncResponse(
          &result, out_param_buffer_handle));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "viz::mojom::GpuService::CreateGpuMemoryBuffer", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), out_param_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif
  return result;
}

void GpuServiceProxy::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, const ::gfx::Size& in_size, ::gfx::BufferFormat in_format, ::gfx::BufferUsage in_usage, int32_t in_client_id, ::gpu::SurfaceHandle in_surface_handle, CreateGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CreateGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type ::gfx::BufferFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type ::gfx::BufferUsage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_handle"), in_surface_handle,
                        "<value of type ::gpu::SurfaceHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuService.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in GpuService.CreateGpuMemoryBuffer request");
  mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      in_format, &params->format);
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      in_usage, &params->usage);
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->surface_handle)::BaseType> surface_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView>(
      in_surface_handle, surface_handle_fragment);
  params->surface_handle.Set(
      surface_handle_fragment.is_null() ? nullptr : surface_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_handle in GpuService.CreateGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_CreateGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::DestroyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, int32_t in_client_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::DestroyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_DestroyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DestroyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuService.DestroyGpuMemoryBuffer request");
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in GpuService.DestroyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DestroyGpuMemoryBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle, ::base::UnsafeSharedMemoryRegion in_shared_memory, CopyGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CopyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CopyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CopyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in GpuService.CopyGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_memory)::BaseType> shared_memory_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_shared_memory, shared_memory_fragment);
  params->shared_memory.Set(
      shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_memory.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_memory in GpuService.CopyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_CopyGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::GetVideoMemoryUsageStats(
    GetVideoMemoryUsageStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::GetVideoMemoryUsageStats");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetVideoMemoryUsageStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::StartPeakMemoryMonitor(
    uint32_t in_sequence_num) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::StartPeakMemoryMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_num"), in_sequence_num,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_StartPeakMemoryMonitor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_StartPeakMemoryMonitor_Params_Data> params(
          message);
  params.Allocate();
  params->sequence_num = in_sequence_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("StartPeakMemoryMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GetPeakMemoryUsage(
    uint32_t in_sequence_num, GetPeakMemoryUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::GetPeakMemoryUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_num"), in_sequence_num,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetPeakMemoryUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_Params_Data> params(
          message);
  params.Allocate();
  params->sequence_num = in_sequence_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetPeakMemoryUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::RequestHDRStatus(
    RequestHDRStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::RequestHDRStatus");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_RequestHDRStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_RequestHDRStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("RequestHDRStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_RequestHDRStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::LoadedShader(
    int32_t in_client_id, const std::string& in_key, const std::string& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::LoadedShader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_LoadedShader_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_LoadedShader_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in GpuService.LoadedShader request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in GpuService.LoadedShader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("LoadedShader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::WakeUpGpu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::WakeUpGpu");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_WakeUpGpu_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_WakeUpGpu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("WakeUpGpu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GpuSwitched(
    ::gl::GpuPreference in_active_gpu_heuristic) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::GpuSwitched", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_gpu_heuristic"), in_active_gpu_heuristic,
                        "<value of type ::gl::GpuPreference>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GpuSwitched_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GpuSwitched_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::gl::mojom::GpuPreference>(
      in_active_gpu_heuristic, &params->active_gpu_heuristic);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GpuSwitched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DisplayAdded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DisplayAdded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_DisplayAdded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayAdded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DisplayRemoved(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DisplayRemoved");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_DisplayRemoved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayRemoved_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DisplayMetricsChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DisplayMetricsChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_DisplayMetricsChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayMetricsChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayMetricsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DestroyAllChannels(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DestroyAllChannels");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_DestroyAllChannels_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DestroyAllChannels_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DestroyAllChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnBackgroundCleanup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnBackgroundCleanup");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_OnBackgroundCleanup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnBackgroundCleanup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgroundCleanup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnBackgrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnBackgrounded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_OnBackgrounded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnBackgrounded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnForegrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnForegrounded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_OnForegrounded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnForegrounded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnForegrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnMemoryPressure(
    ::base::MemoryPressureListener::MemoryPressureLevel in_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::OnMemoryPressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::base::MemoryPressureListener::MemoryPressureLevel>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_OnMemoryPressure_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnMemoryPressure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
      in_level, &params->level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GetDawnInfo(
    GetDawnInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::GetDawnInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetDawnInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetDawnInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetDawnInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetDawnInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::Crash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::Crash");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_Crash_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_Crash_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Crash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::Hang(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::Hang");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_Hang_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_Hang_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Hang");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::ThrowJavaException(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::ThrowJavaException");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_ThrowJavaException_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_ThrowJavaException_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("ThrowJavaException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class GpuService_EstablishGpuChannel_ProxyToResponder {
 public:
  static GpuService::EstablishGpuChannelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_EstablishGpuChannel_ProxyToResponder> proxy(
        new GpuService_EstablishGpuChannel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_EstablishGpuChannel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_EstablishGpuChannel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_EstablishGpuChannel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::EstablishGpuChannelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_EstablishGpuChannel_ProxyToResponder);
};

bool GpuService_EstablishGpuChannel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::EstablishGpuChannelCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_EstablishGpuChannel_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::GPUInfo p_gpu_info{};
  ::gpu::GpuFeatureInfo p_gpu_feature_info{};
  GpuService_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_channel_handle), 
std::move(p_gpu_info), 
std::move(p_gpu_feature_info));
  return true;
}

void GpuService_EstablishGpuChannel_ProxyToResponder::Run(
    ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::EstablishGpuChannelCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), in_channel_handle,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_channel_handle, &params->channel_handle, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info, gpu_feature_info_fragment);
  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_feature_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_feature_info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::EstablishGpuChannelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuService_EstablishGpuChannel_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuService_EstablishGpuChannel_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::GPUInfo p_gpu_info{};
  ::gpu::GpuFeatureInfo p_gpu_feature_info{};
  GpuService_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 0, true);
    return false;
  }
  *out_channel_handle_ = std::move(p_channel_handle);
  *out_gpu_info_ = std::move(p_gpu_info);
  *out_gpu_feature_info_ = std::move(p_gpu_feature_info);
  *result_ = true;
  return true;
}
class GpuService_CreateGpuMemoryBuffer_ProxyToResponder {
 public:
  static GpuService::CreateGpuMemoryBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_CreateGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuService_CreateGpuMemoryBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_CreateGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_CreateGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_CreateGpuMemoryBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::CreateGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuMemoryBufferHandle in_buffer_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_CreateGpuMemoryBuffer_ProxyToResponder);
};

bool GpuService_CreateGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::CreateGpuMemoryBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_handle));
  return true;
}

void GpuService_CreateGpuMemoryBuffer_ProxyToResponder::Run(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::CreateGpuMemoryBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::CreateGpuMemoryBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuService_CreateGpuMemoryBuffer_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 4, true);
    return false;
  }
  *out_buffer_handle_ = std::move(p_buffer_handle);
  *result_ = true;
  return true;
}
class GpuService_CopyGpuMemoryBuffer_ProxyToResponder {
 public:
  static GpuService::CopyGpuMemoryBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_CopyGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuService_CopyGpuMemoryBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_CopyGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_CopyGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_CopyGpuMemoryBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::CopyGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_CopyGpuMemoryBuffer_ProxyToResponder);
};

bool GpuService_CopyGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::CopyGpuMemoryBufferCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_CopyGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_CopyGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  GpuService_CopyGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void GpuService_CopyGpuMemoryBuffer_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::CopyGpuMemoryBufferCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_CopyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CopyGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::CopyGpuMemoryBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetVideoMemoryUsageStats_ProxyToResponder {
 public:
  static GpuService::GetVideoMemoryUsageStatsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_GetVideoMemoryUsageStats_ProxyToResponder> proxy(
        new GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetVideoMemoryUsageStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::GetVideoMemoryUsageStatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::VideoMemoryUsageStats& in_stats);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_GetVideoMemoryUsageStats_ProxyToResponder);
};

bool GpuService_GetVideoMemoryUsageStats_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gpu::VideoMemoryUsageStats p_stats{};
  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStats(&p_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stats));
  return true;
}

void GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run(
    const ::gpu::VideoMemoryUsageStats& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type const ::gpu::VideoMemoryUsageStats&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetVideoMemoryUsageStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::VideoMemoryUsageStatsDataView>(
      in_stats, stats_fragment);
  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stats in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetPeakMemoryUsage_ProxyToResponder {
 public:
  static GpuService::GetPeakMemoryUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_GetPeakMemoryUsage_ProxyToResponder> proxy(
        new GpuService_GetPeakMemoryUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_GetPeakMemoryUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetPeakMemoryUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_GetPeakMemoryUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::GetPeakMemoryUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_GetPeakMemoryUsage_ProxyToResponder);
};

bool GpuService_GetPeakMemoryUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::GetPeakMemoryUsageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_memory_usage{};
  base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t> p_memory_per_allocation_source{};
  GpuService_GetPeakMemoryUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_memory_usage = input_data_view.memory_usage();
  if (success && !input_data_view.ReadMemoryPerAllocationSource(&p_memory_per_allocation_source))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_memory_usage), 
std::move(p_memory_per_allocation_source));
  return true;
}

void GpuService_GetPeakMemoryUsage_ProxyToResponder::Run(
    uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::GetPeakMemoryUsageCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_usage"), in_memory_usage,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_per_allocation_source"), in_memory_per_allocation_source,
                        "<value of type const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetPeakMemoryUsage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->memory_usage = in_memory_usage;
  mojo::internal::MessageFragment<
      typename decltype(params->memory_per_allocation_source)::BaseType>
      memory_per_allocation_source_fragment(params.message());
  const mojo::internal::ContainerValidateParams memory_per_allocation_source_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::gpu::mojom::internal::GpuPeakMemoryAllocationSource_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>>(
      in_memory_per_allocation_source, memory_per_allocation_source_fragment, &memory_per_allocation_source_validate_params);
  params->memory_per_allocation_source.Set(
      memory_per_allocation_source_fragment.is_null() ? nullptr : memory_per_allocation_source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->memory_per_allocation_source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_per_allocation_source in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::GetPeakMemoryUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_RequestHDRStatus_ProxyToResponder {
 public:
  static GpuService::RequestHDRStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_RequestHDRStatus_ProxyToResponder> proxy(
        new GpuService_RequestHDRStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_RequestHDRStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_RequestHDRStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_RequestHDRStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::RequestHDRStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_hdr_enabled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_RequestHDRStatus_ProxyToResponder);
};

bool GpuService_RequestHDRStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::RequestHDRStatusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_RequestHDRStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_RequestHDRStatus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_hdr_enabled{};
  GpuService_RequestHDRStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_hdr_enabled = input_data_view.hdr_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_hdr_enabled));
  return true;
}

void GpuService_RequestHDRStatus_ProxyToResponder::Run(
    bool in_hdr_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::RequestHDRStatusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hdr_enabled"), in_hdr_enabled,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_RequestHDRStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_RequestHDRStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->hdr_enabled = in_hdr_enabled;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::RequestHDRStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("RequestHDRStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetDawnInfo_ProxyToResponder {
 public:
  static GpuService::GetDawnInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_GetDawnInfo_ProxyToResponder> proxy(
        new GpuService_GetDawnInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_GetDawnInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetDawnInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_GetDawnInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::GetDawnInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_dawn_info_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_GetDawnInfo_ProxyToResponder);
};

bool GpuService_GetDawnInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::GetDawnInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GpuService_GetDawnInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetDawnInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_dawn_info_list{};
  GpuService_GetDawnInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDawnInfoList(&p_dawn_info_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_dawn_info_list));
  return true;
}

void GpuService_GetDawnInfo_ProxyToResponder::Run(
    const std::vector<std::string>& in_dawn_info_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::GetDawnInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dawn_info_list"), in_dawn_info_list,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kGpuService_GetDawnInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetDawnInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dawn_info_list)::BaseType>
      dawn_info_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams dawn_info_list_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_dawn_info_list, dawn_info_list_fragment, &dawn_info_list_validate_params);
  params->dawn_info_list.Set(
      dawn_info_list_fragment.is_null() ? nullptr : dawn_info_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dawn_info_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dawn_info_list in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::GetDawnInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetDawnInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuServiceStubDispatch::Accept(
    GpuService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGpuService_EstablishGpuChannel_Name: {
      break;
    }
    case internal::kGpuService_SetChannelClientPid_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::SetChannelClientPid",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::SetChannelClientPid");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_SetChannelClientPid_Params_Data* params =
          reinterpret_cast<internal::GpuService_SetChannelClientPid_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      ::base::ProcessId p_client_pid{};
      GpuService_SetChannelClientPid_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadClientPid(&p_client_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetChannelClientPid(
std::move(p_client_id), 
std::move(p_client_pid));
      return true;
    }
    case internal::kGpuService_CloseChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CloseChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CloseChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_CloseChannel_Params_Data* params =
          reinterpret_cast<internal::GpuService_CloseChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      GpuService_CloseChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseChannel(
std::move(p_client_id));
      return true;
    }
    case internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* params =
          reinterpret_cast<internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> p_vea_provider{};
      GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_vea_provider =
            input_data_view.TakeVeaProvider<decltype(p_vea_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAcceleratorProvider(
std::move(p_vea_provider));
      return true;
    }
    case internal::kGpuService_CreateGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuService_DestroyGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DestroyGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DestroyGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DestroyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuService_DestroyGpuMemoryBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      int32_t p_client_id{};
      ::gpu::SyncToken p_sync_token{};
      GpuService_DestroyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyGpuMemoryBuffer(
std::move(p_id), 
std::move(p_client_id), 
std::move(p_sync_token));
      return true;
    }
    case internal::kGpuService_CopyGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuService_GetVideoMemoryUsageStats_Name: {
      break;
    }
    case internal::kGpuService_StartPeakMemoryMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::StartPeakMemoryMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::StartPeakMemoryMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_StartPeakMemoryMonitor_Params_Data* params =
          reinterpret_cast<internal::GpuService_StartPeakMemoryMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_StartPeakMemoryMonitor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPeakMemoryMonitor(
std::move(p_sequence_num));
      return true;
    }
    case internal::kGpuService_GetPeakMemoryUsage_Name: {
      break;
    }
    case internal::kGpuService_RequestHDRStatus_Name: {
      break;
    }
    case internal::kGpuService_LoadedShader_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::LoadedShader",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::LoadedShader");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_LoadedShader_Params_Data* params =
          reinterpret_cast<internal::GpuService_LoadedShader_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      std::string p_key{};
      std::string p_data{};
      GpuService_LoadedShader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadedShader(
std::move(p_client_id), 
std::move(p_key), 
std::move(p_data));
      return true;
    }
    case internal::kGpuService_WakeUpGpu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::WakeUpGpu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::WakeUpGpu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_WakeUpGpu_Params_Data* params =
          reinterpret_cast<internal::GpuService_WakeUpGpu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_WakeUpGpu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WakeUpGpu();
      return true;
    }
    case internal::kGpuService_GpuSwitched_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GpuSwitched",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GpuSwitched");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_GpuSwitched_Params_Data* params =
          reinterpret_cast<internal::GpuService_GpuSwitched_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gl::GpuPreference p_active_gpu_heuristic{};
      GpuService_GpuSwitched_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActiveGpuHeuristic(&p_active_gpu_heuristic))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GpuSwitched(
std::move(p_active_gpu_heuristic));
      return true;
    }
    case internal::kGpuService_DisplayAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DisplayAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DisplayAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DisplayAdded_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DisplayAdded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayAdded();
      return true;
    }
    case internal::kGpuService_DisplayRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DisplayRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DisplayRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DisplayRemoved_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DisplayRemoved_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayRemoved();
      return true;
    }
    case internal::kGpuService_DisplayMetricsChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DisplayMetricsChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DisplayMetricsChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DisplayMetricsChanged_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayMetricsChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DisplayMetricsChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayMetricsChanged();
      return true;
    }
    case internal::kGpuService_DestroyAllChannels_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DestroyAllChannels",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DestroyAllChannels");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DestroyAllChannels_Params_Data* params =
          reinterpret_cast<internal::GpuService_DestroyAllChannels_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DestroyAllChannels_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyAllChannels();
      return true;
    }
    case internal::kGpuService_OnBackgroundCleanup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnBackgroundCleanup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnBackgroundCleanup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgroundCleanup_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgroundCleanup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnBackgroundCleanup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgroundCleanup();
      return true;
    }
    case internal::kGpuService_OnBackgrounded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnBackgrounded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnBackgrounded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgrounded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnBackgrounded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgrounded();
      return true;
    }
    case internal::kGpuService_OnForegrounded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnForegrounded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnForegrounded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnForegrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnForegrounded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnForegrounded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnForegrounded();
      return true;
    }
    case internal::kGpuService_OnMemoryPressure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnMemoryPressure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnMemoryPressure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::MemoryPressureListener::MemoryPressureLevel p_level{};
      GpuService_OnMemoryPressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(
std::move(p_level));
      return true;
    }
    case internal::kGpuService_GetDawnInfo_Name: {
      break;
    }
    case internal::kGpuService_Crash_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::Crash",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::Crash");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_Crash_Params_Data* params =
          reinterpret_cast<internal::GpuService_Crash_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_Crash_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Crash();
      return true;
    }
    case internal::kGpuService_Hang_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::Hang",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::Hang");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_Hang_Params_Data* params =
          reinterpret_cast<internal::GpuService_Hang_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_Hang_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hang();
      return true;
    }
    case internal::kGpuService_ThrowJavaException_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::ThrowJavaException",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::ThrowJavaException");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_ThrowJavaException_Params_Data* params =
          reinterpret_cast<internal::GpuService_ThrowJavaException_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_ThrowJavaException_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThrowJavaException();
      return true;
    }
  }
  return false;
}

// static
bool GpuServiceStubDispatch::AcceptWithResponder(
    GpuService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuService_EstablishGpuChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::EstablishGpuChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::EstablishGpuChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_EstablishGpuChannel_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_EstablishGpuChannel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      uint64_t p_client_tracing_id{};
      bool p_is_gpu_host{};
      bool p_cache_shaders_on_disk{};
      GpuService_EstablishGpuChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success)
        p_client_tracing_id = input_data_view.client_tracing_id();
      if (success)
        p_is_gpu_host = input_data_view.is_gpu_host();
      if (success)
        p_cache_shaders_on_disk = input_data_view.cache_shaders_on_disk();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 0, false);
        return false;
      }
      GpuService::EstablishGpuChannelCallback callback =
          GpuService_EstablishGpuChannel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishGpuChannel(
std::move(p_client_id), 
std::move(p_client_tracing_id), 
std::move(p_is_gpu_host), 
std::move(p_cache_shaders_on_disk), std::move(callback));
      return true;
    }
    case internal::kGpuService_SetChannelClientPid_Name: {
      break;
    }
    case internal::kGpuService_CloseChannel_Name: {
      break;
    }
    case internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name: {
      break;
    }
    case internal::kGpuService_CreateGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CreateGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CreateGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_CreateGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_CreateGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ::gfx::Size p_size{};
      ::gfx::BufferFormat p_format{};
      ::gfx::BufferUsage p_usage{};
      int32_t p_client_id{};
      ::gpu::SurfaceHandle p_surface_handle{};
      GpuService_CreateGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadUsage(&p_usage))
        success = false;
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadSurfaceHandle(&p_surface_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 4, false);
        return false;
      }
      GpuService::CreateGpuMemoryBufferCallback callback =
          GpuService_CreateGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBuffer(
std::move(p_id), 
std::move(p_size), 
std::move(p_format), 
std::move(p_usage), 
std::move(p_client_id), 
std::move(p_surface_handle), std::move(callback));
      return true;
    }
    case internal::kGpuService_DestroyGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuService_CopyGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CopyGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CopyGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_CopyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_CopyGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
      ::base::UnsafeSharedMemoryRegion p_shared_memory{};
      GpuService_CopyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (success && !input_data_view.ReadSharedMemory(&p_shared_memory))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 6, false);
        return false;
      }
      GpuService::CopyGpuMemoryBufferCallback callback =
          GpuService_CopyGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyGpuMemoryBuffer(
std::move(p_buffer_handle), 
std::move(p_shared_memory), std::move(callback));
      return true;
    }
    case internal::kGpuService_GetVideoMemoryUsageStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_GetVideoMemoryUsageStats_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetVideoMemoryUsageStats_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_GetVideoMemoryUsageStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 7, false);
        return false;
      }
      GpuService::GetVideoMemoryUsageStatsCallback callback =
          GpuService_GetVideoMemoryUsageStats_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoMemoryUsageStats(std::move(callback));
      return true;
    }
    case internal::kGpuService_StartPeakMemoryMonitor_Name: {
      break;
    }
    case internal::kGpuService_GetPeakMemoryUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GetPeakMemoryUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GetPeakMemoryUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_GetPeakMemoryUsage_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetPeakMemoryUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_GetPeakMemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 9, false);
        return false;
      }
      GpuService::GetPeakMemoryUsageCallback callback =
          GpuService_GetPeakMemoryUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPeakMemoryUsage(
std::move(p_sequence_num), std::move(callback));
      return true;
    }
    case internal::kGpuService_RequestHDRStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::RequestHDRStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::RequestHDRStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_RequestHDRStatus_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_RequestHDRStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_RequestHDRStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 10, false);
        return false;
      }
      GpuService::RequestHDRStatusCallback callback =
          GpuService_RequestHDRStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestHDRStatus(std::move(callback));
      return true;
    }
    case internal::kGpuService_LoadedShader_Name: {
      break;
    }
    case internal::kGpuService_WakeUpGpu_Name: {
      break;
    }
    case internal::kGpuService_GpuSwitched_Name: {
      break;
    }
    case internal::kGpuService_DisplayAdded_Name: {
      break;
    }
    case internal::kGpuService_DisplayRemoved_Name: {
      break;
    }
    case internal::kGpuService_DisplayMetricsChanged_Name: {
      break;
    }
    case internal::kGpuService_DestroyAllChannels_Name: {
      break;
    }
    case internal::kGpuService_OnBackgroundCleanup_Name: {
      break;
    }
    case internal::kGpuService_OnBackgrounded_Name: {
      break;
    }
    case internal::kGpuService_OnForegrounded_Name: {
      break;
    }
    case internal::kGpuService_OnMemoryPressure_Name: {
      break;
    }
    case internal::kGpuService_GetDawnInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GetDawnInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GetDawnInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_GetDawnInfo_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetDawnInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_GetDawnInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 22, false);
        return false;
      }
      GpuService::GetDawnInfoCallback callback =
          GpuService_GetDawnInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDawnInfo(std::move(callback));
      return true;
    }
    case internal::kGpuService_Crash_Name: {
      break;
    }
    case internal::kGpuService_Hang_Name: {
      break;
    }
    case internal::kGpuService_ThrowJavaException_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuServiceValidationInfo[] = {
    {internal::kGpuService_EstablishGpuChannel_Name,
     {&internal::GpuService_EstablishGpuChannel_Params_Data::Validate,
      &internal::GpuService_EstablishGpuChannel_ResponseParams_Data::Validate}},
    {internal::kGpuService_SetChannelClientPid_Name,
     {&internal::GpuService_SetChannelClientPid_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CloseChannel_Name,
     {&internal::GpuService_CloseChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name,
     {&internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CreateGpuMemoryBuffer_Name,
     {&internal::GpuService_CreateGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuService_DestroyGpuMemoryBuffer_Name,
     {&internal::GpuService_DestroyGpuMemoryBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CopyGpuMemoryBuffer_Name,
     {&internal::GpuService_CopyGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuService_CopyGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuService_GetVideoMemoryUsageStats_Name,
     {&internal::GpuService_GetVideoMemoryUsageStats_Params_Data::Validate,
      &internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::Validate}},
    {internal::kGpuService_StartPeakMemoryMonitor_Name,
     {&internal::GpuService_StartPeakMemoryMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GetPeakMemoryUsage_Name,
     {&internal::GpuService_GetPeakMemoryUsage_Params_Data::Validate,
      &internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data::Validate}},
    {internal::kGpuService_RequestHDRStatus_Name,
     {&internal::GpuService_RequestHDRStatus_Params_Data::Validate,
      &internal::GpuService_RequestHDRStatus_ResponseParams_Data::Validate}},
    {internal::kGpuService_LoadedShader_Name,
     {&internal::GpuService_LoadedShader_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_WakeUpGpu_Name,
     {&internal::GpuService_WakeUpGpu_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GpuSwitched_Name,
     {&internal::GpuService_GpuSwitched_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DisplayAdded_Name,
     {&internal::GpuService_DisplayAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DisplayRemoved_Name,
     {&internal::GpuService_DisplayRemoved_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DisplayMetricsChanged_Name,
     {&internal::GpuService_DisplayMetricsChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DestroyAllChannels_Name,
     {&internal::GpuService_DestroyAllChannels_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnBackgroundCleanup_Name,
     {&internal::GpuService_OnBackgroundCleanup_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnBackgrounded_Name,
     {&internal::GpuService_OnBackgrounded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnForegrounded_Name,
     {&internal::GpuService_OnForegrounded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnMemoryPressure_Name,
     {&internal::GpuService_OnMemoryPressure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GetDawnInfo_Name,
     {&internal::GpuService_GetDawnInfo_Params_Data::Validate,
      &internal::GpuService_GetDawnInfo_ResponseParams_Data::Validate}},
    {internal::kGpuService_Crash_Name,
     {&internal::GpuService_Crash_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_Hang_Name,
     {&internal::GpuService_Hang_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_ThrowJavaException_Name,
     {&internal::GpuService_ThrowJavaException_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuServiceValidationInfo);
}

bool GpuServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuServiceValidationInfo);

}
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif