// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#include "gpu/ipc/common/mailbox_holder_mojom_traits.h"
#include "gpu/ipc/common/mailbox_mojom_traits.h"
#include "gpu/ipc/common/sync_token_mojom_traits.h"
#include "ipc/ipc_message_utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_id_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operation_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operations_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"
#include "services/viz/public/cpp/compositing/selection_mojom_traits.h"
#include "services/viz/public/cpp/compositing/shared_quad_state_mojom_traits.h"
#include "services/viz/public/cpp/compositing/transferable_resource_mojom_traits.h"
#include "ui/gfx/mojom/selection_bound_mojom_traits.h"
#include "ui/gfx/mojom/transform_mojom_traits.h"
#include "ui/latency/mojom/latency_info_mojom_traits.h"
#endif
namespace viz {
namespace mojom {
namespace blink {
const char CompositorFrameSink::Name_[] = "viz.mojom.CompositorFrameSink";
bool CompositorFrameSink::SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, absl::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, WTF::Vector<::viz::ReturnedResource>* out_resources) {
  NOTREACHED();
  return false;
}
class CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
      bool* result, WTF::Vector<::viz::ReturnedResource>* out_resources)
      : result_(result), out_resources_(out_resources) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  WTF::Vector<::viz::ReturnedResource>* out_resources_;DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse);
};

class CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CompositorFrameSink::SubmitCompositorFrameSyncCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback);
};

CompositorFrameSinkProxy::CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkProxy::SetNeedsBeginFrame(
    bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frame"), in_needs_begin_frame,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SetNeedsBeginFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  params->needs_begin_frame = in_needs_begin_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::SetWantsAnimateOnlyBeginFrames(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetWantsAnimateOnlyBeginFrames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::SubmitCompositorFrame(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, absl::optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), in_hit_test_region_list,
                        "<value of type absl::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), in_submit_time,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrame_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = in_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& param_local_surface_id, ::viz::CompositorFrame param_frame, absl::optional<::viz::HitTestRegionList> param_hit_test_region_list, uint64_t param_submit_time, WTF::Vector<::viz::ReturnedResource>* out_param_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), param_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), param_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), param_hit_test_region_list,
                        "<value of type absl::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), param_submit_time,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      param_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      param_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      param_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = param_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
          &result, out_param_resources));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), out_param_resources,
                        "<value of type WTF::Vector<::viz::ReturnedResource>>");
   });
#endif
  return result;
}

void CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, absl::optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time, SubmitCompositorFrameSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type ::viz::CompositorFrame>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_region_list"), in_hit_test_region_list,
                        "<value of type absl::optional<::viz::HitTestRegionList>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submit_time"), in_submit_time,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, local_surface_id_fragment);
  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, frame_fragment);
  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, hit_test_region_list_fragment);
  params->hit_test_region_list.Set(
      hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());
  params->submit_time = in_submit_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CompositorFrameSinkProxy::DidNotProduceFrame(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidNotProduceFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack"), in_ack,
                        "<value of type const ::viz::BeginFrameAck&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidNotProduceFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_DidNotProduceFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ack)::BaseType> ack_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
      in_ack, ack_fragment);
  params->ack.Set(
      ack_fragment.is_null() ? nullptr : ack_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ack.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ack in CompositorFrameSink.DidNotProduceFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidNotProduceFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::DidAllocateSharedBitmap(
    ::base::ReadOnlySharedMemoryRegion in_region, const ::gpu::Mailbox& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::gpu::Mailbox&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in CompositorFrameSink.DidAllocateSharedBitmap request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CompositorFrameSink.DidAllocateSharedBitmap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidAllocateSharedBitmap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::DidDeleteSharedBitmap(
    const ::gpu::Mailbox& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::gpu::Mailbox&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CompositorFrameSink.DidDeleteSharedBitmap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidDeleteSharedBitmap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::InitializeCompositorFrameSinkType(
    CompositorFrameSinkType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type CompositorFrameSinkType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("InitializeCompositorFrameSinkType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder {
 public:
  static CompositorFrameSink::SubmitCompositorFrameSyncCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder> proxy(
        new CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CompositorFrameSink::SubmitCompositorFrameSyncCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::viz::ReturnedResource> in_resources);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder);
};

bool CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_resources));
  return true;
}

void CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run(
    WTF::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type WTF::Vector<::viz::ReturnedResource>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 3, true);
    return false;
  }
  *out_resources_ = std::move(p_resources);
  *result_ = true;
  return true;
}

// static
bool CompositorFrameSinkStubDispatch::Accept(
    CompositorFrameSink* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCompositorFrameSink_SetNeedsBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SetNeedsBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SetNeedsBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_begin_frame{};
      CompositorFrameSink_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(
std::move(p_needs_begin_frame));
      return true;
    }
    case internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantsAnimateOnlyBeginFrames();
      return true;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      absl::optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrame(
std::move(p_local_surface_id), 
std::move(p_frame), 
std::move(p_hit_test_region_list), 
std::move(p_submit_time));
      return true;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidNotProduceFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidNotProduceFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidNotProduceFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidNotProduceFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidNotProduceFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameAck p_ack{};
      CompositorFrameSink_DidNotProduceFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAck(&p_ack))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidNotProduceFrame(
std::move(p_ack));
      return true;
    }
    case internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::gpu::Mailbox p_id{};
      CompositorFrameSink_DidAllocateSharedBitmap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAllocateSharedBitmap(
std::move(p_region), 
std::move(p_id));
      return true;
    }
    case internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::Mailbox p_id{};
      CompositorFrameSink_DidDeleteSharedBitmap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteSharedBitmap(
std::move(p_id));
      return true;
    }
    case internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CompositorFrameSinkType p_type{};
      CompositorFrameSink_InitializeCompositorFrameSinkType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCompositorFrameSinkType(
std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkStubDispatch::AcceptWithResponder(
    CompositorFrameSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositorFrameSink_SetNeedsBeginFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data* params =
          reinterpret_cast<
              internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      absl::optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrameSync_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 3, false);
        return false;
      }
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback =
          CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrameSync(
std::move(p_local_surface_id), 
std::move(p_frame), 
std::move(p_hit_test_region_list), 
std::move(p_submit_time), std::move(callback));
      return true;
    }
    case internal::kCompositorFrameSink_DidNotProduceFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name: {
      break;
    }
    case internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkValidationInfo[] = {
    {internal::kCompositorFrameSink_SetNeedsBeginFrame_Name,
     {&internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name,
     {&internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SubmitCompositorFrame_Name,
     {&internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name,
     {&internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data::Validate,
      &internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data::Validate}},
    {internal::kCompositorFrameSink_DidNotProduceFrame_Name,
     {&internal::CompositorFrameSink_DidNotProduceFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name,
     {&internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name,
     {&internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name,
     {&internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkValidationInfo);
}

bool CompositorFrameSinkResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSink::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCompositorFrameSinkValidationInfo);

}
const char CompositorFrameSinkClient::Name_[] = "viz.mojom.CompositorFrameSinkClient";

CompositorFrameSinkClientProxy::CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkClientProxy::DidReceiveCompositorFrameAck(
    WTF::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type WTF::Vector<::viz::ReturnedResource>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.DidReceiveCompositorFrameAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("DidReceiveCompositorFrameAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::OnBeginFrame(
    const ::viz::BeginFrameArgs& in_args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::OnBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_OnBeginFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in CompositorFrameSinkClient.OnBeginFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  const mojo::internal::ContainerValidateParams details_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
      in_details, details_fragment, &details_validate_params);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in CompositorFrameSinkClient.OnBeginFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::OnBeginFramePausedChanged(
    bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("paused"), in_paused,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data> params(
          message);
  params.Allocate();
  params->paused = in_paused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::ReclaimResources(
    WTF::Vector<::viz::ReturnedResource> in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::ReclaimResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type WTF::Vector<::viz::ReturnedResource>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_ReclaimResources_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_ReclaimResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, resources_fragment, &resources_validate_params);
  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.ReclaimResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("ReclaimResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::OnCompositorFrameTransitionDirectiveProcessed(
    uint32_t in_sequence_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_id"), in_sequence_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data> params(
          message);
  params.Allocate();
  params->sequence_id = in_sequence_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnCompositorFrameTransitionDirectiveProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CompositorFrameSinkClientStubDispatch::Accept(
    CompositorFrameSinkClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveCompositorFrameAck(
std::move(p_resources));
      return true;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      WTF::HashMap<uint32_t, ::viz::FrameTimingDetails> p_details{};
      CompositorFrameSinkClient_OnBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFrame(
std::move(p_args), 
std::move(p_details));
      return true;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_paused{};
      CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(
std::move(p_paused));
      return true;
    }
    case internal::kCompositorFrameSinkClient_ReclaimResources_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::ReclaimResources",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::ReclaimResources");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_ReclaimResources_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_ReclaimResources_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_ReclaimResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReclaimResources(
std::move(p_resources));
      return true;
    }
    case internal::kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::OnCompositorFrameTransitionDirectiveProcessed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sequence_id{};
      CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_id = input_data_view.sequence_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompositorFrameTransitionDirectiveProcessed(
std::move(p_sequence_id));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
    CompositorFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_ReclaimResources_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkClientValidationInfo[] = {
    {internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name,
     {&internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_OnBeginFrame_Name,
     {&internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name,
     {&internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_ReclaimResources_Name,
     {&internal::CompositorFrameSinkClient_ReclaimResources_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name,
     {&internal::CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSinkClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif