// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "gpu/ipc/common/mailbox.mojom.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_JUMBO_H_
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#endif


namespace viz {
namespace mojom {


void CompositorFrameSinkInterceptorForTesting::SetNeedsBeginFrame(bool needs_begin_frame) {
  GetForwardingInterface()->SetNeedsBeginFrame(std::move(needs_begin_frame));
}
void CompositorFrameSinkInterceptorForTesting::SetWantsAnimateOnlyBeginFrames() {
  GetForwardingInterface()->SetWantsAnimateOnlyBeginFrames();
}
void CompositorFrameSinkInterceptorForTesting::SubmitCompositorFrame(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, absl::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time) {
  GetForwardingInterface()->SubmitCompositorFrame(std::move(local_surface_id), std::move(frame), std::move(hit_test_region_list), std::move(submit_time));
}
void CompositorFrameSinkInterceptorForTesting::SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, absl::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, SubmitCompositorFrameSyncCallback callback) {
  GetForwardingInterface()->SubmitCompositorFrameSync(std::move(local_surface_id), std::move(frame), std::move(hit_test_region_list), std::move(submit_time), std::move(callback));
}
void CompositorFrameSinkInterceptorForTesting::DidNotProduceFrame(const ::viz::BeginFrameAck& ack) {
  GetForwardingInterface()->DidNotProduceFrame(std::move(ack));
}
void CompositorFrameSinkInterceptorForTesting::DidAllocateSharedBitmap(::base::ReadOnlySharedMemoryRegion region, const ::gpu::Mailbox& id) {
  GetForwardingInterface()->DidAllocateSharedBitmap(std::move(region), std::move(id));
}
void CompositorFrameSinkInterceptorForTesting::DidDeleteSharedBitmap(const ::gpu::Mailbox& id) {
  GetForwardingInterface()->DidDeleteSharedBitmap(std::move(id));
}
void CompositorFrameSinkInterceptorForTesting::InitializeCompositorFrameSinkType(CompositorFrameSinkType type) {
  GetForwardingInterface()->InitializeCompositorFrameSinkType(std::move(type));
}
CompositorFrameSinkAsyncWaiter::CompositorFrameSinkAsyncWaiter(
    CompositorFrameSink* proxy) : proxy_(proxy) {}

CompositorFrameSinkAsyncWaiter::~CompositorFrameSinkAsyncWaiter() = default;

void CompositorFrameSinkAsyncWaiter::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, absl::optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, std::vector<::viz::ReturnedResource>* out_resources) {
  base::RunLoop loop;
  proxy_->SubmitCompositorFrameSync(std::move(local_surface_id),std::move(frame),std::move(hit_test_region_list),std::move(submit_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::viz::ReturnedResource>* out_resources
,
             std::vector<::viz::ReturnedResource> resources) {*out_resources = std::move(resources);
            loop->Quit();
          },
          &loop,
          out_resources));
  loop.Run();
}



void CompositorFrameSinkClientInterceptorForTesting::DidReceiveCompositorFrameAck(std::vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->DidReceiveCompositorFrameAck(std::move(resources));
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFrame(const ::viz::BeginFrameArgs& args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details) {
  GetForwardingInterface()->OnBeginFrame(std::move(args), std::move(details));
}
void CompositorFrameSinkClientInterceptorForTesting::OnBeginFramePausedChanged(bool paused) {
  GetForwardingInterface()->OnBeginFramePausedChanged(std::move(paused));
}
void CompositorFrameSinkClientInterceptorForTesting::ReclaimResources(std::vector<::viz::ReturnedResource> resources) {
  GetForwardingInterface()->ReclaimResources(std::move(resources));
}
void CompositorFrameSinkClientInterceptorForTesting::OnCompositorFrameTransitionDirectiveProcessed(uint32_t sequence_id) {
  GetForwardingInterface()->OnCompositorFrameTransitionDirectiveProcessed(std::move(sequence_id));
}
CompositorFrameSinkClientAsyncWaiter::CompositorFrameSinkClientAsyncWaiter(
    CompositorFrameSinkClient* proxy) : proxy_(proxy) {}

CompositorFrameSinkClientAsyncWaiter::~CompositorFrameSinkClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif