// services/viz/public/mojom/compositing/copy_output_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool CopyOutputRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CopyOutputRequest_Data* object = static_cast<const CopyOutputRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::viz::mojom::internal::CopyOutputResultFormat_Data
        ::Validate(object->result_format, validation_context))
    return false;


  if (!::viz::mojom::internal::CopyOutputResultDestination_Data
        ::Validate(object->result_destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scale_from, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scale_from, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scale_to, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scale_to, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->area, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->result_selection, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->result_sender, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->result_sender,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CopyOutputRequest_Data::CopyOutputRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CopyOutputResultSender_SendResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CopyOutputResultSender_SendResult_Params_Data* object = static_cast<const CopyOutputResultSender_SendResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

CopyOutputResultSender_SendResult_Params_Data::CopyOutputResultSender_SendResult_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz
