// services/viz/public/mojom/compositing/frame_sink_bundle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_JUMBO_H_
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#endif
namespace viz {
namespace mojom {
BundledFrameSubmission::BundledFrameSubmission()
    : sink_id(),
      data() {}

BundledFrameSubmission::BundledFrameSubmission(
    uint32_t sink_id_in,
    BundledFrameSubmissionDataPtr data_in)
    : sink_id(std::move(sink_id_in)),
      data(std::move(data_in)) {}

BundledFrameSubmission::~BundledFrameSubmission() = default;

void BundledFrameSubmission::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundledFrameSubmissionDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledFrameSubmission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledCompositorFrame::BundledCompositorFrame()
    : local_surface_id(),
      frame(),
      hit_test_region_list(),
      submit_time() {}

BundledCompositorFrame::BundledCompositorFrame(
    const ::viz::LocalSurfaceId& local_surface_id_in,
    ::viz::CompositorFrame frame_in,
    absl::optional<::viz::HitTestRegionList> hit_test_region_list_in,
    uint64_t submit_time_in)
    : local_surface_id(std::move(local_surface_id_in)),
      frame(std::move(frame_in)),
      hit_test_region_list(std::move(hit_test_region_list_in)),
      submit_time(std::move(submit_time_in)) {}

BundledCompositorFrame::~BundledCompositorFrame() = default;

void BundledCompositorFrame::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::LocalSurfaceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::CompositorFrame>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_region_list"), this->hit_test_region_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::viz::HitTestRegionList>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_time"), this->submit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledCompositorFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledReturnedResources::BundledReturnedResources()
    : sink_id(),
      resources() {}

BundledReturnedResources::BundledReturnedResources(
    uint32_t sink_id_in,
    std::vector<::viz::ReturnedResource> resources_in)
    : sink_id(std::move(sink_id_in)),
      resources(std::move(resources_in)) {}

BundledReturnedResources::~BundledReturnedResources() = default;

void BundledReturnedResources::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::viz::ReturnedResource>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledReturnedResources::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BeginFrameInfo::BeginFrameInfo()
    : sink_id(),
      args(),
      details() {}

BeginFrameInfo::BeginFrameInfo(
    uint32_t sink_id_in,
    const ::viz::BeginFrameArgs& args_in,
    const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details_in)
    : sink_id(std::move(sink_id_in)),
      args(std::move(args_in)),
      details(std::move(details_in)) {}

BeginFrameInfo::~BeginFrameInfo() = default;

void BeginFrameInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "args"), this->args,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::BeginFrameArgs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint32_t, ::viz::FrameTimingDetails>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginFrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledFrameSubmissionData::BundledFrameSubmissionData() : tag_(Tag::FRAME) {
  data_.frame = new BundledCompositorFramePtr;
}

BundledFrameSubmissionData::~BundledFrameSubmissionData() {
  DestroyActive();
}


void BundledFrameSubmissionData::set_frame(
    BundledCompositorFramePtr frame) {
  if (tag_ == Tag::FRAME) {
    *(data_.frame) = std::move(frame);
  } else {
    DestroyActive();
    tag_ = Tag::FRAME;
    data_.frame = new BundledCompositorFramePtr(
        std::move(frame));
  }
}
void BundledFrameSubmissionData::set_did_not_produce_frame(
    const ::viz::BeginFrameAck& did_not_produce_frame) {
  if (tag_ == Tag::DID_NOT_PRODUCE_FRAME) {
    *(data_.did_not_produce_frame) = std::move(did_not_produce_frame);
  } else {
    DestroyActive();
    tag_ = Tag::DID_NOT_PRODUCE_FRAME;
    data_.did_not_produce_frame = new ::viz::BeginFrameAck(
        std::move(did_not_produce_frame));
  }
}
void BundledFrameSubmissionData::set_did_delete_shared_bitmap(
    const ::gpu::Mailbox& did_delete_shared_bitmap) {
  if (tag_ == Tag::DID_DELETE_SHARED_BITMAP) {
    *(data_.did_delete_shared_bitmap) = std::move(did_delete_shared_bitmap);
  } else {
    DestroyActive();
    tag_ = Tag::DID_DELETE_SHARED_BITMAP;
    data_.did_delete_shared_bitmap = new ::gpu::Mailbox(
        std::move(did_delete_shared_bitmap));
  }
}

void BundledFrameSubmissionData::DestroyActive() {
  switch (tag_) {

    case Tag::FRAME:

      delete data_.frame;
      break;
    case Tag::DID_NOT_PRODUCE_FRAME:

      delete data_.did_not_produce_frame;
      break;
    case Tag::DID_DELETE_SHARED_BITMAP:

      delete data_.did_delete_shared_bitmap;
      break;
  }
}

bool BundledFrameSubmissionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FrameSinkBundle::Name_[] = "viz.mojom.FrameSinkBundle";

FrameSinkBundleProxy::FrameSinkBundleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkBundleProxy::InitializeCompositorFrameSinkType(
    uint32_t in_sink_id, ::viz::mojom::CompositorFrameSinkType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::viz::mojom::CompositorFrameSinkType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundle_InitializeCompositorFrameSinkType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("InitializeCompositorFrameSinkType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkBundleProxy::SetNeedsBeginFrame(
    uint32_t in_sink_id, bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundle::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frame"), in_needs_begin_frame,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundle_SetNeedsBeginFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->needs_begin_frame = in_needs_begin_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkBundleProxy::Submit(
    std::vector<BundledFrameSubmissionPtr> in_submissions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundle::Submit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submissions"), in_submissions,
                        "<value of type std::vector<BundledFrameSubmissionPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundle_Submit_Name, kFlags, 0, 0,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_Submit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->submissions)::BaseType>
      submissions_fragment(params.message());
  const mojo::internal::ContainerValidateParams submissions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledFrameSubmissionDataView>>(
      in_submissions, submissions_fragment, &submissions_validate_params);
  params->submissions.Set(
      submissions_fragment.is_null() ? nullptr : submissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->submissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null submissions in FrameSinkBundle.Submit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("Submit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkBundleProxy::DidAllocateSharedBitmap(
    uint32_t in_sink_id, ::base::ReadOnlySharedMemoryRegion in_region, const ::gpu::Mailbox& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundle::DidAllocateSharedBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::gpu::Mailbox&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundle_DidAllocateSharedBitmap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_DidAllocateSharedBitmap_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in FrameSinkBundle.DidAllocateSharedBitmap request");
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in FrameSinkBundle.DidAllocateSharedBitmap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("DidAllocateSharedBitmap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkBundleStubDispatch::Accept(
    FrameSinkBundle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkBundle_InitializeCompositorFrameSinkType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sink_id{};
      ::viz::mojom::CompositorFrameSinkType p_type{};
      FrameSinkBundle_InitializeCompositorFrameSinkType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCompositorFrameSinkType(
std::move(p_sink_id), 
std::move(p_type));
      return true;
    }
    case internal::kFrameSinkBundle_SetNeedsBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundle::SetNeedsBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundle::SetNeedsBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sink_id{};
      bool p_needs_begin_frame{};
      FrameSinkBundle_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(
std::move(p_sink_id), 
std::move(p_needs_begin_frame));
      return true;
    }
    case internal::kFrameSinkBundle_Submit_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundle::Submit",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundle::Submit");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_Submit_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_Submit_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<BundledFrameSubmissionPtr> p_submissions{};
      FrameSinkBundle_Submit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubmissions(&p_submissions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Submit(
std::move(p_submissions));
      return true;
    }
    case internal::kFrameSinkBundle_DidAllocateSharedBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundle::DidAllocateSharedBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundle::DidAllocateSharedBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_DidAllocateSharedBitmap_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_DidAllocateSharedBitmap_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sink_id{};
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::gpu::Mailbox p_id{};
      FrameSinkBundle_DidAllocateSharedBitmap_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAllocateSharedBitmap(
std::move(p_sink_id), 
std::move(p_region), 
std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkBundleStubDispatch::AcceptWithResponder(
    FrameSinkBundle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkBundle_InitializeCompositorFrameSinkType_Name: {
      break;
    }
    case internal::kFrameSinkBundle_SetNeedsBeginFrame_Name: {
      break;
    }
    case internal::kFrameSinkBundle_Submit_Name: {
      break;
    }
    case internal::kFrameSinkBundle_DidAllocateSharedBitmap_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkBundleValidationInfo[] = {
    {internal::kFrameSinkBundle_InitializeCompositorFrameSinkType_Name,
     {&internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkBundle_SetNeedsBeginFrame_Name,
     {&internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkBundle_Submit_Name,
     {&internal::FrameSinkBundle_Submit_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkBundle_DidAllocateSharedBitmap_Name,
     {&internal::FrameSinkBundle_DidAllocateSharedBitmap_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkBundleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkBundle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkBundleValidationInfo);
}

const char FrameSinkBundleClient::Name_[] = "viz.mojom.FrameSinkBundleClient";

FrameSinkBundleClientProxy::FrameSinkBundleClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkBundleClientProxy::FlushNotifications(
    std::vector<BundledReturnedResourcesPtr> in_acks, std::vector<BeginFrameInfoPtr> in_begin_frames, std::vector<BundledReturnedResourcesPtr> in_reclaimed_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundleClient::FlushNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("acks"), in_acks,
                        "<value of type std::vector<BundledReturnedResourcesPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_frames"), in_begin_frames,
                        "<value of type std::vector<BeginFrameInfoPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reclaimed_resources"), in_reclaimed_resources,
                        "<value of type std::vector<BundledReturnedResourcesPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundleClient_FlushNotifications_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_FlushNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->acks)::BaseType>
      acks_fragment(params.message());
  const mojo::internal::ContainerValidateParams acks_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledReturnedResourcesDataView>>(
      in_acks, acks_fragment, &acks_validate_params);
  params->acks.Set(
      acks_fragment.is_null() ? nullptr : acks_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->acks.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null acks in FrameSinkBundleClient.FlushNotifications request");
  mojo::internal::MessageFragment<
      typename decltype(params->begin_frames)::BaseType>
      begin_frames_fragment(params.message());
  const mojo::internal::ContainerValidateParams begin_frames_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BeginFrameInfoDataView>>(
      in_begin_frames, begin_frames_fragment, &begin_frames_validate_params);
  params->begin_frames.Set(
      begin_frames_fragment.is_null() ? nullptr : begin_frames_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->begin_frames.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_frames in FrameSinkBundleClient.FlushNotifications request");
  mojo::internal::MessageFragment<
      typename decltype(params->reclaimed_resources)::BaseType>
      reclaimed_resources_fragment(params.message());
  const mojo::internal::ContainerValidateParams reclaimed_resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledReturnedResourcesDataView>>(
      in_reclaimed_resources, reclaimed_resources_fragment, &reclaimed_resources_validate_params);
  params->reclaimed_resources.Set(
      reclaimed_resources_fragment.is_null() ? nullptr : reclaimed_resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reclaimed_resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reclaimed_resources in FrameSinkBundleClient.FlushNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("FlushNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkBundleClientProxy::OnBeginFramePausedChanged(
    uint32_t in_sink_id, bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("paused"), in_paused,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundleClient_OnBeginFramePausedChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->paused = in_paused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkBundleClientProxy::OnCompositorFrameTransitionDirectiveProcessed(
    uint32_t in_sink_id, uint32_t in_sequence_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_id"), in_sequence_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->sequence_id = in_sequence_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("OnCompositorFrameTransitionDirectiveProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkBundleClientStubDispatch::Accept(
    FrameSinkBundleClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFrameSinkBundleClient_FlushNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundleClient::FlushNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundleClient::FlushNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_FlushNotifications_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_FlushNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<BundledReturnedResourcesPtr> p_acks{};
      std::vector<BeginFrameInfoPtr> p_begin_frames{};
      std::vector<BundledReturnedResourcesPtr> p_reclaimed_resources{};
      FrameSinkBundleClient_FlushNotifications_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAcks(&p_acks))
        success = false;
      if (success && !input_data_view.ReadBeginFrames(&p_begin_frames))
        success = false;
      if (success && !input_data_view.ReadReclaimedResources(&p_reclaimed_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushNotifications(
std::move(p_acks), 
std::move(p_begin_frames), 
std::move(p_reclaimed_resources));
      return true;
    }
    case internal::kFrameSinkBundleClient_OnBeginFramePausedChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sink_id{};
      bool p_paused{};
      FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(
std::move(p_sink_id), 
std::move(p_paused));
      return true;
    }
    case internal::kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sink_id{};
      uint32_t p_sequence_id{};
      FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_sequence_id = input_data_view.sequence_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompositorFrameTransitionDirectiveProcessed(
std::move(p_sink_id), 
std::move(p_sequence_id));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkBundleClientStubDispatch::AcceptWithResponder(
    FrameSinkBundleClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkBundleClient_FlushNotifications_Name: {
      break;
    }
    case internal::kFrameSinkBundleClient_OnBeginFramePausedChanged_Name: {
      break;
    }
    case internal::kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkBundleClientValidationInfo[] = {
    {internal::kFrameSinkBundleClient_FlushNotifications_Name,
     {&internal::FrameSinkBundleClient_FlushNotifications_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkBundleClient_OnBeginFramePausedChanged_Name,
     {&internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name,
     {&internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkBundleClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkBundleClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkBundleClientValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::BundledFrameSubmission::DataView, ::viz::mojom::BundledFrameSubmissionPtr>::Read(
    ::viz::mojom::BundledFrameSubmission::DataView input,
    ::viz::mojom::BundledFrameSubmissionPtr* output) {
  bool success = true;
  ::viz::mojom::BundledFrameSubmissionPtr result(::viz::mojom::BundledFrameSubmission::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::BundledCompositorFrame::DataView, ::viz::mojom::BundledCompositorFramePtr>::Read(
    ::viz::mojom::BundledCompositorFrame::DataView input,
    ::viz::mojom::BundledCompositorFramePtr* output) {
  bool success = true;
  ::viz::mojom::BundledCompositorFramePtr result(::viz::mojom::BundledCompositorFrame::New());
  
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
      if (success && !input.ReadFrame(&result->frame))
        success = false;
      if (success && !input.ReadHitTestRegionList(&result->hit_test_region_list))
        success = false;
      if (success)
        result->submit_time = input.submit_time();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::BundledReturnedResources::DataView, ::viz::mojom::BundledReturnedResourcesPtr>::Read(
    ::viz::mojom::BundledReturnedResources::DataView input,
    ::viz::mojom::BundledReturnedResourcesPtr* output) {
  bool success = true;
  ::viz::mojom::BundledReturnedResourcesPtr result(::viz::mojom::BundledReturnedResources::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadResources(&result->resources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::BeginFrameInfo::DataView, ::viz::mojom::BeginFrameInfoPtr>::Read(
    ::viz::mojom::BeginFrameInfo::DataView input,
    ::viz::mojom::BeginFrameInfoPtr* output) {
  bool success = true;
  ::viz::mojom::BeginFrameInfoPtr result(::viz::mojom::BeginFrameInfo::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadArgs(&result->args))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::BundledFrameSubmissionData::DataView, ::viz::mojom::BundledFrameSubmissionDataPtr>::Read(
    ::viz::mojom::BundledFrameSubmissionData::DataView input,
    ::viz::mojom::BundledFrameSubmissionDataPtr* output) {
  using UnionType = ::viz::mojom::BundledFrameSubmissionData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::FRAME: {
      ::viz::mojom::BundledCompositorFramePtr result_frame;
      if (!input.ReadFrame(&result_frame))
        return false;

      *output = UnionType::NewFrame(
          std::move(result_frame));
      break;
    }
    case Tag::DID_NOT_PRODUCE_FRAME: {
      ::viz::BeginFrameAck result_did_not_produce_frame;
      if (!input.ReadDidNotProduceFrame(&result_did_not_produce_frame))
        return false;

      *output = UnionType::NewDidNotProduceFrame(
          std::move(result_did_not_produce_frame));
      break;
    }
    case Tag::DID_DELETE_SHARED_BITMAP: {
      ::gpu::Mailbox result_did_delete_shared_bitmap;
      if (!input.ReadDidDeleteSharedBitmap(&result_did_delete_shared_bitmap))
        return false;

      *output = UnionType::NewDidDeleteSharedBitmap(
          std::move(result_did_delete_shared_bitmap));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif