// services/viz/public/mojom/compositing/resource_format.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/resource_format.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/resource_format.mojom-params-data.h"
namespace viz {
namespace mojom {

static NOINLINE const char* ResourceFormatToStringHelper(ResourceFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResourceFormat::RGBA_8888:
      return "RGBA_8888";
    case ResourceFormat::RGBA_4444:
      return "RGBA_4444";
    case ResourceFormat::BGRA_8888:
      return "BGRA_8888";
    case ResourceFormat::ALPHA_8:
      return "ALPHA_8";
    case ResourceFormat::LUMINANCE_8:
      return "LUMINANCE_8";
    case ResourceFormat::RGB_565:
      return "RGB_565";
    case ResourceFormat::BGR_565:
      return "BGR_565";
    case ResourceFormat::ETC1:
      return "ETC1";
    case ResourceFormat::RED_8:
      return "RED_8";
    case ResourceFormat::RG_88:
      return "RG_88";
    case ResourceFormat::LUMINANCE_F16:
      return "LUMINANCE_F16";
    case ResourceFormat::RGBA_F16:
      return "RGBA_F16";
    case ResourceFormat::R16_EXT:
      return "R16_EXT";
    case ResourceFormat::RG16_EXT:
      return "RG16_EXT";
    case ResourceFormat::RGBX_8888:
      return "RGBX_8888";
    case ResourceFormat::BGRX_8888:
      return "BGRX_8888";
    case ResourceFormat::RGBX_1010102:
      return "RGBX_1010102";
    case ResourceFormat::BGRX_1010102:
      return "BGRX_1010102";
    case ResourceFormat::YVU_420:
      return "YVU_420";
    case ResourceFormat::YUV_420_BIPLANAR:
      return "YUV_420_BIPLANAR";
    case ResourceFormat::P010:
      return "P010";
    default:
      return nullptr;
  }
}

std::string ResourceFormatToString(ResourceFormat value) {
  const char *str = ResourceFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResourceFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResourceFormat value) {
  return os << ResourceFormatToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ResourceFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ResourceFormat value) {
  return std::move(context).WriteString(::viz::mojom::ResourceFormatToString(value));
}

} // namespace perfetto
