// services/viz/public/mojom/compositing/texture_releaser.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/texture_releaser.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TEXTURE_RELEASER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TEXTURE_RELEASER_MOJOM_BLINK_JUMBO_H_
#endif
namespace viz {
namespace mojom {
namespace blink {
const char TextureReleaser::Name_[] = "viz.mojom.TextureReleaser";

TextureReleaserProxy::TextureReleaserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextureReleaserProxy::Release(
    const ::gpu::SyncToken& in_sync_token, bool in_is_lost) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::TextureReleaser::Release", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token,
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_lost"), in_is_lost,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextureReleaser_Release_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::TextureReleaser_Release_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in TextureReleaser.Release request");
  params->is_lost = in_is_lost;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureReleaser::Name_);
  message.set_method_name("Release");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TextureReleaserStubDispatch::Accept(
    TextureReleaser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTextureReleaser_Release_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::TextureReleaser::Release",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::TextureReleaser::Release");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureReleaser_Release_Params_Data* params =
          reinterpret_cast<internal::TextureReleaser_Release_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::SyncToken p_sync_token{};
      bool p_is_lost{};
      TextureReleaser_Release_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success)
        p_is_lost = input_data_view.is_lost();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureReleaser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Release(
std::move(p_sync_token), 
std::move(p_is_lost));
      return true;
    }
  }
  return false;
}

// static
bool TextureReleaserStubDispatch::AcceptWithResponder(
    TextureReleaser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTextureReleaser_Release_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTextureReleaserValidationInfo[] = {
    {internal::kTextureReleaser_Release_Name,
     {&internal::TextureReleaser_Release_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TextureReleaserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::TextureReleaser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTextureReleaserValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif