// services/viz/public/mojom/gpu.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/gpu.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/gpu.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data* object = static_cast<const GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::gfx::mojom::internal::BufferUsage_Data
        ::Validate(object->usage, validation_context))
    return false;

  return true;
}

GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data* object = static_cast<const GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  return true;
}

GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data::GpuMemoryBufferFactory_CreateGpuMemoryBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data* object = static_cast<const GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data::GpuMemoryBufferFactory_DestroyGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data* object = static_cast<const GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_memory, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  return true;
}

GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data* object = static_cast<const GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data::GpuMemoryBufferFactory_CopyGpuMemoryBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gpu_CreateGpuMemoryBufferFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Gpu_CreateGpuMemoryBufferFactory_Params_Data* object = static_cast<const Gpu_CreateGpuMemoryBufferFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Gpu_CreateGpuMemoryBufferFactory_Params_Data::Gpu_CreateGpuMemoryBufferFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gpu_EstablishGpuChannel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Gpu_EstablishGpuChannel_Params_Data* object = static_cast<const Gpu_EstablishGpuChannel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Gpu_EstablishGpuChannel_Params_Data::Gpu_EstablishGpuChannel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gpu_EstablishGpuChannel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Gpu_EstablishGpuChannel_ResponseParams_Data* object = static_cast<const Gpu_EstablishGpuChannel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->channel_handle,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_feature_info, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_feature_info, validation_context))
    return false;

  return true;
}

Gpu_EstablishGpuChannel_ResponseParams_Data::Gpu_EstablishGpuChannel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data* object = static_cast<const Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->vea_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->vea_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz
