// services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool HitTestRegion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HitTestRegion_Data* object = static_cast<const HitTestRegion_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transform, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transform, validation_context))
    return false;

  return true;
}

HitTestRegion_Data::HitTestRegion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HitTestRegionList_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HitTestRegionList_Data* object = static_cast<const HitTestRegionList_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transform, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transform, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->regions, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams regions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->regions, validation_context,
                                         &regions_validate_params)) {
    return false;
  }

  return true;
}

HitTestRegionList_Data::HitTestRegionList_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz
