// third_party/blink/public/mojom/blob/blob.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/blob.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char BlobReaderClient::Name_[] = "blink.mojom.BlobReaderClient";

BlobReaderClientProxy::BlobReaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobReaderClientProxy::OnCalculatedSize(
    uint64_t in_total_size, uint64_t in_expected_content_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobReaderClient::OnCalculatedSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_content_size"), in_expected_content_size,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobReaderClient_OnCalculatedSize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobReaderClient_OnCalculatedSize_Params_Data> params(
          message);
  params.Allocate();
  params->total_size = in_total_size;
  params->expected_content_size = in_expected_content_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobReaderClient::Name_);
  message.set_method_name("OnCalculatedSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobReaderClientProxy::OnComplete(
    int32_t in_status, uint64_t in_data_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobReaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_length"), in_data_length,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobReaderClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobReaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  params->status = in_status;
  params->data_length = in_data_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobReaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BlobReaderClientStubDispatch::Accept(
    BlobReaderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBlobReaderClient_OnCalculatedSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobReaderClient::OnCalculatedSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobReaderClient::OnCalculatedSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobReaderClient_OnCalculatedSize_Params_Data* params =
          reinterpret_cast<internal::BlobReaderClient_OnCalculatedSize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_total_size{};
      uint64_t p_expected_content_size{};
      BlobReaderClient_OnCalculatedSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_size = input_data_view.total_size();
      if (success)
        p_expected_content_size = input_data_view.expected_content_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobReaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCalculatedSize(
std::move(p_total_size), 
std::move(p_expected_content_size));
      return true;
    }
    case internal::kBlobReaderClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobReaderClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobReaderClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobReaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::BlobReaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_status{};
      uint64_t p_data_length{};
      BlobReaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_status = input_data_view.status();
      if (success)
        p_data_length = input_data_view.data_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobReaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_status), 
std::move(p_data_length));
      return true;
    }
  }
  return false;
}

// static
bool BlobReaderClientStubDispatch::AcceptWithResponder(
    BlobReaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobReaderClient_OnCalculatedSize_Name: {
      break;
    }
    case internal::kBlobReaderClient_OnComplete_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBlobReaderClientValidationInfo[] = {
    {&internal::BlobReaderClient_OnCalculatedSize_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BlobReaderClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool BlobReaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::BlobReaderClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobReaderClientValidationInfo);
}

const char Blob::Name_[] = "blink.mojom.Blob";
bool Blob::CaptureSnapshot(uint64_t* out_length, absl::optional<::base::Time>* out_modification_time) {
  NOTREACHED();
  return false;
}

class Blob_ReadSideData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_ReadSideData_ForwardToCallback(
      Blob::ReadSideDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Blob::ReadSideDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Blob_ReadSideData_ForwardToCallback);
};
class Blob_CaptureSnapshot_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Blob_CaptureSnapshot_HandleSyncResponse(
      bool* result, uint64_t* out_length, absl::optional<::base::Time>* out_modification_time)
      : result_(result), out_length_(out_length), out_modification_time_(out_modification_time) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint64_t* out_length_;
  absl::optional<::base::Time>* out_modification_time_;DISALLOW_COPY_AND_ASSIGN(Blob_CaptureSnapshot_HandleSyncResponse);
};

class Blob_CaptureSnapshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_CaptureSnapshot_ForwardToCallback(
      Blob::CaptureSnapshotCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Blob::CaptureSnapshotCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Blob_CaptureSnapshot_ForwardToCallback);
};

class Blob_GetInternalUUID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Blob_GetInternalUUID_ForwardToCallback(
      Blob::GetInternalUUIDCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Blob::GetInternalUUIDCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Blob_GetInternalUUID_ForwardToCallback);
};

BlobProxy::BlobProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobProxy::Clone(
    ::mojo::PendingReceiver<Blob> in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Blob::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<Blob>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in Blob.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobProxy::AsDataPipeGetter(
    ::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter> in_data_pipe_getter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Blob::AsDataPipeGetter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe_getter"), in_data_pipe_getter,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_AsDataPipeGetter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_AsDataPipeGetter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
      in_data_pipe_getter, &params->data_pipe_getter, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data_pipe_getter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data_pipe_getter in Blob.AsDataPipeGetter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("AsDataPipeGetter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobProxy::ReadAll(
    ::mojo::ScopedDataPipeProducerHandle in_pipe, ::mojo::PendingRemote<BlobReaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Blob::ReadAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BlobReaderClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_ReadAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_pipe, &params->pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pipe in Blob.ReadAll request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
      in_client, &params->client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobProxy::ReadRange(
    uint64_t in_offset, uint64_t in_length, ::mojo::ScopedDataPipeProducerHandle in_pipe, ::mojo::PendingRemote<BlobReaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Blob::ReadRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BlobReaderClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_ReadRange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadRange_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  params->length = in_length;
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_pipe, &params->pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pipe in Blob.ReadRange request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
      in_client, &params->client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobProxy::Load(
    ::mojo::PendingReceiver<::network::mojom::blink::URLLoader> in_loader, const WTF::String& in_request_method, const ::net::HttpRequestHeaders& in_headers, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Blob::Load", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader"), in_loader,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::URLLoader>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_method"), in_request_method,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_Load_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_Load_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
      in_loader, &params->loader, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->loader),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid loader in Blob.Load request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_method)::BaseType> request_method_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_request_method, request_method_fragment);
  params->request_method.Set(
      request_method_fragment.is_null() ? nullptr : request_method_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_method in Blob.Load request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_headers, headers_fragment);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in Blob.Load request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in Blob.Load request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("Load");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BlobProxy::ReadSideData(
    ReadSideDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Blob::ReadSideData");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_ReadSideData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadSideData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadSideData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_ReadSideData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool BlobProxy::CaptureSnapshot(
    uint64_t* out_param_length, absl::optional<::base::Time>* out_param_modification_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "blink::mojom::Blob::CaptureSnapshot");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_CaptureSnapshot_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_CaptureSnapshot_HandleSyncResponse(
          &result, out_param_length, out_param_modification_time));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::Blob::CaptureSnapshot", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), out_param_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modification_time"), out_param_modification_time,
                        "<value of type absl::optional<::base::Time>>");
   });
#endif
  return result;
}

void BlobProxy::CaptureSnapshot(
    CaptureSnapshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Blob::CaptureSnapshot");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_CaptureSnapshot_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_CaptureSnapshot_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobProxy::GetInternalUUID(
    GetInternalUUIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Blob::GetInternalUUID");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_GetInternalUUID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_GetInternalUUID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("GetInternalUUID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Blob_GetInternalUUID_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Blob_ReadSideData_ProxyToResponder {
 public:
  static Blob::ReadSideDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Blob_ReadSideData_ProxyToResponder> proxy(
        new Blob_ReadSideData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Blob_ReadSideData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_ReadSideData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Blob_ReadSideData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::ReadSideDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      absl::optional<::mojo_base::BigBuffer> in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Blob_ReadSideData_ProxyToResponder);
};

bool Blob_ReadSideData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Blob::ReadSideDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Blob_ReadSideData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_ReadSideData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::mojo_base::BigBuffer> p_data{};
  Blob_ReadSideData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void Blob_ReadSideData_ProxyToResponder::Run(
    absl::optional<::mojo_base::BigBuffer> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Blob::ReadSideDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type absl::optional<::mojo_base::BigBuffer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_ReadSideData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_ReadSideData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Blob::ReadSideDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("ReadSideData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Blob_CaptureSnapshot_ProxyToResponder {
 public:
  static Blob::CaptureSnapshotCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Blob_CaptureSnapshot_ProxyToResponder> proxy(
        new Blob_CaptureSnapshot_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Blob_CaptureSnapshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_CaptureSnapshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Blob_CaptureSnapshot_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::CaptureSnapshotCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_length, absl::optional<::base::Time> in_modification_time);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Blob_CaptureSnapshot_ProxyToResponder);
};

bool Blob_CaptureSnapshot_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Blob::CaptureSnapshotCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Blob_CaptureSnapshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_CaptureSnapshot_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_length{};
  absl::optional<::base::Time> p_modification_time{};
  Blob_CaptureSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_length = input_data_view.length();
  if (success && !input_data_view.ReadModificationTime(&p_modification_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_length), 
std::move(p_modification_time));
  return true;
}

void Blob_CaptureSnapshot_ProxyToResponder::Run(
    uint64_t in_length, absl::optional<::base::Time> in_modification_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Blob::CaptureSnapshotCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modification_time"), in_modification_time,
                        "<value of type absl::optional<::base::Time>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_CaptureSnapshot_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_CaptureSnapshot_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->length = in_length;
  mojo::internal::MessageFragment<
      typename decltype(params->modification_time)::BaseType> modification_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_modification_time, modification_time_fragment);
  params->modification_time.Set(
      modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Blob::CaptureSnapshotCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("CaptureSnapshot");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Blob_CaptureSnapshot_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::Blob_CaptureSnapshot_ResponseParams_Data* params =
      reinterpret_cast<internal::Blob_CaptureSnapshot_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  uint64_t p_length{};
  absl::optional<::base::Time> p_modification_time{};
  Blob_CaptureSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_length = input_data_view.length();
  if (success && !input_data_view.ReadModificationTime(&p_modification_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 6, true);
    return false;
  }
  *out_length_ = std::move(p_length);
  *out_modification_time_ = std::move(p_modification_time);
  *result_ = true;
  return true;
}
class Blob_GetInternalUUID_ProxyToResponder {
 public:
  static Blob::GetInternalUUIDCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Blob_GetInternalUUID_ProxyToResponder> proxy(
        new Blob_GetInternalUUID_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Blob_GetInternalUUID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Blob_GetInternalUUID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Blob_GetInternalUUID_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Blob::GetInternalUUIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::String& in_uuid);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Blob_GetInternalUUID_ProxyToResponder);
};

bool Blob_GetInternalUUID_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Blob::GetInternalUUIDCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Blob_GetInternalUUID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Blob_GetInternalUUID_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::String p_uuid{};
  Blob_GetInternalUUID_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUuid(&p_uuid))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Blob::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_uuid));
  return true;
}

void Blob_GetInternalUUID_ProxyToResponder::Run(
    const WTF::String& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Blob::GetInternalUUIDCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const WTF::String&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlob_GetInternalUUID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Blob_GetInternalUUID_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Blob::GetInternalUUIDCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Blob::Name_);
  message.set_method_name("GetInternalUUID");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobStubDispatch::Accept(
    Blob* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBlob_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Blob_Clone_Params_Data* params =
          reinterpret_cast<internal::Blob_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<Blob> p_blob{};
      Blob_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_blob));
      return true;
    }
    case internal::kBlob_AsDataPipeGetter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::AsDataPipeGetter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::AsDataPipeGetter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Blob_AsDataPipeGetter_Params_Data* params =
          reinterpret_cast<internal::Blob_AsDataPipeGetter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter> p_data_pipe_getter{};
      Blob_AsDataPipeGetter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_data_pipe_getter =
            input_data_view.TakeDataPipeGetter<decltype(p_data_pipe_getter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsDataPipeGetter(
std::move(p_data_pipe_getter));
      return true;
    }
    case internal::kBlob_ReadAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::ReadAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::ReadAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Blob_ReadAll_Params_Data* params =
          reinterpret_cast<internal::Blob_ReadAll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      ::mojo::PendingRemote<BlobReaderClient> p_client{};
      Blob_ReadAll_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAll(
std::move(p_pipe), 
std::move(p_client));
      return true;
    }
    case internal::kBlob_ReadRange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::ReadRange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::ReadRange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Blob_ReadRange_Params_Data* params =
          reinterpret_cast<internal::Blob_ReadRange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_length{};
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      ::mojo::PendingRemote<BlobReaderClient> p_client{};
      Blob_ReadRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadRange(
std::move(p_offset), 
std::move(p_length), 
std::move(p_pipe), 
std::move(p_client));
      return true;
    }
    case internal::kBlob_Load_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::Load",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::Load");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Blob_Load_Params_Data* params =
          reinterpret_cast<internal::Blob_Load_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::URLLoader> p_loader{};
      WTF::String p_request_method{};
      ::net::HttpRequestHeaders p_headers{};
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> p_client{};
      Blob_Load_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success && !input_data_view.ReadRequestMethod(&p_request_method))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Load(
std::move(p_loader), 
std::move(p_request_method), 
std::move(p_headers), 
std::move(p_client));
      return true;
    }
    case internal::kBlob_ReadSideData_Name: {
      break;
    }
    case internal::kBlob_CaptureSnapshot_Name: {
      break;
    }
    case internal::kBlob_GetInternalUUID_Name: {
      break;
    }
  }
  return false;
}

// static
bool BlobStubDispatch::AcceptWithResponder(
    Blob* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlob_Clone_Name: {
      break;
    }
    case internal::kBlob_AsDataPipeGetter_Name: {
      break;
    }
    case internal::kBlob_ReadAll_Name: {
      break;
    }
    case internal::kBlob_ReadRange_Name: {
      break;
    }
    case internal::kBlob_Load_Name: {
      break;
    }
    case internal::kBlob_ReadSideData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::ReadSideData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::ReadSideData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Blob_ReadSideData_Params_Data* params =
          reinterpret_cast<
              internal::Blob_ReadSideData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Blob_ReadSideData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 5, false);
        return false;
      }
      Blob::ReadSideDataCallback callback =
          Blob_ReadSideData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSideData(std::move(callback));
      return true;
    }
    case internal::kBlob_CaptureSnapshot_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::CaptureSnapshot",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::CaptureSnapshot");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Blob_CaptureSnapshot_Params_Data* params =
          reinterpret_cast<
              internal::Blob_CaptureSnapshot_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Blob_CaptureSnapshot_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 6, false);
        return false;
      }
      Blob::CaptureSnapshotCallback callback =
          Blob_CaptureSnapshot_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CaptureSnapshot(std::move(callback));
      return true;
    }
    case internal::kBlob_GetInternalUUID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Blob::GetInternalUUID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Blob::GetInternalUUID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Blob_GetInternalUUID_Params_Data* params =
          reinterpret_cast<
              internal::Blob_GetInternalUUID_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Blob_GetInternalUUID_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Blob::Name_, 7, false);
        return false;
      }
      Blob::GetInternalUUIDCallback callback =
          Blob_GetInternalUUID_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInternalUUID(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBlobValidationInfo[] = {
    {&internal::Blob_Clone_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Blob_AsDataPipeGetter_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Blob_ReadAll_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Blob_ReadRange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Blob_Load_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Blob_ReadSideData_Params_Data::Validate,
     &internal::Blob_ReadSideData_ResponseParams_Data::Validate},
    {&internal::Blob_CaptureSnapshot_Params_Data::Validate,
     &internal::Blob_CaptureSnapshot_ResponseParams_Data::Validate},
    {&internal::Blob_GetInternalUUID_Params_Data::Validate,
     &internal::Blob_GetInternalUUID_ResponseParams_Data::Validate},
};

bool BlobRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Blob::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobValidationInfo);
}

bool BlobResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Blob::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif