// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/time.mojom.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_JUMBO_H_
#endif


namespace blink {
namespace mojom {


void BucketHostInterceptorForTesting::Persist(PersistCallback callback) {
  GetForwardingInterface()->Persist(std::move(callback));
}
void BucketHostInterceptorForTesting::Persisted(PersistedCallback callback) {
  GetForwardingInterface()->Persisted(std::move(callback));
}
void BucketHostInterceptorForTesting::Estimate(EstimateCallback callback) {
  GetForwardingInterface()->Estimate(std::move(callback));
}
void BucketHostInterceptorForTesting::Durability(DurabilityCallback callback) {
  GetForwardingInterface()->Durability(std::move(callback));
}
void BucketHostInterceptorForTesting::SetExpires(::base::Time expires, SetExpiresCallback callback) {
  GetForwardingInterface()->SetExpires(std::move(expires), std::move(callback));
}
void BucketHostInterceptorForTesting::Expires(ExpiresCallback callback) {
  GetForwardingInterface()->Expires(std::move(callback));
}
BucketHostAsyncWaiter::BucketHostAsyncWaiter(
    BucketHost* proxy) : proxy_(proxy) {}

BucketHostAsyncWaiter::~BucketHostAsyncWaiter() = default;

void BucketHostAsyncWaiter::Persist(
    bool* out_persisted, bool* out_success) {
  base::RunLoop loop;
  proxy_->Persist(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_persisted
,
             bool* out_success
,
             bool persisted,
             bool success) {*out_persisted = std::move(persisted);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_persisted,
          out_success));
  loop.Run();
}
void BucketHostAsyncWaiter::Persisted(
    bool* out_persisted, bool* out_success) {
  base::RunLoop loop;
  proxy_->Persisted(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_persisted
,
             bool* out_success
,
             bool persisted,
             bool success) {*out_persisted = std::move(persisted);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_persisted,
          out_success));
  loop.Run();
}
void BucketHostAsyncWaiter::Estimate(
    int64_t* out_current_usage, int64_t* out_current_quota, bool* out_success) {
  base::RunLoop loop;
  proxy_->Estimate(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_current_usage
,
             int64_t* out_current_quota
,
             bool* out_success
,
             int64_t current_usage,
             int64_t current_quota,
             bool success) {*out_current_usage = std::move(current_usage);*out_current_quota = std::move(current_quota);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_current_usage,
          out_current_quota,
          out_success));
  loop.Run();
}
void BucketHostAsyncWaiter::Durability(
    BucketDurability* out_durability, bool* out_success) {
  base::RunLoop loop;
  proxy_->Durability(
      base::BindOnce(
          [](base::RunLoop* loop,
             BucketDurability* out_durability
,
             bool* out_success
,
             BucketDurability durability,
             bool success) {*out_durability = std::move(durability);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_durability,
          out_success));
  loop.Run();
}
void BucketHostAsyncWaiter::SetExpires(
    ::base::Time expires, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetExpires(std::move(expires),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void BucketHostAsyncWaiter::Expires(
    absl::optional<::base::Time>* out_expires, bool* out_success) {
  base::RunLoop loop;
  proxy_->Expires(
      base::BindOnce(
          [](base::RunLoop* loop,
             absl::optional<::base::Time>* out_expires
,
             bool* out_success
,
             absl::optional<::base::Time> expires,
             bool success) {*out_expires = std::move(expires);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_expires,
          out_success));
  loop.Run();
}



void BucketManagerHostInterceptorForTesting::OpenBucket(const std::string& name, BucketPoliciesPtr policy, OpenBucketCallback callback) {
  GetForwardingInterface()->OpenBucket(std::move(name), std::move(policy), std::move(callback));
}
void BucketManagerHostInterceptorForTesting::Keys(KeysCallback callback) {
  GetForwardingInterface()->Keys(std::move(callback));
}
void BucketManagerHostInterceptorForTesting::DeleteBucket(const std::string& name, DeleteBucketCallback callback) {
  GetForwardingInterface()->DeleteBucket(std::move(name), std::move(callback));
}
BucketManagerHostAsyncWaiter::BucketManagerHostAsyncWaiter(
    BucketManagerHost* proxy) : proxy_(proxy) {}

BucketManagerHostAsyncWaiter::~BucketManagerHostAsyncWaiter() = default;

void BucketManagerHostAsyncWaiter::OpenBucket(
    const std::string& name, BucketPoliciesPtr policy, ::mojo::PendingRemote<BucketHost>* out_remote) {
  base::RunLoop loop;
  proxy_->OpenBucket(std::move(name),std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<BucketHost>* out_remote
,
             ::mojo::PendingRemote<BucketHost> remote) {*out_remote = std::move(remote);
            loop->Quit();
          },
          &loop,
          out_remote));
  loop.Run();
}
void BucketManagerHostAsyncWaiter::Keys(
    std::vector<std::string>* out_buckets, bool* out_success) {
  base::RunLoop loop;
  proxy_->Keys(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_buckets
,
             bool* out_success
,
             const std::vector<std::string>& buckets,
             bool success) {*out_buckets = std::move(buckets);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_buckets,
          out_success));
  loop.Run();
}
void BucketManagerHostAsyncWaiter::DeleteBucket(
    const std::string& name, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteBucket(std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}





}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif