// third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/compute_pressure/compute_pressure.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ComputePressureStatusToStringHelper(ComputePressureStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ComputePressureStatus::kOk:
      return "kOk";
    case ComputePressureStatus::kNotSupported:
      return "kNotSupported";
    case ComputePressureStatus::kSecurityError:
      return "kSecurityError";
    default:
      return nullptr;
  }
}

std::string ComputePressureStatusToString(ComputePressureStatus value) {
  const char *str = ComputePressureStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ComputePressureStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ComputePressureStatus value) {
  return os << ComputePressureStatusToString(value);
}

namespace internal {


// static
bool ComputePressureState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ComputePressureState_Data* object = static_cast<const ComputePressureState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ComputePressureState_Data::ComputePressureState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComputePressureQuantization_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ComputePressureQuantization_Data* object = static_cast<const ComputePressureQuantization_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cpu_utilization_thresholds, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cpu_utilization_thresholds_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cpu_utilization_thresholds, validation_context,
                                         &cpu_utilization_thresholds_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cpu_speed_thresholds, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cpu_speed_thresholds_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cpu_speed_thresholds, validation_context,
                                         &cpu_speed_thresholds_validate_params)) {
    return false;
  }

  return true;
}

ComputePressureQuantization_Data::ComputePressureQuantization_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComputePressureObserver_OnUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ComputePressureObserver_OnUpdate_Params_Data* object = static_cast<const ComputePressureObserver_OnUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

ComputePressureObserver_OnUpdate_Params_Data::ComputePressureObserver_OnUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComputePressureHost_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ComputePressureHost_AddObserver_Params_Data* object = static_cast<const ComputePressureHost_AddObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->quantization, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->quantization, validation_context))
    return false;

  return true;
}

ComputePressureHost_AddObserver_Params_Data::ComputePressureHost_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComputePressureHost_AddObserver_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ComputePressureHost_AddObserver_ResponseParams_Data* object = static_cast<const ComputePressureHost_AddObserver_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ComputePressureStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ComputePressureHost_AddObserver_ResponseParams_Data::ComputePressureHost_AddObserver_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ComputePressureStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ComputePressureStatus value) {
  return std::move(context).WriteString(::blink::mojom::ComputePressureStatusToString(value));
}

} // namespace perfetto
